/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.grid;

import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.grid.DefaultGridDependencies;
import com.tangosol.internal.net.service.grid.ReplicatedCacheDependencies;

public class DefaultReplicatedCacheDependencies
extends DefaultGridDependencies
implements ReplicatedCacheDependencies {
    private long m_cEnsureCacheTimeout = 30000L;
    private int m_nGraveyardSize;
    private int m_nLeaseGranularity;
    private boolean m_fMobileIssues = false;
    private long m_cStandardLeaseMillis = 20000L;

    public DefaultReplicatedCacheDependencies() {
        this(null);
    }

    public DefaultReplicatedCacheDependencies(ReplicatedCacheDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_cEnsureCacheTimeout = deps.getEnsureCacheTimeoutMillis();
            this.m_nGraveyardSize = deps.getGraveyardSize();
            this.m_nLeaseGranularity = deps.getLeaseGranularity();
            this.m_fMobileIssues = deps.isMobileIssues();
            this.m_cStandardLeaseMillis = deps.getStandardLeaseMillis();
        }
    }

    @Override
    public long getEnsureCacheTimeoutMillis() {
        return this.m_cEnsureCacheTimeout;
    }

    @Injectable(value="ensure-cache-timeout")
    public void setEnsureCacheTimeoutMillis(long cMillis) {
        this.m_cEnsureCacheTimeout = cMillis;
    }

    @Override
    public int getGraveyardSize() {
        return this.m_nGraveyardSize;
    }

    @Injectable(value="graveyard-size")
    public void setGraveyardSize(int nSize) {
        this.m_nGraveyardSize = nSize;
    }

    @Override
    public boolean isMobileIssues() {
        return this.m_fMobileIssues;
    }

    @Injectable(value="mobile-issues")
    public void setMobileIssues(boolean fMobile) {
        this.m_fMobileIssues = fMobile;
    }

    @Override
    public int getLeaseGranularity() {
        return this.m_nLeaseGranularity;
    }

    @Injectable(value="lease-granularity")
    public void setLeaseGranularity(int nGranularity) {
        this.m_nLeaseGranularity = nGranularity;
    }

    @Override
    public long getStandardLeaseMillis() {
        return this.m_cStandardLeaseMillis;
    }

    @Injectable(value="standard-lease-milliseconds")
    public void setStandardLeaseMillis(long cMillis) {
        this.m_cStandardLeaseMillis = cMillis;
    }
}

