/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.peer;

import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.peer.JmsDependencies;
import com.tangosol.util.Base;

public class CommonJmsDependencies
implements JmsDependencies {
    private int m_nMessageDeliveryMode = 1;
    private long m_cMessageExpiration = 0L;
    private int m_nMessagePriority = 4;
    private String m_sQueueConnectionFactoryName = "";
    private String m_sQueueName = "";

    public CommonJmsDependencies() {
        this(null);
    }

    public CommonJmsDependencies(JmsDependencies deps) {
        if (deps != null) {
            this.m_nMessageDeliveryMode = deps.getMessageDeliveryMode();
            this.m_cMessageExpiration = deps.getMessageExpiration();
            this.m_nMessagePriority = deps.getMessagePriority();
            this.m_sQueueConnectionFactoryName = deps.getQueueConnectionFactoryName();
            this.m_sQueueName = deps.getQueueName();
        }
    }

    @Override
    public int getMessageDeliveryMode() {
        return this.m_nMessageDeliveryMode;
    }

    @Injectable(value="message-delivery-mode")
    public void setMessageDeliveryMode(int nDeliveryMode) {
        this.m_nMessageDeliveryMode = nDeliveryMode;
    }

    @Override
    public long getMessageExpiration() {
        return this.m_cMessageExpiration;
    }

    @Injectable(value="message-expiration")
    public void setMessageExpiration(long cMillis) {
        this.m_cMessageExpiration = cMillis;
    }

    @Override
    public int getMessagePriority() {
        return this.m_nMessagePriority;
    }

    @Injectable(value="message-priority")
    public void setMessagePriority(int nPriority) {
        this.m_nMessagePriority = nPriority;
    }

    @Override
    public String getQueueConnectionFactoryName() {
        return this.m_sQueueConnectionFactoryName;
    }

    @Injectable(value="queue-connection-factory-name")
    public void setQueueConnectionFactoryName(String sName) {
        this.m_sQueueConnectionFactoryName = sName;
    }

    @Override
    public String getQueueName() {
        return this.m_sQueueName;
    }

    @Injectable(value="queue-name")
    public void setQueueName(String sName) {
        this.m_sQueueName = sName;
    }

    public CommonJmsDependencies validate() {
        Base.checkNotEmpty(this.getQueueConnectionFactoryName(), "QueueConnectionFactoryName");
        Base.checkNotEmpty(this.getQueueName(), "QueueName");
        return this;
    }

    public String toString() {
        return "CommonJmsDependencies{MessageDeliveryMode=" + this.getMessageDeliveryMode() + ", MessageExpiration=" + this.getMessageExpiration() + ", MessagePriority=" + this.getMessagePriority() + ", QueueConnectionFactoryName=" + this.getQueueConnectionFactoryName() + ", QueueName=" + this.getQueueName() + "}";
    }
}

