/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.peer.initiator;

import com.tangosol.coherence.config.builder.AddressProviderBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.coherence.config.builder.WrapperSocketAddressProviderBuilder;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.peer.initiator.DefaultInitiatorDependencies;
import com.tangosol.internal.net.service.peer.initiator.TcpInitiatorDependencies;
import com.tangosol.net.SocketAddressProvider;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.util.Base;
import java.net.SocketAddress;
import java.net.SocketException;

public class DefaultTcpInitiatorDependencies
extends DefaultInitiatorDependencies
implements TcpInitiatorDependencies {
    private ParameterizedBuilder<SocketAddressProvider> m_bldrAddressProviderRemote;
    private SocketAddress m_localAddress;
    private SocketOptions m_socketOptions;
    private SocketProviderBuilder m_builderSocketProvider = new SocketProviderBuilder(SocketProviderFactory.DEFAULT_SOCKET_PROVIDER);
    private boolean m_fNameServiceAddressProvider = false;

    public DefaultTcpInitiatorDependencies() {
        this(null);
    }

    public DefaultTcpInitiatorDependencies(TcpInitiatorDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_localAddress = deps.getLocalAddress();
            this.m_bldrAddressProviderRemote = deps.getRemoteAddressProviderBuilder();
            this.m_socketOptions = deps.getSocketOptions();
            this.m_builderSocketProvider = deps.getSocketProviderBuilder();
            this.m_fNameServiceAddressProvider = deps.isNameServiceAddressProvider();
        }
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.m_localAddress;
    }

    @Injectable(value="local-address")
    public void setLocalAddress(SocketAddress address) {
        this.m_localAddress = address;
    }

    @Override
    public ParameterizedBuilder<SocketAddressProvider> getRemoteAddressProviderBuilder() {
        return this.m_bldrAddressProviderRemote;
    }

    @Injectable(value="remote-addresses")
    public void setRemoteAddressProviderBuilder(AddressProviderBuilder bldr) {
        if (bldr == null) {
            this.setRemoteSocketAddressProviderBuilder(null);
        } else {
            this.setRemoteSocketAddressProviderBuilder(new WrapperSocketAddressProviderBuilder(bldr));
        }
    }

    public void setRemoteSocketAddressProviderBuilder(ParameterizedBuilder<SocketAddressProvider> bldr) {
        this.m_fNameServiceAddressProvider = false;
        this.m_bldrAddressProviderRemote = bldr;
    }

    @Override
    public SocketOptions getSocketOptions() {
        SocketOptions options = this.m_socketOptions;
        if (options == null) {
            this.m_socketOptions = options = new SocketOptions();
            try {
                options.setOption(8, Boolean.TRUE);
                options.setOption(1, Boolean.TRUE);
                options.setOption(128, 0);
            }
            catch (SocketException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
        return options;
    }

    @Injectable
    public void setSocketOptions(SocketOptions options) {
        this.m_socketOptions = options;
    }

    @Override
    public SocketProviderBuilder getSocketProviderBuilder() {
        return this.m_builderSocketProvider;
    }

    @Injectable(value="socket-provider")
    public void setSocketProviderBuilder(SocketProviderBuilder builder) {
        this.m_builderSocketProvider = builder;
    }

    @Override
    public boolean isNameServiceAddressProvider() {
        return this.m_fNameServiceAddressProvider || this.m_bldrAddressProviderRemote == null;
    }

    @Injectable(value="name-service-addresses")
    public void setNameServiceAddressProviderBuilder(AddressProviderBuilder bldr) {
        this.setRemoteAddressProviderBuilder(bldr);
        this.m_fNameServiceAddressProvider = bldr != null;
    }

    @Override
    public DefaultTcpInitiatorDependencies validate() {
        super.validate();
        Base.checkNotNull(this.getSocketProviderBuilder(), "SocketProviderBuilder");
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "{LocalAddress=" + this.getLocalAddress() + ", RemoteAddressProviderBldr=" + this.getRemoteAddressProviderBuilder() + ", SocketOptions=" + this.getSocketOptions() + ", SocketProvideBuilderr=" + this.getSocketProviderBuilder() + ", isNameServiceAddressProvider=" + this.isNameServiceAddressProvider() + "}";
    }
}

