/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.model;

import com.oracle.coherence.common.collections.Arrays;
import com.tangosol.internal.util.Primes;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.partition.KeyPartitioningStrategy;
import com.tangosol.util.ClassHelper;
import java.io.IOException;

public class Page
extends AbstractEvolvable
implements EvolvablePortableObject {
    public static final int EMPTY = -1;
    public static final long NULL_PAGE = -1L;
    public static final int DATA_VERSION = 1;
    protected long m_lNextPage = -1L;
    protected int m_nTail = -1;
    protected boolean m_fSealed;
    protected int m_cb;
    protected int m_cRefs;
    protected int[] m_anNotifiers;

    public long getNextPartitionPage() {
        return this.m_lNextPage;
    }

    public void setNextPartitionPage(long lPage) {
        this.m_lNextPage = lPage;
    }

    public int getTail() {
        return this.m_nTail;
    }

    public void setTail(int nTail) {
        this.m_nTail = nTail;
    }

    public int getByteSize() {
        return this.m_cb;
    }

    public void setByteSize(int cb) {
        this.m_cb = cb;
    }

    public boolean isSealed() {
        return this.m_fSealed;
    }

    public void setSealed(boolean fSealed) {
        this.m_fSealed = fSealed;
    }

    public void addInsertionNotifier(int nNotifierId) {
        this.m_anNotifiers = Arrays.binaryInsert(this.m_anNotifiers, nNotifierId);
    }

    public int[] resetInsertionNotifiers() {
        int[] anNotify = this.m_anNotifiers;
        this.m_anNotifiers = null;
        return anNotify;
    }

    public int[] getInsertionNotifiers() {
        return this.m_anNotifiers;
    }

    public void setInsertionNotifies(int[] anNotifiers) {
        this.m_anNotifiers = anNotifiers;
    }

    public int adjustReferenceCount(int c) {
        return this.m_cRefs += c;
    }

    public boolean isSubscribed() {
        return this.m_cRefs > 0;
    }

    public void markEmpty() {
        this.m_nTail = -1;
        this.m_cb = 0;
    }

    public boolean isEmpty() {
        return this.m_nTail == -1;
    }

    @Override
    public int getImplVersion() {
        return 1;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_lNextPage = in.readLong(0);
        this.m_nTail = in.readInt(1);
        this.m_fSealed = in.readBoolean(2);
        this.m_cb = in.readInt(3);
        this.m_anNotifiers = in.readIntArray(4);
        this.m_cRefs = in.readInt(5);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_lNextPage);
        out.writeInt(1, this.m_nTail);
        out.writeBoolean(2, this.m_fSealed);
        out.writeInt(3, this.m_cb);
        out.writeIntArray(4, this.m_anNotifiers);
        out.writeInt(5, this.m_cRefs);
    }

    public String toString() {
        int[] anNotify = this.m_anNotifiers;
        return ClassHelper.getSimpleName(this.getClass()) + "(next=" + this.m_lNextPage + ", tail=" + this.m_nTail + ", bytes=" + this.m_cb + ", sealed=" + this.m_fSealed + ", refs=" + this.m_cRefs + ", waiting=" + (anNotify == null ? 0 : anNotify.length) + ')';
    }

    public static class Key
    implements KeyPartitioningStrategy.PartitionAwareKey,
    PortableObject {
        protected int m_nChannel;
        protected long m_lPage;

        public Key() {
        }

        public Key(int nChannel, long lPage) {
            this.m_nChannel = nChannel;
            this.m_lPage = lPage;
        }

        public int getChannelId() {
            return this.m_nChannel;
        }

        public long getPageId() {
            return this.m_lPage;
        }

        @Override
        public int getPartitionId() {
            return Key.mapPageToPartition(this.m_nChannel, this.m_lPage);
        }

        public int hashCode() {
            return this.getPartitionId();
        }

        public boolean equals(Object oThat) {
            if (oThat instanceof Key) {
                Key that = (Key)oThat;
                return this.m_nChannel == that.m_nChannel && this.m_lPage == that.m_lPage;
            }
            return false;
        }

        public String toString() {
            return "PageKey(channel=" + this.m_nChannel + ", page=" + this.m_lPage + ")";
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_nChannel = in.readInt(0);
            this.m_lPage = in.readLong(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeInt(0, this.m_nChannel);
            out.writeLong(1, this.m_lPage);
        }

        public static int mapPageToPartition(int nChannel, long lPage) {
            return (int)(lPage * (long)Primes.next(1000003, nChannel));
        }
    }
}

