/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.collections;

import com.tangosol.internal.sleepycat.bind.EntityBinding;
import com.tangosol.internal.sleepycat.bind.EntryBinding;
import com.tangosol.internal.sleepycat.collections.BaseIterator;
import com.tangosol.internal.sleepycat.collections.DataCursor;
import com.tangosol.internal.sleepycat.collections.DataView;
import com.tangosol.internal.sleepycat.collections.StoredCollection;
import com.tangosol.internal.sleepycat.je.Database;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.je.OperationStatus;
import java.util.Set;

public class StoredValueSet<E>
extends StoredCollection<E>
implements Set<E> {
    public StoredValueSet(Database database, EntryBinding<E> valueBinding, boolean writeAllowed) {
        super(new DataView(database, null, valueBinding, null, writeAllowed, null));
    }

    public StoredValueSet(Database database, EntityBinding<E> valueEntityBinding, boolean writeAllowed) {
        super(new DataView(database, null, null, valueEntityBinding, writeAllowed, null));
    }

    StoredValueSet(DataView valueSetView) {
        super(valueSetView);
    }

    @Override
    public boolean add(E entity) {
        if (this.view.isSecondary()) {
            throw new UnsupportedOperationException("Add not allowed with index");
        }
        if (this.view.range.isSingleKey()) {
            if (!this.view.dupsAllowed) {
                throw new UnsupportedOperationException("Duplicates required");
            }
            DataCursor cursor = null;
            boolean doAutoCommit = this.beginAutoCommit();
            try {
                cursor = new DataCursor(this.view, true);
                cursor.useRangeKey();
                OperationStatus status = cursor.putNoDupData(null, entity, null, true);
                this.closeCursor(cursor);
                this.commitAutoCommit(doAutoCommit);
                return status == OperationStatus.SUCCESS;
            }
            catch (Exception e) {
                this.closeCursor(cursor);
                throw this.handleException(e, doAutoCommit);
            }
        }
        if (this.view.entityBinding == null) {
            throw new UnsupportedOperationException("Add requires entity binding");
        }
        return this.add(null, entity);
    }

    @Override
    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public boolean remove(Object value) {
        return this.removeValue(value);
    }

    @Override
    E makeIteratorData(BaseIterator iterator, DatabaseEntry keyEntry, DatabaseEntry priKeyEntry, DatabaseEntry valueEntry) {
        return (E)this.view.makeValue(priKeyEntry, valueEntry);
    }

    @Override
    boolean hasValues() {
        return true;
    }
}

