/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.latch;

import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.latch.Latch;
import com.tangosol.internal.sleepycat.je.latch.LatchContext;
import com.tangosol.internal.sleepycat.je.latch.LatchImpl;
import com.tangosol.internal.sleepycat.je.latch.LatchSupport;
import com.tangosol.internal.sleepycat.je.latch.LatchTable;
import com.tangosol.internal.sleepycat.je.latch.LatchWithStatsImpl;
import com.tangosol.internal.sleepycat.je.latch.SharedLatch;
import com.tangosol.internal.sleepycat.je.latch.SharedLatchImpl;

public class LatchFactory {
    public static SharedLatch createSharedLatch(LatchContext context, boolean exclusiveOnly) {
        if (exclusiveOnly) {
            return new LatchImpl(context);
        }
        return new SharedLatchImpl(false, context);
    }

    public static SharedLatch createSharedLatch(EnvironmentImpl envImpl, String name, boolean exclusiveOnly) {
        if (exclusiveOnly) {
            return new LatchImpl(LatchFactory.createContext(envImpl, name));
        }
        return new SharedLatchImpl(false, LatchFactory.createContext(envImpl, name));
    }

    public static Latch createExclusiveLatch(LatchContext context, boolean collectStats) {
        if (collectStats) {
            return new LatchWithStatsImpl(context);
        }
        return new LatchImpl(context);
    }

    public static Latch createExclusiveLatch(EnvironmentImpl envImpl, String name, boolean collectStats) {
        if (collectStats) {
            return new LatchWithStatsImpl(LatchFactory.createContext(envImpl, name));
        }
        return new LatchImpl(LatchFactory.createContext(envImpl, name));
    }

    private static LatchContext createContext(final EnvironmentImpl envImpl, final String name) {
        return new LatchContext(){

            @Override
            public int getLatchTimeoutMs() {
                return envImpl.getLatchTimeoutMs();
            }

            @Override
            public String getLatchName() {
                return name;
            }

            @Override
            public LatchTable getLatchTable() {
                return LatchSupport.otherLatchTable;
            }

            @Override
            public EnvironmentImpl getEnvImplForFatalException() {
                return envImpl;
            }
        };
    }

    public static LatchContext createTestLatchContext(final String name) {
        return new LatchContext(){

            @Override
            public int getLatchTimeoutMs() {
                return 1000;
            }

            @Override
            public String getLatchName() {
                return name;
            }

            @Override
            public LatchTable getLatchTable() {
                return LatchSupport.otherLatchTable;
            }

            @Override
            public EnvironmentImpl getEnvImplForFatalException() {
                throw EnvironmentFailureException.unexpectedState();
            }
        };
    }
}

