/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.latch;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LatchTable {
    private ThreadLocal<Set<Object>> latchesByThread = new ThreadLocal();

    LatchTable() {
    }

    boolean add(Object latch) {
        Set<Object> threadLatches = this.latchesByThread.get();
        if (threadLatches == null) {
            threadLatches = new HashSet<Object>();
            this.latchesByThread.set(threadLatches);
        }
        return threadLatches.add(latch);
    }

    boolean remove(Object latch) {
        Set<Object> threadLatches = this.latchesByThread.get();
        if (threadLatches == null) {
            return false;
        }
        return threadLatches.remove(latch);
    }

    int nLatchesHeld() {
        Set<Object> threadLatches = this.latchesByThread.get();
        if (threadLatches != null) {
            return threadLatches.size();
        }
        return 0;
    }

    String latchesHeldToString() {
        Set<Object> threadLatches = this.latchesByThread.get();
        StringBuilder sb = new StringBuilder();
        if (threadLatches != null) {
            Iterator<Object> i = threadLatches.iterator();
            while (i.hasNext()) {
                sb.append(i.next()).append('\n');
            }
        }
        return sb.toString();
    }

    void clear() {
        this.latchesByThread = new ThreadLocal();
    }
}

