/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.log;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.config.EnvironmentParams;
import com.tangosol.internal.sleepycat.je.dbi.DbConfigManager;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentFailureReason;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.ChecksumException;
import com.tangosol.internal.sleepycat.je.log.FileHandle;
import com.tangosol.internal.sleepycat.je.log.FileManager;
import com.tangosol.internal.sleepycat.je.log.FileReader;
import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LastFileReader
extends FileReader {
    private Set<LogEntryType> trackableEntries;
    private long nextUnprovenOffset;
    private long lastValidOffset;
    private LogEntryType entryType;
    private Map<LogEntryType, Long> lastOffsetSeen;

    public LastFileReader(EnvironmentImpl envImpl, int readBufferSize) throws DatabaseException {
        super(envImpl, readBufferSize, true, -1L, -1L, -1L, -1L);
        try {
            this.startAtLastGoodFile(null);
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
        }
        this.trackableEntries = new HashSet<LogEntryType>();
        this.lastOffsetSeen = new HashMap<LogEntryType, Long>();
        this.lastValidOffset = 0L;
        this.nextUnprovenOffset = this.nextEntryOffset;
    }

    LastFileReader(EnvironmentImpl envImpl, int readBufferSize, Long specificFileNumber) throws ChecksumException, DatabaseException {
        super(envImpl, readBufferSize, true, -1L, specificFileNumber, -1L, -1L);
        this.startAtLastGoodFile(specificFileNumber);
        this.trackableEntries = new HashSet<LogEntryType>();
        this.lastOffsetSeen = new HashMap<LogEntryType, Long>();
        this.lastValidOffset = 0L;
        this.nextUnprovenOffset = this.nextEntryOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAtLastGoodFile(Long singleFileNum) throws ChecksumException {
        this.eof = false;
        this.window.initAtFileStart(DbLsn.makeLsn(0L, 0));
        Long lastNum = singleFileNum != null && singleFileNum >= 0L ? singleFileNum : this.fileManager.getLastFileNum();
        FileHandle fileHandle = null;
        long fileLen = 0L;
        while (fileHandle == null && !this.eof) {
            if (lastNum == null) {
                this.eof = true;
                continue;
            }
            try {
                try {
                    this.window.initAtFileStart(DbLsn.makeLsn((long)lastNum, 0));
                    fileHandle = this.fileManager.getFileHandle(lastNum);
                    fileLen = fileHandle.getFile().length();
                    if (fileLen > (long)FileManager.firstLogEntryOffset() || (lastNum = this.fileManager.getFollowingFileNum(lastNum, false)) == null) continue;
                    fileHandle.release();
                    fileHandle = null;
                }
                catch (DatabaseException e) {
                    lastNum = this.attemptToMoveBadFile(e);
                    fileHandle = null;
                }
                catch (ChecksumException e) {
                    lastNum = this.attemptToMoveBadFile(e);
                    fileHandle = null;
                }
                finally {
                    if (fileHandle == null) continue;
                    fileHandle.release();
                }
            }
            catch (IOException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_READ, (Throwable)e);
            }
        }
        this.nextEntryOffset = 0L;
    }

    private Long attemptToMoveBadFile(Exception cause) throws IOException, ChecksumException, DatabaseException {
        String fileName = this.fileManager.getFullFileNames(this.window.currentFileNum())[0];
        File problemFile = new File(fileName);
        if (problemFile.length() <= (long)FileManager.firstLogEntryOffset()) {
            this.fileManager.clear();
            Long lastNum = this.fileManager.getFollowingFileNum(this.window.currentFileNum(), false);
            if (!this.fileManager.renameFile(this.window.currentFileNum(), ".bad")) {
                throw EnvironmentFailureException.unexpectedState("Could not rename file: 0x" + Long.toHexString(this.window.currentFileNum()));
            }
            return lastNum;
        }
        if (cause instanceof DatabaseException) {
            throw (DatabaseException)cause;
        }
        if (cause instanceof ChecksumException) {
            throw (ChecksumException)cause;
        }
        throw EnvironmentFailureException.unexpectedException(cause);
    }

    public void setEndOfFile() throws IOException, DatabaseException {
        this.fileManager.truncateSingleFile(this.window.currentFileNum(), this.nextUnprovenOffset);
    }

    public long getEndOfLog() {
        return DbLsn.makeLsn(this.window.currentFileNum(), this.nextUnprovenOffset);
    }

    public long getLastValidLsn() {
        return DbLsn.makeLsn(this.window.currentFileNum(), this.lastValidOffset);
    }

    public long getPrevOffset() {
        return this.lastValidOffset;
    }

    public LogEntryType getEntryType() {
        return this.entryType;
    }

    public void setTargetType(LogEntryType type) {
        this.trackableEntries.add(type);
    }

    public long getLastSeen(LogEntryType type) {
        Long typeNumber = this.lastOffsetSeen.get(type);
        if (typeNumber != null) {
            return DbLsn.makeLsn(this.window.currentFileNum(), typeNumber);
        }
        return -1L;
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) {
        entryBuffer.position(entryBuffer.position() + this.currentEntryHeader.getItemSize());
        this.entryType = new LogEntryType(this.currentEntryHeader.getType());
        if (this.trackableEntries.contains(this.entryType)) {
            this.lastOffsetSeen.put(this.entryType, this.currentEntryOffset);
        }
        return true;
    }

    @Override
    public boolean readNextEntry() {
        boolean foundEntry;
        block3: {
            foundEntry = false;
            try {
                foundEntry = super.readNextEntryAllowExceptions();
                this.lastValidOffset = this.currentEntryOffset;
                this.nextUnprovenOffset = this.nextEntryOffset;
            }
            catch (FileNotFoundException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
            }
            catch (ChecksumException e) {
                boolean committedTxnFound;
                LoggerUtils.fine(this.logger, this.envImpl, "Found checksum exception while searching for end of log. Last valid entry is at " + DbLsn.toString(DbLsn.makeLsn(this.window.currentFileNum(), this.lastValidOffset)) + " Bad entry is at " + DbLsn.makeLsn(this.window.currentFileNum(), this.nextUnprovenOffset));
                DbConfigManager configManager = this.envImpl.getConfigManager();
                boolean findCommitTxn = configManager.getBoolean(EnvironmentParams.HALT_ON_COMMIT_AFTER_CHECKSUMEXCEPTION);
                if (!findCommitTxn || !(committedTxnFound = this.findCommittedTxn())) break block3;
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.FOUND_COMMITTED_TXN, "Find committed txn after the corruption point");
            }
        }
        return foundEntry;
    }

    private boolean findCommittedTxn() {
        try {
            this.skipData(this.currentEntryHeader.getItemSize());
            while (super.readNextEntryAllowExceptions()) {
                if (!LogEntryType.LOG_TXN_COMMIT.equals(this.entryType)) continue;
                return true;
            }
        }
        catch (FileReader.EOFException e) {
        }
        catch (FileNotFoundException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
        }
        catch (ChecksumException e) {
            LoggerUtils.fine(this.logger, this.envImpl, "Found checksum exception while searching for end of log. Last valid entry is at " + DbLsn.toString(DbLsn.makeLsn(this.window.currentFileNum(), this.lastValidOffset)) + " Bad entry is at " + DbLsn.makeLsn(this.window.currentFileNum(), this.nextUnprovenOffset));
        }
        return false;
    }
}

