/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep;

import com.tangosol.internal.sleepycat.je.dbi.EnvironmentFailureReason;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.FileManager;
import com.tangosol.internal.sleepycat.je.rep.RestartRequiredException;
import com.tangosol.internal.sleepycat.je.rep.impl.RepImpl;
import com.tangosol.internal.sleepycat.je.rep.stream.MatchpointSearchResults;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;

public class RollbackProhibitedException
extends RestartRequiredException {
    private static final long serialVersionUID = 1L;
    private final MatchpointSearchResults searchResults;

    public RollbackProhibitedException(RepImpl repImpl, int rollbackTxnLimit, VLSN matchpointVLSN, MatchpointSearchResults searchResults) {
        super((EnvironmentImpl)repImpl, EnvironmentFailureReason.ROLLBACK_PROHIBITED, RollbackProhibitedException.makeMessage(repImpl.getName(), searchResults, matchpointVLSN, rollbackTxnLimit));
        this.searchResults = searchResults;
    }

    private static String makeMessage(String nodeName, MatchpointSearchResults searchResults, VLSN matchpointVLSN, int rollbackTxnLimit) {
        long matchpointLSN = searchResults.getMatchpointLSN();
        long fileNumber = DbLsn.getFileNumber(matchpointLSN);
        long fileOffset = DbLsn.getFileOffset(matchpointLSN);
        return "Node " + nodeName + " must rollback" + searchResults.getRollbackMsg() + " in order to rejoin the replication group, but the transaction " + "rollback limit of " + rollbackTxnLimit + " prohibits this. " + "Either increase the property je.rep.txnRollbackLimit to a value " + "larger than " + rollbackTxnLimit + " to permit automatic " + "rollback, or manually remove the problematic transactions. " + "To do a manual removal, truncate the log to file " + FileManager.getFileName(fileNumber) + ", offset 0x" + Long.toHexString(fileOffset) + ", vlsn " + matchpointVLSN + " using the directions in com.sleepycat.je.util.DbTruncateLog.";
    }

    public RollbackProhibitedException(String message, RollbackProhibitedException cause) {
        super(message + " " + cause.getMessage(), cause);
        this.searchResults = cause.searchResults;
    }

    @Override
    public RollbackProhibitedException wrapSelf(String msg) {
        return new RollbackProhibitedException(msg, this);
    }

    public long getTruncationFileNumber() {
        return DbLsn.getFileNumber(this.searchResults.getMatchpointLSN());
    }

    public long getTruncationFileOffset() {
        return DbLsn.getFileOffset(this.searchResults.getMatchpointLSN());
    }

    public Long getEarliestTransactionCommitTime() {
        return this.searchResults.getEarliestPassedTxn().time.getTime();
    }

    public long getEarliestTransactionId() {
        return this.searchResults.getEarliestPassedTxn().id;
    }
}

