/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.impl;

import com.tangosol.internal.sleepycat.je.rep.impl.RepGroupImpl;
import com.tangosol.internal.sleepycat.je.rep.impl.RepImpl;
import com.tangosol.internal.sleepycat.je.rep.impl.RepNodeImpl;
import com.tangosol.internal.sleepycat.je.rep.impl.RepParams;
import com.tangosol.internal.sleepycat.je.rep.impl.TextProtocol;
import com.tangosol.internal.sleepycat.je.rep.impl.node.NameIdPair;
import com.tangosol.internal.sleepycat.je.rep.net.DataChannelFactory;

public class RepGroupProtocol
extends TextProtocol {
    public static final String VERSION = "4";
    public static final String REP_GROUP_V3_VERSION = "4";
    public static final String REP_GROUP_V2_VERSION = "3";
    private static volatile String testCurrentVersion = null;
    public final TextProtocol.MessageOp ENSURE_NODE = new TextProtocol.MessageOp("ENREQ", EnsureNode.class);
    public final TextProtocol.MessageOp ENSURE_OK = new TextProtocol.MessageOp("ENRESP", EnsureOK.class);
    public final TextProtocol.MessageOp REMOVE_MEMBER = new TextProtocol.MessageOp("RMREQ", RemoveMember.class);
    public final TextProtocol.MessageOp GROUP_REQ = new TextProtocol.MessageOp("GREQ", GroupRequest.class);
    public final TextProtocol.MessageOp GROUP_RESP = new TextProtocol.MessageOp("GRESP", GroupResponse.class);
    public final TextProtocol.MessageOp RGFAIL_RESP = new TextProtocol.MessageOp("GRFAIL", Fail.class);
    public final TextProtocol.MessageOp UPDATE_ADDRESS = new TextProtocol.MessageOp("UPDADDR", UpdateAddress.class);
    public final TextProtocol.MessageOp TRANSFER_MASTER = new TextProtocol.MessageOp("TMASTER", TransferMaster.class);
    public final TextProtocol.MessageOp TRANSFER_OK = new TextProtocol.MessageOp("TMRESP", TransferOK.class);
    public final TextProtocol.MessageOp DELETE_MEMBER = new TextProtocol.MessageOp("DLREQ", DeleteMember.class);

    public RepGroupProtocol(String groupName, NameIdPair nameIdPair, RepImpl repImpl, DataChannelFactory channelFactory) {
        this(RepGroupProtocol.getCurrentVersion(), groupName, nameIdPair, repImpl, channelFactory);
    }

    RepGroupProtocol(String version, String groupName, NameIdPair nameIdPair, RepImpl repImpl, DataChannelFactory channelFactory) {
        super(version, groupName, nameIdPair, repImpl, channelFactory);
        this.initializeMessageOps(new TextProtocol.MessageOp[]{this.ENSURE_NODE, this.ENSURE_OK, this.REMOVE_MEMBER, this.GROUP_REQ, this.GROUP_RESP, this.RGFAIL_RESP, this.UPDATE_ADDRESS, this.TRANSFER_MASTER, this.TRANSFER_OK, this.DELETE_MEMBER});
        this.setTimeouts(repImpl, RepParams.REP_GROUP_OPEN_TIMEOUT, RepParams.REP_GROUP_READ_TIMEOUT);
    }

    public static String getCurrentVersion() {
        return testCurrentVersion != null ? testCurrentVersion : "4";
    }

    public static void setTestVersion(String testVersion) {
        testCurrentVersion = testVersion;
    }

    private static int getGroupFormatVersion(String protocolVersion) {
        return Double.parseDouble(protocolVersion) <= Double.parseDouble(REP_GROUP_V2_VERSION) ? 2 : 3;
    }

    public class Fail
    extends TextProtocol.Fail {
        final FailReason reason;

        public Fail(FailReason reason, String message) {
            super((TextProtocol)RepGroupProtocol.this, message);
            this.reason = reason;
        }

        public Fail(TextProtocol.RequestMessage request, FailReason reason, String message) {
            super((TextProtocol)RepGroupProtocol.this, request, message);
            this.reason = reason;
        }

        public Fail(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super((TextProtocol)RepGroupProtocol.this, line, tokens);
            this.reason = FailReason.valueOf(this.nextPayloadToken());
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.RGFAIL_RESP;
        }

        @Override
        public String wireFormat() {
            return super.wireFormat() + "|" + this.reason.toString();
        }

        public FailReason getReason() {
            return this.reason;
        }
    }

    public class GroupResponse
    extends TextProtocol.ResponseMessage {
        final RepGroupImpl group;

        public GroupResponse(GroupRequest request, RepGroupImpl group) {
            super(RepGroupProtocol.this, request);
            this.group = group;
        }

        public GroupResponse(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, line, tokens);
            this.group = RepGroupImpl.deserializeHex(tokens, this.getCurrentTokenPosition());
        }

        public RepGroupImpl getGroup() {
            return this.group;
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.GROUP_RESP;
        }

        @Override
        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }

        @Override
        public String wireFormat() {
            int groupFormatVersion = RepGroupProtocol.getGroupFormatVersion(this.sendVersion);
            if (this.group.getFormatVersion() < groupFormatVersion) {
                groupFormatVersion = this.group.getFormatVersion();
            }
            return this.wireFormatPrefix() + "|" + this.group.serializeHex(groupFormatVersion);
        }
    }

    public class TransferOK
    extends TextProtocol.OK {
        private final String winner;

        public TransferOK(TransferMaster request, String winner) {
            super(RepGroupProtocol.this, request);
            this.winner = winner;
        }

        public TransferOK(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, line, tokens);
            this.winner = this.nextPayloadToken();
        }

        public String getWinner() {
            return this.winner;
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.TRANSFER_OK;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.winner;
        }
    }

    public class EnsureOK
    extends TextProtocol.OK {
        private final NameIdPair nameIdPair;

        public EnsureOK(EnsureNode request, NameIdPair nameIdPair) {
            super(RepGroupProtocol.this, request);
            this.nameIdPair = nameIdPair;
        }

        public EnsureOK(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, line, tokens);
            this.nameIdPair = new NameIdPair(this.nextPayloadToken(), Integer.parseInt(this.nextPayloadToken()));
        }

        public NameIdPair getNameIdPair() {
            return this.nameIdPair;
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.ENSURE_OK;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.nameIdPair.getName() + "|" + Integer.toString(this.nameIdPair.getId());
        }
    }

    public class EnsureNode
    extends TextProtocol.RequestMessage {
        final RepNodeImpl node;

        public EnsureNode(RepNodeImpl node) {
            super(RepGroupProtocol.this);
            assert (node.getType().isMonitor());
            this.node = node;
        }

        public EnsureNode(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, line, tokens);
            this.node = RepGroupImpl.hexDeserializeNode(this.nextPayloadToken(), RepGroupProtocol.getGroupFormatVersion(this.sendVersion));
        }

        public RepNodeImpl getNode() {
            return this.node;
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.ENSURE_NODE;
        }

        @Override
        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + RepGroupImpl.serializeHex(this.node, RepGroupProtocol.getGroupFormatVersion(this.sendVersion));
        }
    }

    public class UpdateAddress
    extends CommonRequest {
        private final String newHostName;
        private final int newPort;

        public UpdateAddress(String nodeName, String newHostName, int newPort) {
            super(nodeName);
            this.newHostName = newHostName;
            this.newPort = newPort;
        }

        public UpdateAddress(String requestLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(requestLine, tokens);
            this.newHostName = this.nextPayloadToken();
            this.newPort = new Integer(this.nextPayloadToken());
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.UPDATE_ADDRESS;
        }

        public String getNewHostName() {
            return this.newHostName;
        }

        public int getNewPort() {
            return this.newPort;
        }

        @Override
        public String wireFormat() {
            return super.wireFormat() + "|" + this.newHostName + "|" + this.newPort;
        }
    }

    public class GroupRequest
    extends TextProtocol.RequestMessage {
        public GroupRequest() {
            super(RepGroupProtocol.this);
        }

        public GroupRequest(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, line, tokens);
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.GROUP_REQ;
        }

        @Override
        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix();
        }
    }

    public class TransferMaster
    extends TextProtocol.RequestMessage {
        private final String nodeNameList;
        private final long timeout;
        private final boolean force;

        public TransferMaster(String nodeNameList, long timeout, boolean force) {
            super(RepGroupProtocol.this);
            this.nodeNameList = nodeNameList;
            this.timeout = timeout;
            this.force = force;
        }

        public TransferMaster(String requestLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, requestLine, tokens);
            this.nodeNameList = this.nextPayloadToken();
            this.timeout = Long.parseLong(this.nextPayloadToken());
            this.force = Boolean.parseBoolean(this.nextPayloadToken());
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.nodeNameList + "|" + this.timeout + "|" + this.force;
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.TRANSFER_MASTER;
        }

        public String getNodeNameList() {
            return this.nodeNameList;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public boolean getForceFlag() {
            return this.force;
        }
    }

    public class DeleteMember
    extends CommonRequest {
        public DeleteMember(String nodeName) {
            super(nodeName);
        }

        public DeleteMember(String requestLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(requestLine, tokens);
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.DELETE_MEMBER;
        }
    }

    public class RemoveMember
    extends CommonRequest {
        public RemoveMember(String nodeName) {
            super(nodeName);
        }

        public RemoveMember(String requestLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(requestLine, tokens);
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.REMOVE_MEMBER;
        }
    }

    private abstract class CommonRequest
    extends TextProtocol.RequestMessage {
        private final String nodeName;

        public CommonRequest(String nodeName) {
            super(RepGroupProtocol.this);
            this.nodeName = nodeName;
        }

        public CommonRequest(String requestLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, requestLine, tokens);
            this.nodeName = this.nextPayloadToken();
        }

        @Override
        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }

    public static enum FailReason {
        DEFAULT,
        MEMBER_NOT_FOUND,
        IS_MASTER,
        IS_REPLICA,
        TRANSFER_FAIL,
        MEMBER_ACTIVE;

    }
}

