/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.stream;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.LogEntryHeader;
import com.tangosol.internal.sleepycat.je.log.LogEntryType;
import com.tangosol.internal.sleepycat.je.log.LogUtils;
import com.tangosol.internal.sleepycat.je.log.entry.LogEntry;
import com.tangosol.internal.sleepycat.je.rep.stream.WireRecord;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;

public class InputWireRecord
extends WireRecord {
    private final LogEntry logEntry;

    InputWireRecord(EnvironmentImpl envImpl, ByteBuffer msgBuffer) throws DatabaseException {
        super(new LogEntryHeader(msgBuffer.get(), LogUtils.readInt(msgBuffer), LogUtils.readInt(msgBuffer), new VLSN(LogUtils.readLong(msgBuffer))));
        this.logEntry = this.instantiateEntry(envImpl, msgBuffer);
    }

    InputWireRecord(EnvironmentImpl envImpl, byte entryType, int entryVersion, int itemSize, VLSN vlsn, ByteBuffer entryBuffer) throws DatabaseException {
        super(new LogEntryHeader(entryType, entryVersion, itemSize, vlsn));
        this.logEntry = LogEntryType.findType(this.header.getType()).getNewLogEntry();
        this.logEntry.readEntry(envImpl, this.header, entryBuffer);
    }

    public VLSN getVLSN() {
        return this.header.getVLSN();
    }

    public byte getEntryType() {
        return this.header.getType();
    }

    public LogEntry getLogEntry() {
        return this.logEntry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.header.dumpRep(sb);
        sb.append(" ");
        this.logEntry.dumpRep(sb);
        return sb.toString();
    }

    public String dumpLogEntry() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.header);
        sb.append(" ").append(this.logEntry);
        return sb.toString();
    }
}

