/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.stream;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.config.EnvironmentParams;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.rep.impl.node.NameIdPair;
import com.tangosol.internal.sleepycat.je.rep.stream.FeederReader;
import com.tangosol.internal.sleepycat.je.rep.stream.FeederSource;
import com.tangosol.internal.sleepycat.je.rep.stream.OutputWireRecord;
import com.tangosol.internal.sleepycat.je.rep.vlsn.VLSNIndex;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;
import java.io.IOException;

public class MasterFeederSource
implements FeederSource {
    private final FeederReader feederReader;

    public MasterFeederSource(EnvironmentImpl envImpl, VLSNIndex vlsnIndex, NameIdPair nameIdPair) throws DatabaseException {
        int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.feederReader = new FeederReader(envImpl, vlsnIndex, -1L, readBufferSize, nameIdPair);
    }

    @Override
    public void init(VLSN startVLSN) throws DatabaseException, IOException {
        this.feederReader.initScan(startVLSN);
    }

    @Override
    public OutputWireRecord getWireRecord(VLSN vlsn, int waitTime) throws DatabaseException, InterruptedException, IOException {
        try {
            return this.feederReader.scanForwards(vlsn, waitTime);
        }
        catch (DatabaseException e) {
            e.addErrorMessage("MasterFeederSource fetching vlsn=" + vlsn + " waitTime=" + waitTime);
            throw e;
        }
    }

    @Override
    public String dumpState() {
        return this.feederReader.dumpState();
    }
}

