/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.utilint;

import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.DbInternal;
import com.tangosol.internal.sleepycat.je.Durability;
import com.tangosol.internal.sleepycat.je.EnvironmentConfig;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.EnvironmentLockedException;
import com.tangosol.internal.sleepycat.je.EnvironmentNotFoundException;
import com.tangosol.internal.sleepycat.je.config.EnvironmentParams;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.log.ChecksumException;
import com.tangosol.internal.sleepycat.je.rep.RepInternal;
import com.tangosol.internal.sleepycat.je.rep.ReplicatedEnvironment;
import com.tangosol.internal.sleepycat.je.rep.ReplicationConfig;
import com.tangosol.internal.sleepycat.je.rep.impl.RepImpl;
import com.tangosol.internal.sleepycat.je.rep.impl.RepParams;
import com.tangosol.internal.sleepycat.je.rep.impl.node.NameIdPair;
import com.tangosol.internal.sleepycat.je.rep.stream.FeederReader;
import com.tangosol.internal.sleepycat.je.rep.stream.FeederSyncupReader;
import com.tangosol.internal.sleepycat.je.rep.stream.OutputWireRecord;
import com.tangosol.internal.sleepycat.je.rep.vlsn.VLSNIndex;
import com.tangosol.internal.sleepycat.je.rep.vlsn.VLSNRange;
import com.tangosol.internal.sleepycat.je.tree.Key;
import com.tangosol.internal.sleepycat.je.util.DbPrintLog;
import com.tangosol.internal.sleepycat.je.utilint.CmdUtil;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.IOException;

public class DbFeederPrintLog {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(File envHome, String groupName, String nodeName, String host, boolean forward, long startLsn, VLSN startVLSN, boolean verbose) throws IOException, EnvironmentNotFoundException, EnvironmentLockedException, DatabaseException, InterruptedException, ChecksumException {
        Durability durability = new Durability(Durability.SyncPolicy.NO_SYNC, Durability.SyncPolicy.NO_SYNC, Durability.ReplicaAckPolicy.NONE);
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(false);
        envConfig.setTransactional(true);
        envConfig.setDurability(durability);
        ReplicationConfig repConfig = new ReplicationConfig();
        repConfig.setConfigParam("je.rep.envConsistencyTimeout", "1 min");
        repConfig.setGroupName(groupName);
        repConfig.setNodeName(nodeName);
        int port = Integer.parseInt(RepParams.DEFAULT_PORT.getDefault());
        String hostName = host + ":" + port;
        repConfig.setNodeHostPort(hostName);
        repConfig.setHelperHosts(hostName);
        try (ReplicatedEnvironment rep = RepInternal.createDetachedEnv(envHome, repConfig, envConfig);){
            ReplicatedEnvironment.State state = rep.getState();
            if (state != ReplicatedEnvironment.State.DETACHED) {
                throw EnvironmentFailureException.unexpectedState("joinState=" + (Object)((Object)state));
            }
            EnvironmentImpl envImpl = DbInternal.getEnvironmentImpl(rep);
            VLSNIndex vlsnIndex = RepInternal.getRepImpl(rep).getVLSNIndex();
            startLsn = forward ? -1L : envImpl.getFileManager().getLastUsedLsn();
            int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
            FeederReader feederReader = null;
            FeederSyncupReader backwardsReader = null;
            VLSN scanVLSN = startVLSN;
            if (startVLSN.equals(VLSN.NULL_VLSN)) {
                RepImpl repImpl = RepInternal.getRepImpl(rep);
                VLSNRange range = repImpl.getVLSNIndex().getRange();
                scanVLSN = forward ? range.getFirst() : range.getLast();
            }
            if (scanVLSN.equals(VLSN.NULL_VLSN)) {
                System.out.println("<DbPrintLog>");
                System.out.println("</DbPrintLog>");
                return;
            }
            if (forward) {
                feederReader = new FeederReader(envImpl, vlsnIndex, startLsn, readBufferSize, new NameIdPair("n0", 0));
                feederReader.initScan(scanVLSN);
            } else {
                backwardsReader = new FeederSyncupReader(envImpl, vlsnIndex, startLsn, readBufferSize, new NameIdPair("n0", 0), scanVLSN, -1L);
            }
            OutputWireRecord record = null;
            System.out.println("<DbPrintLog>");
            long lastLsn = 0L;
            do {
                if (forward) {
                    record = feederReader.scanForwards(scanVLSN, 0);
                    scanVLSN = scanVLSN.getNext();
                    lastLsn = feederReader.getLastLsn();
                } else {
                    record = backwardsReader.scanBackwards(scanVLSN);
                    scanVLSN = scanVLSN.getPrev();
                    lastLsn = backwardsReader.getLastLsn();
                }
                if (record == null) continue;
                System.out.println("lsn=" + DbLsn.getNoFormatString(lastLsn) + " " + record);
            } while (record != null);
            System.out.println("</DbPrintLog>");
        }
    }

    public static void main(String[] argv) {
        try {
            String groupName = "repGroup";
            String host = "localHost";
            String nodeName = "node8";
            long startLsn = -1L;
            VLSN startVLSN = VLSN.NULL_VLSN;
            boolean verbose = true;
            boolean forward = true;
            File envHome = new File(".");
            Key.DUMP_TYPE = Key.DumpType.BINARY;
            for (int whichArg = 0; whichArg < argv.length; ++whichArg) {
                String arg;
                int slashOff;
                String nextArg = argv[whichArg];
                if (nextArg.equals("-h")) {
                    envHome = new File(CmdUtil.getArg(argv, ++whichArg));
                    continue;
                }
                if (nextArg.equals("-s")) {
                    long startFileNum;
                    if ((slashOff = (arg = CmdUtil.getArg(argv, ++whichArg)).indexOf("/")) < 0) {
                        startFileNum = CmdUtil.readLongNumber(arg);
                        startLsn = DbLsn.makeLsn(startFileNum, 0);
                        continue;
                    }
                    startFileNum = CmdUtil.readLongNumber(arg.substring(0, slashOff));
                    long startOffset = CmdUtil.readLongNumber(arg.substring(slashOff + 1));
                    startLsn = DbLsn.makeLsn(startFileNum, startOffset);
                    continue;
                }
                if (nextArg.equals("-e")) {
                    long endFileNum;
                    if ((slashOff = (arg = CmdUtil.getArg(argv, ++whichArg)).indexOf("/")) < 0) {
                        endFileNum = CmdUtil.readLongNumber(arg);
                        continue;
                    }
                    endFileNum = CmdUtil.readLongNumber(arg.substring(0, slashOff));
                    long endOffset = CmdUtil.readLongNumber(arg.substring(slashOff + 1));
                    continue;
                }
                if (nextArg.equals("-q")) {
                    verbose = false;
                    continue;
                }
                if (nextArg.equals("-backward")) {
                    forward = false;
                    continue;
                }
                if (nextArg.equals("-vlsn")) {
                    arg = CmdUtil.getArg(argv, ++whichArg);
                    startVLSN = new VLSN(CmdUtil.readLongNumber(arg));
                    continue;
                }
                System.err.println(nextArg + " is not a supported option.");
                DbFeederPrintLog.usage();
                System.exit(-1);
            }
            DbFeederPrintLog printer = new DbFeederPrintLog();
            printer.dump(envHome, groupName, nodeName, host, forward, startLsn, startVLSN, verbose);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            DbFeederPrintLog.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("Usage: " + CmdUtil.getJavaCommand(DbPrintLog.class));
        System.out.println(" -h  <envHomeDir>");
        System.out.println(" -e  <end file number or LSN, in hex>");
        System.out.println(" -s  <start file number or LSN, in hex>");
        System.out.println(" -backward if specified, scan is backwards");
        System.out.println("  -vlsn <startVLSN>");
        System.out.println(" -tx <targeted txn ids, comma separated>");
        System.out.println(" -q  if specified, concise version is printed");
        System.out.println("     Default is verbose version.)");
        System.out.println("All arguments are optional");
    }
}

