/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.tree;

import com.tangosol.internal.sleepycat.je.CacheMode;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseId;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.dbi.MemoryBudget;
import com.tangosol.internal.sleepycat.je.log.LogUtils;
import com.tangosol.internal.sleepycat.je.log.Loggable;
import com.tangosol.internal.sleepycat.je.tree.BIN;
import com.tangosol.internal.sleepycat.je.tree.DeltaInfo;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import com.tangosol.internal.sleepycat.je.utilint.SizeofMarker;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class OldBINDelta
implements Loggable {
    private final DatabaseId dbId = new DatabaseId();
    private long lastFullLsn = -1L;
    private long prevDeltaLsn = -1L;
    private final ArrayList<DeltaInfo> deltas;

    public OldBINDelta() {
        this.deltas = new ArrayList();
    }

    public OldBINDelta(SizeofMarker marker) {
        this.deltas = null;
    }

    public DatabaseId getDbId() {
        return this.dbId;
    }

    public long getLastFullLsn() {
        return this.lastFullLsn;
    }

    public long getPrevDeltaLsn() {
        return this.prevDeltaLsn;
    }

    public byte[] getSearchKey() {
        assert (this.deltas.size() > 0);
        return this.deltas.get(0).getKey();
    }

    public BIN reconstituteBIN(DatabaseImpl dbImpl) {
        EnvironmentImpl envImpl = dbImpl.getEnv();
        BIN fullBIN = (BIN)envImpl.getLogManager().getEntryHandleFileNotFound(this.lastFullLsn);
        this.reconstituteBIN(dbImpl, fullBIN);
        return fullBIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconstituteBIN(DatabaseImpl dbImpl, BIN fullBIN) {
        fullBIN.setDatabase(dbImpl);
        fullBIN.latch(CacheMode.UNCHANGED);
        try {
            fullBIN.setLastFullLsn(this.lastFullLsn);
            for (int i = 0; i < this.deltas.size(); ++i) {
                DeltaInfo info = this.deltas.get(i);
                fullBIN.applyDelta(info.getKey(), info.getLsn(), info.getState(), 0, VLSN.NULL_VLSN.getSequence(), null);
            }
            fullBIN.setDirty(false);
        }
        finally {
            fullBIN.releaseLatch();
        }
    }

    @Override
    public int getLogSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        this.dbId.readFromLog(itemBuffer, entryVersion);
        this.lastFullLsn = LogUtils.readLong(itemBuffer, entryVersion < 6);
        if (entryVersion >= 8) {
            this.prevDeltaLsn = LogUtils.readPackedLong(itemBuffer);
        }
        int numDeltas = LogUtils.readInt(itemBuffer, entryVersion < 6);
        for (int i = 0; i < numDeltas; ++i) {
            DeltaInfo info = new DeltaInfo();
            info.readFromLog(itemBuffer, entryVersion);
            this.deltas.add(info);
        }
        this.deltas.trimToSize();
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        this.dbId.dumpLog(sb, verbose);
        sb.append("<lastFullLsn>");
        sb.append(DbLsn.getNoFormatString(this.lastFullLsn));
        sb.append("</lastFullLsn>");
        sb.append("<prevDeltaLsn>");
        sb.append(DbLsn.getNoFormatString(this.prevDeltaLsn));
        sb.append("</prevDeltaLsn>");
        sb.append("<deltas size=\"").append(this.deltas.size()).append("\"/>");
        for (int i = 0; i < this.deltas.size(); ++i) {
            DeltaInfo info = this.deltas.get(i);
            info.dumpLog(sb, verbose);
        }
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    public long getMemorySize() {
        long size = MemoryBudget.BINDELTA_OVERHEAD + MemoryBudget.ARRAYLIST_OVERHEAD + MemoryBudget.objectArraySize(this.deltas.size());
        for (DeltaInfo info : this.deltas) {
            size += info.getMemorySize();
        }
        return size;
    }
}

