/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.utilint;

import com.tangosol.internal.sleepycat.je.utilint.LongStat;
import com.tangosol.internal.sleepycat.je.utilint.Stat;
import com.tangosol.internal.sleepycat.je.utilint.StatDefinition;
import com.tangosol.internal.sleepycat.je.utilint.StatGroup;

public class LongMaxStat
extends LongStat {
    private static final long serialVersionUID = 1L;

    public LongMaxStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
        this.clear();
    }

    public LongMaxStat(StatGroup group, StatDefinition definition, long counter) {
        super(group, definition);
        this.counter = counter;
    }

    @Override
    public void clear() {
        this.set(Long.MIN_VALUE);
    }

    public boolean setMax(long newValue) {
        if (this.counter < newValue) {
            this.counter = newValue;
            return true;
        }
        return false;
    }

    @Override
    public Stat<Long> computeInterval(Stat<Long> base) {
        return this.counter < base.get() ? base.copy() : this.copy();
    }

    @Override
    public void negate() {
    }

    @Override
    protected String getFormattedValue() {
        if (this.counter == Long.MIN_VALUE) {
            return "NONE";
        }
        return Stat.FORMAT.format(this.counter);
    }
}

