/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.persist.impl;

import com.tangosol.internal.sleepycat.bind.EntityBinding;
import com.tangosol.internal.sleepycat.bind.tuple.TupleBase;
import com.tangosol.internal.sleepycat.compat.DbCompat;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.persist.impl.Accessor;
import com.tangosol.internal.sleepycat.persist.impl.Catalog;
import com.tangosol.internal.sleepycat.persist.impl.Format;
import com.tangosol.internal.sleepycat.persist.impl.PersistCatalog;
import com.tangosol.internal.sleepycat.persist.impl.PersistKeyAssigner;
import com.tangosol.internal.sleepycat.persist.impl.Reader;
import com.tangosol.internal.sleepycat.persist.impl.RecordInput;
import com.tangosol.internal.sleepycat.persist.impl.RecordOutput;
import com.tangosol.internal.sleepycat.persist.impl.RefreshException;
import com.tangosol.internal.sleepycat.persist.raw.RawObject;

public class PersistEntityBinding
implements EntityBinding {
    volatile PersistCatalog catalog;
    volatile Format entityFormat;
    final boolean rawAccess;
    PersistKeyAssigner keyAssigner;

    public PersistEntityBinding(PersistCatalog catalogParam, String entityClassName, boolean rawAccess) {
        this.catalog = catalogParam;
        try {
            this.entityFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, entityClassName, rawAccess);
        }
        catch (RefreshException e) {
            this.catalog = e.refresh();
            try {
                this.entityFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, entityClassName, rawAccess);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
        if (!this.entityFormat.isEntity()) {
            throw new IllegalArgumentException("Not an entity class: " + entityClassName);
        }
        this.rawAccess = rawAccess;
    }

    public PersistKeyAssigner getKeyAssigner() {
        return this.keyAssigner;
    }

    public Object entryToObject(DatabaseEntry key, DatabaseEntry data) {
        try {
            return this.entryToObjectInternal(key, null, data);
        }
        catch (RefreshException e) {
            e.refresh();
            try {
                return this.entryToObjectInternal(key, null, data);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
    }

    public Object entryToObjectWithPriKey(Object priKey, DatabaseEntry data) {
        try {
            if (priKey == null) {
                throw new IllegalArgumentException("Primary key cannot be null.");
            }
            return this.entryToObjectInternal(null, priKey, data);
        }
        catch (RefreshException e) {
            e.refresh();
            try {
                return this.entryToObjectInternal(null, priKey, data);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
    }

    private Object entryToObjectInternal(DatabaseEntry key, Object priKey, DatabaseEntry data) throws RefreshException {
        return PersistEntityBinding.readEntity(this.catalog, key, priKey, data, this.rawAccess);
    }

    static Object readEntity(Catalog useCatalog, DatabaseEntry key, Object priKey, DatabaseEntry data, boolean rawAccess) throws RefreshException {
        RecordInput dataInput = new RecordInput(useCatalog, rawAccess, null, 0, data.getData(), data.getOffset(), data.getSize());
        int initialOffset = dataInput.getBufferOffset();
        int formatId = dataInput.readPackedInt();
        Format format = useCatalog.getFormat(formatId, true);
        dataInput.registerEntityFormat(format);
        Reader reader = format.getReader();
        Object entity = reader.newInstance(dataInput, rawAccess);
        if (priKey == null) {
            RecordInput keyInput = new RecordInput(useCatalog, rawAccess, null, 0, key.getData(), key.getOffset(), key.getSize());
            reader.readPriKey(entity, keyInput, rawAccess);
        } else {
            Accessor accessor = reader.getAccessor(entity instanceof RawObject ? true : rawAccess);
            if (accessor == null) {
                accessor = format.getLatestVersion().getReader().getAccessor(entity instanceof RawObject ? true : rawAccess);
            }
            accessor.setPriField(entity, priKey);
        }
        dataInput.registerEntity(entity, initialOffset);
        entity = reader.readObject(entity, dataInput, rawAccess);
        return entity;
    }

    public void objectToData(Object entity, DatabaseEntry data) {
        try {
            this.objectToDataInternal(entity, data);
        }
        catch (RefreshException e) {
            e.refresh();
            try {
                this.objectToDataInternal(entity, data);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
    }

    private void objectToDataInternal(Object entity, DatabaseEntry data) throws RefreshException {
        Format format = this.getValidFormat(entity);
        this.catalog.checkWriteInReplicaUpgradeMode();
        PersistEntityBinding.writeEntity(format, this.catalog, entity, data, this.rawAccess);
    }

    static void writeEntity(Format format, Catalog catalog, Object entity, DatabaseEntry data, boolean rawAccess) throws RefreshException {
        RecordOutput output = new RecordOutput(catalog, rawAccess);
        output.registerEntity(entity);
        output.writePackedInt(format.getId());
        format.writeObject(entity, output, rawAccess);
        TupleBase.outputToEntry(output, data);
    }

    public void objectToKey(Object entity, DatabaseEntry key) {
        try {
            this.objectToKeyInternal(entity, key);
        }
        catch (RefreshException e) {
            e.refresh();
            try {
                this.objectToKeyInternal(entity, key);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
    }

    private void objectToKeyInternal(Object entity, DatabaseEntry key) throws RefreshException {
        Format format = this.getValidFormat(entity);
        RecordOutput output = new RecordOutput(this.catalog, this.rawAccess);
        format.writePriKey(entity, output, this.rawAccess);
        TupleBase.outputToEntry(output, key);
    }

    private Format getValidFormat(Object entity) throws RefreshException {
        Format format;
        if (entity == null) {
            throw new IllegalArgumentException("An entity may not be null");
        }
        if (this.rawAccess) {
            if (!(entity instanceof RawObject)) {
                throw new IllegalArgumentException("Entity must be a RawObject");
            }
            format = (Format)((RawObject)entity).getType();
        } else {
            format = this.catalog.getFormat(entity.getClass(), true);
        }
        if (format.getEntityFormat() != this.entityFormat) {
            throw new IllegalArgumentException("The entity class (" + format.getClassName() + ") must be this entity class or a subclass of it: " + this.entityFormat.getClassName());
        }
        return format;
    }

    static Format getOrCreateFormat(Catalog useCatalog, String clsName, boolean rawAccess) throws RefreshException {
        if (rawAccess) {
            Format format = useCatalog.getFormat(clsName);
            if (format == null) {
                throw new IllegalArgumentException("Not a persistent class: " + clsName);
            }
            return format;
        }
        Class cls = useCatalog.resolveKeyClass(clsName);
        return useCatalog.getFormat(cls, true);
    }

    void refresh(PersistCatalog newCatalog) {
        this.catalog = newCatalog;
        this.entityFormat = newCatalog.getFormat(this.entityFormat.getClassName());
        if (this.keyAssigner != null) {
            this.keyAssigner.refresh(newCatalog);
        }
    }
}

