/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.tracing.opentracing33;

import com.tangosol.internal.tracing.Tracer;
import com.tangosol.internal.tracing.opentracing.AbstractOpenTracingShim;
import com.tangosol.internal.tracing.opentracing33.OpenTracingTracer;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.util.GlobalTracer;
import java.lang.reflect.Field;

public class OpenTracingShim
extends AbstractOpenTracingShim {
    protected static final Field GLOBAL_TRACER_REGISTERED_FIELD;

    @Override
    protected boolean registerTracer(io.opentracing.Tracer tracer) {
        if (GLOBAL_TRACER_REGISTERED_FIELD == null) {
            return false;
        }
        return GlobalTracer.registerIfAbsent((io.opentracing.Tracer)tracer);
    }

    @Override
    protected void onControlClose() {
        block2: {
            try {
                GLOBAL_TRACER_REGISTERED_FIELD.set(null, false);
                GlobalTracer.registerIfAbsent((io.opentracing.Tracer)NoopTracerFactory.create());
                GLOBAL_TRACER_REGISTERED_FIELD.set(null, false);
            }
            catch (IllegalAccessException | IllegalStateException e) {
                if (!CacheFactory.isLogEnabled(9)) break block2;
                CacheFactory.log("Unexpected exception resetting GlobalTracer: " + e, 9);
                CacheFactory.log(Base.printStackTrace(e), 9);
            }
        }
    }

    @Override
    protected String getApiVersion() {
        return "0.33.0";
    }

    @Override
    protected Tracer createTracer() {
        return new OpenTracingTracer();
    }

    static {
        Field fieldRegistered;
        block2: {
            fieldRegistered = null;
            try {
                fieldRegistered = GlobalTracer.class.getDeclaredField("isRegistered");
                fieldRegistered.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                if (!CacheFactory.isLogEnabled(1)) break block2;
                String sMsg = "An incompatible version of the OpenTracing API has been detected on the classpath.  Tracing will be disabled.";
                CacheFactory.log(sMsg, 1);
            }
        }
        GLOBAL_TRACER_REGISTERED_FIELD = fieldRegistered;
    }
}

