/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class LoggingBridge {
    protected static final int FINEST = Level.FINEST.intValue();
    protected static final int FINER = Level.FINER.intValue();
    protected static final int FINE = Level.FINE.intValue();
    protected static final int CONFIG = Level.CONFIG.intValue();
    protected static final int INFO = Level.INFO.intValue();
    protected static final int WARNING = Level.WARNING.intValue();

    public static Logger createBridge() {
        Logger logger = Logger.getAnonymousLogger();
        for (int nLevel = 0; nLevel < 9 && CacheFactory.isLogEnabled(nLevel); ++nLevel) {
        }
        Level level = CacheFactory.isLogEnabled(9) ? Level.ALL : (CacheFactory.isLogEnabled(7) ? Level.FINER : (CacheFactory.isLogEnabled(5) ? Level.FINE : (CacheFactory.isLogEnabled(4) ? Level.CONFIG : (CacheFactory.isLogEnabled(3) ? Level.INFO : (CacheFactory.isLogEnabled(2) ? Level.WARNING : Level.SEVERE)))));
        logger.setLevel(level);
        logger.setUseParentHandlers(false);
        logger.addHandler(new StreamHandler(){

            @Override
            public void publish(LogRecord record) {
                int nLevelDst;
                int nLevelSrc = record.getLevel().intValue();
                int n = nLevelSrc <= FINEST ? 9 : (nLevelSrc <= FINER ? 7 : (nLevelSrc <= FINE ? 5 : (nLevelSrc <= CONFIG ? 4 : (nLevelSrc <= INFO ? 3 : (nLevelDst = nLevelSrc <= WARNING ? 2 : 1)))));
                if (CacheFactory.isLogEnabled(nLevelDst)) {
                    Throwable ex = record.getThrown();
                    if (ex == null) {
                        CacheFactory.log(this.getFormatter().formatMessage(record), nLevelDst);
                    } else {
                        CacheFactory.log(this.getFormatter().formatMessage(record) + "\n" + Base.printStackTrace(ex), nLevelDst);
                    }
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        return logger;
    }
}

