/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.EntrySetMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.PartitionedFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class MapBackupHelper {
    public static void writeMap(DataOutput out, Map map) throws IOException {
        if (map instanceof NamedCache && ((NamedCache)map).getCacheService() instanceof DistributedCacheService) {
            NamedCache cache = (NamedCache)map;
            DistributedCacheService service = (DistributedCacheService)cache.getCacheService();
            int cPartitions = service.getPartitionCount();
            PartitionSet parts = new PartitionSet(cPartitions);
            out.writeInt(cPartitions);
            for (int iPartition = 0; iPartition < cPartitions; ++iPartition) {
                parts.add(iPartition);
                Set setEntries = cache.entrySet(new PartitionedFilter(AlwaysFilter.INSTANCE, parts));
                ExternalizableHelper.writeMap(out, new EntrySetMap(setEntries));
                parts.remove(iPartition);
            }
        } else {
            out.writeInt(1);
            ExternalizableHelper.writeMap(out, map);
        }
    }

    public static int readMap(DataInput in, Map map, int cBlock, ClassLoader loader) throws IOException {
        int cMaps = in.readInt();
        int cEntries = 0;
        for (int i = 0; i < cMaps; ++i) {
            HashMap mapTmp = new HashMap();
            if (cBlock > 0) {
                ExternalizableHelper.readMap(in, mapTmp, cBlock, loader);
            } else {
                ExternalizableHelper.readMap(in, mapTmp, loader);
            }
            cEntries += mapTmp.size();
            map.putAll(mapTmp);
        }
        return cEntries;
    }
}

