/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.util.Base;

public class MovingAverage
extends Base {
    protected long[] m_alBucket;
    protected int m_nResolution;
    protected int m_iBucket;
    protected long m_lTotal;
    protected int m_cSamplesFixed;
    protected int m_cSamplesVariable;

    public MovingAverage() {
        this(100, 1);
    }

    public MovingAverage(int cSamples, int nResolution) {
        MovingAverage.azzert(nResolution > 0, "resolution must be positive");
        MovingAverage.azzert(cSamples >= nResolution * 2, "samples must be >= 2*resolution");
        this.m_alBucket = new long[cSamples / nResolution];
        this.m_nResolution = nResolution;
    }

    public synchronized void reset() {
        long[] alBucket = this.m_alBucket;
        int c = alBucket.length;
        for (int i = 0; i < c; ++i) {
            alBucket[i] = 0L;
        }
        this.m_lTotal = 0L;
        this.m_iBucket = 0;
        this.m_cSamplesFixed = 0;
        this.m_cSamplesVariable = 0;
    }

    public synchronized void addSample(int iValue) {
        long[] alBucket = this.m_alBucket;
        int iBucket = this.m_iBucket;
        int cSamples = this.m_cSamplesVariable + 1;
        int nResolution = this.m_nResolution;
        if (cSamples > nResolution) {
            int cBucketMax = alBucket.length;
            this.m_iBucket = iBucket = (iBucket + 1) % cBucketMax;
            cSamples = 1;
            if (this.m_cSamplesFixed < (cBucketMax - 1) * nResolution) {
                this.m_cSamplesFixed += nResolution;
            } else {
                this.m_lTotal -= alBucket[iBucket];
                alBucket[iBucket] = 0L;
            }
        }
        int n = iBucket;
        alBucket[n] = alBucket[n] + (long)iValue;
        this.m_lTotal += (long)iValue;
        this.m_cSamplesVariable = cSamples;
    }

    public int getAverage() {
        int cSamples = this.getSampleCount();
        return cSamples == 0 ? 0 : (int)((this.m_lTotal + (long)(cSamples >>> 1)) / (long)cSamples);
    }

    public double getDoubleAverage() {
        int cSamples = this.getSampleCount();
        return cSamples == 0 ? 0.0 : (double)this.m_lTotal / (double)cSamples;
    }

    public double getStandardDeviation() {
        long[] alBucket = this.m_alBucket;
        int iBucket = this.m_iBucket;
        double dResolution = this.m_nResolution;
        int cVar = this.m_cSamplesVariable;
        int cBuckets = this.m_cSamplesFixed / (int)(dResolution + (double)(cVar > 0 ? 1 : 0));
        int cSamples = this.getSampleCount();
        double dAverage = this.getDoubleAverage();
        double dTotal = 0.0;
        for (int i = 0; i < cBuckets; ++i) {
            double dSamples = i == iBucket ? (double)cVar : dResolution;
            double dDelta = (double)alBucket[i] / dSamples - dAverage;
            dTotal += dDelta * dDelta * dSamples;
        }
        return cSamples == 0 ? 0.0 : Math.sqrt(dTotal / (double)this.getSampleCount());
    }

    public int getSampleCount() {
        return this.m_cSamplesFixed + this.m_cSamplesVariable;
    }

    public String toString() {
        return "average = " + this.getDoubleAverage() + "; stddev = " + this.getStandardDeviation() + ", over " + this.getSampleCount() + " samples";
    }

    public static void main(String[] asArg) {
        int cSpan = asArg.length > 0 ? Integer.parseInt(asArg[0]) : 1000;
        int nRes = asArg.length > 1 ? Integer.parseInt(asArg[1]) : 10;
        int nInterval = asArg.length > 2 ? Integer.parseInt(asArg[2]) : 100;
        int cSample = asArg.length > 3 ? Integer.parseInt(asArg[3]) : 1000;
        MovingAverage avg = new MovingAverage(cSpan, nRes);
        for (int i = 0; i < cSample; ++i) {
            avg.addSample(MovingAverage.getRandom().nextInt(i + 1));
            if (i % nInterval != 0) continue;
            MovingAverage.out(avg);
        }
    }
}

