/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.oracle.coherence.common.util.Duration;
import com.oracle.coherence.common.util.MemorySize;
import com.tangosol.coherence.config.scheme.Scheme;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ObjectFormatter {
    private int m_cIndent = 2;
    private StringBuilder m_buf;
    private boolean m_fCacheMapRendered;
    private boolean m_fNullRendered;
    private boolean m_fXmlRendered;
    private ParameterResolver m_resolver;
    private HashSet<String> m_setClassesToIgnore = new HashSet();
    private String[][] m_aPrefixesToModify = new String[][]{{"a", "Array"}, {"bldr", "Builder"}, {"b", ""}, {"c", ""}, {"cb", ""}, {"clz", "Class"}, {"col", "Collection"}, {"config", "Config"}, {"d", ""}, {"date", "Date"}, {"dfl", ""}, {"e", ""}, {"expr", ""}, {"evt", "Event"}, {"f", ""}, {"fl", ""}, {"l", ""}, {"ldt", "Date"}, {"list", "List"}, {"map", "Map"}, {"n", ""}, {"o", ""}, {"of", "Offset"}, {"scheme", "Scheme"}, {"set", "Set"}, {"s", ""}};
    private HashSet<Object> m_setRecursingObjects = new HashSet();

    public ObjectFormatter() {
        this.m_setClassesToIgnore.add("com.tangosol.util.Base");
        this.m_setClassesToIgnore.add("java.lang.Object");
    }

    public ObjectFormatter setIndent(int cIndent) {
        this.m_cIndent = cIndent;
        return this;
    }

    public int getIndent() {
        return this.m_cIndent;
    }

    public ObjectFormatter setCacheMapRendered(boolean flag) {
        this.m_fCacheMapRendered = flag;
        return this;
    }

    public boolean isCacheMapRendered() {
        return this.m_fCacheMapRendered;
    }

    public ObjectFormatter setNullRendered(boolean flag) {
        this.m_fNullRendered = flag;
        return this;
    }

    public boolean isNullRendered() {
        return this.m_fNullRendered;
    }

    public ObjectFormatter setXmlRendered(boolean flag) {
        this.m_fXmlRendered = flag;
        return this;
    }

    public boolean isXmlRendered() {
        return this.m_fXmlRendered;
    }

    public String format(String sTargetName, Object oTarget) {
        return this.format(sTargetName, oTarget, null);
    }

    public String format(String sTargetName, Object oTarget, ParameterResolver resolver) {
        StringBuilder buf = this.m_buf = new StringBuilder();
        try {
            this.m_resolver = resolver == null ? new NullParameterResolver() : resolver;
            buf.append("\n").append(sTargetName);
            this.formatAllFields(oTarget, this.getIndent());
            return buf.toString();
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Exception formatting output for " + oTarget);
        }
    }

    public PrivilegedAction<String> asPrivilegedAction(final String sTargetName, final Object oTarget, final ParameterResolver resolver) {
        return new PrivilegedAction(){

            public String run() {
                return ObjectFormatter.this.format(sTargetName, oTarget, resolver);
            }
        };
    }

    protected void formatAllFields(Object oTarget, int cIndent) {
        StringBuilder buf = this.m_buf;
        if (!this.m_setRecursingObjects.add(oTarget)) {
            return;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        this.getFields(oTarget.getClass(), fields);
        for (Field field : fields) {
            Object oValue = this.getFieldValue(oTarget, field);
            if (oValue == null) continue;
            int nCheckpoint = buf.length();
            this.newline(cIndent);
            String sFieldName = this.cleanFieldName(field.getName());
            buf.append(sFieldName);
            Class<?> clzValue = oValue.getClass();
            String sValueClassName = clzValue.getSimpleName();
            if (oValue instanceof Scheme && !sFieldName.equals(sValueClassName)) {
                buf.append(" (").append(clzValue.getSimpleName()).append(") ");
            }
            if ((oValue = this.tryConvertToList(oValue)) instanceof Iterable) {
                int cIterIndent = cIndent + this.getIndent();
                int i = 0;
                for (Object oEntry : (Iterable)oValue) {
                    if ((oEntry = this.translateValue(oTarget, oEntry)) == null) continue;
                    if (i == 0) {
                        if (clzValue.isArray()) {
                            buf.append(" (").append(sValueClassName).append(")");
                        } else {
                            buf.append(" (").append(sValueClassName).append(" of ").append(oEntry.getClass().getSimpleName()).append(")");
                        }
                    }
                    this.formatArrayDimensions(i++, oEntry, cIterIndent, nCheckpoint);
                }
                continue;
            }
            this.formatOneField(oValue, cIndent, nCheckpoint);
        }
        this.m_setRecursingObjects.remove(oTarget);
    }

    protected void formatArrayDimensions(int nIndex, Object oValue, int cIndent, int nCheckpoint) {
        StringBuilder buf = this.m_buf;
        this.newline(cIndent);
        buf.append("[").append(nIndex).append("] ");
        oValue = this.tryConvertToList(oValue);
        if (oValue instanceof Iterable) {
            int cInnerIndent = cIndent + this.getIndent();
            int i = 0;
            for (Object oEntry : (Iterable)oValue) {
                this.formatArrayDimensions(i++, oEntry, cInnerIndent, nCheckpoint);
            }
        } else {
            nCheckpoint = buf.length();
            this.formatOneField(oValue, cIndent, nCheckpoint);
        }
    }

    protected void formatOneField(Object oValue, int cIndent, int nCheckpoint) {
        boolean fNested;
        StringBuilder buf = this.m_buf;
        try {
            fNested = oValue.getClass().getDeclaredMethod("toString", new Class[0]) == null;
        }
        catch (NoSuchMethodException e) {
            fNested = true;
        }
        if (fNested) {
            int nBufLen = buf.length();
            if (!oValue.getClass().getName().startsWith("com.tangosol.coherence.component")) {
                this.formatAllFields(oValue, cIndent + this.getIndent());
            }
            if (nBufLen == buf.length() && nCheckpoint > 0) {
                this.m_buf.delete(nCheckpoint, nBufLen);
            }
        } else {
            buf.append(": ").append(oValue.toString().trim());
        }
    }

    protected String cleanFieldName(String sFieldName) {
        StringBuilder buf = null;
        if (sFieldName.startsWith("m_") || sFieldName.startsWith("s_")) {
            buf = new StringBuilder();
            buf.append(sFieldName.substring(2));
            for (int i = 0; i < this.m_aPrefixesToModify.length; ++i) {
                String sPrefix = this.m_aPrefixesToModify[i][0];
                int nPrefixLen = sPrefix.length();
                if (buf.length() <= nPrefixLen || !buf.substring(0, nPrefixLen).equals(sPrefix) || !Character.isUpperCase(buf.charAt(nPrefixLen))) continue;
                return buf.substring(nPrefixLen) + this.m_aPrefixesToModify[i][1];
            }
            buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
        }
        return buf == null ? sFieldName : buf.toString().trim();
    }

    protected Object getFieldValue(Object oTarget, Field field) {
        if (!field.isAccessible()) {
            try {
                field.setAccessible(true);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            return null;
        }
        try {
            return this.translateValue(oTarget, field.get(oTarget));
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected Object translateValue(Object oTarget, Object oValue) {
        if (oValue == oTarget) {
            oValue = null;
        } else if (oValue instanceof CacheMap && !this.isCacheMapRendered()) {
            oValue = null;
        } else if (oValue instanceof XmlElement) {
            if (this.isXmlRendered()) {
                XmlElement xml = (XmlElement)((XmlElement)oValue).clone();
                oValue = XmlHelper.isEmpty(xml = XmlHelper.removeEmptyElements(xml)) ? null : xml;
            } else {
                oValue = null;
            }
        } else if (oValue instanceof Expression) {
            try {
                oValue = ((Expression)oValue).evaluate(this.m_resolver);
            }
            catch (Exception xml) {
                // empty catch block
            }
        }
        if (oValue instanceof Float) {
            oValue = ((Float)oValue).floatValue() == 0.0f ? null : oValue;
        } else if (oValue instanceof Double) {
            oValue = (Double)oValue == 0.0 ? null : oValue;
        } else if (oValue instanceof Number) {
            oValue = oValue.toString().equals("0") ? null : (oValue.toString().startsWith("-") ? null : oValue);
        } else if (oValue instanceof Boolean) {
            oValue = (Boolean)oValue != false ? oValue : null;
        } else if (oValue instanceof String) {
            oValue = ((String)oValue).length() == 0 ? null : oValue;
        } else if (oValue instanceof Duration) {
            long cNanos = ((Duration)oValue).as(Duration.Magnitude.NANO);
            oValue = cNanos == 0L ? null : oValue.toString();
        } else if (oValue instanceof MemorySize) {
            long cb = (long)((MemorySize)oValue).as(MemorySize.Magnitude.BYTES);
            oValue = cb == 0L ? null : oValue.toString();
        }
        return oValue;
    }

    protected void getFields(Class<?> clz, ArrayList<Field> fields) {
        Class<?> clzSuper = clz.getSuperclass();
        if (clzSuper != null) {
            this.getFields(clzSuper, fields);
        }
        if (!this.m_setClassesToIgnore.contains(clz.getName())) {
            fields.addAll(Arrays.asList(clz.getDeclaredFields()));
        }
    }

    protected Object tryConvertToList(Object oValue) {
        try {
            oValue = oValue.getClass().isArray() ? Arrays.asList((Object[])oValue) : oValue;
        }
        catch (ClassCastException e) {
            oValue = this.convertPrimitiveArrayToList(oValue);
        }
        return oValue;
    }

    protected List<Object> convertPrimitiveArrayToList(Object oValue) {
        ArrayList<Object> list = new ArrayList<Object>();
        int c = Array.getLength(oValue);
        for (int i = 0; i < c; ++i) {
            Object oEntry = Array.get(oValue, i);
            if (oEntry.getClass().isArray()) {
                list.add(this.convertPrimitiveArrayToList(oValue));
            }
            list.add(oEntry);
        }
        return list;
    }

    protected void indent(int cIndent) {
        StringBuilder sb = this.m_buf;
        for (int i = 0; i < cIndent; ++i) {
            sb.append(' ');
        }
    }

    protected void newline(int cIndent) {
        this.m_buf.append('\n');
        this.indent(cIndent);
    }
}

