/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerAware;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.json.bind.annotation.JsonbProperty;

public class SimpleBinaryEntry<K, V>
implements InvocableMap.Entry<K, V>,
SerializerAware,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="binKey")
    protected Binary m_binKey;
    @JsonbProperty(value="binValue")
    protected Binary m_binValue;
    protected transient Serializer m_serializer;
    protected transient K m_key;
    protected transient V m_value;

    public SimpleBinaryEntry() {
    }

    public SimpleBinaryEntry(BinaryEntry<K, V> entry) {
        this(entry.getBinaryKey(), entry.getBinaryValue());
    }

    public SimpleBinaryEntry(Binary binKey, Binary binValue) {
        this.m_binKey = binKey;
        this.m_binValue = binValue;
    }

    @Override
    public K getKey() {
        Object key = this.m_key;
        if (key == null) {
            key = this.m_key = ExternalizableHelper.fromBinary(this.m_binKey, this.getContextSerializer());
        }
        return key;
    }

    @Override
    public V getValue() {
        Object value = this.m_value;
        if (value == null) {
            value = this.m_value = ExternalizableHelper.fromBinary(this.m_binValue, this.getContextSerializer());
        }
        return value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValue(V value, boolean fSynthetic) {
        this.setValue(value);
    }

    @Override
    public <T> void update(ValueUpdater<V, T> updater, T value) {
        InvocableMapHelper.updateEntry(updater, this, value);
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public void remove(boolean fSynthetic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, E> E extract(ValueExtractor<T, E> extractor) {
        return InvocableMapHelper.extractFromEntry(extractor, this);
    }

    @Override
    public Serializer getContextSerializer() {
        return this.m_serializer;
    }

    @Override
    public void setContextSerializer(Serializer serializer) {
        this.m_serializer = serializer;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_binKey = (Binary)ExternalizableHelper.readObject(in);
        this.m_binValue = (Binary)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_binKey);
        ExternalizableHelper.writeObject(out, this.m_binValue);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_binKey = in.readBinary(0);
        this.m_binValue = in.readBinary(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeBinary(0, this.m_binKey);
        out.writeBinary(1, this.m_binValue);
    }

    public String toString() {
        return "SimpleBinaryEntry(key=\"" + this.getKey() + "\", value=\"" + this.getValue() + "\")";
    }
}

