/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.graal;

import com.tangosol.util.ScriptException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Source;

public class ScriptDescriptor {
    private String m_sLanguage;
    private boolean m_fExists;
    private boolean m_fDirEntry;
    private String m_sResourcePath;
    private String m_sDirectoryName;
    private URI m_rootUri;
    private URL m_scriptUrl;
    private Source m_scriptSource;
    private ScriptUrlConnectionHandler m_urlConnectionHandler;
    private static Map<String, ScriptUrlConnectionHandler> s_handlers = new HashMap<String, ScriptUrlConnectionHandler>();

    public ScriptDescriptor(String sLanguage, String sScriptPath) {
        String sResourcePath = ScriptDescriptor.toResourcePath(sLanguage, sScriptPath);
        URL scriptURL = Thread.currentThread().getContextClassLoader().getResource(sResourcePath);
        this.initialize(sLanguage, sResourcePath, scriptURL);
    }

    private ScriptDescriptor(String sLanguage, String sResourcePath, URL scriptUrl) {
        this.initialize(sLanguage, sResourcePath, scriptUrl);
    }

    public boolean exists() {
        return this.m_fExists;
    }

    public boolean isDirectory() {
        return this.m_fDirEntry;
    }

    public boolean isRoot() {
        return this.m_sResourcePath.equals(this.scriptRoot());
    }

    public ScriptDescriptor resolve(String sScript) {
        if (sScript.startsWith("/")) {
            return new ScriptDescriptor(this.m_sLanguage, sScript);
        }
        try {
            URI uri = this.m_rootUri.resolve(this.m_sResourcePath).resolve(sScript).normalize();
            String resPath = this.m_rootUri.relativize(uri).normalize().getRawPath();
            if (!resPath.startsWith(this.scriptRoot())) {
                throw new ScriptException("invalid path: " + sScript);
            }
            URI fullURI = new URI(this.m_rootUri.toString() + resPath);
            return new ScriptDescriptor(this.m_sLanguage, resPath, fullURI.toURL());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new ScriptException(e.getMessage(), e);
        }
    }

    public String getDirectory() {
        return this.m_sDirectoryName;
    }

    public ScriptDescriptor getParentDescriptor() {
        return this.isRoot() ? null : (this.isDirectory() ? this.resolve("..") : this.resolve("."));
    }

    public String getScriptPath() {
        return this.m_sResourcePath.substring(this.scriptRoot().length());
    }

    public String getResourcePath() {
        return this.m_sResourcePath;
    }

    public URL getScriptUrl() {
        return this.m_scriptUrl;
    }

    public Source getScriptSource() {
        Source scriptSource = this.m_scriptSource;
        if (scriptSource == null) {
            try {
                scriptSource = this.m_scriptSource = Source.newBuilder((String)this.m_sLanguage, (URL)this.m_scriptUrl).build();
            }
            catch (IOException ex) {
                throw new ScriptException("exception while loading the script source: " + this.m_scriptUrl, ex);
            }
        }
        return scriptSource;
    }

    public String getSimpleName() {
        String[] components = this.m_sResourcePath.split("/");
        return components.length > 0 ? components[components.length - 1] : null;
    }

    public Collection<String> listScripts() {
        try {
            ScriptUrlConnectionHandler handler = s_handlers.get(this.getScriptUrl().toURI().getScheme());
            return handler.listScripts(this.getScriptUrl().openConnection());
        }
        catch (IOException | URISyntaxException e) {
            throw new ScriptException("error while preloading scrips", e);
        }
    }

    private void setIsDirectory(boolean isDir) {
        this.m_fDirEntry = isDir;
    }

    private void setExists(boolean fExists) {
        this.m_fExists = fExists;
    }

    private static String toResourcePath(String sLanguage, String sPathToScript) {
        try {
            if (sPathToScript.startsWith("/")) {
                sPathToScript = sPathToScript.substring(1);
            }
            String scriptRoot = "/scripts/" + sLanguage + "/";
            URI uri = new URI("file:" + scriptRoot + sPathToScript).normalize();
            String path = uri.getRawPath();
            if (!path.startsWith(scriptRoot)) {
                throw new IllegalArgumentException("Invalid scriptName: " + sPathToScript);
            }
            return path.substring(1);
        }
        catch (URISyntaxException e) {
            throw new ScriptException(e.getMessage(), e);
        }
    }

    private String scriptRoot() {
        return "scripts/" + this.m_sLanguage + "/";
    }

    private String stripScriptRootPrefix(String sPath) {
        if (sPath.startsWith(this.scriptRoot())) {
            sPath = sPath.substring(this.scriptRoot().length());
        }
        return sPath;
    }

    private void initialize(String sLanguage, String sResourcePath, URL sScriptUrl) {
        this.m_sLanguage = sLanguage;
        this.m_sResourcePath = sResourcePath;
        this.m_scriptUrl = sScriptUrl;
        if (this.m_sResourcePath.endsWith("/")) {
            this.m_sResourcePath = this.m_sResourcePath.substring(0, this.m_sResourcePath.length() - 1);
        }
        if (sScriptUrl != null) {
            try {
                URLConnection urlConn = sScriptUrl.openConnection();
                this.m_urlConnectionHandler = s_handlers.get(this.m_scriptUrl.toURI().getScheme());
                if (this.m_urlConnectionHandler == null) {
                    throw new UnsupportedOperationException("protocol (" + sScriptUrl.getProtocol() + ") not supported");
                }
                this.m_urlConnectionHandler.initializeDescriptor(this, urlConn);
                String rootPath = sScriptUrl.toURI().toString();
                int index = rootPath.lastIndexOf(this.m_sResourcePath);
                this.m_rootUri = new URI(rootPath.substring(0, index));
                if (this.isDirectory()) {
                    this.m_sResourcePath = this.m_sResourcePath + "/";
                    this.m_sDirectoryName = this.stripScriptRootPrefix(sResourcePath);
                } else {
                    int slash = sResourcePath.lastIndexOf(47);
                    this.m_sDirectoryName = sResourcePath.substring(0, slash) + "/";
                    this.m_sDirectoryName = this.stripScriptRootPrefix(this.m_sDirectoryName);
                }
            }
            catch (IOException | URISyntaxException e) {
                throw new ScriptException("error while initializing descriptor. scriptURL: " + sScriptUrl, e);
            }
        }
    }

    public String toString() {
        return "ScriptDescriptor{language='" + this.m_sLanguage + '\'' + ", doesExist=" + this.m_fExists + ", dirEntry=" + this.m_fDirEntry + ", resourcePath='" + this.m_sResourcePath + '\'' + ", directoryName='" + this.m_sDirectoryName + '\'' + ", rootUri=" + this.m_rootUri + ", scriptUrl=" + this.m_scriptUrl + ", scriptSource=" + this.m_scriptSource + '}';
    }

    static {
        s_handlers.put("jar", new JarUrlConnectionHandler());
        s_handlers.put("file", new FileURLConnectionHandler());
    }

    private static class FileURLConnectionHandler
    implements ScriptUrlConnectionHandler {
        private FileURLConnectionHandler() {
        }

        @Override
        public void initializeDescriptor(ScriptDescriptor descriptor, URLConnection urlConn) {
            File entry = new File(urlConn.getURL().getFile());
            descriptor.setIsDirectory(entry.isDirectory());
            descriptor.setExists(entry.exists());
        }

        @Override
        public Collection<String> listScripts(URLConnection urlConn) {
            File entry = new File(urlConn.getURL().getFile());
            File[] scripts = entry.listFiles((dir, name) -> name.endsWith(".js") || name.endsWith(".mjs"));
            if (scripts != null) {
                return Arrays.stream(scripts).map(f -> f.getName()).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }

    private static class JarUrlConnectionHandler
    implements ScriptUrlConnectionHandler {
        private JarUrlConnectionHandler() {
        }

        @Override
        public void initializeDescriptor(ScriptDescriptor descriptor, URLConnection urlConn) throws IOException {
            try {
                JarURLConnection jarUrlConn = (JarURLConnection)urlConn;
                JarEntry jarEntry = jarUrlConn.getJarEntry();
                if (jarEntry != null) {
                    descriptor.setIsDirectory(jarEntry.isDirectory());
                    descriptor.setExists(true);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public Collection<String> listScripts(URLConnection urlConn) throws IOException {
            JarURLConnection jarUrlConn = (JarURLConnection)urlConn;
            Collection list = jarUrlConn.getJarFile().stream().map(je -> je.getName()).map(n -> Paths.get(n, new String[0])).filter(p -> p.getNameCount() == 3).filter(p -> {
                String simpleName = p.getName(2).toString();
                return simpleName.endsWith("js") || simpleName.endsWith(".mjs");
            }).map(p -> p.getName(2).toString()).collect(Collectors.toList());
            return list;
        }
    }

    public static interface ScriptUrlConnectionHandler {
        public void initializeDescriptor(ScriptDescriptor var1, URLConnection var2) throws IOException;

        public Collection<String> listScripts(URLConnection var1) throws IOException;
    }
}

