/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.invoke;

import com.tangosol.internal.util.invoke.ClassIdentity;
import com.tangosol.internal.util.invoke.Remotable;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.json.bind.annotation.JsonbProperty;

public class ClassDefinition
implements ExternalizableLite,
PortableObject {
    protected transient Class<? extends Remotable> m_clz;
    protected transient MethodHandle m_mhCtor;
    @JsonbProperty(value="id")
    protected ClassIdentity m_id;
    @JsonbProperty(value="code")
    protected byte[] m_abClass;

    public ClassDefinition() {
    }

    public ClassDefinition(ClassIdentity id, byte[] abClass) {
        this.m_id = id;
        this.m_abClass = abClass;
        String sClassName = id.getName();
        Base.azzert(sClassName.length() < 65535, "The generated class name is too long:\n" + sClassName);
    }

    public ClassIdentity getId() {
        return this.m_id;
    }

    public byte[] getBytes() {
        return this.m_abClass;
    }

    public Class<? extends Remotable> getRemotableClass() {
        return this.m_clz;
    }

    public void setRemotableClass(Class<? extends Remotable> clz) {
        this.m_clz = clz;
        Constructor<?>[] aCtor = clz.getDeclaredConstructors();
        if (aCtor.length == 1) {
            try {
                MethodType ctorType = MethodType.methodType(Void.TYPE, aCtor[0].getParameterTypes());
                this.m_mhCtor = MethodHandles.publicLookup().findConstructor(clz, ctorType);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    public Object createInstance(Object ... aoArgs) {
        try {
            return this.getConstructor(aoArgs).invokeWithArguments(aoArgs);
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] aCtors;
            for (Constructor<?> ctor : aCtors = this.m_clz.getDeclaredConstructors()) {
                if (ctor.getParameterTypes().length != aoArgs.length) continue;
                try {
                    return ctor.newInstance(aoArgs);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            throw Base.ensureRuntimeException(e);
        }
        catch (Throwable t) {
            throw Base.ensureRuntimeException(t);
        }
    }

    protected MethodHandle getConstructor(Object[] aoArgs) throws NoSuchMethodException {
        if (this.m_mhCtor != null) {
            return this.m_mhCtor;
        }
        Class[] aParamTypes = ClassHelper.getClassArray(aoArgs);
        try {
            MethodType ctorType = MethodType.methodType(Void.TYPE, ClassHelper.unwrap(aParamTypes));
            return MethodHandles.publicLookup().findConstructor(this.m_clz, ctorType);
        }
        catch (NoSuchMethodException e) {
            try {
                MethodType ctorType = MethodType.methodType(Void.TYPE, aParamTypes);
                return MethodHandles.publicLookup().findConstructor(this.m_clz, ctorType);
            }
            catch (IllegalAccessException e1) {
                throw Base.ensureRuntimeException(e1);
            }
        }
        catch (IllegalAccessException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public void dumpClass(String sDir) {
        if (sDir != null) {
            boolean fDisabled;
            File dirDump = new File(sDir, this.m_id.getPackage());
            boolean bl = fDisabled = dirDump.isFile() || !dirDump.exists() && !dirDump.mkdirs();
            if (!fDisabled) {
                try (FileOutputStream os = new FileOutputStream(new File(dirDump, this.m_id.getSimpleName() + ".class"));){
                    ((OutputStream)os).write(this.m_abClass);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ClassDefinition) {
            ClassDefinition that = (ClassDefinition)o;
            return this == that || this.getClass() == that.getClass() && Base.equals(this.m_id, that.m_id);
        }
        return false;
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public String toString() {
        return "ClassDefinition{id=" + this.m_id + '}';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_id = (ClassIdentity)ExternalizableHelper.readObject(in);
        this.m_abClass = ExternalizableHelper.readByteArray(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_id);
        ExternalizableHelper.writeByteArray(out, this.m_abClass);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_id = (ClassIdentity)in.readObject(0);
        this.m_abClass = in.readByteArray(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_id);
        out.writeByteArray(1, this.m_abClass);
    }
}

