/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.invoke;

import com.tangosol.coherence.config.Config;
import com.tangosol.internal.util.invoke.ClassDefinition;
import com.tangosol.internal.util.invoke.ClassIdentity;
import com.tangosol.internal.util.invoke.RemotableClassGenerator;
import com.tangosol.internal.util.invoke.RemotableSupport;
import com.tangosol.util.Base;
import java.io.IOException;
import java.io.InputStream;

public abstract class Classes {
    private static final String DUMP_CLASSES = Config.getProperty("coherence.remotable.dumpClasses", Config.getProperty("coherence.remotable.dumpAll"));

    public static ClassDefinition createDefinition(ClassIdentity id, Class<?> clazz) {
        try {
            String sClassName = clazz.getName().replace('.', '/');
            InputStream in = clazz.getClassLoader().getResourceAsStream(sClassName + ".class");
            byte[] abClass = Base.read(in);
            abClass = RemotableClassGenerator.createRemoteClass(sClassName, id.getName(), abClass);
            ClassDefinition definition = new ClassDefinition(id, abClass);
            definition.dumpClass(DUMP_CLASSES);
            return definition;
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static <T> T createRemotable(Class<T> clzRetValue, Class<? extends T> clzTarget, Object ... args) {
        RemotableSupport support = RemotableSupport.get(clzTarget.getClassLoader());
        return support.realize(support.createRemoteConstructor(clzRetValue, clzTarget, args));
    }
}

