/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.invoke;

import com.oracle.coherence.common.internal.util.CanonicalNames;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.util.invoke.ClassDefinition;
import com.tangosol.internal.util.invoke.ClassIdentity;
import com.tangosol.internal.util.invoke.Remotable;
import com.tangosol.internal.util.invoke.RemotableSupport;
import com.tangosol.internal.util.invoke.lambda.AbstractRemotableLambda;
import com.tangosol.internal.util.invoke.lambda.AnonymousLambdaIdentity;
import com.tangosol.internal.util.invoke.lambda.LambdaIdentity;
import com.tangosol.internal.util.invoke.lambda.MethodReferenceIdentity;
import com.tangosol.internal.util.invoke.lambda.RemotableLambdaGenerator;
import com.tangosol.internal.util.invoke.lambda.StaticLambdaInfo;
import com.tangosol.net.CacheFactory;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;

public abstract class Lambdas {
    private static final String DUMP_LAMBDAS = Config.getProperty("coherence.remotable.dumpLambdas", Config.getProperty("coherence.remotable.dumpAll"));
    public static final String LAMBDAS_SERIALIZATION_MODE_PROPERTY = "coherence.lambdas";
    protected static final SerializationMode LAMBDAS_SERIALIZATION_MODE;

    public static boolean isLambda(Object o) {
        return o != null && Lambdas.isLambdaClass(o.getClass());
    }

    public static boolean isLambdaClass(Class clz) {
        return clz != null && clz.getName().contains("$$Lambda$");
    }

    public static SerializedLambda getSerializedLambda(Object oLambda) {
        if (oLambda == null || !Lambdas.isLambda(oLambda) || !(oLambda instanceof Serializable)) {
            throw new IllegalArgumentException("Specified object is not an instance of a serializable lambda");
        }
        try {
            Class<?> clzLambda = oLambda.getClass();
            Method method = clzLambda.getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(true);
            return (SerializedLambda)method.invoke(oLambda, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to extract SerializedLambda from lambda: " + oLambda, e);
        }
    }

    public static boolean isLambdaMethod(String sMethodName) {
        return sMethodName.startsWith("lambda$");
    }

    public static boolean isMethodReference(SerializedLambda lambda) {
        return lambda.getImplMethodKind() == 8 || !Lambdas.isLambdaMethod(lambda.getImplMethodName()) && lambda.getCapturedArgCount() == 0;
    }

    public static ClassDefinition createDefinition(ClassIdentity id, Serializable lambda, ClassLoader loader) {
        SerializedLambda lambdaMetadata = Lambdas.getSerializedLambda(lambda);
        if (lambdaMetadata.getImplMethodKind() == 6 || Lambdas.isMethodReference(lambdaMetadata)) {
            ClassDefinition definition = new ClassDefinition(id, RemotableLambdaGenerator.createRemoteLambdaClass(id.getName(), lambdaMetadata, loader));
            definition.dumpClass(DUMP_LAMBDAS);
            return definition;
        }
        throw new IllegalArgumentException("The specified lambda is referring to the enclosing class instance or its fields and therefore cannot be marshalled across network boundaries (" + lambdaMetadata + ")");
    }

    public static LambdaIdentity createIdentity(SerializedLambda lambdaMetadata, ClassLoader loader) {
        return Lambdas.isMethodReference(lambdaMetadata) ? new MethodReferenceIdentity(lambdaMetadata, loader) : new AnonymousLambdaIdentity(lambdaMetadata, loader);
    }

    public static Object[] getCapturedArguments(SerializedLambda lambdaMetadata) {
        int c = lambdaMetadata.getCapturedArgCount();
        Object[] aoArgs = new Object[c];
        for (int i = 0; i < c; ++i) {
            aoArgs[i] = lambdaMetadata.getCapturedArg(i);
        }
        return aoArgs;
    }

    public static <T extends Serializable> T ensureRemotable(T function) {
        if (!Lambdas.isDynamicLambdas() || function instanceof AbstractRemotableLambda || !Lambdas.isLambda(function)) {
            return function;
        }
        RemotableSupport support = RemotableSupport.get(function.getClass().getClassLoader());
        return support.realize(support.createRemoteConstructor(function));
    }

    public static Object ensureSerializable(Object oFunction) {
        return Lambdas.isLambda(oFunction) ? (Lambdas.isDynamicLambdas() ? Lambdas.ensureRemotable((Serializable)oFunction) : new StaticLambdaInfo<Object>(oFunction.getClass(), oFunction)) : oFunction;
    }

    public static <T extends Remotable> String getValueExtractorCanonicalName(Object oLambda) {
        if (oLambda instanceof AbstractRemotableLambda) {
            AbstractRemotableLambda lambda = (AbstractRemotableLambda)oLambda;
            return CanonicalNames.computeValueExtractorCanonicalName(((MethodReferenceIdentity)lambda.getId()).getImplMethod() + "()", null);
        }
        return null;
    }

    public static boolean isDynamicLambdas() {
        return LAMBDAS_SERIALIZATION_MODE == SerializationMode.DYNAMIC;
    }

    public static boolean isStaticLambdas() {
        return LAMBDAS_SERIALIZATION_MODE == SerializationMode.STATIC;
    }

    static {
        String sPropValue = null;
        SerializationMode mode = SerializationMode.DYNAMIC;
        try {
            sPropValue = Config.getProperty(LAMBDAS_SERIALIZATION_MODE_PROPERTY, SerializationMode.DYNAMIC.name());
            mode = SerializationMode.valueOf(sPropValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            StringBuilder sbValues = new StringBuilder("[");
            for (SerializationMode m : SerializationMode.values()) {
                sbValues.append((Object)m).append("|");
            }
            sbValues.setCharAt(sbValues.length() - 1, ']');
            String f_sPropValue = sPropValue;
            SerializationMode f_mode = mode;
            CacheFactory.log("System property \"coherence.lambdas\" is set to invalid value of \"" + f_sPropValue + "\"; valid values are: " + sbValues.toString() + ". Reverting to default mode of " + f_mode.name() + ".", 2);
        }
        LAMBDAS_SERIALIZATION_MODE = mode;
    }

    public static enum SerializationMode {
        DYNAMIC,
        STATIC;

    }
}

