/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.invoke;

import com.tangosol.internal.util.invoke.ClassDefinition;
import com.tangosol.internal.util.invoke.ClassIdentity;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.internal.util.invoke.RemotableSupport;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.SerializationSupport;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerAware;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import javax.json.bind.annotation.JsonbProperty;

public class RemoteConstructor<T>
implements ExternalizableLite,
PortableObject,
SerializationSupport,
SerializerAware {
    @JsonbProperty(value="definition")
    protected ClassDefinition m_definition;
    @JsonbProperty(value="args")
    protected Object[] m_aoArgs;
    private transient Serializer m_serializer;
    protected transient ClassLoader m_loader;

    public RemoteConstructor() {
    }

    public RemoteConstructor(ClassDefinition definition, Object[] aoArgs) {
        this.m_definition = definition;
        for (int i = 0; i < aoArgs.length; ++i) {
            Object arg = aoArgs[i];
            aoArgs[i] = Lambdas.isLambda(arg) ? Lambdas.ensureRemotable((Serializable)arg) : arg;
        }
        this.m_aoArgs = aoArgs;
    }

    public ClassIdentity getId() {
        return this.getDefinition().getId();
    }

    public ClassDefinition getDefinition() {
        return this.m_definition;
    }

    public Object[] getArguments() {
        return this.m_aoArgs;
    }

    public T newInstance() {
        RemotableSupport support = RemotableSupport.get(this.getClassLoader());
        return support.realize(this);
    }

    protected ClassLoader getClassLoader() {
        ClassLoader loader = this.m_loader;
        return loader == null ? Base.getContextClassLoader(this) : loader;
    }

    public boolean equals(Object o) {
        if (o instanceof RemoteConstructor) {
            RemoteConstructor that = (RemoteConstructor)o;
            return this == that || this.getClass() == that.getClass() && Base.equals(this.m_definition, that.m_definition) && Base.equalsDeep(this.m_aoArgs, that.m_aoArgs);
        }
        return false;
    }

    public int hashCode() {
        int nHash = this.m_definition.hashCode();
        nHash = 31 * nHash + Arrays.hashCode(this.m_aoArgs);
        return nHash;
    }

    public String toString() {
        return "RemoteConstructor{definition=" + this.m_definition + ", arguments=" + Arrays.toString(this.m_aoArgs) + '}';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_definition = (ClassDefinition)ExternalizableHelper.readObject(in);
        int cArgs = ExternalizableHelper.readInt(in);
        Base.azzert(cArgs < 256, "Unexpected number of constructor arguments.");
        this.m_aoArgs = new Object[cArgs];
        Object[] aoArgs = this.m_aoArgs;
        for (int i = 0; i < aoArgs.length; ++i) {
            aoArgs[i] = ExternalizableHelper.readObject(in);
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_definition);
        Object[] aoArgs = this.m_aoArgs;
        ExternalizableHelper.writeInt(out, aoArgs.length);
        for (Object o : aoArgs) {
            ExternalizableHelper.writeObject(out, o);
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_definition = (ClassDefinition)in.readObject(0);
        this.m_aoArgs = in.readArray(1, Object[]::new);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_definition);
        out.writeObjectArray(1, this.m_aoArgs);
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        if (!Lambdas.isDynamicLambdas()) {
            throw new NotSerializableException(RemoteConstructor.class.getName());
        }
        return this.newInstance();
    }

    @Override
    public Serializer getContextSerializer() {
        return this.m_serializer;
    }

    @Override
    public void setContextSerializer(Serializer serializer) {
        this.m_serializer = serializer;
        if (serializer instanceof ClassLoaderAware) {
            this.m_loader = ((ClassLoaderAware)((Object)serializer)).getContextClassLoader();
        }
    }
}

