/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.invoke.lambda;

import com.tangosol.dev.assembler.Method;
import com.tangosol.internal.asm.ClassReader;
import com.tangosol.internal.asm.ClassWriter;
import com.tangosol.internal.asm.MethodVisitor;
import com.tangosol.internal.asm.Type;
import com.tangosol.internal.asm.tree.ClassNode;
import com.tangosol.internal.asm.tree.MethodNode;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.internal.util.invoke.RemotableClassGenerator;
import com.tangosol.internal.util.invoke.lambda.AbstractRemotableLambda;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.SerializedLambda;
import java.util.List;

public final class RemotableLambdaGenerator
extends RemotableClassGenerator {
    private static final String ABSTRACT_REMOTE_LAMBDA_NAME = Type.getType(AbstractRemotableLambda.class).getInternalName();

    public static byte[] createRemoteLambdaClass(String sClassName, SerializedLambda lambdaMetadata, ClassLoader loader) {
        int i;
        String[] asIfaces = new String[]{lambdaMetadata.getFunctionalInterfaceClass()};
        ClassWriter cw = new ClassWriter(3);
        cw.visit(52, 4113, sClassName, null, ABSTRACT_REMOTE_LAMBDA_NAME, asIfaces);
        String sInvMethodName = lambdaMetadata.getImplMethodName();
        String sInvMethodSig = lambdaMetadata.getImplMethodSignature();
        String sSAMSig = lambdaMetadata.getFunctionalInterfaceMethodSignature();
        String[] asSAMSig = Method.toTypes(lambdaMetadata.getFunctionalInterfaceMethodSignature());
        String[] asImplSig = Method.toTypes(sInvMethodSig);
        String[] asDestSig = Method.toTypes(lambdaMetadata.getInstantiatedMethodType());
        int cArgs = lambdaMetadata.getCapturedArgCount();
        int nSigDelta = asDestSig.length - (asImplSig.length - cArgs);
        if (nSigDelta == 0) {
            asDestSig = asImplSig;
        } else {
            assert (nSigDelta == 1) : "Unexpected differences between lambda signatures: " + lambdaMetadata;
            asDestSig[0] = asImplSig[0];
            int c = asDestSig.length - 1;
            for (int i2 = 1; i2 < c; ++i2) {
                asDestSig[i2 + 1] = asImplSig[i2 + cArgs];
            }
        }
        String[] asArgNames = new String[cArgs];
        for (int i3 = 0; i3 < cArgs; ++i3) {
            asArgNames[i3] = "arg$" + (i3 + 1);
            cw.visitField(18, asArgNames[i3], asImplSig[i3 + 1], null, null).visitEnd();
        }
        String sConSig = RemotableLambdaGenerator.createConstructorSig(asImplSig, cArgs);
        MethodVisitor mv = cw.visitMethod(1, "<init>", sConSig, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, ABSTRACT_REMOTE_LAMBDA_NAME, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false);
        int c = asArgNames.length;
        int lvIndex = 1;
        for (int i4 = 0; i4 < c; ++i4) {
            String sArgType = asImplSig[i4 + 1];
            int nOpcode = RemotableLambdaGenerator.getLoadOpcode(sArgType);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(nOpcode, lvIndex);
            mv.visitFieldInsn(181, sClassName, asArgNames[i4], sArgType);
            lvIndex += nOpcode == 22 || nOpcode == 24 ? 2 : 1;
        }
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        int nMethKind = lambdaMetadata.getImplMethodKind();
        int iOpInvoke = RemotableLambdaGenerator.toInvokeOp(nMethKind);
        String sInvClassName = lambdaMetadata.getImplClass();
        if (Lambdas.isLambdaMethod(sInvMethodName)) {
            RemotableLambdaGenerator.copyLambdaMethod(cw, lambdaMetadata, loader);
            sInvClassName = sClassName;
        }
        MethodVisitor mv2 = cw.visitMethod(1, lambdaMetadata.getFunctionalInterfaceMethodName(), sSAMSig, null, null);
        mv2.visitCode();
        if (nMethKind == 8) {
            mv2.visitTypeInsn(187, sInvClassName);
            mv2.visitInsn(89);
        }
        int c2 = asArgNames.length;
        for (i = 0; i < c2; ++i) {
            mv2.visitVarInsn(25, 0);
            mv2.visitFieldInsn(180, sClassName, asArgNames[i], asImplSig[i + 1]);
        }
        assert (asSAMSig.length == asDestSig.length - cArgs);
        c2 = asSAMSig.length;
        int lvIndex2 = 1;
        for (i = 1; i < c2; ++i) {
            String sTypeSAM = asSAMSig[i];
            String sTypeDest = asDestSig[i + cArgs];
            int nOpcode = RemotableLambdaGenerator.getLoadOpcode(sTypeSAM);
            mv2.visitVarInsn(nOpcode, lvIndex2);
            lvIndex2 += nOpcode == 22 || nOpcode == 24 ? 2 : 1;
            RemotableLambdaGenerator.coerceType(mv2, sTypeSAM, sTypeDest);
        }
        mv2.visitMethodInsn(iOpInvoke, sInvClassName, sInvMethodName, sInvMethodSig, iOpInvoke == 185);
        RemotableLambdaGenerator.coerceType(mv2, asDestSig[0], asSAMSig[0]);
        mv2.visitInsn(RemotableLambdaGenerator.getReturnOpcode(asSAMSig[0]));
        mv2.visitMaxs(-1, -1);
        mv2.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static String createConstructorSig(String[] asArgs, int cMax) {
        assert (cMax <= asArgs.length);
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < cMax; ++i) {
            sb.append(asArgs[i + 1]);
        }
        return sb.append(")V").toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String copyLambdaMethod(ClassWriter cw, SerializedLambda lambdaMetadata, ClassLoader loader) {
        String sImplClassName = lambdaMetadata.getImplClass();
        String sMethodName = lambdaMetadata.getImplMethodName();
        String sMethodSig = lambdaMetadata.getImplMethodSignature();
        try (InputStream is = loader.getResourceAsStream(sImplClassName + ".class");){
            ClassReader reader = new ClassReader(is);
            ClassNode implClass = new ClassNode();
            reader.accept(implClass, 0);
            List<MethodNode> listMethod = implClass.methods;
            MethodNode methMatch = null;
            for (MethodNode mn : listMethod) {
                if (!mn.name.equals(sMethodName) || !mn.desc.equals(sMethodSig)) continue;
                mn.instructions.resetLabels();
                methMatch = mn;
                break;
            }
            if (methMatch != null) {
                methMatch.accept(cw.visitMethod(10, sMethodName, sMethodSig, null, null));
                String string = sMethodName;
                return string;
            }
            throw new IllegalStateException("Expected lambda method not found: " + sImplClassName + '.' + sMethodName + sMethodSig);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error in copying lambda implementation from:" + sImplClassName + '.' + sMethodName + sMethodSig, e);
        }
    }
}

