/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream;

import com.tangosol.internal.util.DoubleBag;
import com.tangosol.internal.util.DoubleSummaryStatistics;
import com.tangosol.internal.util.stream.AbstractPipeline;
import com.tangosol.internal.util.stream.DoubleCollectorAggregator;
import com.tangosol.internal.util.stream.IntPipeline;
import com.tangosol.internal.util.stream.LongPipeline;
import com.tangosol.internal.util.stream.ReferencePipeline;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Streamer;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteDoubleStream;
import com.tangosol.util.stream.RemoteIntStream;
import com.tangosol.util.stream.RemoteLongStream;
import com.tangosol.util.stream.RemotePipeline;
import com.tangosol.util.stream.RemoteStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import javax.json.bind.annotation.JsonbProperty;

public abstract class DoublePipeline<K, V, E_IN, S_IN extends BaseStream<E_IN, S_IN>>
extends AbstractPipeline<K, V, E_IN, Double, S_IN, DoubleStream>
implements RemoteDoubleStream {
    public DoublePipeline() {
    }

    protected DoublePipeline(AbstractPipeline<K, V, ?, E_IN, ?, S_IN> previousStage, Function<S_IN, DoubleStream> intermediateOp) {
        super(previousStage, intermediateOp);
    }

    @Override
    public RemoteDoubleStream sequential() {
        this.setParallel(false);
        return this;
    }

    @Override
    public RemoteDoubleStream parallel() {
        this.setParallel(true);
        return this;
    }

    @Override
    public RemoteDoubleStream unordered() {
        return new StatelessOp(this, s -> (DoubleStream)s.unordered());
    }

    @Override
    public RemoteDoubleStream filter(DoublePredicate predicate) {
        return new StatelessOp(this, s -> s.filter(predicate));
    }

    @Override
    public RemoteDoubleStream map(DoubleUnaryOperator mapper) {
        return new StatelessOp(this, s -> s.map(mapper));
    }

    @Override
    public <U> RemoteStream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        return new ReferencePipeline.StatelessOp(this, s -> s.mapToObj(mapper));
    }

    @Override
    public RemoteLongStream mapToLong(DoubleToLongFunction mapper) {
        return new LongPipeline.StatelessOp(this, s -> s.mapToLong(mapper));
    }

    @Override
    public RemoteIntStream mapToInt(DoubleToIntFunction mapper) {
        return new IntPipeline.StatelessOp(this, s -> s.mapToInt(mapper));
    }

    @Override
    public RemoteDoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        return new StatelessOp(this, s -> s.flatMap(mapper));
    }

    @Override
    public RemoteDoubleStream peek(DoubleConsumer action) {
        return new StatelessOp(this, s -> s.peek(action));
    }

    @Override
    public DoubleStream limit(long maxSize) {
        StatefulOp op = new StatefulOp(this, s -> s.limit(maxSize));
        return Arrays.stream(this.collectToBag(op).toArray()).limit(maxSize);
    }

    @Override
    public DoubleStream skip(long n) {
        return Arrays.stream(this.collectToBag(this).toArray()).skip(n);
    }

    @Override
    public DoubleStream distinct() {
        StatefulOp op = new StatefulOp(this, s -> s.distinct());
        return Arrays.stream(this.collectToBag(op).toArray());
    }

    @Override
    public DoubleStream sorted() {
        StatefulOp op = new StatefulOp(this, s -> s.sorted());
        return Arrays.stream(this.collectToBag(op).toArray()).sorted();
    }

    @Override
    public RemoteStream<Double> boxed() {
        return new ReferencePipeline.StatelessOp(this, s -> s.boxed());
    }

    @Override
    public void forEach(DoubleConsumer action) {
        this.collectToBag(this).forEach(action);
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        this.forEach(action);
    }

    @Override
    public double[] toArray() {
        return this.collectToBag(this).toArray();
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        return ((double[])this.collect(() -> new double[]{identity}, (a, t) -> {
            a[0] = op.applyAsDouble(a[0], t);
        }, (a, b) -> {
            a[0] = op.applyAsDouble(a[0], b[0]);
        }))[0];
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        Optional result = (Optional)this.collect(() -> new Optional(op), Optional::accept, (a, b) -> {
            if (b.isPresent()) {
                a.accept(b.getValue());
            }
        });
        return result.isPresent() ? OptionalDouble.of(result.getValue()) : OptionalDouble.empty();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.collect((RemotePipeline<DoubleStream>)this, supplier, accumulator, combiner);
    }

    @Override
    public double sum() {
        return this.reduce(0.0, Double::sum);
    }

    @Override
    public OptionalDouble min() {
        return this.reduce(Math::min);
    }

    @Override
    public OptionalDouble max() {
        return this.reduce(Math::max);
    }

    @Override
    public long count() {
        return this.mapToLong(e -> 1L).sum();
    }

    @Override
    public OptionalDouble average() {
        long[] avg = (long[])this.collect(() -> new long[2], (ll, i) -> {
            ll[0] = ll[0] + 1L;
            ll[1] = (long)((double)ll[1] + i);
        }, (ll, rr) -> {
            ll[0] = ll[0] + rr[0];
            ll[1] = ll[1] + rr[1];
        });
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return (DoubleSummaryStatistics)this.collect(DoubleSummaryStatistics::new, java.util.DoubleSummaryStatistics::accept, java.util.DoubleSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        return (Boolean)this.invoke(new MatcherAggregator(this, s -> s.anyMatch(predicate), p -> p));
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        return (Boolean)this.invoke(new MatcherAggregator(this, s -> s.allMatch(predicate), p -> p == false));
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return (Boolean)this.invoke(new MatcherAggregator(this, s -> s.noneMatch(predicate), p -> p == false));
    }

    @Override
    public OptionalDouble findFirst() {
        return (OptionalDouble)this.invoke(new FinderAggregator(this, DoubleStream::findFirst));
    }

    @Override
    public OptionalDouble findAny() {
        return (OptionalDouble)this.invoke(new FinderAggregator(this, DoubleStream::findAny));
    }

    @Override
    public final PrimitiveIterator.OfDouble iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public final Spliterator.OfDouble spliterator() {
        return Spliterators.spliterator(this.toArray(), 0);
    }

    protected DoubleBag collectToBag(RemotePipeline<DoubleStream> pipeline) {
        return (DoubleBag)this.collect(pipeline, DoubleBag::new, DoubleBag::add, DoubleBag::addAll);
    }

    protected <R> R collect(RemotePipeline<DoubleStream> pipeline, Remote.Supplier<R> supplier, Remote.ObjDoubleConsumer<R> accumulator, Remote.BiConsumer<R, R> combiner) {
        return this.invoke(new DoubleCollectorAggregator(pipeline, supplier, accumulator, combiner));
    }

    protected <R> R collect(RemotePipeline<DoubleStream> pipeline, Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.invoke(new DoubleCollectorAggregator(pipeline, supplier, accumulator, combiner));
    }

    public static class Optional
    implements Remote.DoubleConsumer,
    ExternalizableLite,
    PortableObject {
        @JsonbProperty(value="op")
        private DoubleBinaryOperator m_op;
        @JsonbProperty(value="value")
        private double m_value = 0.0;
        @JsonbProperty(value="isPresent")
        private boolean m_fPresent = false;

        public Optional() {
        }

        public Optional(DoubleBinaryOperator op) {
            this.m_op = op;
        }

        public double getValue() {
            return this.m_value;
        }

        public boolean isPresent() {
            return this.m_fPresent;
        }

        @Override
        public void accept(double t) {
            if (this.m_fPresent) {
                this.m_value = this.m_op.applyAsDouble(this.m_value, t);
            } else {
                this.m_value = t;
                this.m_fPresent = true;
            }
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_op = (DoubleBinaryOperator)ExternalizableHelper.readObject(in);
            this.m_value = in.readDouble();
            this.m_fPresent = in.readBoolean();
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_op);
            out.writeDouble(this.m_value);
            out.writeBoolean(this.m_fPresent);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_op = (DoubleBinaryOperator)in.readObject(0);
            this.m_value = in.readDouble(1);
            this.m_fPresent = in.readBoolean(2);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_op);
            out.writeDouble(1, this.m_value);
            out.writeBoolean(2, this.m_fPresent);
        }
    }

    public static class FinderAggregator<K, V>
    implements InvocableMap.StreamingAggregator<K, V, OptionalDouble, OptionalDouble>,
    ExternalizableLite,
    PortableObject {
        @JsonbProperty(value="pipeline")
        private RemotePipeline<? extends DoubleStream> m_pipeline;
        @JsonbProperty(value="fnFinder")
        private Remote.Function<DoubleStream, OptionalDouble> m_fnFinder;
        private transient OptionalDouble m_result = OptionalDouble.empty();
        private transient boolean m_fDone;

        public FinderAggregator() {
        }

        FinderAggregator(RemotePipeline<? extends DoubleStream> pipeline, Remote.Function<DoubleStream, OptionalDouble> fnFinder) {
            this.m_pipeline = pipeline;
            this.m_fnFinder = fnFinder;
        }

        @Override
        public InvocableMap.StreamingAggregator<K, V, OptionalDouble, OptionalDouble> supply() {
            return new FinderAggregator<K, V>(this.m_pipeline, this.m_fnFinder);
        }

        @Override
        public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
            DoubleStream stream = this.m_pipeline.evaluate(streamer.stream());
            this.m_result = (OptionalDouble)this.m_fnFinder.apply(stream);
            return !this.m_result.isPresent();
        }

        @Override
        public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean combine(OptionalDouble partialResult) {
            if (!this.m_fDone) {
                this.m_result = partialResult;
                this.m_fDone = this.m_result.isPresent();
            }
            return !this.m_fDone;
        }

        @Override
        public OptionalDouble getPartialResult() {
            return this.m_result;
        }

        @Override
        public OptionalDouble finalizeResult() {
            return this.m_result;
        }

        @Override
        public int characteristics() {
            return 2;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_pipeline = (RemotePipeline)ExternalizableHelper.readObject(in);
            this.m_fnFinder = (Remote.Function)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_pipeline);
            ExternalizableHelper.writeObject(out, this.m_fnFinder);
        }

        @Override
        public void readExternal(PofReader reader) throws IOException {
            this.m_pipeline = (RemotePipeline)reader.readObject(0);
            this.m_fnFinder = (Remote.Function)reader.readObject(1);
        }

        @Override
        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeObject(0, this.m_pipeline);
            writer.writeObject(1, this.m_fnFinder);
        }
    }

    public static class MatcherAggregator<K, V>
    implements InvocableMap.StreamingAggregator<K, V, Boolean, Boolean>,
    ExternalizableLite,
    PortableObject {
        @JsonbProperty(value="pipeline")
        private RemotePipeline<? extends DoubleStream> m_pipeline;
        @JsonbProperty(value="fnMatcher")
        private Remote.Function<DoubleStream, Boolean> m_fnMatcher;
        @JsonbProperty(value="predShortCircuit")
        private Remote.Predicate<Boolean> m_predShortCircuit;
        private transient Boolean m_fResult;
        private transient boolean m_fDone;

        public MatcherAggregator() {
        }

        MatcherAggregator(RemotePipeline<? extends DoubleStream> pipeline, Remote.Function<DoubleStream, Boolean> fnMatcher, Remote.Predicate<Boolean> predShortCircuit) {
            this.m_pipeline = pipeline;
            this.m_fnMatcher = fnMatcher;
            this.m_predShortCircuit = predShortCircuit;
        }

        @Override
        public InvocableMap.StreamingAggregator<K, V, Boolean, Boolean> supply() {
            return new MatcherAggregator<K, V>(this.m_pipeline, this.m_fnMatcher, this.m_predShortCircuit);
        }

        @Override
        public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
            DoubleStream stream = this.m_pipeline.evaluate(streamer.stream());
            this.m_fResult = (Boolean)this.m_fnMatcher.apply(stream);
            return !this.m_predShortCircuit.test(this.m_fResult);
        }

        @Override
        public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean combine(Boolean partialResult) {
            if (!this.m_fDone) {
                this.m_fResult = partialResult;
                this.m_fDone = this.m_predShortCircuit.test(this.m_fResult);
            }
            return !this.m_fDone;
        }

        @Override
        public Boolean getPartialResult() {
            return this.m_fResult;
        }

        @Override
        public Boolean finalizeResult() {
            return this.m_fResult;
        }

        @Override
        public int characteristics() {
            return 2;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_pipeline = (RemotePipeline)ExternalizableHelper.readObject(in);
            this.m_fnMatcher = (Remote.Function)ExternalizableHelper.readObject(in);
            this.m_predShortCircuit = (Remote.Predicate)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_pipeline);
            ExternalizableHelper.writeObject(out, this.m_fnMatcher);
            ExternalizableHelper.writeObject(out, this.m_predShortCircuit);
        }

        @Override
        public void readExternal(PofReader reader) throws IOException {
            this.m_pipeline = (RemotePipeline)reader.readObject(0);
            this.m_fnMatcher = (Remote.Function)reader.readObject(1);
            this.m_predShortCircuit = (Remote.Predicate)reader.readObject(2);
        }

        @Override
        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeObject(0, this.m_pipeline);
            writer.writeObject(1, this.m_fnMatcher);
            writer.writeObject(2, this.m_predShortCircuit);
        }
    }

    public static class StatefulOp<K, V, E_IN, S_IN extends BaseStream<E_IN, S_IN>>
    extends DoublePipeline<K, V, E_IN, S_IN> {
        public StatefulOp() {
        }

        StatefulOp(AbstractPipeline<K, V, ?, E_IN, ?, S_IN> previousStage, Remote.Function<S_IN, DoubleStream> intermediateOp) {
            super(previousStage, intermediateOp);
        }
    }

    public static class StatelessOp<K, V, E_IN, S_IN extends BaseStream<E_IN, S_IN>>
    extends DoublePipeline<K, V, E_IN, S_IN> {
        public StatelessOp() {
        }

        StatelessOp(AbstractPipeline<K, V, ?, E_IN, ?, S_IN> previousStage, Remote.Function<S_IN, DoubleStream> intermediateOp) {
            super(previousStage, intermediateOp);
        }
    }
}

