/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream;

import com.tangosol.internal.util.stream.AbstractPipeline;
import com.tangosol.internal.util.stream.CollectorAggregator;
import com.tangosol.internal.util.stream.DoublePipeline;
import com.tangosol.internal.util.stream.IntPipeline;
import com.tangosol.internal.util.stream.LongPipeline;
import com.tangosol.internal.util.stream.collectors.BiReducingCollector;
import com.tangosol.internal.util.stream.collectors.MappingCollector;
import com.tangosol.internal.util.stream.collectors.ReducingCollector;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.partition.AbstractPartitionedIterator;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.SimpleHolder;
import com.tangosol.util.Streamer;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.filter.PartitionedFilter;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import com.tangosol.util.stream.RemoteCollectors;
import com.tangosol.util.stream.RemoteDoubleStream;
import com.tangosol.util.stream.RemoteIntStream;
import com.tangosol.util.stream.RemoteLongStream;
import com.tangosol.util.stream.RemotePipeline;
import com.tangosol.util.stream.RemoteStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.json.bind.annotation.JsonbProperty;

public abstract class ReferencePipeline<K, V, P_IN, P_OUT, S_IN extends BaseStream<P_IN, S_IN>>
extends AbstractPipeline<K, V, P_IN, P_OUT, S_IN, Stream<P_OUT>>
implements RemoteStream<P_OUT> {
    protected ReferencePipeline() {
    }

    protected ReferencePipeline(InvocableMap<K, V> map, boolean fParallel, Collection<? extends K> colKeys, Filter filter, Function<S_IN, Stream<P_OUT>> intermediateOp) {
        super(map, fParallel, colKeys, filter, intermediateOp);
    }

    protected ReferencePipeline(AbstractPipeline<K, V, ?, P_IN, ?, S_IN> previousStage, Function<S_IN, Stream<P_OUT>> intermediateOp) {
        super(previousStage, intermediateOp);
    }

    @Override
    public RemoteStream<P_OUT> sequential() {
        this.setParallel(false);
        return this;
    }

    @Override
    public RemoteStream<P_OUT> parallel() {
        this.setParallel(true);
        return this;
    }

    @Override
    public RemoteStream<P_OUT> unordered() {
        return new StatelessOp(this, s -> (Stream)s.unordered());
    }

    @Override
    public RemoteStream<P_OUT> filter(Predicate<? super P_OUT> filter) {
        return new StatelessOp(this, s -> s.filter(filter));
    }

    @Override
    public <R> RemoteStream<R> map(Function<? super P_OUT, ? extends R> mapper) {
        return new StatelessOp(this, s -> s.map(mapper));
    }

    @Override
    public RemoteIntStream mapToInt(ToIntFunction<? super P_OUT> mapper) {
        return new IntPipeline.StatelessOp(this, s -> s.mapToInt(mapper));
    }

    @Override
    public RemoteLongStream mapToLong(ToLongFunction<? super P_OUT> mapper) {
        return new LongPipeline.StatelessOp(this, s -> s.mapToLong(mapper));
    }

    @Override
    public RemoteDoubleStream mapToDouble(ToDoubleFunction<? super P_OUT> mapper) {
        return new DoublePipeline.StatelessOp(this, s -> s.mapToDouble(mapper));
    }

    @Override
    public <R> RemoteStream<R> flatMap(Function<? super P_OUT, ? extends Stream<? extends R>> mapper) {
        return new StatelessOp(this, s -> s.flatMap(mapper));
    }

    @Override
    public RemoteIntStream flatMapToInt(Function<? super P_OUT, ? extends IntStream> mapper) {
        return new IntPipeline.StatelessOp(this, s -> s.flatMapToInt(mapper));
    }

    @Override
    public RemoteLongStream flatMapToLong(Function<? super P_OUT, ? extends LongStream> mapper) {
        return new LongPipeline.StatelessOp(this, s -> s.flatMapToLong(mapper));
    }

    @Override
    public RemoteDoubleStream flatMapToDouble(Function<? super P_OUT, ? extends DoubleStream> mapper) {
        return new DoublePipeline.StatelessOp(this, s -> s.flatMapToDouble(mapper));
    }

    @Override
    public RemoteStream<P_OUT> peek(Consumer<? super P_OUT> action) {
        return new StatelessOp(this, s -> s.peek(action));
    }

    @Override
    public Stream<P_OUT> limit(long maxSize) {
        return this.collect(new StatefulOp(this, s -> s.limit(maxSize)), this.toCollection()).stream().limit(maxSize);
    }

    @Override
    public Stream<P_OUT> skip(long n) {
        return this.collect(this, this.toCollection()).stream().skip(n);
    }

    @Override
    public Stream<P_OUT> distinct() {
        return this.collect(this, this.toSet()).stream();
    }

    @Override
    public RemoteStream<P_OUT> sorted() {
        SafeComparator comp = SafeComparator.INSTANCE;
        StatefulOp op = new StatefulOp(this, s -> s.sorted(comp));
        op.setComparator(comp);
        return op;
    }

    @Override
    public RemoteStream<P_OUT> sorted(Comparator<? super P_OUT> comparator) {
        SafeComparator comp = new SafeComparator(comparator);
        StatefulOp op = new StatefulOp(this, s -> s.sorted(comp));
        op.setComparator(comp);
        return op;
    }

    @Override
    public Iterator<P_OUT> iterator() {
        if (this.isSorted() || !this.isPartitionable()) {
            return this.collect(this.toCollection()).iterator();
        }
        return this.createPartitionedIterator(filter -> (Collection)this.getMap().aggregate((Filter)filter, new CollectorAggregator(this, this.toCollection())), false);
    }

    @Override
    public Spliterator<P_OUT> spliterator() {
        if (this.isSorted() || !this.isPartitionable()) {
            return this.collect(this.toCollection()).spliterator();
        }
        return new PartitionedSpliterator<P_OUT>(this.createPartitionedIterator(filter -> (Collection)this.getMap().aggregate((Filter)filter, new CollectorAggregator(this, this.toCollection())), false));
    }

    @Override
    public void forEach(Consumer<? super P_OUT> action) {
        this.iterator().forEachRemaining(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super P_OUT> action) {
        this.forEach(action);
    }

    @Override
    public Object[] toArray() {
        return this.collect(this.toCollection()).toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        Collection col = this.collect(this.toCollection());
        return col.toArray(generator.apply(col.size()));
    }

    @Override
    public P_OUT reduce(P_OUT identity, BinaryOperator<P_OUT> accumulator) {
        return this.collect((RemoteCollector)ReferencePipeline.reducing(identity, accumulator));
    }

    @Override
    public Optional<P_OUT> reduce(BinaryOperator<P_OUT> accumulator) {
        return this.collect((RemoteCollector)ReferencePipeline.reducing(accumulator));
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super P_OUT, U> accumulator, BinaryOperator<U> combiner) {
        return this.collect((RemoteCollector)ReferencePipeline.reducing(identity, accumulator, combiner));
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super P_OUT> accumulator, BiConsumer<R, R> combiner) {
        Remote.BinaryOperator operator = (left, right) -> {
            combiner.accept(left, right);
            return left;
        };
        return this.collect((RemoteCollector)RemoteCollector.of(supplier, accumulator, operator, new Collector.Characteristics[0]));
    }

    @Override
    public <R, A> R collect(RemoteCollector<? super P_OUT, A, R> collector) {
        return this.collect(this, collector);
    }

    @Override
    public Optional<P_OUT> min(Comparator<? super P_OUT> comparator) {
        return this.collect((RemoteCollector)ReferencePipeline.minBy(comparator));
    }

    @Override
    public Optional<P_OUT> max(Comparator<? super P_OUT> comparator) {
        return this.collect((RemoteCollector)ReferencePipeline.maxBy(comparator));
    }

    @Override
    public long count() {
        return this.collect(RemoteCollectors.counting());
    }

    @Override
    public boolean anyMatch(Predicate<? super P_OUT> predicate) {
        return (Boolean)this.invoke(new MatcherAggregator(this, s -> s.anyMatch(predicate), p -> p));
    }

    @Override
    public boolean allMatch(Predicate<? super P_OUT> predicate) {
        return (Boolean)this.invoke(new MatcherAggregator(this, s -> s.allMatch(predicate), p -> p == false));
    }

    @Override
    public boolean noneMatch(Predicate<? super P_OUT> predicate) {
        return (Boolean)this.invoke(new MatcherAggregator(this, s -> s.noneMatch(predicate), p -> p == false));
    }

    @Override
    public Optional<P_OUT> findFirst() {
        return (Optional)this.invoke(new FinderAggregator(this, Stream::findFirst));
    }

    @Override
    public Optional<P_OUT> findAny() {
        return (Optional)this.invoke(new FinderAggregator(this, Stream::findAny));
    }

    protected <R, A> R collect(RemotePipeline<? extends Stream<P_OUT>> pipeline, RemoteCollector<? super P_OUT, A, R> collector) {
        return this.invoke(new CollectorAggregator(pipeline, collector));
    }

    protected static <T, U, A, R> RemoteCollector<T, A, R> mapping(Function<? super T, ? extends U> mapper, RemoteCollector<? super U, A, R> downstream) {
        return new MappingCollector<T, U, A, R>(mapper, downstream);
    }

    protected static <T> RemoteCollector<T, ?, Optional<T>> minBy(Comparator<? super T> comparator) {
        return ReferencePipeline.reducing(Remote.BinaryOperator.minBy(comparator));
    }

    protected static <T> RemoteCollector<T, ?, Optional<T>> maxBy(Comparator<? super T> comparator) {
        return ReferencePipeline.reducing(Remote.BinaryOperator.maxBy(comparator));
    }

    protected static <T> RemoteCollector<T, ?, Optional<T>> reducing(BinaryOperator<T> op) {
        return RemoteCollectors.collectingAndThen(ReferencePipeline.reducing(null, op), Optional::ofNullable);
    }

    protected static <T> RemoteCollector<T, ?, T> reducing(T identity, BinaryOperator<T> op) {
        return new ReducingCollector<T>(identity, op);
    }

    protected static <T, U> RemoteCollector<T, SimpleHolder<U>, U> reducing(U identity, BiFunction<? super U, ? super T, ? extends U> mapper, BinaryOperator<U> op) {
        return new BiReducingCollector<T, U>(identity, mapper, op);
    }

    protected PartitionedIterator<P_OUT> createPartitionedIterator(Function<PartitionedFilter, Iterable<P_OUT>> supplier, boolean fByMember) {
        NamedCache cache = (NamedCache)this.getMap();
        PartitionedService service = (PartitionedService)((Object)cache.getCacheService());
        int cParts = service.getPartitionCount();
        PartitionSet parts = new PartitionSet(cParts).fill();
        return new PartitionedIterator(this.getInvoker().getFilter(), cache, parts, supplier, fByMember);
    }

    public static class FinderAggregator<K, V, T>
    implements InvocableMap.StreamingAggregator<K, V, Optional<T>, Optional<T>>,
    ExternalizableLite,
    PortableObject {
        @JsonbProperty(value="pipeline")
        private RemotePipeline<? extends Stream<T>> m_pipeline;
        @JsonbProperty(value="fnFinder")
        private Remote.Function<Stream<T>, Optional<T>> m_fnFinder;
        private transient Optional<T> m_result = Optional.empty();
        private transient boolean m_fDone;

        public FinderAggregator() {
        }

        FinderAggregator(RemotePipeline<? extends Stream<T>> pipeline, Remote.Function<Stream<T>, Optional<T>> fnFinder) {
            this.m_pipeline = pipeline;
            this.m_fnFinder = fnFinder;
        }

        @Override
        public InvocableMap.StreamingAggregator<K, V, Optional<T>, Optional<T>> supply() {
            return new FinderAggregator<K, V, T>(this.m_pipeline, this.m_fnFinder);
        }

        @Override
        public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
            Stream<T> stream = this.m_pipeline.evaluate(streamer.stream());
            this.m_result = (Optional)this.m_fnFinder.apply(stream);
            return !this.m_result.isPresent();
        }

        @Override
        public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean combine(Optional<T> partialResult) {
            if (!this.m_fDone) {
                this.m_result = partialResult;
                this.m_fDone = this.m_result.isPresent();
            }
            return !this.m_fDone;
        }

        @Override
        public Optional<T> getPartialResult() {
            return this.m_result;
        }

        @Override
        public Optional<T> finalizeResult() {
            return this.m_result;
        }

        @Override
        public int characteristics() {
            return 2;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_pipeline = (RemotePipeline)ExternalizableHelper.readObject(in);
            this.m_fnFinder = (Remote.Function)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_pipeline);
            ExternalizableHelper.writeObject(out, this.m_fnFinder);
        }

        @Override
        public void readExternal(PofReader reader) throws IOException {
            this.m_pipeline = (RemotePipeline)reader.readObject(0);
            this.m_fnFinder = (Remote.Function)reader.readObject(1);
        }

        @Override
        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeObject(0, this.m_pipeline);
            writer.writeObject(1, this.m_fnFinder);
        }
    }

    public static class MatcherAggregator<K, V, T>
    implements InvocableMap.StreamingAggregator<K, V, Boolean, Boolean>,
    ExternalizableLite,
    PortableObject {
        @JsonbProperty(value="pipeline")
        private RemotePipeline<? extends Stream<T>> m_pipeline;
        @JsonbProperty(value="fnMatcher")
        private Remote.Function<Stream<T>, Boolean> m_fnMatcher;
        @JsonbProperty(value="predShortCircuit")
        private Remote.Predicate<Boolean> m_predShortCircuit;
        private transient Boolean m_fResult;
        private transient boolean m_fDone;

        public MatcherAggregator() {
        }

        MatcherAggregator(RemotePipeline<? extends Stream<T>> pipeline, Remote.Function<Stream<T>, Boolean> fnMatcher, Remote.Predicate<Boolean> predShortCircuit) {
            this.m_pipeline = pipeline;
            this.m_fnMatcher = fnMatcher;
            this.m_predShortCircuit = predShortCircuit;
        }

        @Override
        public InvocableMap.StreamingAggregator<K, V, Boolean, Boolean> supply() {
            return new MatcherAggregator<K, V, T>(this.m_pipeline, this.m_fnMatcher, this.m_predShortCircuit);
        }

        @Override
        public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
            Stream<T> stream = this.m_pipeline.evaluate(streamer.stream());
            this.m_fResult = (Boolean)this.m_fnMatcher.apply(stream);
            return !this.m_predShortCircuit.test(this.m_fResult);
        }

        @Override
        public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean combine(Boolean partialResult) {
            if (!this.m_fDone) {
                this.m_fResult = partialResult;
                this.m_fDone = this.m_predShortCircuit.test(this.m_fResult);
            }
            return !this.m_fDone;
        }

        @Override
        public Boolean getPartialResult() {
            return this.m_fResult;
        }

        @Override
        public Boolean finalizeResult() {
            return this.m_fResult;
        }

        @Override
        public int characteristics() {
            return 2;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_pipeline = (RemotePipeline)ExternalizableHelper.readObject(in);
            this.m_fnMatcher = (Remote.Function)ExternalizableHelper.readObject(in);
            this.m_predShortCircuit = (Remote.Predicate)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_pipeline);
            ExternalizableHelper.writeObject(out, this.m_fnMatcher);
            ExternalizableHelper.writeObject(out, this.m_predShortCircuit);
        }

        @Override
        public void readExternal(PofReader reader) throws IOException {
            this.m_pipeline = (RemotePipeline)reader.readObject(0);
            this.m_fnMatcher = (Remote.Function)reader.readObject(1);
            this.m_predShortCircuit = (Remote.Predicate)reader.readObject(2);
        }

        @Override
        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeObject(0, this.m_pipeline);
            writer.writeObject(1, this.m_fnMatcher);
            writer.writeObject(2, this.m_predShortCircuit);
        }
    }

    protected static class PartitionedSpliterator<T>
    implements Spliterator<T> {
        private PartitionedIterator<T> m_iterator;
        private int m_nCharacteristics;

        public PartitionedSpliterator(PartitionedIterator<T> iterator) {
            this(iterator, 0);
        }

        public PartitionedSpliterator(PartitionedIterator<T> iterator, int nCharacteristics) {
            this.m_iterator = iterator;
            this.m_nCharacteristics = nCharacteristics;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.m_iterator.forEachRemaining(action);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            PartitionedIterator<T> it = this.m_iterator;
            if (it.hasNext()) {
                action.accept(it.next());
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<T> trySplit() {
            PartitionSet parts = this.m_iterator.getPartitionSet().split();
            if (parts == null) {
                return null;
            }
            PartitionedIterator<T> iterator = new PartitionedIterator<T>(this.m_iterator, parts);
            return new PartitionedSpliterator<T>(iterator, this.m_nCharacteristics);
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 0x1000 | this.m_nCharacteristics;
        }
    }

    protected static class PartitionedIterator<T>
    extends AbstractPartitionedIterator<T> {
        private Function<PartitionedFilter, Iterable<T>> m_supplier;

        public PartitionedIterator(Filter filter, NamedCache cache, PartitionSet setPids, Function<PartitionedFilter, Iterable<T>> supplier, boolean fByMember) {
            super(filter, cache, setPids, fByMember, false);
            Objects.requireNonNull(supplier);
            this.m_supplier = supplier;
        }

        public PartitionedIterator(PartitionedIterator<T> that, PartitionSet setPids) {
            super(that.m_filter, that.m_cache, setPids, that.m_fByMember, that.m_fRandom);
            this.m_supplier = that.m_supplier;
        }

        @Override
        protected Iterable<T> nextIterable(PartitionedFilter filter) {
            return this.m_supplier.apply(filter);
        }

        protected PartitionSet getPartitionSet() {
            return this.m_setPids;
        }
    }

    public static class StatefulOp<K, V, P_IN, P_OUT, S_IN extends BaseStream<P_IN, S_IN>>
    extends ReferencePipeline<K, V, P_IN, P_OUT, S_IN> {
        public StatefulOp() {
        }

        StatefulOp(AbstractPipeline<K, V, ?, P_IN, ?, S_IN> previousStage, Remote.Function<S_IN, Stream<P_OUT>> intermediateOp) {
            super(previousStage, intermediateOp);
        }
    }

    public static class StatelessOp<K, V, P_IN, P_OUT, S_IN extends BaseStream<P_IN, S_IN>>
    extends ReferencePipeline<K, V, P_IN, P_OUT, S_IN> {
        public StatelessOp() {
        }

        StatelessOp(AbstractPipeline<K, V, ?, P_IN, ?, S_IN> previousStage, Remote.Function<S_IN, Stream<P_OUT>> intermediateOp) {
            super(previousStage, intermediateOp);
        }
    }

    public static class Head<K, V, P_IN, P_OUT, S_IN extends BaseStream<P_IN, S_IN>>
    extends ReferencePipeline<K, V, P_IN, P_OUT, S_IN> {
        public Head() {
        }

        protected Head(InvocableMap<K, V> map, boolean parallel, Collection<? extends K> colKeys, Filter filter, Remote.Function<S_IN, Stream<P_OUT>> intermediateOp) {
            super(map, parallel, colKeys, filter, intermediateOp);
        }
    }
}

