/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.json.bind.annotation.JsonbProperty;

public class MapCollector<T, K, V, M extends Map<K, V>>
implements RemoteCollector<T, M, M>,
ExternalizableLite,
PortableObject {
    protected static final Set<Collector.Characteristics> S_CHARACTERISTICS = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    @JsonbProperty(value="keyMapper")
    protected Function<? super T, ? extends K> m_keyMapper;
    @JsonbProperty(value="valueMapper")
    protected Function<? super T, ? extends V> m_valueMapper;
    @JsonbProperty(value="mergeFunction")
    protected BinaryOperator<V> m_mergeFunction;
    @JsonbProperty(value="supplier")
    protected Supplier<M> m_supplier;

    public MapCollector() {
    }

    public MapCollector(Remote.Function<? super T, ? extends K> keyMapper, Remote.Function<? super T, ? extends V> valueMapper, Remote.BinaryOperator<V> mergeFunction, Remote.Supplier<M> supplier) {
        this.m_keyMapper = Lambdas.ensureRemotable(keyMapper);
        this.m_valueMapper = Lambdas.ensureRemotable(valueMapper);
        this.m_mergeFunction = mergeFunction;
        this.m_supplier = supplier;
    }

    @Override
    public Supplier<M> supplier() {
        return this.m_supplier;
    }

    @Override
    public BiConsumer<M, T> accumulator() {
        Function keyMapper = this.m_keyMapper;
        Function valueMapper = this.m_valueMapper;
        BinaryOperator mergeFunction = this.getMergeFunction();
        return (map, t) -> map.merge(keyMapper.apply(t), valueMapper.apply(t), mergeFunction);
    }

    @Override
    public BinaryOperator<M> combiner() {
        BinaryOperator<V> mergeFunction = this.getMergeFunction();
        return Remote.BinaryOperator.mapMerger(mergeFunction);
    }

    @Override
    public Function<M, M> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return S_CHARACTERISTICS;
    }

    protected BinaryOperator<V> getMergeFunction() {
        return this.m_mergeFunction == null ? this.throwingMerger() : this.m_mergeFunction;
    }

    protected BinaryOperator<V> throwingMerger() {
        return (v1, v2) -> {
            throw new IllegalStateException(String.format("Duplicate key for values %s and %s", v1, v2));
        };
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_keyMapper = (Function)ExternalizableHelper.readObject(in);
        this.m_valueMapper = (Function)ExternalizableHelper.readObject(in);
        this.m_mergeFunction = (BinaryOperator)ExternalizableHelper.readObject(in);
        this.m_supplier = (Supplier)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_keyMapper);
        ExternalizableHelper.writeObject(out, this.m_valueMapper);
        ExternalizableHelper.writeObject(out, this.m_mergeFunction);
        ExternalizableHelper.writeObject(out, this.m_supplier);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_keyMapper = (Function)in.readObject(0);
        this.m_valueMapper = (Function)in.readObject(1);
        this.m_mergeFunction = (BinaryOperator)in.readObject(2);
        this.m_supplier = (Supplier)in.readObject(3);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_keyMapper);
        out.writeObject(1, this.m_valueMapper);
        out.writeObject(2, this.m_mergeFunction);
        out.writeObject(3, this.m_supplier);
    }
}

