/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collector;
import javax.json.bind.annotation.JsonbProperty;

public class SummingDoubleCollector<T>
implements RemoteCollector<T, double[], Double>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="mapper")
    protected ToDoubleFunction<? super T> m_mapper;

    public SummingDoubleCollector() {
    }

    public SummingDoubleCollector(Remote.ToDoubleFunction<? super T> mapper) {
        this.m_mapper = mapper;
    }

    @Override
    public Supplier<double[]> supplier() {
        return () -> new double[3];
    }

    @Override
    public BiConsumer<double[], T> accumulator() {
        ToDoubleFunction mapper = this.m_mapper;
        return (a, t) -> {
            double dblValue = mapper.applyAsDouble(t);
            SummingDoubleCollector.sumWithCompensation(a, dblValue);
            a[2] = a[2] + dblValue;
        };
    }

    @Override
    public BinaryOperator<double[]> combiner() {
        return (a, b) -> {
            SummingDoubleCollector.sumWithCompensation(a, b[0]);
            a[2] = a[2] + b[2];
            return SummingDoubleCollector.sumWithCompensation(a, b[1]);
        };
    }

    @Override
    public Function<double[], Double> finisher() {
        return SummingDoubleCollector::computeFinalSum;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    protected static double[] sumWithCompensation(double[] intermediateSum, double value) {
        double tmp = value - intermediateSum[1];
        double sum = intermediateSum[0];
        double velvel = sum + tmp;
        intermediateSum[1] = velvel - sum - tmp;
        intermediateSum[0] = velvel;
        return intermediateSum;
    }

    protected static double computeFinalSum(double[] summands) {
        double tmp = summands[0] + summands[1];
        double simpleSum = summands[summands.length - 1];
        if (Double.isNaN(tmp) && Double.isInfinite(simpleSum)) {
            return simpleSum;
        }
        return tmp;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_mapper = (ToDoubleFunction)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_mapper);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_mapper = (ToDoubleFunction)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_mapper);
    }
}

