/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractByteArrayReadBuffer;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.DelegatingWriteBuffer;
import com.tangosol.io.InputStreaming;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public abstract class AbstractWriteBuffer
implements WriteBuffer {
    public static final byte[] NO_BYTES = AbstractByteArrayReadBuffer.NO_BYTES;
    public static final Binary NO_BINARY = AbstractByteArrayReadBuffer.NO_BINARY;
    private static final int MIN_BUF = 64;
    private static final int MAX_BUF = 1024;
    protected static final int CHAR_BUF_SIZE = 256;
    protected static final int CHAR_BUF_MASK = 255;
    private transient byte[] m_abBuf;
    protected transient char[] m_achBuf;

    @Override
    public abstract void write(int var1, byte var2);

    @Override
    public void write(int ofDest, byte[] abSrc) {
        this.write(ofDest, abSrc, 0, abSrc.length);
    }

    @Override
    public abstract void write(int var1, byte[] var2, int var3, int var4);

    @Override
    public void write(int ofDest, ReadBuffer bufSrc) {
        this.write(ofDest, bufSrc, 0, bufSrc.length());
    }

    @Override
    public void write(int ofDest, ReadBuffer bufSrc, int ofSrc, int cbSrc) {
        this.write(ofDest, bufSrc.toByteArray(ofSrc, cbSrc), 0, cbSrc);
    }

    @Override
    public void write(int ofDest, InputStreaming stream) throws IOException {
        this.copyStream(ofDest, stream, this.getMaximumCapacity() - ofDest);
    }

    @Override
    public void write(int ofDest, InputStreaming stream, int cbSrc) throws IOException {
        int cbActual;
        if (stream instanceof ReadBuffer.BufferInput) {
            this.copyBufferInputPortion(ofDest, (ReadBuffer.BufferInput)stream, cbSrc);
            return;
        }
        byte[] abTmp = this.tmpbuf(cbSrc);
        int cbTmp = abTmp.length;
        for (int cbWritten = 0; cbWritten < cbSrc; cbWritten += cbActual) {
            cbActual = stream.read(abTmp, 0, Math.min(cbSrc - cbWritten, cbTmp));
            if (cbActual < 0) {
                throw new EOFException("requested to read " + cbSrc + " bytes but only " + cbWritten + " bytes were available");
            }
            this.write(ofDest + cbWritten, abTmp, 0, cbActual);
        }
    }

    @Override
    public abstract int length();

    @Override
    public void retain(int of) {
        this.retain(of, this.length() - of);
    }

    @Override
    public abstract void retain(int var1, int var2);

    @Override
    public void clear() {
        this.retain(0, 0);
        this.releaseBuffers();
    }

    @Override
    public abstract int getCapacity();

    @Override
    public int getMaximumCapacity() {
        return this.getCapacity();
    }

    @Override
    public WriteBuffer getWriteBuffer(int of) {
        return this.getWriteBuffer(of, this.getMaximumCapacity() - of);
    }

    @Override
    public WriteBuffer getWriteBuffer(int of, int cb) {
        if (of < 0 || cb < 0 || of + cb > this.getMaximumCapacity()) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", max=" + this.getMaximumCapacity());
        }
        return new DelegatingWriteBuffer(this, of, cb);
    }

    @Override
    public WriteBuffer.BufferOutput getBufferOutput() {
        return this.getBufferOutput(0);
    }

    @Override
    public WriteBuffer.BufferOutput getBufferOutput(int of) {
        return new AbstractBufferOutput(of);
    }

    @Override
    public WriteBuffer.BufferOutput getAppendingBufferOutput() {
        return this.getBufferOutput(this.length());
    }

    @Override
    public ReadBuffer getReadBuffer() {
        return new ByteArrayReadBuffer(this.toByteArray());
    }

    @Override
    public abstract ReadBuffer getUnsafeReadBuffer();

    @Override
    public byte[] toByteArray() {
        return this.getUnsafeReadBuffer().toByteArray();
    }

    @Override
    public Binary toBinary() {
        return this.getUnsafeReadBuffer().toBinary();
    }

    @Override
    public Object clone() {
        ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(this.getCapacity(), this.getMaximumCapacity());
        if (this.length() > 0) {
            buf.write(0, this.getUnsafeReadBuffer());
        }
        return buf;
    }

    protected void copyBufferInputPortion(int ofDest, ReadBuffer.BufferInput inSrc, int cbSrc) throws IOException {
        int cbMax = inSrc.available();
        int ofSrc = inSrc.getOffset();
        int cbCopy = Math.min(cbSrc, cbMax);
        this.write(ofDest, inSrc.getBuffer(), ofSrc, cbCopy);
        inSrc.setOffset(ofSrc + cbCopy);
        if (cbSrc > cbMax) {
            throw new EOFException("instructed to copy " + cbSrc + " bytes, but only " + cbMax + " were available");
        }
    }

    protected int copyBufferInputRemainder(int ofDest, ReadBuffer.BufferInput inSrc, int cbMax) throws IOException {
        int cbSrc = inSrc.available();
        int cbCopy = Math.min(cbSrc, cbMax);
        this.copyBufferInputPortion(ofDest, inSrc, cbCopy);
        if (cbSrc > cbMax) {
            throw new IOException("Overflow: attempted to write " + cbSrc + " bytes, but limited to " + cbMax + " bytes");
        }
        return cbCopy;
    }

    protected int copyStream(int ofDest, InputStreaming stream, int cbMax) throws IOException {
        int ofOrig;
        block8: {
            int b;
            if (stream instanceof ReadBuffer.BufferInput) {
                return this.copyBufferInputRemainder(ofDest, (ReadBuffer.BufferInput)stream, cbMax);
            }
            ofOrig = ofDest;
            int cbRemain = cbMax;
            int cbAvail = stream.available();
            if (cbAvail > 0) {
                byte[] abTmp = this.tmpbuf(cbAvail);
                int cbTmp = abTmp.length;
                do {
                    int cbActual;
                    if ((cbActual = stream.read(abTmp, 0, Math.min(cbAvail, cbTmp))) <= 0) continue;
                    this.write(ofDest, abTmp, 0, Math.min(cbActual, cbRemain));
                    ofDest += cbActual;
                    if ((cbRemain -= cbActual) >= 0) continue;
                    throw new IOException("Overflow: attempted to copy " + cbActual + " available bytes, but limited to " + cbMax + " bytes");
                } while ((cbAvail = stream.available()) > 0);
            }
            if ((b = stream.read()) < 0) break block8;
            if (cbRemain > 0) {
                this.write(ofDest, (byte)b);
            }
            ++ofDest;
            if (--cbRemain < 0) {
                throw new IOException("Overflow: attempted to copy at least " + (ofDest - ofOrig) + " bytes, but limited to " + cbMax + " bytes");
            }
            byte[] abBlock = this.tmpbuf(1024);
            int cbBlock = abBlock.length;
            try {
                int cbActual;
                while ((cbActual = stream.read(abBlock, 0, cbBlock)) >= 0) {
                    if (cbActual <= 0) continue;
                    this.write(ofDest, abBlock, 0, Math.min(cbActual, cbRemain));
                    ofDest += cbActual;
                    if ((cbRemain -= cbActual) >= 0) continue;
                    throw new IOException("Overflow: attempted to copy at least " + (ofDest - ofOrig) + " bytes, but limited to " + cbMax + " bytes");
                }
            }
            catch (EOFException e) {}
        }
        return ofDest - ofOrig;
    }

    protected byte[] tmpbuf() {
        byte[] ab = this.m_abBuf;
        if (ab == null) {
            this.m_abBuf = ab = new byte[64];
        }
        return ab;
    }

    protected byte[] tmpbuf(int cb) {
        byte[] ab = this.m_abBuf;
        if (ab == null || ab.length < cb) {
            int cbOld = ab == null ? 0 : ab.length;
            int cbNew = Math.max(64, Math.min(1024, cb));
            if (cbNew > cbOld) {
                this.m_abBuf = ab = new byte[cbNew > 512 ? 1024 : cbNew];
            }
        }
        return ab;
    }

    protected final void releaseBuffers() {
        this.m_abBuf = null;
        this.m_achBuf = null;
    }

    public class AbstractBufferOutput
    extends OutputStream
    implements WriteBuffer.BufferOutput {
        protected int m_ofWrite;

        public AbstractBufferOutput() {
        }

        public AbstractBufferOutput(int of) {
            this.setOffset(of);
        }

        @Override
        public void write(int b) throws IOException {
            int ofWrite = this.m_ofWrite;
            AbstractWriteBuffer.this.write(ofWrite, (byte)b);
            this.m_ofWrite = ofWrite + 1;
        }

        @Override
        public void write(byte[] ab) throws IOException {
            int ofWrite = this.m_ofWrite;
            AbstractWriteBuffer.this.write(ofWrite, ab);
            this.m_ofWrite = ofWrite + ab.length;
        }

        @Override
        public void write(byte[] ab, int of, int cb) throws IOException {
            int ofWrite = this.m_ofWrite;
            AbstractWriteBuffer.this.write(ofWrite, ab, of, cb);
            this.m_ofWrite = ofWrite + cb;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
            AbstractWriteBuffer.this.releaseBuffers();
        }

        @Override
        public void writeBoolean(boolean f) throws IOException {
            this.write(f ? 1 : 0);
        }

        @Override
        public void writeByte(int b) throws IOException {
            this.write(b);
        }

        @Override
        public void writeShort(int n) throws IOException {
            byte[] ab = AbstractWriteBuffer.this.tmpbuf();
            ab[0] = (byte)(n >>> 8);
            ab[1] = (byte)n;
            this.write(ab, 0, 2);
        }

        @Override
        public void writeChar(int ch) throws IOException {
            this.writeShort(ch);
        }

        @Override
        public void writeInt(int n) throws IOException {
            byte[] ab = AbstractWriteBuffer.this.tmpbuf();
            ab[0] = (byte)(n >>> 24);
            ab[1] = (byte)(n >>> 16);
            ab[2] = (byte)(n >>> 8);
            ab[3] = (byte)n;
            this.write(ab, 0, 4);
        }

        @Override
        public void writeLong(long l) throws IOException {
            byte[] ab = ExternalizableHelper.toByteArray(l, AbstractWriteBuffer.this.tmpbuf());
            this.write(ab, 0, 8);
        }

        @Override
        public void writeFloat(float fl) throws IOException {
            this.writeInt(Float.floatToIntBits(fl));
        }

        @Override
        public void writeDouble(double dfl) throws IOException {
            this.writeLong(Double.doubleToLongBits(dfl));
        }

        @Override
        public void writeBytes(String s) throws IOException {
            int cbChunk;
            int cb;
            int of = 0;
            byte[] abTmp = AbstractWriteBuffer.this.tmpbuf(cb);
            int cbTmp = abTmp.length;
            for (cb = s.length(); cb > 0; cb -= cbChunk) {
                cbChunk = Math.min(cb, cbTmp);
                s.getBytes(of, of + cbChunk, abTmp, 0);
                this.write(abTmp, 0, cbChunk);
                of += cbChunk;
            }
        }

        @Override
        public void writeChars(String s) throws IOException {
            int cch = s.length();
            char[] achTmp = this.getCharBuf();
            int cchTmp = achTmp.length;
            int cbTmp = cchTmp << 1;
            byte[] abTmp = AbstractWriteBuffer.this.tmpbuf(cbTmp);
            assert (abTmp.length >= cbTmp);
            for (int of = 0; of < cch; of += cchTmp) {
                int cchChunk = Math.min(of + cchTmp, cch);
                s.getChars(of, cchChunk, achTmp, 0);
                int ofb = 0;
                for (int ofch = 0; ofch < cchChunk; ++ofch) {
                    char ch = achTmp[ofch];
                    abTmp[ofb++] = (byte)(ch >>> 8);
                    abTmp[ofb++] = (byte)ch;
                }
                this.write(abTmp, 0, cchChunk << 1);
            }
        }

        @Override
        public void writeUTF(String s) throws IOException {
            int cch = s.length();
            if (cch == 0) {
                this.writeShort(0);
            } else {
                int cb = this.calcUTF(s);
                if (cb > 65535) {
                    throw new UTFDataFormatException("UTF binary length=" + cb + ", max=65535");
                }
                this.writeShort(cb);
                this.writeUTF(s, cch, cb);
            }
        }

        @Override
        public WriteBuffer getBuffer() {
            return AbstractWriteBuffer.this;
        }

        @Override
        public void writeSafeUTF(String s) throws IOException {
            if (s == null) {
                this.writePackedInt(-1);
            } else {
                int cch = s.length();
                if (cch == 0) {
                    this.writePackedInt(0);
                } else {
                    int cb = this.calcUTF(s);
                    this.writePackedInt(cb);
                    this.writeUTF(s, cch, cb);
                }
            }
        }

        @Override
        public void writePackedInt(int n) throws IOException {
            byte[] ab = AbstractWriteBuffer.this.tmpbuf();
            int cb = 0;
            int b = 0;
            if (n < 0) {
                b = 64;
                n ^= 0xFFFFFFFF;
            }
            b |= (byte)(n & 0x3F);
            n >>>= 6;
            while (n != 0) {
                ab[cb++] = (byte)(b |= 0x80);
                b = n & 0x7F;
                n >>>= 7;
            }
            if (cb == 0) {
                this.write(b);
            } else {
                ab[cb++] = (byte)b;
                this.write(ab, 0, cb);
            }
        }

        @Override
        public void writePackedLong(long l) throws IOException {
            byte[] ab = AbstractWriteBuffer.this.tmpbuf();
            int cb = 0;
            int b = 0;
            if (l < 0L) {
                b = 64;
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            b |= (byte)((int)l & 0x3F);
            l >>>= 6;
            while (l != 0L) {
                ab[cb++] = (byte)(b |= 0x80);
                b = (int)l & 0x7F;
                l >>>= 7;
            }
            if (cb == 0) {
                this.write(b);
            } else {
                ab[cb++] = (byte)b;
                this.write(ab, 0, cb);
            }
        }

        @Override
        public void writeBuffer(ReadBuffer buf) throws IOException {
            int ofWrite = this.m_ofWrite;
            AbstractWriteBuffer.this.write(ofWrite, buf);
            this.m_ofWrite = ofWrite + buf.length();
        }

        @Override
        public void writeBuffer(ReadBuffer buf, int of, int cb) throws IOException {
            int ofWrite = this.m_ofWrite;
            AbstractWriteBuffer.this.write(ofWrite, buf, of, cb);
            this.m_ofWrite = ofWrite + cb;
        }

        @Override
        public void writeStream(InputStreaming stream) throws IOException {
            int ofWrite = this.m_ofWrite;
            int cb = AbstractWriteBuffer.this.copyStream(ofWrite, stream, AbstractWriteBuffer.this.getMaximumCapacity() - ofWrite);
            this.m_ofWrite = ofWrite + cb;
        }

        @Override
        public void writeStream(InputStreaming stream, int cb) throws IOException {
            int ofWrite = this.m_ofWrite;
            AbstractWriteBuffer.this.write(ofWrite, stream, cb);
            this.m_ofWrite = ofWrite + cb;
        }

        @Override
        public final int getOffset() {
            return this.m_ofWrite;
        }

        @Override
        public void setOffset(int of) {
            if (of < 0 || of > AbstractWriteBuffer.this.getMaximumCapacity()) {
                throw new IndexOutOfBoundsException("of=" + of + ", min=0, max=" + AbstractWriteBuffer.this.getMaximumCapacity());
            }
            this.m_ofWrite = of;
        }

        protected void writeUTF(String s, int cch, int cb) throws IOException {
            if (cb == cch) {
                this.writeBytes(s);
            } else {
                char[] ach = this.getCharBuf();
                byte[] abTmp = AbstractWriteBuffer.this.tmpbuf(cb);
                for (int ofch = 0; ofch < cch; ofch += 256) {
                    int cchChunk = Math.min(256, cch - ofch);
                    if (cch > 256) {
                        s.getChars(ofch, ofch + cchChunk, ach, 0);
                    }
                    int cbChunk = this.formatUTF(abTmp, 0, ach, cchChunk);
                    this.write(abTmp, 0, cbChunk);
                }
            }
        }

        protected final char[] getCharBuf() {
            char[] ach = AbstractWriteBuffer.this.m_achBuf;
            if (ach == null) {
                AbstractWriteBuffer.this.m_achBuf = ach = new char[256];
            }
            return ach;
        }

        protected final int calcUTF(String s) {
            boolean fSmall;
            int cch;
            int cb = cch = s.length();
            char[] ach = this.getCharBuf();
            boolean bl = fSmall = cch <= 256;
            if (fSmall) {
                s.getChars(0, cch, ach, 0);
            }
            for (int ofch = 0; ofch < cch; ++ofch) {
                char ch;
                if (fSmall) {
                    ch = ach[ofch];
                } else {
                    int ofBuf = ofch & 0xFF;
                    if (ofBuf == 0) {
                        s.getChars(ofch, Math.min(ofch + 256, cch), ach, 0);
                    }
                    ch = ach[ofBuf];
                }
                if (ch <= '\u007f') {
                    if (ch != '\u0000') continue;
                    ++cb;
                    continue;
                }
                cb += ch <= '\u07ff' ? 1 : 2;
            }
            return cb;
        }

        protected final void formatUTF(byte[] ab, int ofb, int cb, String s) {
            int cch = s.length();
            if (cb == cch) {
                s.getBytes(0, cch, ab, ofb);
            } else {
                char[] ach = this.getCharBuf();
                if (cch <= 256) {
                    this.formatUTF(ab, ofb, ach, cch);
                } else {
                    for (int ofch = 0; ofch < cch; ofch += 256) {
                        int cchChunk = Math.min(256, cch - ofch);
                        s.getChars(ofch, ofch + cchChunk, ach, 0);
                        ofb += this.formatUTF(ab, ofb, ach, cchChunk);
                    }
                }
            }
        }

        protected final int formatUTF(byte[] ab, int ofb, char[] ach, int cch) {
            int ofbOrig = ofb;
            for (int ofch = 0; ofch < cch; ++ofch) {
                char ch = ach[ofch];
                if (ch >= '\u0001' && ch <= '\u007f') {
                    ab[ofb++] = (byte)ch;
                    continue;
                }
                if (ch <= '\u07ff') {
                    ab[ofb++] = (byte)(0xC0 | ch >>> 6 & 0x1F);
                    ab[ofb++] = (byte)(0x80 | ch & 0x3F);
                    continue;
                }
                ab[ofb++] = (byte)(0xE0 | ch >>> 12 & 0xF);
                ab[ofb++] = (byte)(0x80 | ch >>> 6 & 0x3F);
                ab[ofb++] = (byte)(0x80 | ch & 0x3F);
            }
            return ofb - ofbOrig;
        }
    }
}

