/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.io.BinaryStore;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Daemon;
import com.tangosol.util.SegmentedConcurrentMap;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

public class AsyncBinaryStore
extends Base
implements BinaryStore {
    protected static final Binary DELETED = new Binary();
    protected static final int DEFAULT_LIMIT = 0x400000;
    protected static final Object LOCK_ALL = ConcurrentMap.LOCK_ALL;
    protected static final long WAIT_FOREVER = -1L;
    private volatile BinaryStore m_store;
    private ConcurrentMap m_mapPending = new SegmentedConcurrentMap();
    private int m_cbMax;
    private int m_cbPending;
    private QueueDaemon m_daemon;
    private boolean m_fAsync = true;
    private volatile long m_cAsyncWrite;
    private volatile long m_cSyncWrite;

    public AsyncBinaryStore(BinaryStore store) {
        this(store, 0x400000);
    }

    public AsyncBinaryStore(BinaryStore store, int cbMax) {
        this.m_store = store;
        this.m_cbMax = cbMax;
        this.ensureQueueDaemon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binary load(Binary binKey) {
        Binary binValue;
        ConcurrentMap mapPending = this.getPendingMap();
        while (!mapPending.lock(binKey, -1L)) {
        }
        try {
            binValue = (Binary)mapPending.get(binKey);
            if (binValue == DELETED) {
                binValue = null;
            } else if (binValue != null) {
            } else {
                BinaryStore store = this.getBinaryStore();
                if (store == null) {
                    throw new IllegalStateException("BinaryStore has been closed");
                }
                binValue = store.load(binKey);
            }
        }
        finally {
            mapPending.unlock(binKey);
        }
        return binValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Binary binKey, Binary binValue) {
        ConcurrentMap mapPending = this.getPendingMap();
        while (!mapPending.lock(binKey, -1L)) {
        }
        try {
            BinaryStore store = this.getBinaryStore();
            if (store == null) {
                throw new IllegalStateException("BinaryStore has been closed");
            }
            Binary binOldValue = mapPending.put(binKey, binValue);
            int cbNew = binKey.length() + binValue.length();
            int cbOld = binOldValue == null ? 0 : binKey.length() + binOldValue.length();
            this.updateQueuedSize(cbNew - cbOld);
            QueueDaemon daemon = this.getQueueDaemon();
            if (daemon != null && this.isAsync() && this.getQueuedSize() < this.getQueuedLimit()) {
                daemon.scheduleWork();
                ++this.m_cAsyncWrite;
            } else {
                if (binValue == DELETED) {
                    store.erase(binKey);
                } else {
                    store.store(binKey, binValue);
                }
                mapPending.remove(binKey);
                this.updateQueuedSize(-cbNew);
                ++this.m_cSyncWrite;
            }
        }
        finally {
            mapPending.unlock(binKey);
        }
    }

    @Override
    public void erase(Binary binKey) {
        this.store(binKey, DELETED);
    }

    @Override
    public void eraseAll() {
        ConcurrentMap mapPending = this.getPendingMap();
        while (!mapPending.lock(LOCK_ALL, -1L)) {
        }
        try {
            BinaryStore store = this.getBinaryStore();
            if (store == null) {
                throw new IllegalStateException("BinaryStore has been closed");
            }
            store.eraseAll();
            mapPending.clear();
            this.updateQueuedSize(-this.getQueuedSize());
        }
        finally {
            mapPending.unlock(LOCK_ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator keys() {
        ConcurrentMap mapPending = this.getPendingMap();
        while (!mapPending.lock(LOCK_ALL, -1L)) {
        }
        try {
            BinaryStore store = this.getBinaryStore();
            if (store == null) {
                throw new IllegalStateException("BinaryStore has been closed");
            }
            Iterator<Object> iter = store.keys();
            if (!mapPending.isEmpty()) {
                HashSet<Binary> setKeys = new HashSet<Binary>();
                while (iter.hasNext()) {
                    setKeys.add(iter.next());
                }
                for (Map.Entry entry : mapPending.entrySet()) {
                    Binary binKey = (Binary)entry.getKey();
                    Binary binValue = (Binary)entry.getValue();
                    if (binValue == DELETED) {
                        setKeys.remove(binKey);
                        continue;
                    }
                    setKeys.add(binKey);
                }
                iter = setKeys.iterator();
            }
            Iterator<Binary> iterator = iter;
            return iterator;
        }
        finally {
            mapPending.unlock(LOCK_ALL);
        }
    }

    public void close() {
        this.internalClose(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalClose(Consumer<? super BinaryStore> onClose) {
        BinaryStore store = this.getBinaryStore();
        if (store == null) {
            return;
        }
        ConcurrentMap mapPending = this.getPendingMap();
        while (!mapPending.lock(LOCK_ALL, -1L)) {
        }
        try {
            AsyncBinaryStore asyncBinaryStore = this;
            synchronized (asyncBinaryStore) {
                block15: {
                    store = this.getBinaryStore();
                    if (store != null) break block15;
                    return;
                }
                try {
                    if (onClose == null) {
                        ClassHelper.invoke(store, "close", ClassHelper.VOID);
                    } else {
                        onClose.accept(store);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.forceSync();
                this.setBinaryStore(null);
                mapPending.clear();
                this.updateQueuedSize(-this.getQueuedSize());
                QueueDaemon daemon = this.getQueueDaemon();
                if (daemon != null) {
                    daemon.wakeNow();
                }
            }
        }
        finally {
            mapPending.unlock(LOCK_ALL);
        }
    }

    public BinaryStore getBinaryStore() {
        return this.m_store;
    }

    protected synchronized void setBinaryStore(BinaryStore store) {
        this.m_store = store;
    }

    public int getQueuedLimit() {
        return this.m_cbMax;
    }

    public int getQueuedSize() {
        return this.m_cbPending;
    }

    protected synchronized void updateQueuedSize(int cb) {
        this.m_cbPending += cb;
    }

    public boolean isAsync() {
        return this.m_fAsync;
    }

    public synchronized void forceSync() {
        this.m_fAsync = false;
    }

    protected ConcurrentMap getPendingMap() {
        return this.m_mapPending;
    }

    public String toString() {
        BinaryStore store = this.getBinaryStore();
        return "AsyncBinaryStore{" + (store == null ? "Closed" : store.toString()) + ", async writes=" + this.m_cAsyncWrite + ", sync writes=" + this.m_cSyncWrite + ", effectiveness=" + (this.m_cSyncWrite == 0L ? 1.0f : (float)(1.0 - (double)this.m_cSyncWrite / (double)(this.m_cSyncWrite + this.m_cAsyncWrite))) + '}';
    }

    protected void finalize() {
        this.close();
    }

    protected QueueDaemon getQueueDaemon() {
        return this.m_daemon;
    }

    protected void setQueueDaemon(QueueDaemon daemon) {
        this.m_daemon = daemon;
    }

    protected synchronized QueueDaemon ensureQueueDaemon() {
        QueueDaemon daemon = this.getQueueDaemon();
        if (daemon == null) {
            daemon = this.instantiateQueueDaemon();
            daemon.start();
            this.setQueueDaemon(daemon);
        }
        return daemon;
    }

    protected QueueDaemon instantiateQueueDaemon() {
        return new QueueDaemon();
    }

    protected class QueueDaemon
    extends Daemon {
        private boolean m_fDormant;

        public QueueDaemon() {
            super("AsyncBinaryStore[" + ClassHelper.getSimpleName(AsyncBinaryStore.this.getBinaryStore().getClass()) + "]");
        }

        public synchronized void scheduleWork() {
            if (this.isDormant()) {
                this.notifyAll();
            }
        }

        public synchronized void wakeNow() {
            this.notifyAll();
        }

        public boolean isDone() {
            return AsyncBinaryStore.this.getBinaryStore() == null || !AsyncBinaryStore.this.isAsync();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                ConcurrentMap mapPending = AsyncBinaryStore.this.getPendingMap();
                while (!this.isDone()) {
                    boolean fNoWork = true;
                    try {
                        Iterator iter = mapPending.entrySet().iterator();
                        while (iter.hasNext()) {
                            fNoWork = false;
                            Map.Entry entry = iter.next();
                            Binary binKey = (Binary)entry.getKey();
                            Binary binValue = (Binary)entry.getValue();
                            this.processPending(binKey, binValue);
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        fNoWork = false;
                    }
                    QueueDaemon queueDaemon = this;
                    synchronized (queueDaemon) {
                        if (mapPending.isEmpty()) {
                            if (fNoWork) {
                                this.takeVacation();
                            } else {
                                this.takeNap();
                            }
                        } else {
                            this.takeBreak();
                        }
                    }
                }
                return;
            }
            catch (Throwable e) {
                if (this.isDone()) return;
                QueueDaemon.err("An exception occurred in the AsyncBinaryStore QueueDaemon:");
                QueueDaemon.err(e);
                QueueDaemon.err("(The daemon is terminating.)");
                return;
            }
            finally {
                AsyncBinaryStore.this.setQueueDaemon(null);
                AsyncBinaryStore.this.forceSync();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processPending(Binary binKey, Binary binValue) {
            ConcurrentMap mapPending = AsyncBinaryStore.this.getPendingMap();
            if (mapPending.lock(binKey)) {
                try {
                    if (mapPending.containsKey(binKey)) {
                        BinaryStore store = AsyncBinaryStore.this.getBinaryStore();
                        if (store != null) {
                            if (binValue == DELETED) {
                                store.erase(binKey);
                            } else {
                                store.store(binKey, binValue);
                            }
                        }
                        mapPending.remove(binKey);
                        int cbWrite = binKey.length() + binValue.length();
                        AsyncBinaryStore.this.updateQueuedSize(-cbWrite);
                    }
                }
                finally {
                    mapPending.unlock(binKey);
                }
            }
        }

        protected synchronized void takeBreak() {
            try {
                Blocking.wait(this, 32L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        protected synchronized void takeNap() {
            try {
                Blocking.wait(this, 256L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        protected synchronized void takeVacation() {
            this.setDormant(true);
            try {
                Blocking.wait(this);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.setDormant(false);
            }
        }

        protected boolean isDormant() {
            return this.m_fDormant;
        }

        protected synchronized void setDormant(boolean fDormant) {
            this.m_fDormant = fDormant;
        }
    }
}

