/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractReadBuffer;
import com.tangosol.io.DeltaCompressor;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;

public class DecorationOnlyDeltaCompressor
extends ExternalizableHelper
implements DeltaCompressor {
    protected static Binary BIN_DECO_ONLY = new Binary(new byte[]{-1});

    @Override
    public ReadBuffer extractDelta(ReadBuffer bufOld, ReadBuffer bufNew) {
        if (bufOld == null) {
            return bufNew;
        }
        if (Base.equals(bufOld, bufNew)) {
            return null;
        }
        boolean fDecoNew = DecorationOnlyDeltaCompressor.isDecorated(bufNew);
        boolean fDecoOld = DecorationOnlyDeltaCompressor.isDecorated(bufOld);
        if ((fDecoNew || fDecoOld) && Base.equals(DecorationOnlyDeltaCompressor.getUndecorated(bufNew), DecorationOnlyDeltaCompressor.getUndecorated(bufOld))) {
            Binary binDecoOnly = BIN_DECO_ONLY;
            if (fDecoNew) {
                ReadBuffer[] abufDeco = DecorationOnlyDeltaCompressor.getDecorations(bufNew);
                abufDeco[0] = null;
                bufNew = DecorationOnlyDeltaCompressor.decorate((ReadBuffer)binDecoOnly, abufDeco);
            } else {
                bufNew = binDecoOnly;
            }
        }
        return bufNew;
    }

    @Override
    public ReadBuffer applyDelta(ReadBuffer bufOld, ReadBuffer bufDelta) {
        if (bufDelta == null) {
            return bufOld;
        }
        if (BIN_DECO_ONLY.equals(DecorationOnlyDeltaCompressor.getUndecorated(bufDelta))) {
            ReadBuffer[] abufDeco = DecorationOnlyDeltaCompressor.getDecorations(bufDelta);
            abufDeco[0] = null;
            if ((bufOld = DecorationOnlyDeltaCompressor.getUndecorated(bufOld)).length() == 0 && abufDeco.length > 1) {
                bufOld = AbstractReadBuffer.NO_BINARY;
            }
            return abufDeco.length == 1 ? bufOld : DecorationOnlyDeltaCompressor.decorate(bufOld, abufDeco);
        }
        return bufDelta;
    }
}

