/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.tangosol.io.nio.ByteBufferInputStream;
import com.tangosol.io.nio.ByteBufferManager;
import com.tangosol.io.nio.ByteBufferOutputStream;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.SimpleMapEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class BinaryMap
extends AbstractMap {
    protected static final boolean MODE_DEBUG = false;
    protected static final byte FILL_BYTE = 0;
    protected static final byte[] FILL_BUFFER = new byte[16384];
    protected static final int MAX_SIZE_CODES = 26;
    protected static final int[] BUCKET_COUNTS;
    protected static final int SIZE_COPY_BUFFER = 1024;
    protected static final int NIL = -1;
    protected static final int MAX_OPEN_BLOCKS = 8;
    public static final double DEFAULT_MAXLOADFACTOR = 0.875;
    public static final double DEFAULT_MINLOADFACTOR = 0.75;
    private static final char[] HEX;
    private boolean m_fStrict;
    private double m_dflLoadPercentGrow = 0.875;
    private double m_dflLoadPercentShrink = 0.75;
    private ByteBufferManager m_bufmgr;
    private ByteBuffer m_buffer;
    private DataInputStream m_streamIn;
    private DataOutputStream m_streamOut;
    private int m_nBucketLevel;
    private int[] m_aofBucket;
    private int m_nModuloCurrent;
    private int m_nModuloPrevious;
    private int m_nBucketNextRehash;
    private int m_cEntries;
    private int m_cEntriesGrow;
    private int m_cEntriesShrink;
    private int m_cbKeyTotal;
    private int m_cbValueTotal;
    private int[] m_aofFree;
    private int m_ofBlockNextCompact;
    private int m_ofBlockLast;
    private int[] m_aofBlockCache = new int[8];
    private Block[] m_ablockCache = new Block[8];
    private int m_cOpenBlocks;
    protected transient EntrySet m_set;
    protected transient KeySet m_setKeys;
    protected transient ValuesCollection m_colValues;

    public BinaryMap(ByteBuffer buffer) {
        this(buffer, 0.875, 0.75, false);
    }

    public BinaryMap(ByteBuffer buffer, double dflMaxLoadFactor, double dflMinLoadFactor, boolean fStrict) {
        this();
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer must not be null");
        }
        if (dflMaxLoadFactor <= 0.0 || dflMaxLoadFactor > 8.0) {
            throw new IllegalArgumentException("Illegal MaxLoadFactor value (" + dflMaxLoadFactor + "); MaxLoadFactor is a percentage such that 100% is expressed as 1.00");
        }
        if (dflMinLoadFactor <= 0.0 || dflMinLoadFactor > 8.0) {
            throw new IllegalArgumentException("Illegal MinLoadFactor value (" + dflMinLoadFactor + "); MinLoadFactor is a percentage such that 100% is expressed as 1.00");
        }
        if (!(dflMinLoadFactor < dflMaxLoadFactor)) {
            throw new IllegalArgumentException("Illegal threshold values (MaxLoadFactor=" + dflMaxLoadFactor + ", MinLoadFactor=" + dflMinLoadFactor + "); MinLoadFactor must be smaller than MaxLoadFactor");
        }
        this.setStrict(fStrict);
        this.setMaxLoadFactor(dflMaxLoadFactor);
        this.setMinLoadFactor(dflMinLoadFactor);
        this.initializeFreeLists();
        this.initializeBuckets();
        this.setBuffer(buffer);
        this.clearBuffer();
    }

    public BinaryMap(ByteBufferManager bufmgr) {
        this(bufmgr, 0.875, 0.75, false);
    }

    public BinaryMap(ByteBufferManager bufmgr, double dflMaxLoadFactor, double dflMinLoadFactor, boolean fStrict) {
        this(bufmgr.getBuffer(), dflMaxLoadFactor, dflMinLoadFactor, fStrict);
        this.setBufferManager(bufmgr);
    }

    protected BinaryMap() {
        int[] aofBlockCache = this.m_aofBlockCache;
        Block[] ablockCache = this.m_ablockCache;
        int c = 8;
        for (int i = 0; i < c; ++i) {
            aofBlockCache[i] = -1;
            ablockCache[i] = this.instantiateBlock();
        }
    }

    @Override
    public int size() {
        return this.getEntryBlockCount();
    }

    @Override
    public boolean isEmpty() {
        return this.getEntryBlockCount() == 0;
    }

    @Override
    public synchronized boolean containsKey(Object oKey) {
        try {
            Block block = this.findEntryBlock((Binary)oKey);
            if (block != null) {
                block.close();
            }
            return block != null;
        }
        catch (RuntimeException e) {
            throw this.validateKey(oKey, e);
        }
    }

    @Override
    public synchronized Object get(Object oKey) {
        try {
            Binary oValue = null;
            Block block = this.findEntryBlock((Binary)oKey);
            if (block != null) {
                oValue = block.getValue();
                block.close();
            }
            return oValue;
        }
        catch (RuntimeException e) {
            throw this.validateKey(oKey, e);
        }
    }

    @Override
    public synchronized Object put(Object oKey, Object oValue) {
        try {
            this.compactNext();
            Binary binKey = (Binary)oKey;
            Binary binValue = (Binary)oValue;
            Binary binOld = null;
            Block block = this.findEntryBlock(binKey);
            if (block == null) {
                block = this.allocateBlock(29 + binKey.length() + binValue.length());
                block.setKey(binKey);
                block.setValue(binValue);
                block.link();
                block.close();
                this.m_cbKeyTotal += binKey.length();
                this.m_cbValueTotal += binValue.length();
                ++this.m_cEntries;
                this.checkModulo();
            } else {
                int cbFill;
                binOld = block.getValue();
                int cbOld = binOld.length();
                int cbNew = binValue.length();
                int cbDif = cbNew - cbOld;
                if (cbDif > (cbFill = block.getFillLength())) {
                    int cbGrow = cbDif - cbFill;
                    int cbFree = this.getFreeCapacity();
                    ByteBufferManager bufmgr = this.getBufferManager();
                    if (bufmgr != null) {
                        cbFree += bufmgr.getMaxCapacity() - bufmgr.getCapacity();
                    }
                    if (cbGrow > cbFree) {
                        throw this.reportOutOfMemory(cbGrow);
                    }
                    int cbBlock = block.length();
                    block.free();
                    block = this.allocateBlock(cbBlock + cbGrow);
                    block.setKey(binKey);
                    block.link();
                } else if (cbDif < 0 && this.isStrict()) {
                    block.clearValue();
                }
                block.setValue(binValue);
                block.close();
                this.m_cbValueTotal += cbDif;
                if (cbDif < 0) {
                    this.checkBufferShrink();
                }
            }
            return binOld;
        }
        catch (RuntimeException e) {
            throw this.validateEntry(oKey, oValue, e);
        }
    }

    @Override
    public synchronized Object remove(Object oKey) {
        try {
            Binary binValue = null;
            Block block = this.findEntryBlock((Binary)oKey);
            if (block != null) {
                binValue = block.getValue();
                this.m_cbKeyTotal -= block.getKeyLength();
                this.m_cbValueTotal -= block.getValueLength();
                boolean fEmpty = --this.m_cEntries == 0;
                block.free();
                if (fEmpty) {
                    this.clear();
                }
                this.compactNext();
                this.checkBufferShrink();
            }
            return binValue;
        }
        catch (RuntimeException e) {
            throw this.validateKey(oKey, e);
        }
    }

    @Override
    public synchronized void clear() {
        this.clearFreeLists();
        this.initializeBuckets();
        this.clearBuffer();
        this.checkBufferShrink();
    }

    @Override
    public Set entrySet() {
        EntrySet set = this.m_set;
        if (set == null) {
            this.m_set = set = this.instantiateEntrySet();
        }
        return set;
    }

    @Override
    public Set keySet() {
        KeySet set = this.m_setKeys;
        if (set == null) {
            this.m_setKeys = set = this.instantiateKeySet();
        }
        return set;
    }

    @Override
    public Collection values() {
        ValuesCollection col = this.m_colValues;
        if (col == null) {
            this.m_colValues = col = this.instantiateValuesCollection();
        }
        return col;
    }

    public int getEntryBlockCount() {
        return this.m_cEntries;
    }

    protected Block findEntryBlock(Binary binKey) {
        int nPreviousBucket;
        this.rehashNext();
        int cbKey = binKey.length();
        int nHash = binKey.hashCode();
        int nBucket = this.calculateBucket(nHash);
        int ofBlock = this.getBucketOffset(nBucket);
        while (ofBlock != -1) {
            Block block = this.openBlock(ofBlock);
            if (block.getKeyHash() == nHash && block.getKeyLength() == cbKey && binKey.equals(block.getKey())) {
                return block;
            }
            ofBlock = block.getNextNodeOffset();
            block.close();
        }
        if (this.isRehashing() && (nPreviousBucket = this.calculatePreviousBucket(nHash)) != nBucket) {
            ofBlock = this.getBucketOffset(nPreviousBucket);
            while (ofBlock != -1) {
                Block block = this.openBlock(ofBlock);
                if (block.getKeyHash() == nHash && block.getKeyLength() == cbKey && binKey.equals(block.getKey())) {
                    return block;
                }
                ofBlock = block.getNextNodeOffset();
                block.close();
            }
        }
        return null;
    }

    protected synchronized Object[] toArray(Object[] ao, Converter conv) {
        int co = this.size();
        if (ao == null) {
            ao = new Object[co];
        } else if (ao.length < co) {
            ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), co);
        } else if (ao.length > co) {
            ao[co] = null;
        }
        int of = 0;
        int i = 0;
        while (of != -1) {
            Block block = this.openBlock(of);
            if (block.isEntry()) {
                ao[i++] = conv.convert(block);
            }
            of = block.getNextBlockOffset();
            block.close();
        }
        return ao;
    }

    protected RuntimeException validateKey(Object key, RuntimeException e) {
        if (key instanceof Binary) {
            throw e;
        }
        throw new IllegalArgumentException("BinaryMap key must be of type Binary");
    }

    protected RuntimeException validateEntry(Object key, Object value, RuntimeException e) {
        if (!(key instanceof Binary)) {
            throw new IllegalArgumentException("BinaryMap key must be of type Binary");
        }
        if (!(value instanceof Binary)) {
            throw new IllegalArgumentException("BinaryMap value must be of type Binary");
        }
        throw e;
    }

    protected RuntimeException reportOutOfMemory(int cbRequired) {
        throw new RuntimeException("OutOfMemory: Required=" + cbRequired + ", Available=" + this.getFreeCapacity());
    }

    protected EntrySet instantiateEntrySet() {
        return new EntrySet();
    }

    protected KeySet instantiateKeySet() {
        return new KeySet();
    }

    protected ValuesCollection instantiateValuesCollection() {
        return new ValuesCollection();
    }

    protected Entry instantiateEntry(Binary binKey, Binary binValue) {
        return new Entry(binKey, binValue);
    }

    public ByteBufferManager getBufferManager() {
        return this.m_bufmgr;
    }

    protected void setBufferManager(ByteBufferManager bufmgr) {
        this.m_bufmgr = bufmgr;
    }

    protected void checkBufferGrow(int cbAdditional) {
        int cbRequired;
        ByteBufferManager bufmgr = this.getBufferManager();
        if (bufmgr != null && (cbRequired = this.getUsedCapacity() + cbAdditional) > bufmgr.getGrowthThreshold()) {
            int cbNew;
            Block block = this.openBlock(this.getLastBlockOffset());
            boolean fFree = block.isFree();
            if (fFree) {
                block.unlink();
            }
            int cbOld = this.getCapacity();
            this.setBuffer(null);
            bufmgr.grow(cbRequired);
            this.setBuffer(bufmgr.getBuffer());
            if (this.isStrict() && (cbNew = this.getCapacity()) > cbOld) {
                this.wipe(cbOld, cbNew - cbOld);
            }
            if (fFree) {
                block.link();
            }
            block.close();
        }
    }

    protected void checkBufferShrink() {
        int cbRequired;
        ByteBufferManager bufmgr = this.getBufferManager();
        if (bufmgr != null && (cbRequired = this.getUsedCapacity() + 17) < bufmgr.getShrinkageThreshold()) {
            this.compactAll();
            Block block = this.openBlock(this.getLastBlockOffset());
            assert (block.isFree());
            block.unlink();
            this.setBuffer(null);
            bufmgr.shrink(cbRequired);
            this.setBuffer(bufmgr.getBuffer());
            block.link();
            block.close();
        }
    }

    protected ByteBuffer getBuffer() {
        ByteBuffer buffer = this.m_buffer;
        if (buffer == null) {
            throw new IllegalStateException("Failed to resize the buffer due to OutOfMemoryError");
        }
        return buffer;
    }

    protected void setBuffer(ByteBuffer buffer) {
        ByteBuffer bufferOrig = this.m_buffer;
        if (buffer != bufferOrig) {
            this.m_buffer = buffer;
            this.m_streamIn = null;
            this.m_streamOut = null;
            if (buffer != null) {
                this.m_streamIn = new DataInputStream(new ByteBufferInputStream(buffer));
                this.m_streamOut = new DataOutputStream(new ByteBufferOutputStream(buffer));
            }
        }
    }

    protected int getCapacity() {
        return this.getBuffer().capacity();
    }

    protected int getFreeCapacity() {
        return this.getCapacity() - this.getUsedCapacity();
    }

    protected int getUsedCapacity() {
        return this.getEntryBlockCount() * 29 + this.m_cbKeyTotal + this.m_cbValueTotal;
    }

    protected int getLastBlockOffset() {
        return this.m_ofBlockLast;
    }

    protected void setLastBlockOffset(int ofBlock) {
        assert (ofBlock != -1);
        this.m_ofBlockLast = ofBlock;
    }

    protected boolean isStrict() {
        return this.m_fStrict;
    }

    protected void setStrict(boolean fStrict) {
        this.m_fStrict = fStrict;
    }

    protected void clearBuffer() {
        this.setNextCompactBlock(-1);
        ByteBuffer buffer = this.m_buffer;
        if (this.isStrict()) {
            this.wipe(0, buffer.capacity());
        }
        this.m_cEntries = 0;
        this.m_cbKeyTotal = 0;
        this.m_cbValueTotal = 0;
        Block block = this.initBlock(0);
        block.setType(1);
        block.link();
        block.close();
        this.compactBegin();
    }

    protected DataInputStream getBufferInput() {
        return this.m_streamIn;
    }

    protected DataOutputStream getBufferOutput() {
        return this.m_streamOut;
    }

    protected void wipe(int of, int cb) {
        int cbWrite;
        ByteBuffer buffer = this.getBuffer();
        buffer.position(of);
        byte[] abBlank = FILL_BUFFER;
        int cbBlank = abBlank.length;
        if ((of %= cbBlank) > 0) {
            cbWrite = Math.min(cb, cbBlank - of);
            buffer.put(abBlank, of, cbWrite);
            cb -= cbWrite;
        }
        while (cb > 0) {
            cbWrite = Math.min(cb, cbBlank);
            buffer.put(abBlank, 0, cbWrite);
            cb -= cbBlank;
        }
    }

    public void check(String sDesc) {
        int nModulo2;
        int ofPrev;
        int ofBlock;
        int i;
        Block block;
        ByteBuffer buffer = this.getBuffer();
        int cbBuf = buffer.capacity();
        HashSet<Integer> setOffsets = new HashSet<Integer>();
        boolean fPrevFree = false;
        int ofLastActual = -1;
        int of = 0;
        int ofPrev2 = -1;
        while (of != -1) {
            ofLastActual = of;
            if (of < 0 || of > cbBuf - 17) {
                throw new IllegalStateException(sDesc + ": illegal block offset " + of + " (0x" + Integer.toString(of, 16) + ")");
            }
            block = this.openBlock(of);
            if (!block.isFree() && !block.isEntry()) {
                throw new IllegalStateException(sDesc + ": illegal block type " + block.getType() + " for block at " + of + " (0x" + Integer.toString(of, 16) + ")");
            }
            boolean fFree = block.isFree();
            if (fPrevFree && fFree) {
                throw new IllegalStateException(sDesc + ": two contiguous free blocks found at " + ofPrev2 + " (0x" + Integer.toString(ofPrev2, 16) + ") and " + of + " (0x" + Integer.toString(of, 16) + ")");
            }
            fPrevFree = fFree;
            setOffsets.add(of);
            int ofPrevBlock = block.getPrevBlockOffset();
            int ofNextBlock = block.getNextBlockOffset();
            int ofPrevNode = block.getPrevNodeOffset();
            int ofNextNode = block.getNextNodeOffset();
            if (ofPrevBlock == -1) {
                if (of != 0) {
                    throw new IllegalStateException(sDesc + ": illegal previous block offset of NIL for block at " + of + " (0x" + Integer.toString(of, 16) + ")");
                }
            } else if (ofPrevBlock < 0 || ofPrevBlock >= cbBuf || ofPrevBlock >= of) {
                throw new IllegalStateException(sDesc + ": previous block offset of " + ofPrevBlock + " (0x" + Integer.toString(ofPrevBlock, 16) + ") for block at " + of + " (0x" + Integer.toString(of, 16) + ") is out of range");
            }
            if (ofPrevBlock != ofPrev2) {
                throw new IllegalStateException(sDesc + ": previous block offset of " + ofPrevBlock + " (0x" + Integer.toString(ofPrevBlock, 16) + ") for block at " + of + " (0x" + Integer.toString(of, 16) + ") was expected to be " + ofPrev2 + " (0x" + Integer.toString(ofPrev2, 16));
            }
            if (ofNextBlock != -1 && (ofNextBlock < 0 || ofNextBlock >= cbBuf || ofNextBlock <= of)) {
                throw new IllegalStateException(sDesc + ": next block offset of " + ofNextBlock + " (0x" + Integer.toString(ofNextBlock, 16) + ") for block at " + of + " (0x" + Integer.toString(of, 16) + ") is out of range");
            }
            if (ofPrevNode == -1) {
                if (block.isFree()) {
                    int nCode = block.getSizeCode();
                    int ofHead = this.getFreeBlockOffset(nCode);
                    if (ofHead != of) {
                        throw new IllegalStateException(sDesc + ": the free block at " + of + " (0x" + Integer.toString(of, 16) + ") with a size code of " + nCode + " has a previous node offset of NIL, but the free list head for that size code is at " + ofHead + " (0x" + Integer.toString(ofHead, 16) + ")");
                    }
                } else {
                    int nHash = block.getKeyHash();
                    int nBucket = this.calculateBucket(nHash);
                    int nBucket2 = this.calculatePreviousBucket(nHash);
                    int ofBucket = this.getBucketOffset(nBucket);
                    int ofBucket2 = this.getBucketOffset(nBucket2);
                    if (of == ofBucket) {
                        if (nBucket != nBucket2 && of == ofBucket2) {
                            throw new IllegalStateException(sDesc + ": the entry block at " + of + " (0x" + Integer.toString(of, 16) + ") with a hash code of " + nHash + " is found in both bucket " + nBucket + " and " + nBucket2);
                        }
                    } else if (ofBucket2 != of) {
                        throw new IllegalStateException(sDesc + ": the entry block at " + of + " (0x" + Integer.toString(of, 16) + ") with a hash code of " + nHash + " has a previous node offset of NIL, but the bucket heads (" + nBucket + ", " + nBucket2 + ") for that hash are at offsets " + ofBucket + " (0x" + Integer.toString(ofBucket, 16) + ") and " + ofBucket2 + " (0x" + Integer.toString(ofBucket2, 16) + ")");
                    }
                }
            } else if (ofPrevNode < 0 || ofPrevNode >= cbBuf) {
                throw new IllegalStateException(sDesc + ": previous node offset of " + ofPrevNode + " (0x" + Integer.toString(ofPrevNode, 16) + ") for block at " + of + " (0x" + Integer.toString(of, 16) + ") is out of range");
            }
            if (ofNextNode != -1 && (ofNextNode < 0 || ofNextNode >= cbBuf)) {
                throw new IllegalStateException(sDesc + ": next node offset of " + ofNextNode + " (0x" + Integer.toString(ofNextNode, 16) + ") for block at " + of + " (0x" + Integer.toString(of, 16) + ") is out of range");
            }
            if (block.isEntry()) {
                int cbBlock = block.getLength();
                int nHash = block.getKeyHash();
                int cbKey = block.getKeyLength();
                int cbValue = block.getValueLength();
                if (cbKey < 0 || cbValue < 0 || cbKey + cbValue > cbBlock - 29) {
                    throw new IllegalStateException(sDesc + ": block at " + of + " (0x" + Integer.toString(of, 16) + ") has length of " + cbBlock + " (0x" + Integer.toString(cbBlock, 16) + "), key length of " + cbKey + " (0x" + Integer.toString(cbKey, 16) + ") and value length of " + cbValue + " (0x" + Integer.toString(cbValue, 16) + ")");
                }
                Binary binKey = block.getKey();
                int nKeyHash = binKey.hashCode();
                if (nHash != nKeyHash) {
                    throw new IllegalStateException(sDesc + ": block at " + of + " (0x" + Integer.toString(of, 16) + ") has hash stored as " + nHash + " (0x" + Integer.toString(nHash, 16) + ") but key hashes to " + nKeyHash + " (0x" + Integer.toString(nKeyHash, 16) + ")");
                }
            }
            if (this.isStrict()) {
                int cbFill = block.getFillLength();
                int ofFill = block.isEntry() ? block.getOffset() + 29 + block.getKeyLength() + block.getValueLength() : block.getOffset() + 17;
                buffer.position(ofFill);
                byte bFill = 0;
                for (int cbRemain = cbFill; cbRemain > 0; --cbRemain) {
                    byte b = buffer.get();
                    if (b == bFill) continue;
                    throw new IllegalStateException(sDesc + ": block at " + of + " (0x" + Integer.toString(of, 16) + ") is expected to have " + cbFill + " (0x" + Integer.toString(cbFill, 16) + ") bytes of fill at offset " + ofFill + " (0x" + Integer.toString(ofFill, 16) + "); found byte " + b + " (0x" + Integer.toString(b, 16) + ") but it should be " + bFill + " (0x" + Integer.toString(bFill, 16) + ")");
                }
            }
            block.close();
            int ofNext = ofNextBlock;
            ofPrev2 = of;
            of = ofNext;
        }
        int c = this.getBucketCount();
        for (i = 0; i < c; ++i) {
            ofBlock = this.getBucketOffset(i);
            if (ofBlock == -1) continue;
            if (!setOffsets.contains(ofBlock)) {
                throw new IllegalStateException(sDesc + ": bucket " + i + " has offset " + ofBlock + " (0x" + Integer.toString(ofBlock, 16) + ") which is not a valid block offset");
            }
            block = this.openBlock(ofBlock);
            if (!block.isEntry()) {
                throw new IllegalStateException(sDesc + ": free list " + i + " has offset " + ofBlock + " (0x" + Integer.toString(ofBlock, 16) + ") which is not an entry block");
            }
            ofPrev = block.getPrevNodeOffset();
            if (ofPrev != -1) {
                throw new IllegalStateException(sDesc + ": bucket " + i + " has offset " + ofBlock + " (0x" + Integer.toString(ofBlock, 16) + ") which is a valid block offset, but the block at that offset has previous node offset of " + ofPrev + " (0x" + Integer.toString(ofPrev, 16) + ")");
            }
            block.close();
        }
        c = this.getFreeListCount();
        for (i = 0; i < c; ++i) {
            ofBlock = this.getFreeBlockOffset(i);
            if (ofBlock == -1) continue;
            if (!setOffsets.contains(ofBlock)) {
                throw new IllegalStateException(sDesc + ": free list " + i + " has offset " + ofBlock + " (0x" + Integer.toString(ofBlock, 16) + ") which is not a valid block offset");
            }
            block = this.openBlock(ofBlock);
            if (!block.isFree()) {
                throw new IllegalStateException(sDesc + ": free list " + i + " has offset " + ofBlock + " (0x" + Integer.toString(ofBlock, 16) + ") which is not a free block");
            }
            ofPrev = block.getPrevNodeOffset();
            if (ofPrev != -1) {
                throw new IllegalStateException(sDesc + ": free list " + i + " has offset " + ofBlock + " (0x" + Integer.toString(ofBlock, 16) + ") which is a valid block offset, but the block at that offset has previous node offset of " + ofPrev + " (0x" + Integer.toString(ofPrev, 16) + ")");
            }
            block.close();
        }
        int cBuckets = this.getBucketCount();
        int nModulo = this.getModulo();
        if (nModulo == (nModulo2 = this.getPreviousModulo()) && nModulo != cBuckets || nModulo != nModulo2 && (nModulo > cBuckets || nModulo2 > cBuckets || nModulo != cBuckets && nModulo2 != cBuckets)) {
            throw new IllegalStateException(sDesc + ": modulos (" + nModulo + " and " + nModulo2 + ") are illegal given the bucket count (" + cBuckets + ")");
        }
        int nRehash = this.getNextRehashBucket();
        if (nModulo == nModulo2 && nRehash != -1 || nModulo != nModulo2 && (nRehash == -1 || nRehash < 0 || nRehash >= cBuckets)) {
            throw new IllegalStateException(sDesc + ": rehash bucket (" + nRehash + ") is illegal given the modulos (" + nModulo + " and " + nModulo2 + ")");
        }
        int ofCompact = this.getNextCompactBlock();
        if (ofCompact != -1 && !setOffsets.contains(ofCompact)) {
            throw new IllegalStateException(sDesc + ": increment compact block offset " + ofCompact + " (0x" + Integer.toString(ofCompact, 16) + ") is not a valid block offset");
        }
        int ofLast = this.getLastBlockOffset();
        if (!setOffsets.contains(ofLast)) {
            throw new IllegalStateException(sDesc + ": last block offset " + ofLast + " (0x" + Integer.toString(ofLast, 16) + ") is not a valid block offset");
        }
        if (ofLast != ofLastActual) {
            throw new IllegalStateException(sDesc + ": last block offset " + ofLast + " (0x" + Integer.toString(ofLast, 16) + ") is not actually last! the real last block is at offset " + ofLastActual + " (0x" + Integer.toString(ofLastActual, 16) + ")");
        }
        int[] aofBlockCache = this.m_aofBlockCache;
        int cCacheBlocks = 8;
        int cOpenBlocks = this.m_cOpenBlocks;
        if (cOpenBlocks != 0) {
            throw new IllegalStateException(sDesc + ": there are " + cOpenBlocks + " open cache blocks (it should be zero)");
        }
        for (int i2 = 0; i2 < cCacheBlocks; ++i2) {
            int of2 = aofBlockCache[i2];
            if (of2 == -1) continue;
            throw new IllegalStateException(sDesc + ": the cache block at index " + i2 + " has an offset of " + of2 + " (0x" + Integer.toString(of2, 16) + ") (it should be NIL)");
        }
    }

    public static void main(String[] asArg) {
        try {
            int cbBuf = 256;
            try {
                cbBuf = Integer.parseInt(asArg[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            byte[] abBuf = new byte[cbBuf];
            ByteBuffer buf = ByteBuffer.wrap(abBuf);
            Base.out("Instantiating BinaryMap for a " + cbBuf + "-byte buffer");
            BinaryMap map = new BinaryMap(buf);
            PrintStream out = System.out;
            LineNumberReader in = new LineNumberReader(new InputStreamReader(System.in));
            boolean fDone = false;
            do {
                out.println();
                out.print("Command: ");
                out.flush();
                String sLine = in.readLine().trim();
                out.println();
                if (sLine == null || sLine.length() <= 0) continue;
                String[] asParts = Base.parseDelimitedString(sLine, ' ');
                int cParts = asParts.length;
                String sCmd = asParts[0];
                try {
                    if (sCmd.equalsIgnoreCase("quit") || sCmd.equalsIgnoreCase("bye") || sCmd.equalsIgnoreCase("exit") || sCmd.equalsIgnoreCase("q")) {
                        fDone = true;
                        continue;
                    }
                    if (sCmd.equalsIgnoreCase("dump")) {
                        map.dump();
                        continue;
                    }
                    if (sCmd.equalsIgnoreCase("get")) {
                        if (cParts < 2) {
                            out.println("get <key>");
                            continue;
                        }
                        out.println(BinaryMap.str(map.get(BinaryMap.bin(asParts[1]))));
                        continue;
                    }
                    if (sCmd.equalsIgnoreCase("put")) {
                        if (cParts < 3) {
                            out.println("put <key> <value>");
                            continue;
                        }
                        out.println(BinaryMap.str(map.put(BinaryMap.bin(asParts[1]), BinaryMap.bin(asParts[2]))));
                        continue;
                    }
                    if (sCmd.equalsIgnoreCase("remove")) {
                        if (cParts < 2) {
                            out.println("remove <key>");
                            continue;
                        }
                        out.println(BinaryMap.str(map.remove(BinaryMap.bin(asParts[1]))));
                        continue;
                    }
                    if (sCmd.equalsIgnoreCase("clear")) {
                        out.println("before: size()=" + map.size() + ", isEmpty()=" + map.isEmpty());
                        map.clear();
                        out.println("after: size()=" + map.size() + ", isEmpty()=" + map.isEmpty());
                        continue;
                    }
                    if (sCmd.equalsIgnoreCase("size")) {
                        out.println("size()=" + map.size() + ", isEmpty()=" + map.isEmpty());
                        continue;
                    }
                    if (sCmd.equalsIgnoreCase("list")) {
                        for (Map.Entry entry : map.entrySet()) {
                            out.println(BinaryMap.str(entry.getKey()) + "=" + BinaryMap.str(entry.getValue()));
                        }
                        continue;
                    }
                    if (sCmd.equalsIgnoreCase("keys")) {
                        Iterator iter = map.keySet().iterator();
                        while (iter.hasNext()) {
                            out.println(BinaryMap.str(iter.next()));
                        }
                        continue;
                    }
                    if (sCmd.equalsIgnoreCase("help")) {
                        out.println("get <key>");
                        out.println("put <key> <value>");
                        out.println("remove <key>");
                        out.println("size");
                        out.println("list");
                        out.println("keys");
                        out.println("quit");
                        continue;
                    }
                    out.println("unknown command: " + sCmd);
                    out.println("try \"help\"");
                }
                catch (Throwable e) {
                    Base.err(e);
                }
            } while (!fDone);
        }
        catch (Throwable e) {
            Base.err(e);
        }
    }

    public void dump() {
        Base.out("BinaryMap (entry count=" + this.m_cEntries + ")");
        Base.out("ByteBuffer (length=" + this.getCapacity() + ", free=" + this.getFreeCapacity() + ", used=" + this.getUsedCapacity() + ", total key bytes=" + this.m_cbKeyTotal + ", total value bytes=" + this.m_cbValueTotal + ", strict=" + this.isStrict() + "):");
        if (this.getBuffer().hasArray()) {
            Base.out(Base.indentString(Base.toHexDump(this.getBuffer().array(), 32), "  "));
        } else {
            Base.out("  <no array available>");
        }
        Base.out("Hash buckets (bucket count=" + this.getBucketCount() + ", bucket level=" + this.getBucketLevel() + ", modulo=" + this.getModulo() + ", prev modulo=" + this.getPreviousModulo() + ", shrink at=" + this.getShrinkageCount() + ", grow at=" + this.getGrowthCount() + ", rehashing=" + this.isRehashing() + ", next bucket=" + BinaryMap.formatIndex(this.getNextRehashBucket()) + "):");
        Base.out(Base.indentString(BinaryMap.formatOffsetArray(this.m_aofBucket), "  "));
        Base.out("Free lists (count=" + this.getFreeListCount() + ", next compaction offset=" + BinaryMap.formatOffset(this.getNextCompactBlock()) + "):");
        Base.out(Base.indentString(BinaryMap.formatOffsetArray(this.m_aofFree), "  "));
    }

    protected static String formatIndex(int n) {
        return n == -1 ? "nil" : Integer.toString(n);
    }

    protected static String formatOffset(int of) {
        return of == -1 ? "nil" : Base.toHexString(of, Base.getMaxHexDigits(of));
    }

    protected static String formatOffsetArray(int[] an) {
        int cn = an.length;
        int nMax = -1;
        for (int i = 0; i < cn; ++i) {
            if (an[i] <= nMax) continue;
            nMax = an[i];
        }
        int cDigitsHead = Base.getMaxHexDigits(cn);
        int cDigitsEach = Math.max(Base.getMaxHexDigits(nMax), 4);
        int cCharsPerLine = 137;
        int cPerLine = (cCharsPerLine - cDigitsHead - 3) / (cDigitsEach + 1);
        int cLines = (cn + cPerLine - 1) / cPerLine;
        int cch = cLines * 137;
        char[] ach = new char[cch];
        for (int i = 0; i < cch; ++i) {
            ach[i] = 32;
        }
        int ofColon = cDigitsHead;
        int ofLF = cCharsPerLine - 1;
        int ofFirst = ofColon + 3;
        int iOffset = 0;
        int ofLine = 0;
        int iLastLine = cLines - 1;
        for (int iLine = 0; iLine <= iLastLine; ++iLine) {
            int n = iOffset;
            int of = ofLine + cDigitsHead;
            for (int i = 0; i < cDigitsHead; ++i) {
                ach[--of] = HEX[n & 0xF];
                n >>= 4;
            }
            ach[ofLine + ofColon] = 58;
            for (int iEach = 0; iEach < cPerLine; ++iEach) {
                try {
                    n = an[iOffset++];
                    of = ofLine + ofFirst + (iEach + 1) * (cDigitsEach + 1) - 1;
                    if (n == -1) {
                        ach[--of] = 108;
                        ach[--of] = 105;
                        ach[--of] = 110;
                        continue;
                    }
                    for (int i = 0; i < cDigitsEach; ++i) {
                        ach[--of] = HEX[n & 0xF];
                        n >>= 4;
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (iLine != iLastLine) {
                ach[ofLine + ofLF] = 10;
            }
            ofLine += cCharsPerLine;
        }
        return new String(ach, 0, cch - 1);
    }

    protected static Binary bin(String s) {
        return new Binary(s.getBytes());
    }

    protected static String str(Object bin) {
        if (bin == null) {
            return "<null>";
        }
        return new String(((Binary)bin).toByteArray());
    }

    protected void initializeFreeLists() {
        this.m_aofFree = new int[26];
        this.clearFreeLists();
    }

    protected void clearFreeLists() {
        int[] aof = this.m_aofFree;
        int c = aof.length;
        for (int i = 0; i < c; ++i) {
            aof[i] = -1;
        }
    }

    protected int getFreeListCount() {
        return this.m_aofFree.length;
    }

    protected int getFreeBlockOffset(int nCode) {
        return this.m_aofFree[nCode];
    }

    protected void setFreeBlockOffset(int nCode, int ofBlock) {
        this.m_aofFree[nCode] = ofBlock;
    }

    protected void initializeBuckets() {
        this.setBucketCount(0);
        this.setBucketLevel(0);
        int nModulo = this.getModulo();
        this.setBucketCount(nModulo);
        this.setPreviousModulo(nModulo);
        this.setNextRehashBucket(-1);
    }

    protected int getBucketLevel() {
        return this.m_nBucketLevel;
    }

    protected void setBucketLevel(int nLevel) {
        int nModuloShrink;
        assert (nLevel < BUCKET_COUNTS.length);
        this.m_nBucketLevel = nLevel;
        int nModulo = BUCKET_COUNTS[nLevel];
        int n = nModuloShrink = nLevel == 0 ? 0 : BUCKET_COUNTS[nLevel - 1];
        assert (this.getMaxLoadFactor() > this.getMinLoadFactor());
        this.setModulo(nModulo);
        this.setGrowthCount(nLevel == BUCKET_COUNTS.length - 1 ? Integer.MAX_VALUE : (int)((double)nModulo * this.getMaxLoadFactor()));
        this.setShrinkageCount((int)((double)nModuloShrink * this.getMinLoadFactor()));
    }

    protected int getBucketCount() {
        return this.m_aofBucket.length;
    }

    protected void setBucketCount(int cBuckets) {
        int cNew = cBuckets;
        int[] aofOld = this.m_aofBucket;
        int cOld = aofOld == null ? 0 : aofOld.length;
        if (cNew == cOld) {
            return;
        }
        int[] aofNew = new int[cNew];
        if (cOld > 0) {
            System.arraycopy(aofOld, 0, aofNew, 0, Math.min(cOld, cNew));
        }
        this.m_aofBucket = aofNew;
        if (cNew > cOld) {
            this.clearBucketOffsets(cOld);
        }
    }

    protected int getBucketOffset(int nBucket) {
        return this.m_aofBucket[nBucket];
    }

    protected void setBucketOffset(int nBucket, int ofBlock) {
        this.m_aofBucket[nBucket] = ofBlock;
    }

    protected double getMaxLoadFactor() {
        return this.m_dflLoadPercentGrow;
    }

    protected void setMaxLoadFactor(double dflPercent) {
        this.m_dflLoadPercentGrow = dflPercent;
    }

    protected double getMinLoadFactor() {
        return this.m_dflLoadPercentShrink;
    }

    protected void setMinLoadFactor(double dflPercent) {
        this.m_dflLoadPercentShrink = dflPercent;
    }

    protected int getGrowthCount() {
        return this.m_cEntriesGrow;
    }

    protected void setGrowthCount(int cEntries) {
        this.m_cEntriesGrow = cEntries;
    }

    protected int getShrinkageCount() {
        return this.m_cEntriesShrink;
    }

    protected void setShrinkageCount(int cEntries) {
        this.m_cEntriesShrink = cEntries;
    }

    protected int getModulo() {
        return this.m_nModuloCurrent;
    }

    protected void setModulo(int nModulo) {
        this.m_nModuloCurrent = nModulo;
    }

    protected int getPreviousModulo() {
        return this.m_nModuloPrevious;
    }

    protected void setPreviousModulo(int nModulo) {
        this.m_nModuloPrevious = nModulo;
    }

    protected int calculateBucket(int nHash) {
        return (int)(((long)nHash & 0xFFFFFFFFL) % (long)this.getModulo());
    }

    protected int calculatePreviousBucket(int nHash) {
        return (int)(((long)nHash & 0xFFFFFFFFL) % (long)this.getPreviousModulo());
    }

    protected void clearBucketOffsets() {
        this.clearBucketOffsets(0);
    }

    protected void clearBucketOffsets(int nBucket) {
        int cBuckets = this.getBucketCount();
        while (nBucket < cBuckets) {
            this.setBucketOffset(nBucket, -1);
            ++nBucket;
        }
    }

    protected void checkModulo() {
        int cEntries = this.getEntryBlockCount();
        int nDelta = 0;
        if (cEntries < this.getShrinkageCount()) {
            nDelta = -1;
        } else if (cEntries >= this.getGrowthCount()) {
            nDelta = 1;
        }
        if (nDelta == 0) {
            return;
        }
        if (this.isRehashing()) {
            this.rehashAll();
        }
        this.setPreviousModulo(this.getModulo());
        this.setBucketLevel(this.getBucketLevel() + nDelta);
        this.setBucketCount(Math.max(this.getModulo(), this.getPreviousModulo()));
        this.rehashBegin();
    }

    protected boolean isRehashing() {
        return this.getModulo() != this.getPreviousModulo();
    }

    protected int getNextRehashBucket() {
        return this.m_nBucketNextRehash;
    }

    protected void setNextRehashBucket(int nBucket) {
        this.m_nBucketNextRehash = nBucket;
    }

    protected void rehashBegin() {
        assert (this.isRehashing());
        this.setNextRehashBucket(0);
    }

    protected void rehash(int nBucket) {
        int ofBlock = this.getBucketOffset(nBucket);
        while (ofBlock != -1) {
            Block block = this.openBlock(ofBlock);
            ofBlock = block.getNextNodeOffset();
            if (this.calculateBucket(block.getKeyHash()) != nBucket) {
                block.unlink();
                block.link();
            }
            block.close();
        }
    }

    protected void rehashNext() {
        if (this.isRehashing()) {
            int cBuckets;
            int nBucket = this.getNextRehashBucket();
            if (nBucket < (cBuckets = this.getPreviousModulo())) {
                this.rehash(nBucket);
                this.setNextRehashBucket(++nBucket);
            }
            if (nBucket >= cBuckets) {
                this.rehashComplete();
            }
        }
    }

    protected void rehashAll() {
        if (this.isRehashing()) {
            int cBuckets = this.getBucketCount();
            for (int nBucket = this.getNextRehashBucket(); nBucket < cBuckets; ++nBucket) {
                this.rehash(nBucket);
            }
            this.rehashComplete();
        }
    }

    protected void rehashComplete() {
        this.setNextRehashBucket(-1);
        this.setPreviousModulo(this.getModulo());
        this.setBucketCount(this.getModulo());
    }

    protected Block initBlock(int of) {
        Block block = this.grabBlock(of);
        assert (block.getType() == 0);
        return block;
    }

    protected Block openBlock(int of) {
        Block block = this.grabBlock(of);
        if (block.getType() == 0) {
            block.readHeader();
        }
        return block;
    }

    protected Block allocateBlock(int cb) {
        int of;
        int i;
        assert (cb >= 29);
        this.checkBufferGrow(cb);
        int nCode = BinaryMap.calculateSizeCode(cb);
        int cCodes = 26;
        for (i = nCode + 1; i < cCodes; ++i) {
            of = this.getFreeBlockOffset(i);
            if (of == -1) continue;
            Block block = this.openBlock(of);
            block.allocate(cb);
            return block;
        }
        if (cb > this.getFreeCapacity()) {
            throw this.reportOutOfMemory(cb);
        }
        this.compactUntil(cb);
        for (i = nCode + 1; i < cCodes; ++i) {
            of = this.getFreeBlockOffset(i);
            if (of == -1) continue;
            Block block = this.openBlock(of);
            block.allocate(cb);
            return block;
        }
        int of2 = this.getFreeBlockOffset(nCode);
        while (of2 != -1) {
            Block block = this.openBlock(of2);
            if (block.length() >= cb) {
                block.allocate(cb);
                return block;
            }
            of2 = block.getNextNodeOffset();
            block.close();
        }
        throw this.reportOutOfMemory(cb);
    }

    protected boolean isCompacting() {
        return this.getEntryBlockCount() > 0;
    }

    protected int getNextCompactBlock() {
        return this.m_ofBlockNextCompact;
    }

    protected void setNextCompactBlock(int ofBlock) {
        this.m_ofBlockNextCompact = ofBlock;
    }

    protected void compactBegin() {
        this.setNextCompactBlock(0);
    }

    protected void compactUntil(int cbReqFree) {
        int cbNextFree;
        assert (cbReqFree <= this.getFreeCapacity());
        ByteBuffer buffer = this.getBuffer();
        byte[] abBuf = null;
        int cbBuf = 1024;
        do {
            int cbCopy;
            int ofCopyTo;
            cbNextFree = 0;
            int ofBlock = this.getNextCompactBlock();
            this.setNextCompactBlock(-1);
            Block block = this.openBlock(ofBlock);
            int ofNext = block.getNextBlockOffset();
            if (block.isFree()) {
                cbNextFree = block.getLength();
                if (ofNext != -1) {
                    Block blockEntry = this.openBlock(ofNext);
                    assert (blockEntry.isEntry());
                    int ofFollow = blockEntry.getNextBlockOffset();
                    int cbFill = blockEntry.getFillLength();
                    int cbNext = blockEntry.length();
                    int cbEntry = cbNext - cbFill;
                    int ofFree = ofBlock + cbEntry;
                    int cbFree = block.getLength() + cbFill;
                    block.unlink();
                    blockEntry.unlink();
                    int ofCopyFrom = ofNext + 17;
                    ofCopyTo = ofBlock + 17;
                    cbCopy = blockEntry.getKeyLength() + blockEntry.getValueLength() + 12;
                    if (abBuf == null) {
                        abBuf = new byte[cbBuf];
                    }
                    BinaryMap.buffercopy(buffer, ofCopyFrom, ofCopyTo, cbCopy, abBuf);
                    blockEntry.setOffset(ofBlock);
                    blockEntry.setPrevBlockOffset(block.getPrevBlockOffset());
                    blockEntry.setNextBlockOffset(ofFree);
                    block.setOffset(ofFree);
                    block.setPrevBlockOffset(ofBlock);
                    block.setNextBlockOffset(ofFollow);
                    boolean fMerge = false;
                    if (ofFollow != -1) {
                        Block blockFollow = this.openBlock(ofFollow);
                        fMerge = blockFollow.isFree();
                        blockFollow.setPrevBlockOffset(ofFree);
                        blockFollow.close();
                    }
                    if (this.isStrict()) {
                        block.clear();
                    }
                    block.link();
                    blockEntry.link();
                    blockEntry.close();
                    ofNext = ofFree;
                    cbNextFree = cbFree;
                    if (fMerge) {
                        block.merge();
                        cbNextFree = block.getLength();
                    }
                }
            } else {
                int ofEntry;
                int cbFill = block.getFillLength();
                if (cbFill >= 17) {
                    ofEntry = ofBlock;
                    int cbEntry = block.getLength();
                    int ofFree = ofEntry + cbEntry - cbFill;
                    int cbFree = cbFill;
                    int ofFollow = ofNext;
                    block.setNextBlockOffset(ofFree);
                    block.close();
                    boolean fMerge = false;
                    if (ofFollow != -1) {
                        Block blockFollow = this.openBlock(ofFollow);
                        fMerge = blockFollow.isFree();
                        blockFollow.setPrevBlockOffset(ofFree);
                        blockFollow.close();
                    }
                    block = this.initBlock(ofFree);
                    block.setType(1);
                    block.setNextBlockOffset(ofFollow);
                    block.setPrevBlockOffset(ofBlock);
                    block.link();
                    ofNext = ofFree;
                    cbNextFree = cbFree;
                    if (fMerge) {
                        block.merge();
                        cbNextFree = block.getLength();
                    }
                } else if (cbFill > 0 && ofNext != -1) {
                    ofEntry = ofBlock;
                    int cbEntryOld = block.getLength();
                    int cbEntryNew = cbEntryOld - cbFill;
                    int ofNextOld = ofNext;
                    int ofNextNew = ofNext - cbFill;
                    assert (ofNextNew == ofEntry + cbEntryNew);
                    block.setNextBlockOffset(ofNextNew);
                    block.close();
                    block = this.openBlock(ofNextOld);
                    int ofFollow = block.getNextBlockOffset();
                    if (ofFollow != -1) {
                        Block blockFollow = this.openBlock(ofFollow);
                        blockFollow.setPrevBlockOffset(ofNextNew);
                        blockFollow.close();
                    }
                    block.unlink();
                    if (block.isFree()) {
                        if (this.isStrict()) {
                            this.wipe(ofNextOld, 17);
                        }
                        cbNextFree = block.getLength() + cbFill;
                    } else {
                        int ofCopyFrom = ofNextOld + 17;
                        ofCopyTo = ofNextNew + 17;
                        cbCopy = block.getKeyLength() + block.getValueLength() + 12;
                        if (abBuf == null) {
                            abBuf = new byte[cbBuf];
                        }
                        BinaryMap.buffercopy(buffer, ofCopyFrom, ofCopyTo, cbCopy, abBuf);
                        if (this.isStrict()) {
                            this.wipe(ofCopyTo + cbCopy, ofCopyFrom - ofCopyTo);
                        }
                    }
                    block.setOffset(ofNextNew);
                    block.link();
                    ofNext = ofNextNew;
                }
            }
            block.close();
            this.setNextCompactBlock(ofNext);
            if (ofNext != -1) continue;
            this.compactComplete();
        } while (cbNextFree < cbReqFree);
    }

    protected void compactNext() {
        if (this.isCompacting()) {
            this.compactUntil(0);
        }
    }

    protected void compactAll() {
        Block block;
        this.setNextCompactBlock(-1);
        this.clearFreeLists();
        this.clearBucketOffsets();
        int ofSrc = 0;
        int ofDest = 0;
        int ofPrevDest = -1;
        byte[] abBuf = null;
        int cbBuf = 1024;
        ByteBuffer buffer = this.getBuffer();
        while (ofSrc != -1) {
            block = this.openBlock(ofSrc);
            int ofNextSrc = block.getNextBlockOffset();
            int ofNextDest = ofDest;
            if (block.isEntry()) {
                int cbBlock = block.getLength();
                int cbFill = block.getFillLength();
                ofNextDest += cbBlock - cbFill;
                if (ofSrc != ofDest) {
                    assert (ofSrc > ofDest);
                    int ofCopyFrom = ofSrc + 17;
                    int ofCopyTo = ofDest + 17;
                    int cbCopy = block.getKeyLength() + block.getValueLength() + 12;
                    if (abBuf == null) {
                        abBuf = new byte[cbBuf];
                    }
                    BinaryMap.buffercopy(buffer, ofCopyFrom, ofCopyTo, cbCopy, abBuf);
                    block.setOffset(ofDest);
                }
                block.setPrevBlockOffset(ofPrevDest);
                block.setNextBlockOffset(ofNextDest);
                block.setNextNodeOffset(-1);
                block.setPrevNodeOffset(-1);
                block.link();
                block.close();
                ofPrevDest = ofDest;
                ofDest = ofNextDest;
            } else {
                block.discard();
            }
            ofSrc = ofNextSrc;
        }
        assert (ofDest < this.getCapacity());
        block = this.initBlock(ofDest);
        block.setType(1);
        block.setPrevBlockOffset(ofPrevDest);
        if (this.isStrict()) {
            block.clear();
        }
        block.link();
        block.close();
        this.compactBegin();
    }

    protected void compactComplete() {
        this.compactBegin();
    }

    protected Block grabBlock(int ofBlock) {
        int[] aofBlockCache = this.m_aofBlockCache;
        Block[] ablockCache = this.m_ablockCache;
        int cCacheBlocks = 8;
        int cOpenBlocks = this.m_cOpenBlocks;
        Block block = null;
        for (int i = 0; i < cOpenBlocks; ++i) {
            if (aofBlockCache[i] != ofBlock) continue;
            block = ablockCache[i];
            break;
        }
        if (block == null) {
            if (cOpenBlocks < cCacheBlocks) {
                aofBlockCache[cOpenBlocks] = ofBlock;
                block = ablockCache[cOpenBlocks];
                block.init(ofBlock);
                this.m_cOpenBlocks = cOpenBlocks + 1;
            } else {
                throw new IllegalStateException("grabBlock(): ran out of blocks");
            }
        }
        block.use();
        return block;
    }

    protected void adjustOpenBlockOffset(int ofOld, int ofNew) {
        int[] aofBlockCache = this.m_aofBlockCache;
        int cOpenBlocks = this.m_cOpenBlocks;
        for (int i = 0; i < cOpenBlocks; ++i) {
            if (aofBlockCache[i] != ofOld) continue;
            aofBlockCache[i] = ofNew;
            return;
        }
        assert (false) : "could not find open block at offset " + ofOld + " (0x" + Integer.toString(ofOld, 16) + ") that is being moved to " + ofNew + " (0x" + Integer.toString(ofNew, 16) + ")";
    }

    protected void recycleBlock(Block block) {
        assert (block.getOffset() == -1);
        int[] aofBlockCache = this.m_aofBlockCache;
        Block[] ablockCache = this.m_ablockCache;
        int cOpenBlocks = this.m_cOpenBlocks;
        int iLast = cOpenBlocks - 1;
        for (int i = 0; i <= iLast; ++i) {
            if (ablockCache[i] != block) continue;
            if (i < iLast) {
                aofBlockCache[i] = aofBlockCache[iLast];
                ablockCache[i] = ablockCache[iLast];
                aofBlockCache[iLast] = -1;
                ablockCache[iLast] = block;
            } else {
                aofBlockCache[i] = -1;
            }
            this.m_cOpenBlocks = cOpenBlocks - 1;
            return;
        }
        assert (false) : "attempt to release block that was not open";
    }

    protected static void buffercopy(ByteBuffer buffer, int ofCopyFrom, int ofCopyTo, int cbCopy, byte[] abBuf) {
        assert (ofCopyFrom > ofCopyTo);
        assert (cbCopy > 0);
        assert (abBuf != null && abBuf.length > 0);
        int cbBuf = abBuf.length;
        while (cbCopy > 0) {
            int cbChunk = Math.min(cbCopy, cbBuf);
            buffer.position(ofCopyFrom);
            buffer.get(abBuf, 0, cbChunk);
            buffer.position(ofCopyTo);
            buffer.put(abBuf, 0, cbChunk);
            ofCopyFrom += cbChunk;
            ofCopyTo += cbChunk;
            cbCopy -= cbChunk;
        }
    }

    protected static int calculateSizeCode(int cbBlock) {
        int nNibble = cbBlock >>> 6;
        int cShifts = 0;
        if (nNibble > 65535) {
            nNibble >>>= 16;
            cShifts += 16;
        }
        if (nNibble > 255) {
            nNibble >>>= 8;
            cShifts += 8;
        }
        if (nNibble > 15) {
            nNibble >>>= 4;
            cShifts += 4;
        }
        switch (nNibble) {
            case 0: {
                assert (cShifts == 0);
                return 0;
            }
            case 1: {
                return cShifts + 1;
            }
            case 2: 
            case 3: {
                assert (cbBlock >= 0) : "Negative block size: " + cbBlock;
                return cShifts + 2;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return cShifts + 3;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return cShifts + 4;
            }
        }
        throw new AssertionError((Object)("Nibble out of range: " + nNibble));
    }

    protected Block instantiateBlock() {
        return new Block();
    }

    static {
        int c = FILL_BUFFER.length;
        for (int i = 0; i < c; ++i) {
            BinaryMap.FILL_BUFFER[i] = 0;
        }
        BUCKET_COUNTS = new int[]{7, 47, 199, 797, 3191, 12799, 51199, 204797, 819187, 0x31FFFF, 13107197, 52428767};
        HEX = "0123456789ABCDEF".toCharArray();
    }

    public class Block
    extends Base {
        public static final int NONE = 0;
        public static final int FREE = 1;
        public static final int ENTRY = 2;
        public static final int OFFSET_HASH = 17;
        public static final int OFFSET_KEY = 21;
        public static final int OFFSET_VALUE = 25;
        public static final int MIN_SPLIT = 64;
        public static final int MIN_FREE = 17;
        public static final int MIN_ENTRY = 29;
        private int m_nType;
        private int m_ofThisBlock;
        private int m_ofNextBlock;
        private int m_ofPrevBlock;
        private int m_ofNextNode;
        private int m_ofPrevNode;
        private int m_nHash;
        private int m_cbKey;
        private int m_cbValue;
        private Binary m_binKey;
        private Binary m_binValue;
        private int m_cUses;
        private boolean m_fHeaderMod;
        private boolean m_fKeyMod;
        private boolean m_fValueMod;

        public Block() {
            this.reset();
        }

        public void init(int of) {
            assert (this.m_ofThisBlock == -1);
            this.m_ofThisBlock = of;
        }

        protected void use() {
            ++this.m_cUses;
        }

        protected boolean finishUse() {
            assert (this.m_cUses > 0);
            int cUses = this.m_cUses;
            if (cUses > 0) {
                this.m_cUses = --cUses;
            }
            return cUses == 0;
        }

        public void reset() {
            this.m_nType = 0;
            this.m_ofThisBlock = -1;
            this.m_ofNextBlock = -1;
            this.m_ofPrevBlock = -1;
            this.m_ofNextNode = -1;
            this.m_ofPrevNode = -1;
            this.m_nHash = 0;
            this.m_cbKey = 0;
            this.m_cbValue = 0;
            this.m_fHeaderMod = false;
            this.m_fKeyMod = false;
            this.m_fValueMod = false;
            this.m_binKey = null;
            this.m_binValue = null;
        }

        public void flush() {
            if (this.m_fHeaderMod) {
                this.writeHeader();
            }
            if (this.m_fKeyMod) {
                this.writeKey();
            }
            if (this.m_fValueMod) {
                this.writeValue();
            }
        }

        public void close() {
            if (this.m_ofThisBlock != -1) {
                if (this.getNextBlockOffset() == -1) {
                    BinaryMap.this.setLastBlockOffset(this.m_ofThisBlock);
                }
                if (this.finishUse()) {
                    this.flush();
                    this.reset();
                    BinaryMap.this.recycleBlock(this);
                }
            }
        }

        public void discard() {
            if (this.m_ofThisBlock != -1) {
                boolean fFinish = this.finishUse();
                assert (fFinish);
                if (this.m_ofThisBlock == BinaryMap.this.getNextCompactBlock()) {
                    int ofPrev = this.getPrevBlockOffset();
                    if (ofPrev == -1) {
                        ofPrev = 0;
                    }
                    BinaryMap.this.setNextCompactBlock(ofPrev);
                }
                if (BinaryMap.this.isStrict()) {
                    this.clear();
                }
                this.reset();
                BinaryMap.this.recycleBlock(this);
            }
        }

        public void clear() {
            BinaryMap.this.wipe(this.getOffset(), this.getLength());
        }

        public void clearValue() {
            BinaryMap.this.wipe(this.getOffset() + 25 + this.getKeyLength(), this.getValueLength() + 4);
        }

        public int getType() {
            return this.m_nType;
        }

        public void setType(int nType) {
            assert (nType == 0 || nType == 1 || nType == 2) : "Illegal Block Type: " + nType;
            if (nType != this.m_nType) {
                this.m_nType = nType;
                this.m_fHeaderMod = true;
            }
        }

        public boolean isFree() {
            return this.getType() == 1;
        }

        public boolean isEntry() {
            return this.getType() == 2;
        }

        public int getOffset() {
            return this.m_ofThisBlock;
        }

        public void setOffset(int ofBlock) {
            int ofPrev = this.m_ofThisBlock;
            if (ofBlock != ofPrev) {
                if (ofPrev == BinaryMap.this.getNextCompactBlock()) {
                    BinaryMap.this.setNextCompactBlock(ofBlock);
                }
                BinaryMap.this.adjustOpenBlockOffset(ofPrev, ofBlock);
                this.m_ofThisBlock = ofBlock;
                this.m_fHeaderMod = true;
            }
        }

        public int getLength() {
            return this.length();
        }

        public int length() {
            int ofThis = this.m_ofThisBlock;
            assert (ofThis != -1) : "Block is not initialized";
            int ofNext = this.m_ofNextBlock;
            if (ofNext == -1) {
                ofNext = BinaryMap.this.getBuffer().capacity();
            }
            return ofNext - ofThis;
        }

        public int getSizeCode() {
            return BinaryMap.calculateSizeCode(this.length());
        }

        public int getNextBlockOffset() {
            return this.m_ofNextBlock;
        }

        public void setNextBlockOffset(int ofBlock) {
            if (ofBlock != this.m_ofNextBlock) {
                this.m_ofNextBlock = ofBlock;
                this.m_fHeaderMod = true;
            }
        }

        public int getPrevBlockOffset() {
            return this.m_ofPrevBlock;
        }

        public void setPrevBlockOffset(int ofBlock) {
            if (ofBlock != this.m_ofPrevBlock) {
                this.m_ofPrevBlock = ofBlock;
                this.m_fHeaderMod = true;
            }
        }

        public int getNextNodeOffset() {
            return this.m_ofNextNode;
        }

        public void setNextNodeOffset(int ofBlock) {
            if (ofBlock != this.m_ofNextNode) {
                this.m_ofNextNode = ofBlock;
                this.m_fHeaderMod = true;
            }
        }

        public int getPrevNodeOffset() {
            return this.m_ofPrevNode;
        }

        public void setPrevNodeOffset(int ofBlock) {
            if (ofBlock != this.m_ofPrevNode) {
                this.m_ofPrevNode = ofBlock;
                this.m_fHeaderMod = true;
            }
        }

        public int getKeyHash() {
            return this.m_nHash;
        }

        public int getKeyLength() {
            return this.m_cbKey;
        }

        public Binary getKey() {
            if (this.m_binKey == null) {
                this.readKey();
            }
            return this.m_binKey;
        }

        public void setKey(Binary bin) {
            Binary binOld = this.m_binKey;
            if (!Block.equals(bin, binOld)) {
                this.m_binKey = bin;
                this.m_cbKey = bin.length();
                this.m_nHash = bin.hashCode();
                this.m_fKeyMod = true;
            }
        }

        public int getValueLength() {
            return this.m_cbValue;
        }

        public Binary getValue() {
            if (this.m_binValue == null) {
                this.readValue();
            }
            return this.m_binValue;
        }

        public void setValue(Binary bin) {
            Binary binOld = this.m_binValue;
            if (!Block.equals(bin, binOld)) {
                this.m_binValue = bin;
                this.m_cbValue = bin.length();
                this.m_fValueMod = true;
            }
        }

        public int getFillLength() {
            assert (this.isFree() || this.isEntry()) : "Attempt to get fill length for invalid block type=" + this.getType();
            return this.isEntry() ? this.length() - 29 - this.getKeyLength() - this.getValueLength() : this.length() - 17;
        }

        public void readHeader() {
            assert (!this.m_fHeaderMod) : "Attempt to re-read header for block at offset " + this.getOffset() + " after header was modified";
            BinaryMap.this.getBuffer().position(this.m_ofThisBlock);
            DataInputStream stream = BinaryMap.this.getBufferInput();
            try {
                this.m_nType = stream.readByte();
                this.m_ofNextBlock = stream.readInt();
                this.m_ofPrevBlock = stream.readInt();
                this.m_ofNextNode = stream.readInt();
                this.m_ofPrevNode = stream.readInt();
                switch (this.m_nType) {
                    case 0: {
                        throw new AssertionError((Object)("Illegal block type (NONE) found at offset " + this.m_ofThisBlock));
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.m_nHash = stream.readInt();
                        this.m_cbKey = stream.readInt();
                        stream.skip(this.m_cbKey);
                        this.m_cbValue = stream.readInt();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Illegal block type (" + this.m_nType + ") found at offset " + this.m_ofThisBlock));
                    }
                }
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            this.m_fHeaderMod = false;
        }

        public void writeHeader() {
            assert (this.isFree() || this.isEntry()) : "Attempt to write block of type " + this.getType();
            BinaryMap.this.getBuffer().position(this.m_ofThisBlock);
            DataOutputStream stream = BinaryMap.this.getBufferOutput();
            try {
                stream.writeByte(this.m_nType);
                stream.writeInt(this.m_ofNextBlock);
                stream.writeInt(this.m_ofPrevBlock);
                stream.writeInt(this.m_ofNextNode);
                stream.writeInt(this.m_ofPrevNode);
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            this.m_fHeaderMod = false;
        }

        public void readKey() {
            assert (this.isEntry());
            assert (this.getOffset() != -1);
            BinaryMap.this.getBuffer().position(this.getOffset() + 21);
            try {
                this.m_binKey = new Binary(BinaryMap.this.getBufferInput());
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            assert (this.getKeyLength() == this.m_binKey.length());
        }

        public void writeKey() {
            assert (this.isEntry());
            assert (this.getOffset() != -1);
            assert (this.m_binKey != null);
            BinaryMap.this.getBuffer().position(this.getOffset() + 17);
            DataOutputStream stream = BinaryMap.this.getBufferOutput();
            try {
                stream.writeInt(this.m_nHash);
                this.m_binKey.writeExternal(stream);
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            this.m_fKeyMod = false;
        }

        public void readValue() {
            assert (this.isEntry());
            assert (this.getOffset() != -1);
            BinaryMap.this.getBuffer().position(this.getOffset() + 25 + this.getKeyLength());
            try {
                this.m_binValue = new Binary(BinaryMap.this.getBufferInput());
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            assert (this.getValueLength() == this.m_binValue.length());
        }

        public void writeValue() {
            assert (this.isEntry());
            assert (this.getOffset() != -1);
            assert (this.m_binValue != null);
            BinaryMap.this.getBuffer().position(this.getOffset() + 25 + this.getKeyLength());
            try {
                this.m_binValue.writeExternal(BinaryMap.this.getBufferOutput());
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            this.m_fValueMod = false;
        }

        public void link() {
            switch (this.m_nType) {
                case 0: {
                    throw new AssertionError((Object)("Illegal unlink of type NONE at offset " + this.m_ofThisBlock));
                }
                case 1: 
                case 2: {
                    int ofNext;
                    int nWhich;
                    assert (this.getNextNodeOffset() == -1) : "Attempt to link node at offset " + this.getOffset() + " which a non-NIL next node offset " + this.getNextNodeOffset();
                    assert (this.getPrevNodeOffset() == -1) : "Attempt to link node at offset " + this.getOffset() + " which a non-NIL prev node offset " + this.getPrevNodeOffset();
                    int ofThis = this.getOffset();
                    boolean fFree = this.isFree();
                    if (fFree) {
                        nWhich = this.getSizeCode();
                        ofNext = BinaryMap.this.getFreeBlockOffset(nWhich);
                    } else {
                        nWhich = BinaryMap.this.calculateBucket(this.getKeyHash());
                        ofNext = BinaryMap.this.getBucketOffset(nWhich);
                    }
                    if (ofNext != -1) {
                        Block block = BinaryMap.this.openBlock(ofNext);
                        block.setPrevNodeOffset(ofThis);
                        block.close();
                    }
                    this.setNextNodeOffset(ofNext);
                    this.setPrevNodeOffset(-1);
                    if (fFree) {
                        BinaryMap.this.setFreeBlockOffset(nWhich, ofThis);
                        break;
                    }
                    BinaryMap.this.setBucketOffset(nWhich, ofThis);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Illegal block type (" + this.m_nType + ") unlink at offset " + this.m_ofThisBlock));
                }
            }
        }

        public void unlink() {
            switch (this.m_nType) {
                case 0: {
                    throw new AssertionError((Object)("Illegal unlink of type NONE at offset " + this.m_ofThisBlock));
                }
                case 1: 
                case 2: {
                    Block block;
                    int ofNext = this.getNextNodeOffset();
                    int ofPrev = this.getPrevNodeOffset();
                    if (ofNext != -1) {
                        block = BinaryMap.this.openBlock(ofNext);
                        block.setPrevNodeOffset(ofPrev);
                        block.close();
                    }
                    if (ofPrev == -1) {
                        if (this.isFree()) {
                            int nCode = this.getSizeCode();
                            assert (BinaryMap.this.getFreeBlockOffset(nCode) == this.getOffset()) : "First free block for size code " + nCode + " is at offset " + BinaryMap.this.getFreeBlockOffset(nCode) + " (0x" + Integer.toString(BinaryMap.this.getFreeBlockOffset(nCode), 16) + ") but the block at offset " + this.getOffset() + " (0x" + Integer.toString(this.getOffset(), 16) + ") has size code " + this.getSizeCode() + " and a previous offset of NIL";
                            BinaryMap.this.setFreeBlockOffset(nCode, ofNext);
                        } else {
                            int nBucket = BinaryMap.this.calculateBucket(this.getKeyHash());
                            if (BinaryMap.this.getBucketOffset(nBucket) != this.getOffset()) {
                                nBucket = BinaryMap.this.calculatePreviousBucket(this.getKeyHash());
                            }
                            assert (BinaryMap.this.getBucketOffset(nBucket) == this.getOffset()) : "First Entry block for bucket " + nBucket + " is at offset " + BinaryMap.this.getBucketOffset(nBucket) + " but the block at offset " + this.getOffset() + " has bucket " + nBucket + " (hash=" + this.getKeyHash() + ") and a previous offset of NIL";
                            BinaryMap.this.setBucketOffset(nBucket, ofNext);
                        }
                    } else {
                        block = BinaryMap.this.openBlock(ofPrev);
                        block.setNextNodeOffset(ofNext);
                        block.close();
                    }
                    this.setNextNodeOffset(-1);
                    this.setPrevNodeOffset(-1);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Illegal block type (" + this.m_nType + ") unlink at offset " + this.m_ofThisBlock));
                }
            }
        }

        public void split(int cbRetain) {
            assert (this.isFree());
            int ofThis = this.getOffset();
            int cbThis = this.length();
            if (cbThis - cbRetain < 64) {
                return;
            }
            int ofThat = ofThis + cbRetain;
            Block that = BinaryMap.this.initBlock(ofThat);
            that.setType(1);
            this.unlink();
            int ofNext = this.getNextBlockOffset();
            if (ofNext != -1) {
                Block block = BinaryMap.this.openBlock(ofNext);
                block.setPrevBlockOffset(ofThat);
                block.close();
            }
            this.setNextBlockOffset(ofThat);
            that.setPrevBlockOffset(ofThis);
            that.setNextBlockOffset(ofNext);
            this.link();
            that.link();
            that.close();
        }

        public void merge() {
            Block block;
            assert (this.isFree());
            int ofPrevOld = this.getPrevBlockOffset();
            int ofNextOld = this.getNextBlockOffset();
            int ofOld = this.getOffset();
            int ofPrevNew = ofPrevOld;
            int ofNextNew = ofNextOld;
            int ofNew = ofOld;
            this.unlink();
            if (ofPrevOld != -1) {
                block = BinaryMap.this.openBlock(ofPrevOld);
                if (block.isFree()) {
                    ofNew = block.getOffset();
                    ofPrevNew = block.getPrevBlockOffset();
                    block.unlink();
                    block.discard();
                } else {
                    block.close();
                }
            }
            if (ofNextOld != -1) {
                block = BinaryMap.this.openBlock(ofNextOld);
                if (block.isFree()) {
                    ofNextNew = block.getNextBlockOffset();
                    block.unlink();
                    block.discard();
                } else {
                    block.close();
                }
            }
            if ((ofOld != ofNew || ofNextOld != ofNextNew) && ofNextNew != -1) {
                block = BinaryMap.this.openBlock(ofNextNew);
                assert (!block.isFree());
                block.setPrevBlockOffset(ofNew);
                block.close();
            }
            this.setOffset(ofNew);
            this.setPrevBlockOffset(ofPrevNew);
            this.setNextBlockOffset(ofNextNew);
            this.link();
        }

        public void allocate(int cb) {
            assert (this.isFree());
            this.split(cb);
            this.unlink();
            this.setType(2);
            assert (this.isEntry());
            assert (this.length() >= cb);
        }

        public void free() {
            assert (this.isEntry());
            this.unlink();
            this.setType(1);
            this.link();
            if (BinaryMap.this.isStrict()) {
                this.clear();
            }
            this.merge();
            this.close();
        }
    }

    public static class Entry
    extends SimpleMapEntry {
        public Entry(Binary binKey, Binary binValue) {
            super(binKey, binValue);
        }
    }

    protected class ValuesCollection
    extends AbstractCollection {
        protected ValuesCollection() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private Iterator m_iter;
                {
                    this.m_iter = BinaryMap.this.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Object next() {
                    return BinaryMap.this.get(this.m_iter.next());
                }

                @Override
                public void remove() {
                    this.m_iter.remove();
                }
            };
        }

        @Override
        public int size() {
            return BinaryMap.this.size();
        }

        @Override
        public void clear() {
            BinaryMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] ao) {
            BinaryMap map = BinaryMap.this;
            return map.toArray(ao, new Converter(){

                @Override
                public Object convert(Object o) {
                    Block block = (Block)o;
                    return block.getValue();
                }
            });
        }
    }

    protected class KeySet
    extends AbstractSet {
        protected KeySet() {
        }

        @Override
        public Iterator iterator() {
            BinaryMap.this.rehashAll();
            return new Iterator(){
                private int m_cBuckets;
                private int m_iBucket;
                private Object[] m_aoKey;
                private int m_cKeys;
                private int m_iKey;
                private boolean m_fCanRemove;
                {
                    this.m_cBuckets = BinaryMap.this.getBucketCount();
                    this.m_iBucket = 0;
                    this.m_aoKey = new Object[16];
                    this.m_cKeys = 0;
                    this.m_iKey = 0;
                    this.m_fCanRemove = false;
                }

                @Override
                public boolean hasNext() {
                    if (this.m_iKey < this.m_cKeys) {
                        return true;
                    }
                    this.nextBucket();
                    return this.m_iKey < this.m_cKeys;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void nextBucket() {
                    BinaryMap binaryMap = BinaryMap.this;
                    synchronized (binaryMap) {
                        int cBuckets = this.m_cBuckets;
                        if (cBuckets != BinaryMap.this.getBucketCount()) {
                            if (KeySet.this.isEmpty()) {
                                return;
                            }
                            throw new ConcurrentModificationException(cBuckets + "!=" + BinaryMap.this.getBucketCount());
                        }
                        int iBucket = this.m_iBucket;
                        int ofBlock = -1;
                        while (iBucket < cBuckets && ofBlock == -1) {
                            ofBlock = BinaryMap.this.getBucketOffset(iBucket++);
                        }
                        this.m_iBucket = iBucket;
                        Object[] ao = this.m_aoKey;
                        int co = 0;
                        int coMax = ao.length;
                        while (ofBlock != -1) {
                            Block block = BinaryMap.this.openBlock(ofBlock);
                            if (co >= coMax) {
                                Object[] aoNew = new Object[coMax *= 2];
                                System.arraycopy(ao, 0, aoNew, 0, co);
                                ao = aoNew;
                                this.m_aoKey = aoNew;
                            }
                            ao[co++] = block.getKey();
                            ofBlock = block.getNextNodeOffset();
                            block.close();
                        }
                        this.m_cKeys = co;
                        this.m_iKey = 0;
                    }
                }

                public Object next() {
                    if (this.m_iKey >= this.m_cKeys) {
                        this.nextBucket();
                    }
                    if (this.m_iKey < this.m_cKeys) {
                        Object oKey = this.m_aoKey[this.m_iKey++];
                        this.m_fCanRemove = true;
                        return oKey;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    if (!this.m_fCanRemove) {
                        throw new IllegalStateException();
                    }
                    BinaryMap.this.remove(this.m_aoKey[this.m_iKey - 1]);
                    this.m_fCanRemove = false;
                }
            };
        }

        @Override
        public int size() {
            return BinaryMap.this.size();
        }

        @Override
        public boolean contains(Object oKey) {
            return BinaryMap.this.containsKey(oKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            BinaryMap map;
            BinaryMap binaryMap = map = BinaryMap.this;
            synchronized (binaryMap) {
                if (map.containsKey(o)) {
                    map.remove(o);
                    return true;
                }
                return false;
            }
        }

        @Override
        public void clear() {
            BinaryMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] ao) {
            BinaryMap map = BinaryMap.this;
            return map.toArray(ao, new Converter(){

                @Override
                public Object convert(Object o) {
                    Block block = (Block)o;
                    return block.getKey();
                }
            });
        }
    }

    public class EntrySet
    extends AbstractSet {
        @Override
        public Iterator iterator() {
            return new Iterator(){
                private Iterator m_iter;
                {
                    this.m_iter = BinaryMap.this.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Object next() {
                    Binary binKey = (Binary)this.m_iter.next();
                    Binary binValue = (Binary)BinaryMap.this.get(binKey);
                    return BinaryMap.this.instantiateEntry(binKey, binValue);
                }

                @Override
                public void remove() {
                    this.m_iter.remove();
                }
            };
        }

        @Override
        public int size() {
            return BinaryMap.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                BinaryMap map = BinaryMap.this;
                Map.Entry entry = (Map.Entry)o;
                Object oKey = entry.getKey();
                Object oValue = entry.getValue();
                if (oKey instanceof Binary && oValue instanceof Binary) {
                    BinaryMap binaryMap = map;
                    synchronized (binaryMap) {
                        return map.containsKey(oKey) && map.get(oKey).equals(oValue);
                    }
                }
            }
            return false;
        }

        @Override
        public void clear() {
            BinaryMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] ao) {
            BinaryMap map = BinaryMap.this;
            return map.toArray(ao, new Converter(){

                @Override
                public Object convert(Object o) {
                    Block block = (Block)o;
                    return BinaryMap.this.instantiateEntry(block.getKey(), block.getValue());
                }
            });
        }
    }
}

