/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.oracle.coherence.common.base.Disposable;
import com.tangosol.io.BinaryStore;
import com.tangosol.io.nio.BinaryMap;
import com.tangosol.io.nio.ByteBufferManager;
import com.tangosol.io.nio.MappedBufferManager;
import com.tangosol.util.Binary;
import com.tangosol.util.SimpleEnumerator;
import java.util.Collections;
import java.util.Iterator;

public class BinaryMapStore
implements BinaryStore,
BinaryStore.SizeAware,
Disposable {
    private volatile BinaryMap m_map;

    public BinaryMapStore(BinaryMap map) {
        this.m_map = map;
    }

    public BinaryMap getBinaryMap() {
        return this.m_map;
    }

    @Override
    public Binary load(Binary binKey) {
        return (Binary)this.m_map.get(binKey);
    }

    @Override
    public void store(Binary binKey, Binary binValue) {
        this.m_map.putAll(Collections.singletonMap(binKey, binValue));
    }

    @Override
    public void erase(Binary binKey) {
        this.m_map.keySet().remove(binKey);
    }

    @Override
    public void eraseAll() {
        this.m_map.clear();
    }

    public Iterator keys() {
        return new SimpleEnumerator<Object>(this.m_map.keySet().toArray());
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    @Override
    public void dispose() {
        BinaryMap map = this.m_map;
        this.m_map = null;
        if (map != null) {
            try {
                ByteBufferManager mgr = map.getBufferManager();
                if (mgr instanceof MappedBufferManager) {
                    ((MappedBufferManager)mgr).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        this.dispose();
    }
}

