/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.tangosol.io.AbstractReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;

public class ByteBufferReadBuffer
extends AbstractReadBuffer
implements ReadBuffer {
    private final ByteBuffer m_buf;

    public ByteBufferReadBuffer(ByteBuffer buf) {
        if (buf.order() != ByteOrder.BIG_ENDIAN) {
            buf = buf.slice();
            buf.order(ByteOrder.BIG_ENDIAN);
        } else if (buf.position() != 0) {
            buf = buf.slice();
        }
        this.m_buf = buf;
    }

    public ByteBuffer getByteBuffer() {
        return this.m_buf;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.toBinary().writeTo(out);
    }

    @Override
    public void writeTo(OutputStream out, int of, int cb) throws IOException {
        this.toBinary(of, cb).writeTo(out);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.toBinary().writeTo(out);
    }

    @Override
    public void writeTo(DataOutput out, int of, int cb) throws IOException {
        this.toBinary(of, cb).writeTo(out);
    }

    @Override
    public void writeTo(ByteBuffer buf) {
        this.toBinary().writeTo(buf);
    }

    @Override
    public void writeTo(ByteBuffer buf, int of, int cb) throws IOException {
        this.toBinary(of, cb).writeTo(buf);
    }

    @Override
    public int length() {
        return this.getByteBuffer().limit();
    }

    @Override
    public byte byteAt(int of) {
        return this.getByteBuffer().get(of);
    }

    @Override
    public void copyBytes(int ofBegin, int ofEnd, byte[] abDest, int ofDest) {
        ByteBuffer buf = this.getByteBuffer().duplicate();
        buf.position(ofBegin);
        buf.get(abDest, ofDest, ofEnd - ofBegin);
    }

    @Override
    public byte[] toByteArray(int of, int cb) {
        this.checkBounds(of, cb);
        if (cb == 0) {
            return NO_BYTES;
        }
        byte[] abNew = new byte[cb];
        ByteBuffer buf = this.getByteBuffer();
        if (buf.hasArray() && !buf.isReadOnly()) {
            System.arraycopy(buf.array(), buf.arrayOffset() + of, abNew, 0, cb);
        } else {
            buf = buf.duplicate();
            buf.position(of);
            buf.get(abNew, 0, cb);
        }
        return abNew;
    }

    @Override
    public Binary toBinary(int of, int cb) {
        ByteBuffer buf = this.getByteBuffer();
        if (buf.hasArray() && !buf.isReadOnly()) {
            this.checkBounds(of, cb);
            return new Binary(buf.array(), buf.arrayOffset() + of, cb);
        }
        BinaryWriteBuffer bwb = new BinaryWriteBuffer(cb, cb);
        bwb.write(0, this, of, cb);
        return bwb.toBinary();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.getByteBuffer().asReadOnlyBuffer();
    }

    @Override
    public ByteBuffer toByteBuffer(int of, int cb) {
        this.checkBounds(of, cb);
        ByteBuffer buffer = this.getByteBuffer().asReadOnlyBuffer();
        buffer.limit(of + cb).position(of);
        return buffer.slice();
    }

    @Override
    public Object clone() {
        ByteBuffer buf = this.getByteBuffer();
        int cb = buf.capacity();
        ByteBuffer bufDup = (ByteBuffer)buf.duplicate().limit(cb).rewind();
        ByteBuffer bufClone = (ByteBuffer)(buf.isDirect() ? ByteBuffer.allocateDirect(cb) : ByteBuffer.allocate(cb)).put(bufDup).limit(buf.limit()).position(buf.position());
        return new ByteBufferReadBuffer(buf.isReadOnly() ? bufClone.asReadOnlyBuffer() : bufClone);
    }

    @Override
    protected ReadBuffer instantiateReadBuffer(int of, int cb) {
        ByteBuffer buf = this.getByteBuffer().duplicate();
        buf.position(of);
        buf.limit(of + cb);
        return new ByteBufferReadBuffer(buf);
    }

    @Override
    protected ReadBuffer.BufferInput instantiateBufferInput() {
        ByteBuffer buf = this.getByteBuffer().duplicate();
        buf.rewind();
        buf.order(ByteOrder.BIG_ENDIAN);
        return new ByteBufferInput(buf);
    }

    public final class ByteBufferInput
    extends AbstractReadBuffer.AbstractBufferInput
    implements ReadBuffer.BufferInput {
        protected ByteBuffer m_buf;

        public ByteBufferInput(ByteBuffer buf) {
            this.m_buf = buf;
        }

        public ByteBuffer getByteBuffer() {
            return this.m_buf;
        }

        @Override
        public int read() throws IOException {
            ByteBuffer buf = this.getByteBuffer();
            return buf.hasRemaining() ? buf.get() & 0xFF : -1;
        }

        @Override
        public int read(byte[] abDest, int ofDest, int cbDest) throws IOException {
            if (abDest == null || ofDest < 0 || cbDest < 0 || ofDest + cbDest > abDest.length) {
                if (abDest == null) {
                    throw new IllegalArgumentException("null byte array");
                }
                throw new IllegalArgumentException("abDest.length=" + abDest.length + ", ofDest=" + ofDest + ", cbDest=" + cbDest);
            }
            ByteBuffer buf = this.getByteBuffer();
            int cbMaxSrc = buf.remaining();
            if (cbDest > cbMaxSrc) {
                if (cbMaxSrc == 0) {
                    return -1;
                }
                cbDest = cbMaxSrc;
            }
            buf.get(abDest, ofDest, cbDest);
            return cbDest;
        }

        @Override
        public void mark(int cbReadLimit) {
            this.getByteBuffer().mark();
            super.mark(cbReadLimit);
        }

        @Override
        public void reset() throws IOException {
            try {
                this.getByteBuffer().reset();
            }
            catch (InvalidMarkException e) {
                throw new IOException("not marked");
            }
        }

        @Override
        public int available() throws IOException {
            return this.getByteBuffer().remaining();
        }

        @Override
        public int skipBytes(int cb) throws IOException {
            ByteBuffer buf = this.getByteBuffer();
            int cbSkip = Math.min(cb, buf.remaining());
            this.adjustOffsetInternal(cbSkip);
            return cbSkip;
        }

        @Override
        public byte readByte() throws IOException {
            try {
                return this.getByteBuffer().get();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        @Override
        public short readShort() throws IOException {
            try {
                return this.getByteBuffer().getShort();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        @Override
        public int readUnsignedShort() throws IOException {
            try {
                return this.getByteBuffer().getShort() & 0xFFFF;
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        @Override
        public char readChar() throws IOException {
            try {
                return this.getByteBuffer().getChar();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        @Override
        public int readInt() throws IOException {
            try {
                return this.getByteBuffer().getInt();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        @Override
        public long readLong() throws IOException {
            try {
                return this.getByteBuffer().getLong();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        @Override
        public float readFloat() throws IOException {
            try {
                return this.getByteBuffer().getFloat();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        @Override
        public double readDouble() throws IOException {
            try {
                return this.getByteBuffer().getDouble();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
        }

        @Override
        public int getOffset() {
            return this.getByteBuffer().position();
        }

        @Override
        public void setOffsetInternal(int of) {
            this.getByteBuffer().position(of);
        }

        @Override
        protected void adjustOffsetInternal(int cb) {
            ByteBuffer buf = this.getByteBuffer();
            buf.position(buf.position() + cb);
        }

        @Override
        protected String convertUTF(int of, int cb) throws IOException {
            byte[] ab;
            ByteBuffer buf = this.getByteBuffer();
            if (buf.hasArray() && !buf.isReadOnly()) {
                ab = buf.array();
                of += buf.arrayOffset();
            } else {
                ab = ByteBufferReadBuffer.this.toByteArray(of, cb);
                of = 0;
            }
            return ExternalizableHelper.convertUTF(ab, of, cb, this.getCharBuf(cb));
        }
    }
}

