/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class InetSocketAddressSerializer
implements PofSerializer<InetSocketAddress> {
    @Override
    public void serialize(PofWriter out, InetSocketAddress addr) throws IOException {
        out.writeByteArray(0, addr.getAddress().getAddress());
        out.writeInt(1, addr.getPort());
        out.writeRemainder(null);
    }

    @Override
    public InetSocketAddress deserialize(PofReader in) throws IOException {
        byte[] abAddr = in.readByteArray(0);
        int nPort = in.readInt(1);
        in.readRemainder();
        return new InetSocketAddress(InetAddress.getByAddress(abAddr), nPort);
    }
}

