/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.util.OptionalDouble;

public class OptionalDoubleSerializer
implements PofSerializer<OptionalDouble> {
    @Override
    public void serialize(PofWriter out, OptionalDouble value) throws IOException {
        boolean fPresent = value.isPresent();
        out.writeBoolean(0, fPresent);
        if (fPresent) {
            out.writeDouble(1, value.getAsDouble());
        }
        out.writeRemainder(null);
    }

    @Override
    public OptionalDouble deserialize(PofReader in) throws IOException {
        boolean fPresent = in.readBoolean(0);
        OptionalDouble value = fPresent ? OptionalDouble.of(in.readInt(1)) : OptionalDouble.empty();
        in.readRemainder();
        return value;
    }
}

