/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect.internal;

import com.tangosol.io.pof.annotation.Portable;
import com.tangosol.io.pof.annotation.PortableProperty;
import com.tangosol.io.pof.reflect.Codec;
import com.tangosol.io.pof.reflect.Codecs;
import com.tangosol.io.pof.reflect.internal.ClassMetadataBuilder;
import com.tangosol.io.pof.reflect.internal.InvocationStrategies;
import com.tangosol.io.pof.reflect.internal.NameManglers;
import com.tangosol.io.pof.reflect.internal.Visitor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;

public class AnnotationVisitor<T>
implements Visitor<ClassMetadataBuilder<T>> {
    private final boolean m_fAutoIndex;

    public AnnotationVisitor() {
        this(false);
    }

    public AnnotationVisitor(boolean fAutoIndex) {
        this.m_fAutoIndex = fAutoIndex;
    }

    @Override
    public <C> void visit(ClassMetadataBuilder<T> builder, Class<C> clz) {
        Portable portable = clz.getAnnotation(Portable.class);
        if (portable == null) {
            return;
        }
        boolean fAutoIndex = this.m_fAutoIndex;
        builder.setClass(clz);
        Field[] aFields = clz.getDeclaredFields();
        HashSet<String> listFieldsExcluded = new HashSet<String>(aFields.length);
        for (int i = 0; i < aFields.length; ++i) {
            Field field = aFields[i];
            PortableProperty attribute = field.getAnnotation(PortableProperty.class);
            if (attribute == null) continue;
            String sFieldName = field.getName();
            Class<?> clzField = field.getType();
            String sMangledName = NameManglers.FIELD_MANGLER.mangle(sFieldName);
            Codec codec = Codecs.getCodec(attribute.codec());
            if (!fAutoIndex && attribute.value() < 0) {
                throw new IllegalArgumentException("A POF Index must be specified for the property " + clz.getName() + "#" + sFieldName + " by specifying within the annotation or enabling autoIndexing on the Portable annotation");
            }
            builder.addAttribute(builder.newAttribute().setName(sMangledName).setCodec(codec).setInvocationStrategy(new InvocationStrategies.FieldInvocationStrategy(field)).setIndex(attribute.value()).build());
            listFieldsExcluded.add(sMangledName);
        }
        Method[] aMethods = clz.getDeclaredMethods();
        for (int i = 0; i < aMethods.length; ++i) {
            String sName;
            String sMethodName;
            Method method = aMethods[i];
            PortableProperty attribute = method.getAnnotation(PortableProperty.class);
            if (attribute == null || !(sMethodName = method.getName()).startsWith("get") && !sMethodName.startsWith("set") && !sMethodName.startsWith("is") || listFieldsExcluded.contains(sName = NameManglers.METHOD_MANGLER.mangle(sMethodName))) continue;
            InvocationStrategies.MethodInvocationStrategy strategy = new InvocationStrategies.MethodInvocationStrategy(method);
            Codec codec = Codecs.getCodec(attribute.codec());
            if (!fAutoIndex && attribute.value() < 0) {
                throw new IllegalArgumentException("A POF Index must be specified for the method " + clz.getName() + "#" + sMethodName + " by specifying within the annotation or enabling autoIndexing on the Portable annotation");
            }
            builder.addAttribute(builder.newAttribute().setName(sName).setCodec(codec).setInvocationStrategy(strategy).setIndex(attribute.value()).build());
            listFieldsExcluded.add(sName);
        }
    }
}

