/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.util.Options;
import com.tangosol.internal.util.processor.CacheProcessors;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.aggregator.Count;
import com.tangosol.util.comparator.EntryComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.function.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntSupplier;

public interface AsyncNamedCache<K, V> {
    public static final Consumer<Object> ANY = any -> {};

    public NamedCache<K, V> getNamedCache();

    default public CompletableFuture<V> get(K key) {
        return this.invoke(key, CacheProcessors.get());
    }

    default public CompletableFuture<Map<K, V>> getAll(Collection<? extends K> colKeys) {
        return this.invokeAll(colKeys, CacheProcessors.get());
    }

    default public CompletableFuture<Map<K, V>> getAll(Filter filter) {
        return this.invokeAll(filter, CacheProcessors.get());
    }

    default public CompletableFuture<Void> getAll(Collection<? extends K> colKeys, BiConsumer<? super K, ? super V> callback) {
        return this.invokeAll(colKeys, CacheProcessors.get(), (? super Map.Entry<? extends K, ? extends R> entry) -> callback.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    default public CompletableFuture<Void> getAll(Collection<? extends K> colKeys, Consumer<? super Map.Entry<? extends K, ? extends V>> callback) {
        return this.invokeAll(colKeys, CacheProcessors.get(), callback);
    }

    default public CompletableFuture<Void> put(K key, V value) {
        return this.put(key, value, 0L);
    }

    default public CompletableFuture<Void> put(K key, V value, long cMillis) {
        return this.invoke(key, CacheProcessors.put(value, cMillis));
    }

    default public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> map) {
        return this.invokeAll(map.keySet(), CacheProcessors.putAll(map)).thenAccept(nil -> {});
    }

    default public CompletableFuture<V> remove(K key) {
        return this.invoke(key, CacheProcessors.remove());
    }

    default public CompletableFuture<Void> removeAll(Collection<? extends K> colKeys) {
        return this.invokeAll(colKeys, CacheProcessors.removeBlind()).thenAccept(ANY);
    }

    default public CompletableFuture<Void> removeAll(Filter filter) {
        return this.invokeAll(filter, CacheProcessors.removeBlind()).thenAccept(ANY);
    }

    default public CompletableFuture<Set<K>> keySet() {
        return this.keySet(AlwaysFilter.INSTANCE);
    }

    default public CompletableFuture<Set<K>> keySet(Filter filter) {
        return this.invokeAll(filter, CacheProcessors.nop()).thenApply(Map::keySet);
    }

    default public CompletableFuture<Void> keySet(Consumer<? super K> callback) {
        return this.keySet(AlwaysFilter.INSTANCE, callback);
    }

    default public CompletableFuture<Void> keySet(Filter filter, Consumer<? super K> callback) {
        return this.invokeAll(filter, CacheProcessors.nop(), (? super Map.Entry<? extends K, ? extends R> entry) -> callback.accept((Object)entry.getKey()));
    }

    default public CompletableFuture<Set<Map.Entry<K, V>>> entrySet() {
        return this.entrySet(AlwaysFilter.INSTANCE);
    }

    default public CompletableFuture<Set<Map.Entry<K, V>>> entrySet(Filter filter) {
        return this.invokeAll(filter, CacheProcessors.get()).thenApply(Map::entrySet);
    }

    default public CompletableFuture<Set<Map.Entry<K, V>>> entrySet(Filter filter, Comparator comparator) {
        return this.invokeAll(filter, CacheProcessors.get()).thenApply(mapResult -> {
            int cEntries = mapResult.size();
            Object[] aEntries = mapResult.entrySet().toArray(new Map.Entry[cEntries]);
            Arrays.sort(aEntries, new EntryComparator(comparator == null ? SafeComparator.INSTANCE : comparator));
            return new ImmutableArrayList(aEntries, 0, cEntries).getSet();
        });
    }

    default public CompletableFuture<Void> entrySet(BiConsumer<? super K, ? super V> callback) {
        return this.entrySet((Filter)AlwaysFilter.INSTANCE, callback);
    }

    default public CompletableFuture<Void> entrySet(Consumer<? super Map.Entry<? extends K, ? extends V>> callback) {
        return this.entrySet((Filter)AlwaysFilter.INSTANCE, callback);
    }

    default public CompletableFuture<Void> entrySet(Filter filter, BiConsumer<? super K, ? super V> callback) {
        return this.invokeAll(filter, CacheProcessors.get(), (? super Map.Entry<? extends K, ? extends R> entry) -> callback.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    default public CompletableFuture<Void> entrySet(Filter filter, Consumer<? super Map.Entry<? extends K, ? extends V>> callback) {
        return this.invokeAll(filter, CacheProcessors.get(), callback);
    }

    default public CompletableFuture<Collection<V>> values() {
        return this.values(AlwaysFilter.INSTANCE);
    }

    default public CompletableFuture<Collection<V>> values(Filter filter) {
        return this.invokeAll(filter, CacheProcessors.get()).thenApply(Map::values);
    }

    default public CompletableFuture<Collection<V>> values(Filter filter, Comparator<? super V> comparator) {
        return this.values(filter).thenApply(colValues -> {
            ArrayList values = new ArrayList(colValues);
            values.sort(comparator);
            return values;
        });
    }

    default public CompletableFuture<Void> values(Consumer<? super V> callback) {
        return this.values((Filter)AlwaysFilter.INSTANCE, callback);
    }

    default public CompletableFuture<Void> values(Filter filter, Consumer<? super V> callback) {
        return this.invokeAll(filter, CacheProcessors.get(), (? super Map.Entry<? extends K, ? extends R> entry) -> callback.accept((Object)entry.getValue()));
    }

    public <R> CompletableFuture<R> invoke(K var1, InvocableMap.EntryProcessor<K, V, R> var2);

    default public <R> CompletableFuture<Map<K, R>> invokeAll(InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.invokeAll(AlwaysFilter.INSTANCE, processor);
    }

    public <R> CompletableFuture<Map<K, R>> invokeAll(Collection<? extends K> var1, InvocableMap.EntryProcessor<K, V, R> var2);

    public <R> CompletableFuture<Map<K, R>> invokeAll(Filter var1, InvocableMap.EntryProcessor<K, V, R> var2);

    default public <R> CompletableFuture<Void> invokeAll(InvocableMap.EntryProcessor<K, V, R> processor, Consumer<? super Map.Entry<? extends K, ? extends R>> callback) {
        return this.invokeAll((Filter)AlwaysFilter.INSTANCE, processor, callback);
    }

    default public <R> CompletableFuture<Void> invokeAll(InvocableMap.EntryProcessor<K, V, R> processor, BiConsumer<? super K, ? super R> callback) {
        return this.invokeAll((Filter)AlwaysFilter.INSTANCE, processor, (? super Map.Entry<? extends K, ? extends R> entry) -> callback.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    public <R> CompletableFuture<Void> invokeAll(Collection<? extends K> var1, InvocableMap.EntryProcessor<K, V, R> var2, Consumer<? super Map.Entry<? extends K, ? extends R>> var3);

    default public <R> CompletableFuture<Void> invokeAll(Collection<? extends K> collKeys, InvocableMap.EntryProcessor<K, V, R> processor, BiConsumer<? super K, ? super R> callback) {
        return this.invokeAll(collKeys, processor, (? super Map.Entry<? extends K, ? extends R> entry) -> callback.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    public <R> CompletableFuture<Void> invokeAll(Filter var1, InvocableMap.EntryProcessor<K, V, R> var2, Consumer<? super Map.Entry<? extends K, ? extends R>> var3);

    default public <R> CompletableFuture<Void> invokeAll(Filter filter, InvocableMap.EntryProcessor<K, V, R> processor, BiConsumer<? super K, ? super R> callback) {
        return this.invokeAll(filter, processor, (? super Map.Entry<? extends K, ? extends R> entry) -> callback.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    default public <R> CompletableFuture<R> aggregate(InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        return this.aggregate(AlwaysFilter.INSTANCE, aggregator);
    }

    public <R> CompletableFuture<R> aggregate(Collection<? extends K> var1, InvocableMap.EntryAggregator<? super K, ? super V, R> var2);

    public <R> CompletableFuture<R> aggregate(Filter var1, InvocableMap.EntryAggregator<? super K, ? super V, R> var2);

    default public CompletableFuture<Integer> size() {
        return this.aggregate(new Count());
    }

    default public CompletableFuture<Boolean> isEmpty() {
        return this.size().thenApply(size -> size == 0);
    }

    default public CompletableFuture<Void> clear() {
        return this.removeAll(AlwaysFilter.INSTANCE);
    }

    default public CompletableFuture<Boolean> containsKey(K key) {
        return this.invoke(key, InvocableMap.Entry::isPresent);
    }

    default public CompletableFuture<V> getOrDefault(K key, V valueDefault) {
        return this.invoke(key, entry -> {
            if (entry.isPresent()) {
                return new Object[]{true, entry.getValue()};
            }
            return new Object[]{false};
        }).thenApply(aoResult -> {
            if (Boolean.TRUE.equals(aoResult[0])) {
                return aoResult[1];
            }
            return valueDefault;
        });
    }

    default public CompletableFuture<V> putIfAbsent(K key, V value) {
        return this.invoke(key, CacheProcessors.putIfAbsent(value));
    }

    default public CompletableFuture<Boolean> remove(K key, V value) {
        return this.invoke(key, CacheProcessors.remove(value));
    }

    default public CompletableFuture<V> replace(K key, V value) {
        return this.invoke(key, CacheProcessors.replace(value));
    }

    default public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.invoke(key, CacheProcessors.replace(oldValue, newValue));
    }

    default public CompletableFuture<V> computeIfAbsent(K key, Remote.Function<? super K, ? extends V> mappingFunction) {
        return this.invoke(key, CacheProcessors.computeIfAbsent(mappingFunction));
    }

    default public CompletableFuture<V> computeIfPresent(K key, Remote.BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.invoke(key, CacheProcessors.computeIfPresent(remappingFunction));
    }

    default public CompletableFuture<V> compute(K key, Remote.BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.invoke(key, CacheProcessors.compute(remappingFunction));
    }

    default public CompletableFuture<V> merge(K key, V value, Remote.BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.invoke(key, CacheProcessors.merge(value, remappingFunction));
    }

    default public CompletableFuture<Map<K, Void>> replaceAll(Remote.BiFunction<? super K, ? super V, ? extends V> function) {
        return this.replaceAll(AlwaysFilter.INSTANCE, function);
    }

    default public CompletableFuture<Map<K, Void>> replaceAll(Collection<? extends K> collKeys, Remote.BiFunction<? super K, ? super V, ? extends V> function) {
        return this.invokeAll(collKeys, CacheProcessors.replace(function));
    }

    default public CompletableFuture<Map<K, Void>> replaceAll(Filter filter, Remote.BiFunction<? super K, ? super V, ? extends V> function) {
        return this.invokeAll(filter, CacheProcessors.replace(function));
    }

    public static class OrderBy
    implements Option {
        protected static final Random RANDOM = new Random();
        protected static final OrderBy THREAD = new OrderBy(() -> Thread.currentThread().hashCode());
        protected static final OrderBy NONE = new OrderBy(RANDOM::nextInt);
        protected final IntSupplier m_supplierOrderId;

        protected OrderBy(IntSupplier supplierOrderId) {
            this.m_supplierOrderId = supplierOrderId;
        }

        public int getOrderId() {
            return this.m_supplierOrderId.getAsInt();
        }

        @Options.Default
        public static OrderBy thread() {
            return THREAD;
        }

        public static OrderBy none() {
            return NONE;
        }

        public static OrderBy id(int nOrderId) {
            return new OrderBy(() -> nOrderId);
        }

        public static OrderBy custom(IntSupplier supplierOrderId) {
            return new OrderBy(supplierOrderId);
        }
    }

    public static interface Option {
    }
}

