/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Lockable;
import com.tangosol.net.CacheFactoryBuilder;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.TransactionMap;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;

public abstract class CacheFactory
extends Base {
    public static final String PRODUCT;
    public static final String VERSION;
    private static final String COHERENCE = "com.tangosol.coherence.component.application.console.Coherence";
    private static CacheFactoryBuilder s_builder;
    private static ConfigurableCacheFactory s_factory;
    private static final Method METHOD_GETSAFECLUSTER;
    private static final Method METHOD_SHUTDOWN;
    private static final Method METHOD_GETLOCALTX;
    private static final Method METHOD_TRACE;
    private static final Method METHOD_ISTRACEENABLED;
    private static final Method METHOD_GETSERVICECONFIG;
    private static final Method METHOD_SETSERVICECONFIG;
    private static final Method METHOD_MAIN;
    private static final Method METHOD_RESOLVEEDITION;
    private static final Throwable INIT_FAILURE;

    public static CacheFactoryBuilder getCacheFactoryBuilder() {
        return System.getSecurityManager() == null ? CacheFactory.getCacheFactoryBuilderInternal() : AccessController.doPrivileged(CacheFactory::getCacheFactoryBuilderInternal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CacheFactoryBuilder getCacheFactoryBuilderInternal() {
        CacheFactoryBuilder cfb = s_builder;
        if (cfb != null) return cfb;
        Class<CacheFactory> clazz = CacheFactory.class;
        synchronized (CacheFactory.class) {
            cfb = s_builder;
            if (cfb != null) return cfb;
            XmlElement xml = CacheFactory.getCacheFactoryBuilderConfig();
            String sClass = xml.getSafeElement("class-name").getString("com.tangosol.net.DefaultCacheFactoryBuilder");
            try {
                Class<?> clz = Class.forName(sClass);
                Object[] aoParam = XmlHelper.parseInitParams(xml.getSafeElement("init-params"));
                cfb = (CacheFactoryBuilder)ClassHelper.newInstance(clz, aoParam);
            }
            catch (Exception e) {
                throw CacheFactory.ensureRuntimeException(e, "Failed to load the CacheFactoryBuilder");
            }
            CacheFactory.setCacheFactoryBuilder(cfb);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cfb;
        }
    }

    public static synchronized void setCacheFactoryBuilder(CacheFactoryBuilder cfb) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new LocalPermission("CacheFactory.setCacheFactoryBuilder"));
        }
        s_builder = cfb;
        CacheFactory.checkConsistentCCFUsage();
    }

    public static ConfigurableCacheFactory getConfigurableCacheFactory() {
        return CacheFactory.getConfigurableCacheFactory(CacheFactory.getContextClassLoader());
    }

    public static ConfigurableCacheFactory getConfigurableCacheFactory(ClassLoader loader) {
        return s_factory == null ? CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(loader) : s_factory;
    }

    public static synchronized void setConfigurableCacheFactory(ConfigurableCacheFactory factory) {
        s_factory = factory;
        CacheFactory.checkConsistentCCFUsage();
    }

    public static Service getService(String sName) {
        return CacheFactory.getConfigurableCacheFactory().ensureService(sName);
    }

    public static <K, V> NamedCache<K, V> getCache(String sName) {
        return CacheFactory.getCache(sName, (ClassLoader)null, null);
    }

    public static <K, V> NamedCache<K, V> getCache(String sName, NamedCache.Option ... options) {
        return CacheFactory.getCache(sName, null, options);
    }

    public static <K, V> NamedCache<K, V> getCache(String sName, ClassLoader loader) {
        return CacheFactory.getConfigurableCacheFactory(CacheFactory.ensureClassLoader(loader)).ensureCache(sName, loader, null);
    }

    public static <K, V> NamedCache<K, V> getCache(String sName, ClassLoader loader, NamedCache.Option ... options) {
        return CacheFactory.getConfigurableCacheFactory(CacheFactory.ensureClassLoader(loader)).ensureCache(sName, loader, options);
    }

    public static <K, V> NamedCache<K, V> getTypedCache(String sCacheName, TypeAssertion<K, V> assertion) {
        return CacheFactory.getCache(sCacheName, (ClassLoader)null, assertion);
    }

    public static <K, V> NamedCache<K, V> getTypedCache(String sCacheName, ClassLoader loader, TypeAssertion<K, V> assertion) {
        return CacheFactory.getCache(sCacheName, loader, assertion);
    }

    public static TransactionMap getLocalTransaction(NamedCache map) {
        if (map == null) {
            throw new IllegalArgumentException("NamedCache must be specified");
        }
        if (INIT_FAILURE != null) {
            throw CacheFactory.ensureRuntimeException(INIT_FAILURE);
        }
        try {
            return (TransactionMap)METHOD_GETLOCALTX.invoke(null, map);
        }
        catch (Exception e) {
            throw CacheFactory.ensureRuntimeException(e);
        }
    }

    public static boolean commitTransactionCollection(Collection collCaches, int cRetry) {
        TransactionMap cacheTx;
        int iCache;
        if (cRetry < 0 || cRetry > 100) {
            throw new IllegalArgumentException("illegal retry count: " + cRetry);
        }
        int cTry = 1 + cRetry;
        List listCaches = collCaches instanceof List ? (List)collCaches : new ImmutableArrayList(collCaches);
        int cCaches = listCaches.size();
        for (iCache = 0; iCache < cCaches; ++iCache) {
            cacheTx = (TransactionMap)listCaches.get(iCache);
            boolean fPrepared = false;
            for (int iTry = 0; iTry < cTry; ++iTry) {
                try {
                    cacheTx.prepare();
                    fPrepared = true;
                    break;
                }
                catch (ConcurrentModificationException e) {
                    if (iTry < cRetry) {
                        try {
                            Blocking.sleep(1 + CacheFactory.getRandom().nextInt(5));
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    CacheFactory.log("Unable to prepare transaction:\n" + CacheFactory.getStackTrace(e), 4);
                    continue;
                }
                catch (RuntimeException e) {
                    break;
                }
                catch (Error e) {
                    CacheFactory.log("Error during prepare (tx will rollback):\n" + CacheFactory.getStackTrace(e), 1);
                    break;
                }
            }
            if (fPrepared) continue;
            CacheFactory.rollbackTransactionCollection(collCaches);
            return false;
        }
        for (iCache = 0; iCache < cCaches; ++iCache) {
            cacheTx = (TransactionMap)listCaches.get(iCache);
            try {
                cacheTx.commit();
                continue;
            }
            catch (Throwable e) {
                String sCategory;
                String string = sCategory = e instanceof Error ? "Error" : "Exception";
                if (iCache == 0) {
                    CacheFactory.log(sCategory + " during commit (tx will rollback):\n" + CacheFactory.getStackTrace(e), 1);
                    CacheFactory.rollbackTransactionCollection(collCaches);
                    return false;
                }
                CacheFactory.log(sCategory + " during commit (tx will continue, but tx outcome is nondeterministic):\n" + CacheFactory.getStackTrace(e), 1);
            }
        }
        return true;
    }

    public static void rollbackTransactionCollection(Collection collCaches) {
        for (TransactionMap cacheTx : collCaches) {
            try {
                cacheTx.rollback();
            }
            catch (Throwable e) {
                CacheFactory.log((e instanceof Error ? "Error" : "Exception") + " during rollback (ignored):\n" + CacheFactory.getStackTrace(e), 1);
            }
        }
    }

    public static Cluster getCluster() {
        if (INIT_FAILURE != null) {
            throw CacheFactory.ensureRuntimeException(INIT_FAILURE);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Cluster>(){

                @Override
                public Cluster run() throws Exception {
                    return (Cluster)METHOD_GETSAFECLUSTER.invoke(null, ClassHelper.VOID);
                }
            });
        }
        catch (Exception e) {
            throw CacheFactory.ensureRuntimeException(e);
        }
    }

    public static Cluster ensureCluster() {
        Cluster cluster = CacheFactory.getCluster();
        try (Lockable.Unlockable unlockable = ((Lockable)((Object)cluster)).exclusively();){
            if (!cluster.isRunning()) {
                cluster.start();
            }
            Cluster cluster2 = cluster;
            return cluster2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void shutdown() {
        try {
            METHOD_SHUTDOWN.invoke(null, ClassHelper.VOID);
        }
        catch (Exception e) {
            try {
                throw CacheFactory.ensureRuntimeException(e);
            }
            catch (Throwable throwable) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            CacheFactory.setCacheFactoryBuilder(null);
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CacheFactory.setConfigurableCacheFactory(null);
                throw throwable;
            }
        }
        try {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CacheFactory.setConfigurableCacheFactory(null);
    }

    public static void releaseCache(NamedCache cache) {
        CacheFactory.getConfigurableCacheFactory(CacheFactory.getContextClassLoader()).releaseCache(cache);
    }

    public static void destroyCache(NamedCache cache) {
        CacheFactory.getConfigurableCacheFactory(CacheFactory.getContextClassLoader()).destroyCache(cache);
    }

    public static String getEdition() {
        XmlElement xmlLicense = CacheFactory.getServiceConfig("$License");
        try {
            METHOD_RESOLVEEDITION.invoke(null, xmlLicense);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmlLicense.getSafeElement("edition-name").getString();
    }

    private static void checkConsistentCCFUsage() {
        if (s_factory != null && s_builder != null) {
            CacheFactory.log("Mixed usage of getCacheFactoryBuilder() and setConfigurableCacheFactory() is not recommended.", 2);
        }
    }

    public static void log(String sMessage, int nSeverity) {
        try {
            METHOD_TRACE.invoke(null, sMessage, nSeverity);
        }
        catch (Throwable e) {
            if (nSeverity > 0) {
                System.err.println(sMessage);
            }
            System.out.println(sMessage);
        }
    }

    public static boolean isLogEnabled(int nSeverity) {
        try {
            return (Boolean)METHOD_ISTRACEENABLED.invoke(null, nSeverity);
        }
        catch (Throwable e) {
            return true;
        }
    }

    public static XmlElement getClusterConfig() {
        return CacheFactory.getServiceConfig("Cluster");
    }

    public static XmlElement getReplicatedCacheConfig() {
        return CacheFactory.getServiceConfig("ReplicatedCache");
    }

    public static XmlElement getDistributedCacheConfig() {
        return CacheFactory.getServiceConfig("DistributedCache");
    }

    public static XmlElement getLoggingConfig() {
        return CacheFactory.getServiceConfig("$Logger");
    }

    public static void setLoggingConfig(XmlElement xmlCfg) {
        CacheFactory.setServiceConfig("$Logger", xmlCfg);
    }

    public static XmlElement getCacheFactoryBuilderConfig() {
        return CacheFactory.getServiceConfig("$CacheFactoryBuilder");
    }

    public static void setCacheFactoryBuilderConfig(XmlElement xmlCfg) {
        CacheFactory.setServiceConfig("$CacheFactoryBuilder", xmlCfg);
    }

    public static XmlElement getConfigurableCacheFactoryConfig() {
        return CacheFactory.getServiceConfig("$CacheFactory");
    }

    public static void setConfigurableCacheFactoryConfig(XmlElement xmlCfg) {
        CacheFactory.setServiceConfig("$CacheFactory", xmlCfg);
    }

    public static XmlElement getSecurityConfig() {
        return CacheFactory.getServiceConfig("$Security");
    }

    public static void setSecurityConfig(XmlElement xmlCfg) {
        CacheFactory.setServiceConfig("$Security", xmlCfg);
    }

    public static XmlElement getManagementConfig() {
        return CacheFactory.getServiceConfig("$Management");
    }

    public static void setManagementConfig(XmlElement xmlCfg) {
        CacheFactory.setServiceConfig("$Management", xmlCfg);
    }

    public static XmlElement getServiceConfig(final String sServiceType) {
        if (INIT_FAILURE != null) {
            throw CacheFactory.ensureRuntimeException(INIT_FAILURE);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<XmlElement>(){

                @Override
                public XmlElement run() throws Exception {
                    return (XmlElement)METHOD_GETSERVICECONFIG.invoke(null, sServiceType);
                }
            });
        }
        catch (Exception e) {
            throw CacheFactory.ensureRuntimeException(e);
        }
    }

    public static void setServiceConfig(String sServiceType, XmlElement xmlCfg) {
        if (INIT_FAILURE != null) {
            throw CacheFactory.ensureRuntimeException(INIT_FAILURE);
        }
        try {
            METHOD_SETSERVICECONFIG.invoke(null, sServiceType, xmlCfg);
        }
        catch (Exception e) {
            throw CacheFactory.ensureRuntimeException(e);
        }
    }

    public static void main(String[] asArg) throws Exception {
        if (INIT_FAILURE != null) {
            throw CacheFactory.ensureRuntimeException(INIT_FAILURE);
        }
        METHOD_MAIN.invoke(null, new Object[]{asArg});
    }

    static {
        final EntryPoints ep = new EntryPoints();
        AccessController.doPrivileged(new PrivilegedAction<EntryPoints>(){

            @Override
            public EntryPoints run() {
                return ep.getEntryPoints();
            }
        });
        PRODUCT = ep.m_sProduct;
        VERSION = ep.m_sVersion;
        METHOD_GETSAFECLUSTER = ep.m_methGetSafeCluster;
        METHOD_SHUTDOWN = ep.m_methShutdown;
        METHOD_GETLOCALTX = ep.m_methGetLocalTransaction;
        METHOD_TRACE = ep.m_methTrace;
        METHOD_ISTRACEENABLED = ep.m_methIsTraceEnabled;
        METHOD_GETSERVICECONFIG = ep.m_methGetServiceConfig;
        METHOD_SETSERVICECONFIG = ep.m_methSetServiceConfig;
        METHOD_MAIN = ep.m_methMain;
        METHOD_RESOLVEEDITION = ep.m_methResolveEdition;
        INIT_FAILURE = ep.m_eInitFailure;
    }

    private static class EntryPoints {
        String m_sProduct;
        String m_sVersion;
        Method m_methGetSafeCluster;
        Method m_methShutdown;
        Method m_methGetLocalTransaction;
        Method m_methTrace;
        Method m_methIsTraceEnabled;
        Method m_methGetServiceConfig;
        Method m_methSetServiceConfig;
        Method m_methMain;
        Method m_methResolveEdition;
        Throwable m_eInitFailure;

        private EntryPoints() {
        }

        private EntryPoints getEntryPoints() {
            try {
                Class<?> clzLibrary = Class.forName(CacheFactory.COHERENCE);
                this.m_sProduct = (String)clzLibrary.getField("TITLE").get(null);
                this.m_sVersion = (String)clzLibrary.getField("VERSION").get(null);
                this.m_methGetSafeCluster = clzLibrary.getMethod("getSafeCluster", new Class[0]);
                this.m_methShutdown = clzLibrary.getMethod("shutdown", new Class[0]);
                this.m_methGetLocalTransaction = clzLibrary.getMethod("getLocalTransaction", NamedCache.class);
                this.m_methTrace = clzLibrary.getMethod("_trace", String.class, Integer.TYPE);
                this.m_methIsTraceEnabled = clzLibrary.getMethod("_isTraceEnabled", Integer.TYPE);
                this.m_methGetServiceConfig = clzLibrary.getMethod("getServiceConfig", String.class);
                this.m_methSetServiceConfig = clzLibrary.getMethod("setServiceConfig", String.class, XmlElement.class);
                this.m_methMain = clzLibrary.getMethod("main", String[].class);
                this.m_methResolveEdition = clzLibrary.getMethod("resolveEdition", XmlElement.class);
            }
            catch (Throwable e) {
                this.m_eInitFailure = e;
            }
            return this;
        }
    }
}

