/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.application.ContainerContext;
import com.tangosol.application.Context;
import com.tangosol.application.LifecycleListener;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.net.metrics.MetricsHttpHelper;
import com.tangosol.internal.net.service.LegacyXmlServiceHelper;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheFactoryBuilder;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceMonitor;
import com.tangosol.net.SimpleServiceMonitor;
import com.tangosol.net.security.DoAsAction;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.io.File;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;

public class DefaultCacheServer
extends Base {
    public static final long DEFAULT_WAIT_MILLIS = 5000L;
    private static DefaultCacheServer s_instance = null;
    private final Object m_lock = new Object();
    private final ConfigurableCacheFactory m_factory;
    protected volatile ServiceMonitor m_serviceMon;
    protected volatile boolean m_fShutdown;
    protected boolean m_fServicesStarted;
    protected Thread m_threadShutdown = DefaultCacheServer.makeThread(null, this::stopMonitoring, null);
    protected List<LifecycleListener> m_listLifecycleListener;

    public DefaultCacheServer(ConfigurableCacheFactory factory) {
        this.m_factory = factory;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.ensureLifecycleListeners().add(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.ensureLifecycleListeners().remove(listener);
    }

    public void startAndMonitor(long cWaitMillis) {
        AccessController.doPrivileged(() -> {
            this.initialStartServices(cWaitMillis);
            this.markServicesStarted();
            this.monitorServices(cWaitMillis);
            return null;
        });
    }

    public void startDaemon(long cWaitMillis) {
        while (true) {
            try {
                AccessController.doPrivileged(new DoAsAction<Object>(() -> {
                    this.initialStartServices(cWaitMillis);
                    return null;
                }));
                this.markServicesStarted();
            }
            catch (Exception e) {
                CacheFactory.log("Failed to start services: " + e, 1);
                Runtime.getRuntime().removeShutdownHook(this.m_threadShutdown);
                try {
                    Blocking.sleep(5000L);
                }
                catch (InterruptedException e2) {
                    break;
                }
            }
        }
    }

    public List<Service> startServices() {
        return new LinkedList<Service>(this.startServicesInternal().keySet());
    }

    public void shutdownServer() {
        List<LifecycleListener> listListener = this.ensureLifecycleListeners();
        LifecycleContext ctx = new LifecycleContext();
        for (LifecycleListener listener : listListener) {
            try {
                listener.preStop(ctx);
            }
            catch (Throwable e) {
                CacheFactory.err(e);
            }
        }
        this.stopServiceMonitor();
        CacheFactory.shutdown();
        this.notifyShutdown();
        for (LifecycleListener listener : listListener) {
            try {
                listener.postStop(ctx);
            }
            catch (Throwable e) {
                CacheFactory.err(e);
            }
        }
        Runtime.getRuntime().removeShutdownHook(this.m_threadShutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForServiceStart() {
        if (!this.m_fServicesStarted) {
            Object object = this.m_lock;
            synchronized (object) {
                while (!this.m_fServicesStarted && !this.m_fShutdown) {
                    try {
                        Blocking.wait(this.m_lock);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.m_fServicesStarted) {
                    throw new IllegalStateException("Services were not started");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markServicesStarted() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_fServicesStarted = true;
            this.m_lock.notifyAll();
        }
    }

    public static void shutdown() {
        DefaultCacheServer dcs = DefaultCacheServer.getInstance();
        if (dcs != null) {
            s_instance = null;
            dcs.shutdownServer();
        }
    }

    public static void startDaemon() {
        DefaultCacheServer.startServerDaemon();
    }

    public static DefaultCacheServer startServerDaemon() {
        DefaultCacheServer server = DefaultCacheServer.ensureInstance(DefaultCacheServer.getConfigurableCacheFactory());
        DefaultCacheServer.startDaemon(server);
        return server;
    }

    public static void main(String[] asArg) {
        long cWaitMillis = 5000L;
        File fileGar = null;
        String sAppName = null;
        String[] asTenant = null;
        for (int i = 0; i < asArg.length; ++i) {
            String sArg = asArg[i];
            if (sArg.endsWith(".xml")) {
                CacheFactory.getCacheFactoryBuilder().setCacheConfiguration(null, XmlHelper.loadFileOrResource(sArg, "cache configuration", null));
                continue;
            }
            if (Pattern.matches("[0-9]*", sArg)) {
                try {
                    cWaitMillis = 1000L * (long)Math.max(0, Integer.parseInt(sArg));
                }
                catch (Exception exception) {}
                continue;
            }
            if (sArg.endsWith(".gar") || sArg.contains(File.separator) || ".".equals(sArg)) {
                fileGar = new File(sArg);
                continue;
            }
            if (sArg.contains(",")) {
                asTenant = Base.parseDelimitedString(sArg, ',');
                continue;
            }
            sAppName = sArg;
        }
        DefaultCacheServer dcs = DefaultCacheServer.ensureInstance(DefaultCacheServer.getConfigurableCacheFactory());
        if (asTenant != null) {
            CacheFactory.log("Multi-tenancy is only supported for a GAR deployment", 2);
        }
        dcs.startAndMonitor(cWaitMillis);
    }

    public static List start() {
        return DefaultCacheServer.start(DefaultCacheServer.getConfigurableCacheFactory());
    }

    public static List start(ConfigurableCacheFactory factory) {
        return DefaultCacheServer.ensureInstance(factory).startServices();
    }

    protected boolean stopMonitoring() {
        this.stopServiceMonitor();
        return this.notifyShutdown();
    }

    protected void stopServiceMonitor() {
        ServiceMonitor monitor = this.m_serviceMon;
        if (monitor != null) {
            monitor.stopMonitoring();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyShutdown() {
        Object object = this.m_lock;
        synchronized (object) {
            boolean fWasStarted = this.m_fServicesStarted;
            this.m_fServicesStarted = false;
            this.m_fShutdown = true;
            this.m_lock.notifyAll();
            return fWasStarted;
        }
    }

    protected void initialStartServices(long cWaitMillis) {
        Runtime.getRuntime().addShutdownHook(this.m_threadShutdown);
        this.m_serviceMon = new SimpleServiceMonitor(cWaitMillis);
        List<LifecycleListener> listListener = this.ensureLifecycleListeners();
        LifecycleContext ctx = new LifecycleContext();
        for (LifecycleListener listener : listListener) {
            try {
                listener.preStart(ctx);
            }
            catch (Throwable e) {
                CacheFactory.err(e);
            }
        }
        Map<Service, String> mapServices = this.startServicesInternal();
        this.m_serviceMon.setConfigurableCacheFactory(this.m_factory);
        this.m_serviceMon.registerServices(mapServices);
        this.reportStarted();
        for (LifecycleListener listener : listListener) {
            try {
                listener.postStart(ctx);
            }
            catch (Throwable e) {
                CacheFactory.err(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LifecycleListener> ensureLifecycleListeners() {
        if (this.m_listLifecycleListener == null) {
            DefaultCacheServer defaultCacheServer = this;
            synchronized (defaultCacheServer) {
                CopyOnWriteArrayList<LifecycleListener> list = new CopyOnWriteArrayList<LifecycleListener>();
                ServiceLoader<LifecycleListener> loader = ServiceLoader.load(LifecycleListener.class);
                for (LifecycleListener listener : loader) {
                    list.add(listener);
                }
                this.m_listLifecycleListener = list;
            }
        }
        return this.m_listLifecycleListener;
    }

    protected void reportStarted() {
        CacheFactory.log(this.getServiceBanner(CacheFactory.getCluster()) + '\n' + "Started " + this.getClass().getSimpleName() + "...\n", 3);
    }

    protected Map<Service, String> startServicesInternal() {
        ConfigurableCacheFactory factory = this.m_factory;
        LinkedHashMap<Service, String> mapServices = null;
        if (factory instanceof DefaultConfigurableCacheFactory) {
            DefaultConfigurableCacheFactory dccf = (DefaultConfigurableCacheFactory)factory;
            mapServices = new LinkedHashMap();
            for (Object o : dccf.getConfig().getSafeElement("caching-schemes").getElementList()) {
                XmlElement xmlScheme = (XmlElement)o;
                if (!xmlScheme.getSafeElement("autostart").getBoolean()) continue;
                try {
                    Service service = dccf.ensureService(xmlScheme);
                    if (mapServices.containsKey(service)) continue;
                    mapServices.put(service, LegacyXmlServiceHelper.getServiceName(xmlScheme));
                }
                catch (RuntimeException e) {
                    this.handleEnsureServiceException(e);
                }
            }
        } else if (factory instanceof ExtensibleConfigurableCacheFactory) {
            ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)factory;
            try {
                eccf.activate();
                mapServices = eccf.getServiceMap();
            }
            catch (RuntimeException e) {
                this.handleEnsureServiceException(e);
            }
        } else {
            throw new IllegalStateException("StartServices not supported for factory " + factory);
        }
        try {
            if (MetricsHttpHelper.isHttpCapable()) {
                MetricsHttpHelper.ensureMetricsService(mapServices);
            }
        }
        catch (Exception e) {
            DefaultCacheServer.err(e);
        }
        return mapServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void monitorServices(long cWaitMillis) {
        do {
            Object object = this.m_lock;
            synchronized (object) {
                try {
                    Blocking.wait(this.m_lock, cWaitMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!this.isMonitorStopped());
        this.stopMonitoring();
    }

    protected void handleEnsureServiceException(RuntimeException e) {
        throw e;
    }

    protected String getServiceBanner(Cluster cluster) {
        try {
            cluster = (Cluster)ClassHelper.invoke(cluster, "getCluster", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\nServices\n  (\n  ");
        if (cluster != null) {
            Enumeration e = cluster.getServiceNames();
            while (e.hasMoreElements()) {
                Service service = cluster.getService((String)e.nextElement());
                if (service == null) continue;
                sb.append(service).append("\n  ");
            }
        }
        sb.append(")\n");
        return sb.toString();
    }

    public boolean isMonitorStopped() {
        return !this.m_serviceMon.isMonitoring();
    }

    protected static void startDaemon(DefaultCacheServer dcs) {
        Thread thread = DefaultCacheServer.makeThread(null, () -> dcs.startDaemon(5000L), "DefaultCacheServer");
        thread.setDaemon(true);
        thread.start();
    }

    protected static ConfigurableCacheFactory getConfigurableCacheFactory() {
        return CacheFactory.getConfigurableCacheFactory();
    }

    protected static synchronized DefaultCacheServer ensureInstance(ConfigurableCacheFactory factory) {
        DefaultCacheServer instance = s_instance;
        if (instance == null) {
            s_instance = instance = new DefaultCacheServer(factory);
        } else if (factory != instance.m_factory) {
            throw new IllegalArgumentException("The DefaultCacheServer has already been started with a different factory object");
        }
        return instance;
    }

    public static synchronized DefaultCacheServer getInstance() {
        DefaultCacheServer instance = s_instance;
        if (instance == null) {
            throw new IllegalStateException("The DefaultCacheServer has not been started");
        }
        return instance;
    }

    protected class LifecycleContext
    implements Context {
        protected LifecycleContext() {
        }

        @Override
        public ConfigurableCacheFactory getConfigurableCacheFactory() {
            return DefaultCacheServer.this.m_factory;
        }

        @Override
        public CacheFactoryBuilder getCacheFactoryBuilder() {
            return CacheFactory.getCacheFactoryBuilder();
        }

        @Override
        public ClassLoader getClassLoader() {
            if (DefaultCacheServer.this.m_factory instanceof ExtensibleConfigurableCacheFactory) {
                ((ExtensibleConfigurableCacheFactory)DefaultCacheServer.this.m_factory).getConfigClassLoader();
            }
            return DefaultCacheServer.this.m_factory.getClass().getClassLoader();
        }

        @Override
        public String getApplicationName() {
            return "DefaultCacheServer";
        }

        @Override
        public ServiceMonitor getServiceMonitor() {
            return DefaultCacheServer.this.m_serviceMon;
        }

        @Override
        public String getPofConfigURI() {
            return Config.getProperty("coherence.pof.config", "pof-config.xml");
        }

        @Override
        public String getCacheConfigURI() {
            return Config.getProperty("coherence.cacheconfig", "coherence-cache-config.xml");
        }

        @Override
        public ContainerContext getContainerContext() {
            return null;
        }

        @Override
        public Context.ExtendedContext getExtendedContext() {
            return null;
        }
    }
}

