/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.base.Lockable;
import com.tangosol.coherence.config.CacheConfig;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.SchemeMappingRegistry;
import com.tangosol.coherence.config.builder.InstanceBuilder;
import com.tangosol.coherence.config.builder.NamedEventInterceptorBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.Parameter;
import com.tangosol.io.AsyncBinaryStore;
import com.tangosol.io.AsyncBinaryStoreManager;
import com.tangosol.io.BinaryStore;
import com.tangosol.io.BinaryStoreManager;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.bdb.BerkeleyDBBinaryStoreManager;
import com.tangosol.io.nio.BinaryMap;
import com.tangosol.io.nio.BinaryMapStore;
import com.tangosol.io.nio.ByteBufferManager;
import com.tangosol.io.nio.MappedBufferManager;
import com.tangosol.io.nio.MappedStoreManager;
import com.tangosol.net.AbstractBackingMapManager;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.Service;
import com.tangosol.net.cache.AbstractBundler;
import com.tangosol.net.cache.BinaryEntryStore;
import com.tangosol.net.cache.BundlingNamedCache;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.MapCacheStore;
import com.tangosol.net.cache.NearCache;
import com.tangosol.net.cache.OverflowMap;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.net.cache.SerializationCache;
import com.tangosol.net.cache.SerializationMap;
import com.tangosol.net.cache.SerializationPagedCache;
import com.tangosol.net.cache.SimpleOverflowMap;
import com.tangosol.net.cache.SimpleSerializationMap;
import com.tangosol.net.cache.VersionedBackingMap;
import com.tangosol.net.cache.VersionedNearCache;
import com.tangosol.net.events.EventDispatcherRegistry;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.events.annotation.Interceptor;
import com.tangosol.net.events.internal.InterceptorManager;
import com.tangosol.net.events.internal.NamedEventInterceptor;
import com.tangosol.net.events.internal.Registry;
import com.tangosol.net.internal.ScopedCacheReferenceStore;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.partition.ObservableSplittingBackingCache;
import com.tangosol.net.partition.ObservableSplittingBackingMap;
import com.tangosol.net.partition.PartitionAwareBackingMap;
import com.tangosol.net.partition.ReadWriteSplittingBackingMap;
import com.tangosol.net.security.Security;
import com.tangosol.net.security.StorageAccessAuthorizer;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.SimpleValue;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapSet;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleResourceRegistry;
import java.io.File;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

@Deprecated
public class DefaultConfigurableCacheFactory
extends Base
implements ConfigurableCacheFactory {
    public static final String FILE_CFG_CACHE = "coherence-cache-config.xml";
    public static final String CACHE_NAME = "{cache-name}";
    public static final String CLASS_LOADER = "{class-loader}";
    public static final String MGR_CONTEXT = "{manager-context}";
    public static final String SCHEME_REF = "{scheme-ref}";
    public static final String CACHE_REF = "{cache-ref}";
    public static final int SCHEME_UNKNOWN = 0;
    public static final int SCHEME_REPLICATED = 1;
    public static final int SCHEME_OPTIMISTIC = 2;
    public static final int SCHEME_DISTRIBUTED = 3;
    public static final int SCHEME_NEAR = 4;
    public static final int SCHEME_VERSIONED_NEAR = 5;
    public static final int SCHEME_LOCAL = 6;
    public static final int SCHEME_OVERFLOW = 7;
    public static final int SCHEME_DISK = 8;
    public static final int SCHEME_EXTERNAL = 9;
    public static final int SCHEME_EXTERNAL_PAGED = 10;
    public static final int SCHEME_CLASS = 11;
    public static final int SCHEME_READ_WRITE_BACKING = 12;
    public static final int SCHEME_VERSIONED_BACKING = 13;
    public static final int SCHEME_INVOCATION = 14;
    public static final int SCHEME_PROXY = 15;
    public static final int SCHEME_REMOTE_CACHE = 16;
    public static final int SCHEME_REMOTE_INVOCATION = 17;
    public static final int SCHEME_TRANSACTIONAL = 18;
    public static final int SCHEME_FLASHJOURNAL = 19;
    public static final int SCHEME_RAMJOURNAL = 20;
    public static final int SCHEME_PAGED_TOPIC = 21;
    private XmlElement m_xmlConfig;
    private ClassLoader m_loader;
    protected ScopedCacheReferenceStore m_store = new ScopedCacheReferenceStore();
    private ThreadLocal m_tlo = new ThreadLocal();
    private String m_sScopeName;
    protected Set m_setManager = new MapSet(new WeakHashMap());
    protected ResourceRegistry m_registry;

    public DefaultConfigurableCacheFactory() {
        this(DefaultConfigurableCacheFactory.loadConfig(FILE_CFG_CACHE));
    }

    public DefaultConfigurableCacheFactory(String sPath) {
        this(DefaultConfigurableCacheFactory.loadConfig(sPath));
    }

    public DefaultConfigurableCacheFactory(String sPath, ClassLoader loader) {
        this(DefaultConfigurableCacheFactory.loadConfig(sPath, loader), loader);
    }

    public DefaultConfigurableCacheFactory(XmlElement xmlConfig) {
        this(xmlConfig, null);
    }

    public DefaultConfigurableCacheFactory(XmlElement xmlConfig, ClassLoader loader) {
        this.setConfigClassLoader(loader);
        this.setConfig(xmlConfig);
        CacheFactory.log("Created cache factory " + this.getClass().getName(), 3);
    }

    public XmlElement getConfig() {
        return (XmlElement)this.m_xmlConfig.clone();
    }

    protected XmlElement getConfigUnsafe() {
        return this.m_xmlConfig;
    }

    public void setConfig(XmlElement xmlConfig) {
        xmlConfig = (XmlElement)xmlConfig.clone();
        XmlHelper.replaceSystemProperties(xmlConfig, "system-property");
        String sScopeName = xmlConfig.getSafeElement("scope-name").getString();
        if (!sScopeName.isEmpty()) {
            this.m_sScopeName = sScopeName;
        }
        this.m_xmlConfig = xmlConfig;
        ResourceRegistry registry = this.m_registry;
        if (registry != null) {
            registry.dispose();
        }
        registry = this.m_registry = new SimpleResourceRegistry();
        Registry eventRegistry = new Registry();
        registry.registerResource(InterceptorRegistry.class, eventRegistry);
        registry.registerResource(EventDispatcherRegistry.class, eventRegistry);
        CacheConfig cacheConfig = new CacheConfig(new NullParameterResolver());
        cacheConfig.addCacheMappingRegistry(new SchemeMappingRegistry());
        InterceptorManager manager = new InterceptorManager(cacheConfig, this.getConfigClassLoader(), registry);
        registry.registerResource(InterceptorManager.class, manager);
        this.configureInterceptors(xmlConfig);
        this.m_store.clear();
    }

    @Override
    public <K, V> NamedCache<K, V> ensureCache(String sCacheName, ClassLoader loader, NamedCache.Option ... options) {
        NamedCache cache;
        if (sCacheName == null || sCacheName.length() == 0) {
            throw new IllegalArgumentException("Cache name cannot be null");
        }
        loader = DefaultConfigurableCacheFactory.ensureClassLoader(loader);
        ScopedCacheReferenceStore store = this.m_store;
        do {
            if ((cache = store.getCache(sCacheName, loader)) != null && cache.isActive()) {
                DefaultConfigurableCacheFactory.checkPermission(cache);
                return cache;
            }
            if (cache != null && !cache.isDestroyed() && !cache.isReleased()) {
                try {
                    DefaultConfigurableCacheFactory.checkPermission(cache);
                    return cache;
                }
                catch (IllegalStateException e) {
                    store.releaseCache(cache, loader);
                }
            }
            store.clearInactiveCacheRefs();
            CacheInfo infoCache = this.findSchemeMapping(sCacheName);
            XmlElement xmlScheme = this.resolveScheme(infoCache);
            String sSchemeType = xmlScheme.getName();
            int nSchemeType = this.translateSchemeType(sSchemeType);
            int iHashCurrent = loader == null ? 0 : loader.hashCode();
            xmlScheme.addAttribute("tier").setString("front");
            this.pushCacheContext("tier=front,loader=" + iHashCurrent);
            cache = this.configureCache(infoCache, xmlScheme, loader);
            if (nSchemeType != 18) continue;
            return cache;
        } while (store.putCacheIfAbsent(cache, loader) != null);
        return cache;
    }

    public void releaseCache(NamedCache cache) {
        this.releaseCache(cache, false);
    }

    public void destroyCache(NamedCache cache) {
        this.releaseCache(cache, true);
    }

    @Override
    public <V> NamedTopic<V> ensureTopic(String sName, ClassLoader loader, NamedCollection.Option ... options) {
        throw new UnsupportedOperationException("NamedTopic is not supported by DefaultConfigurableCacheFactory");
    }

    @Override
    public void releaseTopic(NamedTopic<?> topic) {
        throw new UnsupportedOperationException("NamedTopic is not supported by DefaultConfigurableCacheFactory");
    }

    @Override
    public void destroyTopic(NamedTopic<?> topic) {
        throw new UnsupportedOperationException("NamedTopic is not supported by DefaultConfigurableCacheFactory");
    }

    @Override
    public Service ensureService(String sServiceName) {
        return this.ensureService(this.findServiceScheme(sServiceName));
    }

    @Override
    public synchronized void activate() {
    }

    @Override
    public synchronized void dispose() {
    }

    @Override
    public boolean isCacheActive(String sCacheName, ClassLoader loader) {
        return this.m_store.getCache(sCacheName, DefaultConfigurableCacheFactory.ensureClassLoader(loader)) != null;
    }

    public String getScopeName() {
        return this.m_sScopeName;
    }

    public void setScopeName(String sScopeName) {
        if (!this.m_store.getNames().isEmpty()) {
            throw new IllegalStateException("Scope cannot be set after service start");
        }
        this.m_sScopeName = sScopeName;
    }

    protected ClassLoader getConfigClassLoader() {
        return this.m_loader;
    }

    @Override
    public ResourceRegistry getResourceRegistry() {
        return this.m_registry;
    }

    @Override
    public InterceptorRegistry getInterceptorRegistry() {
        ResourceRegistry registry = this.m_registry;
        return registry == null ? null : registry.getResource(InterceptorRegistry.class);
    }

    protected static void checkPermission(NamedCache cache) {
        CacheService service = cache.getCacheService();
        Security.checkPermission(service.getCluster(), service.getInfo().getServiceName(), cache.getCacheName(), "join");
    }

    public void setConfigClassLoader(ClassLoader loader) {
        this.m_loader = DefaultConfigurableCacheFactory.ensureClassLoader(loader);
    }

    public static XmlDocument loadConfig(String sName) {
        return DefaultConfigurableCacheFactory.loadConfig(sName, null);
    }

    public static XmlDocument loadConfig(String sName, ClassLoader loader) {
        return XmlHelper.loadFileOrResource(sName, "cache configuration", loader);
    }

    public static XmlDocument loadConfigAsResource(String sResource, ClassLoader loader) {
        return DefaultConfigurableCacheFactory.loadConfig(sResource, loader);
    }

    public static XmlDocument loadConfigFromFile(File file) {
        if (file.isDirectory()) {
            file = new File(file, FILE_CFG_CACHE);
        }
        return DefaultConfigurableCacheFactory.loadConfig(file.getAbsolutePath(), null);
    }

    public CacheInfo findSchemeMapping(String sCacheName) {
        XmlElement xmlMatch;
        XmlElement xmlDefaultMatch = null;
        XmlElement xmlPrefixMatch = null;
        XmlElement xmlExactMatch = null;
        String sSuffix = null;
        Iterator iter = this.m_xmlConfig.getSafeElement("caching-scheme-mapping").getElements("cache-mapping");
        while (iter.hasNext()) {
            String sPrefix;
            XmlElement xmlMapping = (XmlElement)iter.next();
            String sName = xmlMapping.getSafeElement("cache-name").getString();
            if (sName.equals(sCacheName)) {
                xmlExactMatch = xmlMapping;
                break;
            }
            if (sName.equals("*")) {
                xmlDefaultMatch = xmlMapping;
                continue;
            }
            int cchPrefix = sName.indexOf(42);
            if (cchPrefix < 0 || !sCacheName.startsWith(sPrefix = sName.substring(0, cchPrefix))) continue;
            if (cchPrefix != sName.length() - 1) {
                throw new IllegalArgumentException("Invalid wildcard pattern:\n" + xmlMapping);
            }
            xmlPrefixMatch = xmlMapping;
            sSuffix = sCacheName.substring(cchPrefix);
        }
        if (xmlExactMatch != null) {
            xmlMatch = xmlExactMatch;
            sSuffix = "";
        } else if (xmlPrefixMatch != null) {
            xmlMatch = xmlPrefixMatch;
        } else {
            xmlMatch = xmlDefaultMatch;
            sSuffix = sCacheName;
        }
        if (xmlMatch == null) {
            throw new IllegalArgumentException("No scheme for cache: \"" + sCacheName + '\"');
        }
        String sScheme = xmlMatch.getSafeElement("scheme-name").getString();
        HashMap<String, String> mapAttr = new HashMap<String, String>();
        Iterator iter2 = xmlMatch.getSafeElement("init-params").getElements("init-param");
        while (iter2.hasNext()) {
            XmlElement xmlParam = (XmlElement)iter2.next();
            String sName = xmlParam.getSafeElement("param-name").getString();
            String sValue = xmlParam.getSafeElement("param-value").getString();
            if (sName.length() == 0) continue;
            int ofReplace = sValue.indexOf(42);
            if (ofReplace >= 0 && sSuffix != null) {
                sValue = sValue.substring(0, ofReplace) + sSuffix + sValue.substring(ofReplace + 1);
            }
            mapAttr.put(sName, sValue);
        }
        return new CacheInfo(sCacheName, sScheme, mapAttr);
    }

    public XmlElement resolveScheme(CacheInfo info) {
        XmlElement xmlScheme = this.findScheme(info.getSchemeName());
        info.replaceAttributes(xmlScheme);
        return this.resolveScheme(xmlScheme, info, false, true);
    }

    protected XmlElement findScheme(String sSchemeName) {
        XmlElement xmlScheme = DefaultConfigurableCacheFactory.findScheme(this.m_xmlConfig, sSchemeName);
        if (xmlScheme != null) {
            return (XmlElement)xmlScheme.clone();
        }
        throw new IllegalArgumentException("Missing scheme: \"" + sSchemeName + '\"');
    }

    protected static XmlElement findScheme(XmlElement xmlConfig, String sSchemeName) {
        if (sSchemeName != null) {
            for (XmlElement xml : xmlConfig.getSafeElement("caching-schemes").getElementList()) {
                if (!xml.getSafeElement("scheme-name").getString().equals(sSchemeName)) continue;
                return xml;
            }
        }
        return null;
    }

    public static Map collectServiceSchemes(XmlElement xmlConfig) {
        HashMap mapService = new HashMap();
        for (XmlElement xmlScheme : xmlConfig.getSafeElement("caching-schemes").getElementList()) {
            DefaultConfigurableCacheFactory.collectServiceSchemes(xmlScheme, xmlConfig, mapService);
        }
        return mapService;
    }

    protected static void collectServiceSchemes(XmlElement xmlScheme, XmlElement xmlConfig, HashMap mapService) {
        String sSchemeType = xmlScheme.getName();
        String sServiceName = xmlScheme.getSafeElement("service-name").getString();
        String sServiceType = null;
        switch (DefaultConfigurableCacheFactory.translateStandardSchemeType(sSchemeType)) {
            case 1: {
                sServiceType = "ReplicatedCache";
                break;
            }
            case 2: {
                sServiceType = "OptimisticCache";
                break;
            }
            case 3: {
                sServiceType = "DistributedCache";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: {
                sServiceType = "LocalCache";
                break;
            }
            case 4: {
                XmlElement xmlBack = DefaultConfigurableCacheFactory.resolveScheme(xmlConfig, xmlScheme.getSafeElement("back-scheme"), null, true, true, false);
                DefaultConfigurableCacheFactory.collectServiceSchemes(xmlBack, xmlConfig, mapService);
                return;
            }
            case 5: {
                XmlElement xmlVer = DefaultConfigurableCacheFactory.resolveScheme(xmlConfig, xmlScheme.getSafeElement("version-transient-scheme"), null, true, true, false);
                XmlElement xmlBack = DefaultConfigurableCacheFactory.resolveScheme(xmlConfig, xmlScheme.getSafeElement("back-scheme"), null, true, true, false);
                DefaultConfigurableCacheFactory.collectServiceSchemes(xmlVer, xmlConfig, mapService);
                DefaultConfigurableCacheFactory.collectServiceSchemes(xmlBack, xmlConfig, mapService);
                return;
            }
            case 14: {
                sServiceType = "Invocation";
                break;
            }
            case 15: {
                sServiceType = "Proxy";
                break;
            }
            case 16: {
                sServiceType = "RemoteCache";
                break;
            }
            case 17: {
                sServiceType = "RemoteInvocation";
            }
        }
        if (sServiceName.length() == 0) {
            sServiceName = sServiceType;
        }
        if (sServiceName != null) {
            mapService.put(sServiceName, xmlScheme);
        }
    }

    protected XmlElement findServiceScheme(String sServiceName) {
        if (sServiceName != null) {
            for (XmlElement xml : this.m_xmlConfig.getSafeElement("caching-schemes").getElementList()) {
                if (!xml.getSafeElement("service-name").getString().equals(sServiceName)) continue;
                return (XmlElement)xml.clone();
            }
        }
        throw new IllegalArgumentException("Missing scheme for service: \"" + sServiceName + '\"');
    }

    protected static XmlElement resolveScheme(XmlElement xmlConfig, XmlElement xmlScheme, CacheInfo info, boolean fChild, boolean fRequired, boolean fApply) {
        String sRefName;
        if (fChild) {
            XmlElement xmlChild = null;
            for (XmlElement xml : xmlScheme.getElementList()) {
                if (!xml.getName().endsWith("-scheme")) continue;
                if (xmlChild == null) {
                    xmlChild = xml;
                    continue;
                }
                throw new IllegalArgumentException("Scheme contains more then one child scheme:\n" + xmlScheme);
            }
            if (xmlChild == null) {
                if (fRequired) {
                    String sName = xmlScheme.getName();
                    if (xmlScheme == xmlScheme.getParent().getElement(sName)) {
                        throw new IllegalArgumentException("Child scheme is missing at:\n" + xmlScheme);
                    }
                    throw new IllegalArgumentException("Element \"" + sName + "\" is missing at:\n" + xmlScheme.getParent());
                }
                return null;
            }
            xmlScheme = xmlChild;
        }
        if ((sRefName = xmlScheme.getSafeElement("scheme-ref").getString()).length() == 0) {
            return xmlScheme;
        }
        XmlElement xmlBase = DefaultConfigurableCacheFactory.findScheme(xmlConfig, sRefName);
        if (xmlBase == null) {
            throw new IllegalArgumentException("Unresolved reference to scheme:\n" + sRefName);
        }
        XmlElement xmlElement = xmlBase = fApply ? (XmlElement)xmlBase.clone() : xmlBase;
        if (!xmlScheme.getName().equals(xmlBase.getName())) {
            throw new IllegalArgumentException("Reference does not match the scheme type: scheme=\n" + xmlScheme + "\nbase=" + xmlBase);
        }
        if (xmlScheme.equals(xmlBase)) {
            throw new IllegalArgumentException("Circular reference in scheme:\n" + xmlScheme);
        }
        if (info != null) {
            info.replaceAttributes(xmlBase);
        }
        XmlElement xmlResolve = DefaultConfigurableCacheFactory.resolveScheme(xmlConfig, xmlBase, info, false, false, fApply);
        if (fApply) {
            Iterator iter = xmlScheme.getElementList().iterator();
            while (iter.hasNext()) {
                XmlHelper.replaceElement(xmlResolve, (XmlElement)iter.next());
            }
        }
        return xmlResolve;
    }

    protected XmlElement resolveScheme(XmlElement xmlScheme, CacheInfo info, boolean fChild, boolean fRequired) {
        return DefaultConfigurableCacheFactory.resolveScheme(this.m_xmlConfig, xmlScheme, info, fChild, fRequired, true);
    }

    protected NamedCache ensureCache(CacheInfo info, XmlElement xmlScheme, ClassLoader loader) {
        try {
            CacheService service = (CacheService)this.ensureService(xmlScheme);
            return service.ensureCache(info.getCacheName(), loader);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Invalid scheme:\n" + xmlScheme);
        }
    }

    public Service ensureService(XmlElement xmlScheme) {
        return this.ensureServiceInternal(this.resolveScheme(xmlScheme, null, false, false));
    }

    protected Service ensureServiceInternal(XmlElement xmlScheme) {
        String sServiceType;
        Cluster cluster;
        String sSchemeType = xmlScheme.getName();
        int nSchemeType = this.translateSchemeType(sSchemeType);
        switch (nSchemeType) {
            case 1: {
                cluster = CacheFactory.ensureCluster();
                sServiceType = "ReplicatedCache";
                break;
            }
            case 2: {
                cluster = CacheFactory.ensureCluster();
                sServiceType = "OptimisticCache";
                break;
            }
            case 3: {
                cluster = CacheFactory.ensureCluster();
                sServiceType = "DistributedCache";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: {
                cluster = CacheFactory.getCluster();
                sServiceType = "LocalCache";
                break;
            }
            case 4: {
                return this.ensureServiceInternal(this.resolveScheme(xmlScheme.getSafeElement("back-scheme"), null, true, true));
            }
            case 5: {
                XmlElement xmlVer = this.resolveScheme(xmlScheme.getSafeElement("version-transient-scheme"), null, true, true);
                XmlElement xmlBack = this.resolveScheme(xmlScheme.getSafeElement("back-scheme"), null, true, true);
                this.ensureServiceInternal(xmlVer);
                return this.ensureServiceInternal(xmlBack);
            }
            case 14: {
                cluster = CacheFactory.ensureCluster();
                sServiceType = "Invocation";
                break;
            }
            case 15: {
                cluster = CacheFactory.ensureCluster();
                sServiceType = "Proxy";
                break;
            }
            case 16: {
                cluster = CacheFactory.getCluster();
                sServiceType = "RemoteCache";
                break;
            }
            case 17: {
                cluster = CacheFactory.getCluster();
                sServiceType = "RemoteInvocation";
                break;
            }
            case 18: {
                throw new UnsupportedOperationException("Transactions are not supported in Coherence CE");
            }
            default: {
                throw new UnsupportedOperationException("ensureService: " + sSchemeType);
            }
        }
        String sServiceName = xmlScheme.getSafeElement("service-name").getString();
        if (sServiceName.length() == 0) {
            sServiceName = sServiceType;
        }
        sServiceName = this.getScopedServiceName(sServiceName);
        try (Lockable.Unlockable unlockable = ((Lockable)((Object)cluster)).exclusively();){
            Service service = cluster.ensureService(sServiceName, sServiceType);
            if (service.isRunning()) {
                if (service instanceof CacheService) {
                    this.validateBackingMapManager((CacheService)service);
                }
            } else {
                XmlElement xmlConfig = CacheFactory.getServiceConfig(sServiceType);
                if (xmlConfig != null) {
                    List listStandard = xmlConfig.getElementList();
                    int c = listStandard.size();
                    for (int i = 0; i < c; ++i) {
                        XmlElement xmlParamStandard = (XmlElement)listStandard.get(i);
                        String sParamName = xmlParamStandard.getName();
                        XmlElement xmlParam = xmlScheme.getElement(sParamName);
                        if (xmlParam == null || XmlHelper.isEmpty(xmlParam)) continue;
                        xmlParam = DefaultConfigurableCacheFactory.resolveScheme(this.m_xmlConfig, xmlParam, null, false, false, true);
                        listStandard.set(i, xmlParam.clone());
                    }
                }
                switch (nSchemeType) {
                    case 15: {
                        XmlElement xmlSub = xmlConfig.getSafeElement("acceptor-config");
                        this.resolveSerializer(xmlSub);
                        xmlSub = xmlSub.getElement("tcp-acceptor");
                        if (xmlSub == null) break;
                        this.resolveSocketProvider(xmlSub);
                        break;
                    }
                    case 16: 
                    case 17: {
                        XmlElement xmlSub = xmlConfig.getSafeElement("initiator-config");
                        this.resolveSerializer(xmlSub);
                        xmlSub = xmlSub.getElement("tcp-initiator");
                        if (xmlSub == null) break;
                        this.resolveSocketProvider(xmlSub);
                    }
                }
                this.resolveSerializer(xmlConfig);
                service.configure(xmlConfig);
                if (service instanceof CacheService) {
                    BackingMapManager mgr = this.instantiateBackingMapManager(nSchemeType, xmlScheme);
                    this.registerBackingMapManager(mgr);
                    ((CacheService)service).setBackingMapManager(mgr);
                }
                this.startService(service);
            }
            Service service2 = service;
            return service2;
        }
    }

    protected void startService(Service service) {
        service.start();
    }

    public String getScopedServiceName(String sServiceName) {
        String sScopeName = this.getScopeName();
        return sScopeName == null || sScopeName.length() == 0 ? sServiceName : sScopeName + ":" + sServiceName;
    }

    protected void resolveSerializer(XmlElement xmlConfig) {
        XmlElement xmlSerializer = xmlConfig.getElement("serializer");
        if (xmlSerializer == null || XmlHelper.isEmpty(xmlSerializer)) {
            if (xmlSerializer != null) {
                XmlHelper.removeElement(xmlConfig, "serializer");
            }
            if ((xmlSerializer = this.getConfig().findElement("defaults/serializer")) != null) {
                xmlConfig.getElementList().add(xmlSerializer);
            }
        }
    }

    protected void resolveSocketProvider(XmlElement xmlConfig) {
        XmlElement xmlProvider = xmlConfig.getElement("socket-provider");
        if (xmlProvider == null || XmlHelper.isEmpty(xmlProvider)) {
            if (xmlProvider != null) {
                XmlHelper.removeElement(xmlConfig, "socket-provider");
            }
            if ((xmlProvider = this.getConfig().findElement("defaults/socket-provider")) != null) {
                xmlConfig.getElementList().add(xmlProvider);
            }
        }
    }

    protected BackingMapManager instantiateBackingMapManager(int nSchemeType, XmlElement xmlScheme) {
        switch (nSchemeType) {
            default: 
        }
        return new Manager();
    }

    protected void registerBackingMapManager(BackingMapManager mgr) {
        this.m_setManager.add(mgr);
    }

    protected void validateBackingMapManager(CacheService service) {
        BackingMapManager manager = service.getBackingMapManager();
        if (this.m_setManager.contains(manager)) {
            return;
        }
        if (!(manager instanceof Manager)) {
            throw new IllegalStateException("Service \"" + service.getInfo().getServiceName() + "\" has been started " + (manager == null ? "without a BackingMapManager" : "with a non-compatible BackingMapManager: " + manager));
        }
        DefaultConfigurableCacheFactory that = ((Manager)manager).getCacheFactory();
        if (that != this && !DefaultConfigurableCacheFactory.equals(that.getConfig(), this.getConfig())) {
            throw new IllegalStateException("Service \"" + service.getInfo().getServiceName() + "\" has been started by the factory with a different configuration descriptor");
        }
    }

    public NamedCache configureCache(CacheInfo info, XmlElement xmlScheme, ClassLoader loader) {
        NamedCache cache;
        String sSchemeType = xmlScheme.getName();
        switch (this.translateSchemeType(sSchemeType)) {
            case 11: {
                Object oCache = this.instantiateAny(info, xmlScheme, null, loader);
                if (oCache instanceof NamedCache) {
                    return (NamedCache)oCache;
                }
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: 
            case 20: {
                cache = this.ensureCache(info, xmlScheme, loader);
                break;
            }
            case 3: 
            case 16: {
                cache = this.ensureCache(info, xmlScheme, loader);
                XmlElement xmlBundling = xmlScheme.getElement("operation-bundling");
                if (xmlBundling == null) break;
                cache = this.instantiateBundlingNamedCache(cache, xmlBundling);
                break;
            }
            case 4: {
                NearCache cacheNear;
                String sSubclass;
                int nStrategy;
                String sCacheCtx = this.popCacheContext();
                XmlElement xmlFront = this.resolveScheme(xmlScheme.getSafeElement("front-scheme"), info, true, true);
                Map mapFront = this.configureBackingMap(info, xmlFront, null, loader, null);
                XmlElement xmlBack = this.resolveScheme(xmlScheme.getSafeElement("back-scheme"), info, true, true);
                NamedCache cacheBack = this.configureCache(info, xmlBack, loader);
                String sStrategy = xmlScheme.getSafeElement("invalidation-strategy").getString("auto");
                int n = sStrategy.equalsIgnoreCase("none") ? 0 : (sStrategy.equalsIgnoreCase("present") ? 1 : (sStrategy.equalsIgnoreCase("all") ? 2 : (sStrategy.equalsIgnoreCase("auto") ? 3 : (nStrategy = sStrategy.equalsIgnoreCase("logical") ? 4 : Integer.MIN_VALUE))));
                if (nStrategy == Integer.MIN_VALUE) {
                    CacheFactory.log("Invalid invalidation strategy of '" + sStrategy + "'; proceeding with default of 'auto'", 2);
                    nStrategy = 3;
                }
                if ((sSubclass = xmlScheme.getSafeElement("class-name").getString()).length() == 0) {
                    cacheNear = this.instantiateNearCache(mapFront, cacheBack, nStrategy);
                } else {
                    Object[] aoParam = new Object[]{mapFront, cacheBack, nStrategy};
                    cacheNear = (NearCache)this.instantiateSubclass(sSubclass, NearCache.class, loader, aoParam, xmlScheme.getElement("init-params"));
                }
                if (sCacheCtx != null) {
                    cacheNear.setRegistrationContext(sCacheCtx);
                    this.register(cacheNear, sCacheCtx);
                }
                cache = cacheNear;
                break;
            }
            case 5: {
                NearCache cacheNear;
                String sCacheCtx = this.popCacheContext();
                XmlElement xmlFront = this.resolveScheme(xmlScheme.getSafeElement("front-scheme"), info, true, true);
                Map mapFront = this.configureBackingMap(info, xmlFront, null, loader, null);
                XmlElement xmlBack = this.resolveScheme(xmlScheme.getSafeElement("back-scheme"), info, true, true);
                NamedCache cacheBack = this.ensureCache(info, xmlBack, loader);
                XmlElement xmlVer = xmlScheme.getSafeElement("version-transient-scheme");
                String sSuffix = xmlVer.getSafeElement("cache-name-suffix").getString("-version");
                xmlVer = this.resolveScheme(xmlVer, info, true, true);
                NamedCache cacheVer = this.ensureCache(info.getSyntheticInfo(sSuffix), xmlVer, loader);
                String sSubclass = xmlScheme.getSafeElement("class-name").getString();
                if (sSubclass.length() == 0) {
                    cacheNear = this.instantiateVersionedNearCache(mapFront, cacheBack, cacheVer);
                } else {
                    Object[] aoParam = new Object[]{mapFront, cacheBack, cacheVer};
                    cacheNear = (NearCache)this.instantiateSubclass(sSubclass, VersionedNearCache.class, loader, aoParam, xmlScheme.getElement("init-params"));
                }
                if (sCacheCtx != null) {
                    cacheNear.setRegistrationContext(sCacheCtx);
                    this.register(cacheNear, sCacheCtx);
                }
                cache = cacheNear;
                break;
            }
            case 18: {
                throw new UnsupportedOperationException("Transactions are not supported in Coherence CE");
            }
            default: {
                throw new UnsupportedOperationException("configureCache: " + sSchemeType);
            }
        }
        this.verifyMapListener(info, cache, xmlScheme, null, loader, null);
        return cache;
    }

    protected NearCache instantiateNearCache(Map mapFront, NamedCache mapBack, int nStrategy) {
        return new NearCache(mapFront, mapBack, nStrategy);
    }

    protected VersionedNearCache instantiateVersionedNearCache(Map mapLocal, NamedCache mapDist, NamedCache mapVersion) {
        return new VersionedNearCache(mapLocal, mapDist, mapVersion);
    }

    public Map configureBackingMap(CacheInfo info, XmlElement xmlScheme, BackingMapManagerContext context, ClassLoader loader, Map mapListeners) {
        Map map;
        String sPartitioned;
        xmlScheme = this.resolveBackingMapScheme(info, xmlScheme);
        int nType = this.translateSchemeType(xmlScheme.getName());
        String sCtx = this.popCacheContext();
        if (loader == null && context != null) {
            loader = context.getClassLoader();
        }
        if (DefaultConfigurableCacheFactory.isPartitioned(sPartitioned = xmlScheme.getSafeAttribute("partitioned").getString(), nType)) {
            if (nType == 12) {
                map = this.instantiateReadWriteBackingMap(info, xmlScheme, context, mapListeners);
            } else {
                XmlElement xmlTemp = (XmlElement)xmlScheme.clone();
                xmlTemp.setAttribute("partitioned", new SimpleValue("false"));
                PartitionedBackingMapManager mgrInner = new PartitionedBackingMapManager(info, xmlTemp, context, loader);
                mgrInner.init(context);
                String sCacheName = info.getCacheName();
                ObservableSplittingBackingMap pabm = sPartitioned.equals("observable") || nType == 19 || nType == 20 ? new ObservableSplittingBackingMap(mgrInner, sCacheName) : new ObservableSplittingBackingCache(mgrInner, sCacheName);
                map = pabm;
            }
        } else {
            switch (nType) {
                case 6: {
                    map = this.instantiateLocalCache(info, xmlScheme, context, loader);
                    break;
                }
                case 12: {
                    if (context == null) {
                        throw new IllegalArgumentException("ReadWriteBackingMap requires BackingMapManagerContext");
                    }
                    map = this.instantiateReadWriteBackingMap(info, xmlScheme, context, mapListeners);
                    break;
                }
                case 13: {
                    if (context == null) {
                        throw new IllegalArgumentException("VersionedBackingMap requires BackingMapManagerContext");
                    }
                    map = this.instantiateVersionedBackingMap(info, xmlScheme, context, mapListeners);
                    break;
                }
                case 7: {
                    map = this.instantiateOverflowBackingMap(info, xmlScheme, context, loader, mapListeners);
                    break;
                }
                case 8: {
                    map = this.instantiateDiskBackingMap(info, xmlScheme, context, loader);
                    break;
                }
                case 9: {
                    map = this.instantiateExternalBackingMap(info, xmlScheme, context, loader);
                    break;
                }
                case 10: {
                    map = this.instantiatePagedExternalBackingMap(info, xmlScheme, context, loader);
                    break;
                }
                case 16: {
                    map = this.configureCache(info, xmlScheme, loader);
                    break;
                }
                case 19: {
                    map = this.instantiateFlashJournalBackingMap(info, xmlScheme, context, loader);
                    break;
                }
                case 20: {
                    map = this.instantiateRamJournalBackingMap(info, xmlScheme, context, loader);
                    break;
                }
                case 11: {
                    map = this.instantiateMap(info, xmlScheme, context, loader);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("configureBackingMap: " + xmlScheme.getName());
                }
            }
        }
        if (xmlScheme.getAttribute("partition-name") == null) {
            this.verifyMapListener(info, map, xmlScheme, context, loader, mapListeners);
            if (sCtx != null && context != null) {
                this.register(context.getCacheService(), info.getCacheName(), sCtx, map);
            }
        }
        return map;
    }

    public XmlElement resolveBackingMapScheme(CacheInfo info, XmlElement xmlScheme) {
        String sSchemeType = xmlScheme.getName();
        switch (this.translateSchemeType(sSchemeType)) {
            case 1: 
            case 2: 
            case 3: {
                XmlElement xmlBM = xmlScheme.getSafeElement("backing-map-scheme");
                XmlElement xmlMap = this.resolveScheme(xmlBM, info, true, true);
                XmlElement xmlPartitioned = xmlBM.getSafeElement("partitioned");
                if (xmlPartitioned != null) {
                    xmlMap.addAttribute("partitioned").setString(xmlPartitioned.getString());
                }
                return xmlMap;
            }
            case 4: {
                XmlElement xmlBack = this.resolveScheme(xmlScheme.getSafeElement("back-scheme"), info, true, true);
                return this.resolveBackingMapScheme(info, xmlBack);
            }
            case 5: {
                XmlElement xmlBack = this.resolveScheme(xmlScheme.getSafeElement("back-scheme"), info, true, true);
                XmlElement xmlVer = xmlScheme.getSafeElement("version-transient-scheme");
                String sSuffix = xmlVer.getSafeElement("cache-name-suffix").getString("-version");
                xmlVer = this.resolveScheme(xmlVer, info, true, true);
                return this.resolveBackingMapScheme(info, info.getCacheName().endsWith(sSuffix) ? xmlVer : xmlBack);
            }
        }
        return xmlScheme;
    }

    protected void verifyMapListener(CacheInfo info, Map map, XmlElement xmlScheme, BackingMapManagerContext context, ClassLoader loader, Map mapListeners) {
        XmlElement xmlListener = xmlScheme.getSafeElement("listener");
        XmlElement xmlClass = this.resolveScheme(xmlListener, info, true, false);
        if (xmlClass != null) {
            String sTier = xmlScheme.getSafeAttribute("tier").getString();
            if (sTier.length() > 0) {
                boolean fBackOnly = xmlListener.getSafeAttribute("target").getString().equals("backing-map");
                if (sTier.equals("front") && fBackOnly) {
                    return;
                }
                if (sTier.equals("back") && !fBackOnly) {
                    return;
                }
            }
            MapListener listener = this.instantiateMapListener(info, xmlClass, context, loader);
            try {
                ((ObservableMap)map).addMapListener(listener);
                if (mapListeners != null) {
                    mapListeners.put(map, listener);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Map is not observable: " + map.getClass());
            }
        }
    }

    protected Map instantiateReadWriteBackingMap(CacheInfo info, XmlElement xmlRWBM, BackingMapManagerContext context, Map mapListeners) {
        ReadWriteBackingMap rwbm;
        String sSubclass;
        ObservableMap mapInternal;
        String sWriteDelay;
        XmlElement xmlInternal = this.resolveScheme(xmlRWBM.getSafeElement("internal-cache-scheme"), info, true, true);
        XmlElement xmlMisses = this.resolveScheme(xmlRWBM.getSafeElement("miss-cache-scheme"), info, true, false);
        XmlElement xmlStore = this.resolveScheme(xmlRWBM.getSafeElement("cachestore-scheme"), info, false, false);
        ClassLoader loader = context.getClassLoader();
        Map mapMisses = xmlMisses == null ? null : this.instantiateLocalCache(info, xmlMisses, context, loader);
        boolean fReadOnly = xmlRWBM.getSafeElement("read-only").getBoolean();
        double dflRefreshAhead = this.convertDouble(xmlRWBM.getSafeElement("refresh-ahead-factor"));
        double dflWriteFactor = this.convertDouble(xmlRWBM.getSafeElement("write-batch-factor"));
        int cWriteRequeue = this.convertInt(xmlRWBM.getSafeElement("write-requeue-threshold"));
        String sSplitting = xmlRWBM.getSafeAttribute("partitioned").getString();
        boolean fSplitting = DefaultConfigurableCacheFactory.isPartitioned(sSplitting, this.translateSchemeType(xmlInternal.getName()));
        long cStoreTimeout = DefaultConfigurableCacheFactory.parseTime(xmlRWBM.getSafeElement("cachestore-timeout").getString("0"));
        boolean fRethrow = xmlRWBM.getSafeElement("rollback-cachestore-failures").getBoolean(true);
        int cBatchSize = this.convertInt(xmlRWBM.getSafeElement("write-max-batch-size"), 128);
        if (!fRethrow) {
            CacheFactory.log("The rollback-cachestore-failures setting is explicitly configured to prevent CacheStore exceptions from being propagated to the client; this setting is not recommended and has been deprecated", 2);
        }
        long cWriteBehindMillis = (sWriteDelay = xmlRWBM.getSafeElement("write-delay").getString()) == null || sWriteDelay.length() == 0 ? 1000L * (long)xmlRWBM.getSafeElement("write-delay-seconds").getInt() : DefaultConfigurableCacheFactory.parseTime(sWriteDelay, 1000);
        int cWriteBehindSec = cWriteBehindMillis == 0L ? 0 : Math.max(1, (int)(cWriteBehindMillis / 1000L));
        try {
            if (fSplitting) {
                xmlInternal = (XmlElement)xmlInternal.clone();
                xmlInternal.addAttribute("partitioned").setString(sSplitting);
            }
            mapInternal = (ObservableMap)this.configureBackingMap(info, xmlInternal, context, null, mapListeners);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Map is not observable:\n" + xmlInternal);
        }
        Object store = this.instantiateCacheStore(info, xmlStore, context, loader);
        BinaryEntryStore storeBinary = null;
        if (!(!(store instanceof BinaryEntryStore) || store instanceof NamedCache && store instanceof ClassLoaderAware && ((ClassLoaderAware)store).getContextClassLoader() != NullImplementation.getClassLoader())) {
            storeBinary = (BinaryEntryStore)store;
        }
        if ((sSubclass = xmlRWBM.getSafeElement("class-name").getString()).length() == 0) {
            if (storeBinary == null) {
                CacheLoader storeObject = (CacheLoader)store;
                rwbm = fSplitting ? this.instantiateReadWriteSplittingBackingMap(context, (PartitionAwareBackingMap)((Object)mapInternal), mapMisses, storeObject, fReadOnly, cWriteBehindSec, dflRefreshAhead) : this.instantiateReadWriteBackingMap(context, mapInternal, mapMisses, storeObject, fReadOnly, cWriteBehindSec, dflRefreshAhead);
            } else {
                rwbm = fSplitting ? this.instantiateReadWriteSplittingBackingMap(context, (PartitionAwareBackingMap)((Object)mapInternal), mapMisses, storeBinary, fReadOnly, cWriteBehindSec, dflRefreshAhead) : this.instantiateReadWriteBackingMap(context, mapInternal, mapMisses, storeBinary, fReadOnly, cWriteBehindSec, dflRefreshAhead);
            }
        } else {
            Object[] objectArray;
            if (storeBinary == null) {
                Object[] objectArray2 = new Object[7];
                objectArray2[0] = context;
                objectArray2[1] = mapInternal;
                objectArray2[2] = mapMisses;
                objectArray2[3] = store;
                objectArray2[4] = new Boolean(fReadOnly);
                objectArray2[5] = cWriteBehindSec;
                objectArray = objectArray2;
                objectArray2[6] = new Double(dflRefreshAhead);
            } else {
                Object[] objectArray3 = new Object[7];
                objectArray3[0] = context;
                objectArray3[1] = mapInternal;
                objectArray3[2] = mapMisses;
                objectArray3[3] = storeBinary;
                objectArray3[4] = new Boolean(fReadOnly);
                objectArray3[5] = cWriteBehindSec;
                objectArray = objectArray3;
                objectArray3[6] = new Double(dflRefreshAhead);
            }
            Object[] aoParam = objectArray;
            rwbm = (ReadWriteBackingMap)this.instantiateSubclass(sSubclass, ReadWriteBackingMap.class, loader, aoParam, xmlRWBM.getElement("init-params"));
        }
        rwbm.setCacheName(info.getCacheName());
        rwbm.setRethrowExceptions(fRethrow);
        rwbm.setWriteBatchFactor(dflWriteFactor);
        rwbm.setWriteRequeueThreshold(cWriteRequeue);
        rwbm.setWriteMaxBatchSize(cBatchSize);
        if (cWriteBehindMillis != 1000L * (long)cWriteBehindSec) {
            rwbm.setWriteBehindMillis(cWriteBehindMillis);
        }
        rwbm.setCacheStoreTimeoutMillis(cStoreTimeout);
        XmlElement xmlBundling = xmlStore.getElement("operation-bundling");
        if (xmlBundling != null) {
            ReadWriteBackingMap.StoreWrapper storeWrapper = rwbm.getCacheStore();
            Iterator iter = xmlBundling.getElements("bundle-config");
            while (iter.hasNext()) {
                XmlElement xmlBundle = (XmlElement)iter.next();
                String sOperation = xmlBundle.getSafeElement("operation-name").getString("all");
                int cBundle = this.convertInt(xmlBundle.getSafeElement("preferred-size"));
                if (sOperation.equals("all")) {
                    this.initializeBundler(storeWrapper.ensureLoadBundler(cBundle), xmlBundle);
                    this.initializeBundler(storeWrapper.ensureStoreBundler(cBundle), xmlBundle);
                    this.initializeBundler(storeWrapper.ensureEraseBundler(cBundle), xmlBundle);
                    continue;
                }
                if (sOperation.equals("load")) {
                    this.initializeBundler(storeWrapper.ensureLoadBundler(cBundle), xmlBundle);
                    continue;
                }
                if (sOperation.equals("store")) {
                    this.initializeBundler(storeWrapper.ensureStoreBundler(cBundle), xmlBundle);
                    continue;
                }
                if (sOperation.equals("erase")) {
                    this.initializeBundler(storeWrapper.ensureEraseBundler(cBundle), xmlBundle);
                    continue;
                }
                throw new IllegalArgumentException("Invalid \"operation-name\" element:\n" + xmlBundle);
            }
        }
        return rwbm;
    }

    protected ReadWriteBackingMap instantiateReadWriteBackingMap(BackingMapManagerContext context, ObservableMap mapInternal, Map mapMisses, CacheLoader store, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        return new ReadWriteBackingMap(context, mapInternal, mapMisses, store, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor);
    }

    protected ReadWriteBackingMap instantiateReadWriteBackingMap(BackingMapManagerContext context, ObservableMap mapInternal, Map mapMisses, BinaryEntryStore storeBinary, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        return new ReadWriteBackingMap(context, mapInternal, mapMisses, storeBinary, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor);
    }

    protected ReadWriteSplittingBackingMap instantiateReadWriteSplittingBackingMap(BackingMapManagerContext context, PartitionAwareBackingMap mapInternal, Map mapMisses, CacheLoader store, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        return new ReadWriteSplittingBackingMap(context, mapInternal, mapMisses, store, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor);
    }

    protected ReadWriteSplittingBackingMap instantiateReadWriteSplittingBackingMap(BackingMapManagerContext context, PartitionAwareBackingMap mapInternal, Map mapMisses, BinaryEntryStore storeBinary, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        return new ReadWriteSplittingBackingMap(context, mapInternal, mapMisses, storeBinary, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor);
    }

    protected Map instantiateVersionedBackingMap(CacheInfo info, XmlElement xmlVBM, BackingMapManagerContext context, Map mapListeners) {
        VersionedBackingMap vbm;
        ObservableMap mapInternal;
        String sWriteDelay;
        XmlElement xmlPersist = xmlVBM.getElement("version-persistent-scheme");
        String sPersistSuffix = "-persist";
        if (xmlPersist != null) {
            sPersistSuffix = xmlPersist.getSafeElement("cache-name-suffix").getString(sPersistSuffix);
            xmlPersist = this.resolveScheme(xmlPersist, info, true, false);
            if (info.getCacheName().endsWith(sPersistSuffix) && xmlPersist != null) {
                return this.configureBackingMap(info, xmlPersist, context, null, mapListeners);
            }
        }
        XmlElement xmlTrans = xmlVBM.getElement("version-transient-scheme");
        String sTransSuffix = "-version";
        if (xmlTrans != null) {
            sTransSuffix = xmlTrans.getSafeElement("cache-name-suffix").getString(sTransSuffix);
            xmlTrans = this.resolveScheme(xmlTrans, info, true, false);
            if (info.getCacheName().endsWith(sTransSuffix) && xmlTrans != null) {
                return this.configureBackingMap(info, xmlTrans, context, null, mapListeners);
            }
        }
        XmlElement xmlInternal = this.resolveScheme(xmlVBM.getSafeElement("internal-cache-scheme"), info, true, true);
        XmlElement xmlMisses = this.resolveScheme(xmlVBM.getSafeElement("miss-cache-scheme"), info, true, false);
        XmlElement xmlStore = this.resolveScheme(xmlVBM.getSafeElement("cachestore-scheme"), info, false, false);
        ClassLoader loader = context.getClassLoader();
        Map mapMisses = xmlMisses == null ? null : this.instantiateLocalCache(info, xmlMisses, context, loader);
        boolean fReadOnly = xmlVBM.getSafeElement("read-only").getBoolean();
        double dflRefreshAhead = this.convertDouble(xmlVBM.getSafeElement("refresh-ahead-factor"));
        boolean fRethrow = xmlVBM.getSafeElement("rollback-cachestore-failures").getBoolean(true);
        double dflWriteFactor = this.convertDouble(xmlVBM.getSafeElement("write-batch-factor"));
        int cWriteRequeue = this.convertInt(xmlVBM.getSafeElement("write-requeue-threshold"));
        NamedCache cachePersist = xmlPersist == null ? null : this.ensureCache(info.getSyntheticInfo(sPersistSuffix), xmlPersist, loader);
        NamedCache cacheTrans = xmlTrans == null ? null : this.ensureCache(info.getSyntheticInfo(sTransSuffix), xmlTrans, loader);
        boolean fManageTrans = xmlVBM.getSafeElement("manage-transient").getBoolean();
        if (!fRethrow) {
            CacheFactory.log("The rollback-cachestore-failures setting is explicitly configured to prevent CacheStore exceptions from being propagated to the client; this setting is not recommended and has been deprecated", 2);
        }
        long cWriteBehindMillis = (sWriteDelay = xmlVBM.getSafeElement("write-delay").getString()) == null || sWriteDelay.length() == 0 ? 1000L * (long)xmlVBM.getSafeElement("write-delay-seconds").getInt() : DefaultConfigurableCacheFactory.parseTime(sWriteDelay, 1000);
        int cWriteBehindSec = cWriteBehindMillis == 0L ? 0 : Math.max(1, (int)(cWriteBehindMillis / 1000L));
        try {
            mapInternal = (ObservableMap)this.configureBackingMap(info, xmlInternal, context, null, mapListeners);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Map is not observable:\n" + xmlInternal);
        }
        CacheLoader store = (CacheLoader)this.instantiateCacheStore(info, xmlStore, context, loader);
        String sSubclass = xmlVBM.getSafeElement("class-name").getString();
        if (sSubclass.length() == 0) {
            vbm = store instanceof CacheStore ? this.instantiateVersionedBackingMap(context, mapInternal, mapMisses, (CacheStore)store, fReadOnly, cWriteBehindSec, dflRefreshAhead, cacheTrans, cachePersist, fManageTrans) : this.instantiateVersionedBackingMap(context, mapInternal, mapMisses, store, cacheTrans, cachePersist, fManageTrans);
        } else {
            Object[] objectArray;
            if (store instanceof CacheStore) {
                Object[] objectArray2 = new Object[10];
                objectArray2[0] = context;
                objectArray2[1] = mapInternal;
                objectArray2[2] = mapMisses;
                objectArray2[3] = store;
                objectArray2[4] = new Boolean(fReadOnly);
                objectArray2[5] = cWriteBehindSec;
                objectArray2[6] = new Double(dflRefreshAhead);
                objectArray2[7] = cacheTrans;
                objectArray2[8] = cachePersist;
                objectArray = objectArray2;
                objectArray2[9] = new Boolean(fManageTrans);
            } else {
                Object[] objectArray3 = new Object[7];
                objectArray3[0] = context;
                objectArray3[1] = mapInternal;
                objectArray3[2] = mapMisses;
                objectArray3[3] = store;
                objectArray3[4] = cacheTrans;
                objectArray3[5] = cachePersist;
                objectArray = objectArray3;
                objectArray3[6] = new Boolean(fManageTrans);
            }
            Object[] aoParam = objectArray;
            vbm = (VersionedBackingMap)this.instantiateSubclass(sSubclass, VersionedBackingMap.class, loader, aoParam, xmlVBM.getElement("init-params"));
        }
        vbm.setRethrowExceptions(fRethrow);
        vbm.setWriteBatchFactor(dflWriteFactor);
        vbm.setWriteRequeueThreshold(cWriteRequeue);
        if (cWriteBehindMillis != 1000L * (long)cWriteBehindSec) {
            vbm.setWriteBehindMillis(cWriteBehindMillis);
        }
        return vbm;
    }

    protected VersionedBackingMap instantiateVersionedBackingMap(BackingMapManagerContext context, ObservableMap mapInternal, Map mapMisses, CacheStore store, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, NamedCache mapVersionTransient, NamedCache mapVersionPersist, boolean fManageTransient) {
        return new VersionedBackingMap(context, mapInternal, mapMisses, store, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, mapVersionTransient, mapVersionPersist, fManageTransient);
    }

    protected VersionedBackingMap instantiateVersionedBackingMap(BackingMapManagerContext context, ObservableMap mapInternal, Map mapMisses, CacheLoader loader, NamedCache mapVersionTransient, NamedCache mapVersionPersist, boolean fManageTransient) {
        return new VersionedBackingMap(context, mapInternal, mapMisses, loader, mapVersionTransient, mapVersionPersist, fManageTransient);
    }

    protected Map instantiateLocalCache(CacheInfo info, XmlElement xmlLocal, BackingMapManagerContext context, ClassLoader loader) {
        LocalCache cache;
        block16: {
            String sSubclass;
            int cHighUnits = (int)DefaultConfigurableCacheFactory.parseMemorySize(xmlLocal.getSafeElement("high-units").getString("0"));
            int cLowUnits = (int)DefaultConfigurableCacheFactory.parseMemorySize(xmlLocal.getSafeElement("low-units").getString("0"));
            int cExpiryDelayMillis = (int)DefaultConfigurableCacheFactory.parseTime(xmlLocal.getSafeElement("expiry-delay").getString("0"), 1000);
            if (cHighUnits <= 0) {
                cHighUnits = Integer.MAX_VALUE;
            }
            if (cLowUnits <= 0) {
                cLowUnits = (int)((double)cHighUnits * 0.8);
            }
            if (cExpiryDelayMillis < 0) {
                cExpiryDelayMillis = 0;
            }
            if ((sSubclass = xmlLocal.getSafeElement("class-name").getString()).length() == 0) {
                cache = this.instantiateLocalCache(cHighUnits, cExpiryDelayMillis);
            } else {
                Object[] aoParam = new Object[]{cHighUnits, cExpiryDelayMillis};
                cache = (LocalCache)this.instantiateSubclass(sSubclass, LocalCache.class, loader, aoParam, xmlLocal.getElement("init-params"));
            }
            cache.setLowUnits(cLowUnits);
            XmlElement xmlEviction = xmlLocal.getElement("eviction-policy");
            if (xmlEviction != null) {
                int nEvictionType;
                String sEvictionType = xmlEviction.getString();
                int n = sEvictionType.equalsIgnoreCase("HYBRID") ? 0 : (sEvictionType.equalsIgnoreCase("LRU") ? 1 : (nEvictionType = sEvictionType.equalsIgnoreCase("LFU") ? 2 : Integer.MIN_VALUE));
                if (nEvictionType >= 0) {
                    cache.setEvictionType(nEvictionType);
                } else {
                    XmlElement xmlClass = xmlEviction.getElement("class-scheme");
                    if (xmlClass == null) {
                        throw new IllegalArgumentException("Unknown eviction policy:\n" + xmlEviction);
                    }
                    try {
                        cache.setEvictionPolicy((ConfigurableCacheMap.EvictionPolicy)this.instantiateAny(info, xmlClass, context, loader));
                    }
                    catch (Exception e) {
                        throw Base.ensureRuntimeException(e, "Error instantiating custom eviction policy:\n" + xmlEviction);
                    }
                }
            }
            this.configureUnitCalculator(xmlLocal, cache, info, context, loader);
            XmlElement xmlStore = this.resolveScheme(xmlLocal.getSafeElement("cachestore-scheme"), info, false, false);
            CacheLoader store = (CacheLoader)this.instantiateCacheStore(info, xmlStore, context, loader);
            if (store != null) {
                cache.setCacheLoader(store);
            }
            if (xmlLocal.getSafeElement("pre-load").getBoolean()) {
                try {
                    cache.loadAll();
                }
                catch (Throwable e) {
                    String sText = "An exception occurred while pre-loading the \"" + info.getCacheName() + "\" cache:" + '\n' + DefaultConfigurableCacheFactory.indentString(DefaultConfigurableCacheFactory.getStackTrace(e), "    ") + "\nThe following configuration was used for the \"" + info.getCacheName() + "\" cache:" + '\n' + DefaultConfigurableCacheFactory.indentString(xmlLocal.toString(), "    ");
                    if (!(e instanceof Error)) {
                        sText = sText + "\n(The exception has been logged and will be ignored.)";
                    }
                    CacheFactory.log(sText, 2);
                    if (!(e instanceof Error)) break block16;
                    throw (Error)e;
                }
            }
        }
        return cache;
    }

    protected void configureUnitCalculator(XmlElement xmlCache, ConfigurableCacheMap cache, CacheInfo info, BackingMapManagerContext context, ClassLoader loader) {
        ConfigurableCacheMap.UnitCalculator calculator;
        XmlElement xmlCalculator = xmlCache.getElement("unit-calculator");
        if (xmlCalculator == null) {
            return;
        }
        String sType = xmlCalculator.getString();
        if (sType.equalsIgnoreCase("FIXED")) {
            calculator = LocalCache.INSTANCE_FIXED;
        } else if (sType.equalsIgnoreCase("BINARY")) {
            calculator = LocalCache.INSTANCE_BINARY;
        } else {
            XmlElement xmlClass = xmlCalculator.getElement("class-scheme");
            if (xmlClass == null) {
                throw new IllegalArgumentException("Unknown unit calculator:\n" + xmlCalculator);
            }
            try {
                calculator = (ConfigurableCacheMap.UnitCalculator)this.instantiateAny(info, xmlClass, context, loader);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Error instantiating custom unit calculator:\n" + xmlCalculator);
            }
        }
        if (calculator != null) {
            cache.setUnitCalculator(calculator);
            XmlElement xmlFactor = xmlCache.getElement("unit-factor");
            if (xmlFactor != null) {
                cache.setUnitFactor((int)DefaultConfigurableCacheFactory.parseMemorySize(xmlFactor.getString("1")));
            }
        }
    }

    protected LocalCache instantiateLocalCache(int cUnits, int cExpiryMillis) {
        return new LocalCache(cUnits, cExpiryMillis);
    }

    protected Map instantiateOverflowBackingMap(CacheInfo info, XmlElement xmlOverflow, BackingMapManagerContext context, ClassLoader loader, Map mapListeners) {
        Map mapOverflow;
        boolean fObservable;
        boolean fExpiry;
        int cExpiryMillis;
        Map mapMisses;
        block17: {
            XmlElement xmlFront = this.resolveScheme(xmlOverflow.getSafeElement("front-scheme"), info, true, true);
            XmlElement xmlBack = this.resolveScheme(xmlOverflow.getSafeElement("back-scheme"), info, true, true);
            XmlElement xmlMisses = this.resolveScheme(xmlOverflow.getSafeElement("miss-cache-scheme"), info, true, false);
            Map mapFront = this.configureBackingMap(info, xmlFront, context, loader, mapListeners);
            Map mapBack = this.configureBackingMap(info, xmlBack, context, loader, mapListeners);
            mapMisses = xmlMisses == null ? null : this.instantiateLocalCache(info, xmlMisses, context, loader);
            String sSubclass = xmlOverflow.getSafeElement("class-name").getString();
            boolean fExplicit = sSubclass != null && sSubclass.length() > 0;
            cExpiryMillis = (int)DefaultConfigurableCacheFactory.parseTime(xmlOverflow.getSafeElement("expiry-delay").getString("0"), 1000);
            fExpiry = cExpiryMillis > 0 || xmlOverflow.getSafeElement("expiry-enabled").getBoolean();
            fObservable = mapBack instanceof ObservableMap;
            boolean fExplicitOverflow = fExplicit && sSubclass.equals(OverflowMap.class.getName());
            boolean fExplicitSimple = fExplicit && sSubclass.equals(SimpleOverflowMap.class.getName());
            try {
                if (fExplicit && !fExplicitSimple && !fExplicitOverflow) {
                    Object[] objectArray;
                    block16: {
                        try {
                            Class clz = ExternalizableHelper.loadClass(sSubclass, loader, OverflowMap.class.getClassLoader());
                            if (OverflowMap.class.isAssignableFrom(clz)) {
                                fExplicitOverflow = true;
                                break block16;
                            }
                            if (SimpleOverflowMap.class.isAssignableFrom(clz)) {
                                fExplicitSimple = true;
                                break block16;
                            }
                            throw new IllegalArgumentException(sSubclass + " is not a sub-class of either OverflowMap or SimpleOverflowMap");
                        }
                        catch (Exception e) {
                            throw DefaultConfigurableCacheFactory.ensureRuntimeException(e);
                        }
                    }
                    if (fExplicitSimple && mapMisses != null) {
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = (ObservableMap)mapFront;
                        objectArray2[1] = mapBack;
                        objectArray = objectArray2;
                        objectArray2[2] = mapMisses;
                    } else {
                        Object[] objectArray3 = new Object[2];
                        objectArray3[0] = (ObservableMap)mapFront;
                        objectArray = objectArray3;
                        objectArray3[1] = mapBack;
                    }
                    Object[] aoParam = objectArray;
                    XmlElement xmlParams = xmlOverflow.getElement("init-params");
                    mapOverflow = (Map)this.instantiateSubclass(sSubclass, OverflowMap.class, loader, aoParam, xmlParams);
                    break block17;
                }
                mapOverflow = fExplicitSimple ? this.instantiateSimpleOverflowMap((ObservableMap)mapFront, mapBack, mapMisses) : this.instantiateOverflowMap((ObservableMap)mapFront, mapBack, fExpiry);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("FrontMap is not observable: " + mapFront.getClass());
            }
        }
        if (mapOverflow instanceof OverflowMap) {
            if (cExpiryMillis > 0) {
                ((OverflowMap)mapOverflow).setExpiryDelay(cExpiryMillis);
            }
            if (mapMisses != null) {
                CacheFactory.log("Cache " + info.getCacheName() + " of scheme " + info.getSchemeName() + " has a \"miss-cache-scheme\" configured; since the default OverflowMap implementation has been selected, the miss cache will not be used.", 2);
            }
        } else if (mapOverflow instanceof SimpleOverflowMap) {
            if (fExpiry) {
                CacheFactory.log("Cache " + info.getCacheName() + " of scheme " + info.getSchemeName() + " has \"expiry-enabled\" set to true or \"expiry-delay\" configured; these settings will have no effect, and expiry will not work, because the scheme explicitly ues a SimpleOverflowMap.", 2);
            }
            if (fObservable) {
                CacheFactory.log("Cache " + info.getCacheName() + " of scheme " + info.getSchemeName() + " has a \"back-scheme\" that is observable; the events from the back map will be ignored because the scheme explicitly uses a SimpleOverflowMap, and this could result in missing events if the back map actively expires and/or evicts its entries.", 2);
            }
        }
        return mapOverflow;
    }

    protected OverflowMap instantiateOverflowMap(ObservableMap mapFront, Map mapBack, boolean fExpiry) {
        OverflowMap map = new OverflowMap(mapFront, mapBack);
        if (fExpiry) {
            map.setExpiryEnabled(true);
        }
        return map;
    }

    protected SimpleOverflowMap instantiateSimpleOverflowMap(ObservableMap mapFront, Map mapBack, Map mapMisses) {
        return new SimpleOverflowMap(mapFront, mapBack, mapMisses);
    }

    protected Map instantiateDiskBackingMap(CacheInfo info, XmlElement xmlDisk, BackingMapManagerContext context, ClassLoader loader) {
        String sSubclass = xmlDisk.getSafeElement("class-name").getString();
        String sFS = xmlDisk.getSafeElement("file-manager").getString();
        String sPath = xmlDisk.getSafeElement("directory").getString();
        int cHighUnits = this.convertInt(xmlDisk.getSafeElement("high-units"));
        int cPages = this.convertInt(xmlDisk.getSafeElement("page-limit"));
        String sTarget = xmlDisk.getSafeAttribute("target").getString();
        boolean fAsync = xmlDisk.getSafeElement("async").getBoolean();
        int cbMaxAsync = (int)DefaultConfigurableCacheFactory.parseMemorySize(xmlDisk.getSafeElement("async-limit").getString("0"));
        int cPageSecs = (int)(DefaultConfigurableCacheFactory.parseTime(xmlDisk.getSafeElement("page-duration").getString("0"), 1000) / 1000L);
        int cExpiryMillis = (int)DefaultConfigurableCacheFactory.parseTime(xmlDisk.getSafeElement("expiry-delay").getString("0"), 1000);
        if (sPath.length() == 0) {
            sPath = xmlDisk.getSafeElement("root-directory").getString();
        }
        File file = sPath.length() == 0 ? null : new File(sPath);
        boolean fPaged = cPages > 0 && cPageSecs > 0;
        boolean fBackup = sTarget.equals("backup");
        boolean fBinaryMap = context != null && "DistributedCache".equals(context.getCacheService().getInfo().getServiceType());
        BinaryStore store = null;
        BinaryStoreManager storeMgr = null;
        if (sFS.equalsIgnoreCase("NIO-file")) {
            long cbInit = DefaultConfigurableCacheFactory.parseMemorySize(xmlDisk.getSafeElement("initial-size").getString("1"), 20);
            long cbMax = DefaultConfigurableCacheFactory.parseMemorySize(xmlDisk.getSafeElement("maximum-size").getString("1024"), 20);
            int cbMaxSize = (int)Math.min(Math.max(cbMax, 1L), 2147482624L);
            int cbInitSize = (int)Math.min(Math.max(cbInit, 1L), (long)cbMaxSize);
            if (fPaged) {
                storeMgr = new MappedStoreManager(cbInitSize, cbMaxSize, file);
            } else {
                MappedBufferManager bufferMgr = new MappedBufferManager(cbInitSize, cbMaxSize, file);
                store = new BinaryMapStore(new BinaryMap(bufferMgr));
            }
        } else {
            throw new UnsupportedOperationException("file-manager: " + sFS);
        }
        if (fAsync) {
            if (store != null) {
                store = this.instantiateAsyncBinaryStore(store, cbMaxAsync);
            } else if (storeMgr != null) {
                storeMgr = this.instantiateAsyncBinaryStoreManager(storeMgr, cbMaxAsync);
            } else {
                throw new UnsupportedOperationException("async option without BinaryStore or BinaryStoreManager!");
            }
        }
        if (fPaged) {
            Object[] objectArray;
            if (sSubclass.length() == 0) {
                return fBinaryMap ? this.instantiateSerializationPagedCache(storeMgr, cPages, cPageSecs, true, fBackup) : this.instantiateSerializationPagedCache(storeMgr, cPages, cPageSecs, loader);
            }
            if (fBinaryMap) {
                Object[] objectArray2 = new Object[5];
                objectArray2[0] = storeMgr;
                objectArray2[1] = cPages;
                objectArray2[2] = cPageSecs;
                objectArray2[3] = Boolean.TRUE;
                objectArray = objectArray2;
                objectArray2[4] = new Boolean(fBackup);
            } else {
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = storeMgr;
                objectArray3[1] = cPages;
                objectArray3[2] = cPageSecs;
                objectArray = objectArray3;
                objectArray3[3] = loader;
            }
            Object[] aoParam = objectArray;
            return (Map)this.instantiateSubclass(sSubclass, SerializationPagedCache.class, loader, aoParam, xmlDisk.getElement("init-params"));
        }
        return this.instantiateSerializationMap(store, fBinaryMap, loader, cHighUnits, cExpiryMillis, sSubclass, xmlDisk.getElement("init-params"));
    }

    protected Map instantiateSerializationMap(BinaryStore store, boolean fBinaryMap, ClassLoader loader, int cHighUnits, int cExpiryMillis, String sSubclass, XmlElement xmlInitParams) {
        Object[] objectArray;
        if (sSubclass.length() == 0) {
            if (cHighUnits > 0 || cExpiryMillis > 0) {
                SerializationCache cache;
                SerializationCache serializationCache = cache = fBinaryMap ? this.instantiateSerializationCache(store, cHighUnits, true) : this.instantiateSerializationCache(store, cHighUnits, loader);
                if (cExpiryMillis > 0) {
                    cache.setExpiryDelay(cExpiryMillis);
                }
                return cache;
            }
            if (fBinaryMap && store.getClass() == BinaryMapStore.class) {
                return ((BinaryMapStore)store).getBinaryMap();
            }
            return fBinaryMap ? this.instantiateSerializationMap(store, true) : this.instantiateSerializationMap(store, loader);
        }
        if (cHighUnits > 0 || cExpiryMillis > 0) {
            Object[] objectArray2;
            if (fBinaryMap) {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = store;
                objectArray3[1] = cHighUnits;
                objectArray2 = objectArray3;
                objectArray3[2] = Boolean.TRUE;
            } else {
                Object[] objectArray4 = new Object[3];
                objectArray4[0] = store;
                objectArray4[1] = cHighUnits;
                objectArray2 = objectArray4;
                objectArray4[2] = loader;
            }
            Object[] aoParam = objectArray2;
            SerializationCache cache = (SerializationCache)this.instantiateSubclass(sSubclass, SerializationCache.class, loader, aoParam, xmlInitParams);
            if (cExpiryMillis > 0) {
                cache.setExpiryDelay(cExpiryMillis);
            }
            return cache;
        }
        if (fBinaryMap) {
            Object[] objectArray5 = new Object[2];
            objectArray5[0] = store;
            objectArray = objectArray5;
            objectArray5[1] = Boolean.TRUE;
        } else {
            Object[] objectArray6 = new Object[2];
            objectArray6[0] = store;
            objectArray = objectArray6;
            objectArray6[1] = loader;
        }
        Object[] aoParam = objectArray;
        Map map = (Map)this.instantiateSubclass(sSubclass, AbstractKeyBasedMap.class, loader, aoParam, xmlInitParams);
        if (map instanceof SerializationMap || map instanceof SimpleSerializationMap) {
            return map;
        }
        throw new IllegalArgumentException(sSubclass + " does not extend either " + SerializationMap.class.getName() + " or " + SimpleSerializationMap.class.getName());
    }

    protected Map instantiateExternalBackingMap(CacheInfo info, XmlElement xmlExternal, BackingMapManagerContext context, ClassLoader loader) {
        String sSubclass = xmlExternal.getSafeElement("class-name").getString();
        int cHighUnits = (int)DefaultConfigurableCacheFactory.parseMemorySize(xmlExternal.getSafeElement("high-units").getString("0"));
        int cExpiryMillis = (int)DefaultConfigurableCacheFactory.parseTime(xmlExternal.getSafeElement("expiry-delay").getString("0"), 1000);
        boolean fBinaryMap = context != null && "DistributedCache".equals(context.getCacheService().getInfo().getServiceType());
        BinaryStore store = this.instantiateBinaryStoreManager(xmlExternal, loader, false).createBinaryStore();
        Map map = this.instantiateSerializationMap(store, fBinaryMap, loader, cHighUnits, cExpiryMillis, sSubclass, xmlExternal.getElement("init-params"));
        if (map instanceof ConfigurableCacheMap) {
            this.configureUnitCalculator(xmlExternal, (ConfigurableCacheMap)map, info, context, loader);
        }
        return map;
    }

    protected Map instantiatePagedExternalBackingMap(CacheInfo info, XmlElement xmlPaged, BackingMapManagerContext context, ClassLoader loader) {
        Object[] objectArray;
        String sSubclass = xmlPaged.getSafeElement("class-name").getString();
        int cPages = this.convertInt(xmlPaged.getSafeElement("page-limit"));
        int cPageSecs = (int)(DefaultConfigurableCacheFactory.parseTime(xmlPaged.getSafeElement("page-duration").getString("5"), 1000) / 1000L);
        boolean fBackup = xmlPaged.getSafeAttribute("target").getString().equals("backup");
        boolean fBinaryMap = context != null && "DistributedCache".equals(context.getCacheService().getInfo().getServiceType());
        BinaryStoreManager mgr = this.instantiateBinaryStoreManager(xmlPaged, loader, true);
        if (sSubclass.length() == 0) {
            return fBinaryMap ? this.instantiateSerializationPagedCache(mgr, cPages, cPageSecs, true, fBackup) : this.instantiateSerializationPagedCache(mgr, cPages, cPageSecs, loader);
        }
        if (fBinaryMap) {
            Object[] objectArray2 = new Object[5];
            objectArray2[0] = mgr;
            objectArray2[1] = cPages;
            objectArray2[2] = cPageSecs;
            objectArray2[3] = Boolean.TRUE;
            objectArray = objectArray2;
            objectArray2[4] = new Boolean(fBackup);
        } else {
            Object[] objectArray3 = new Object[4];
            objectArray3[0] = mgr;
            objectArray3[1] = cPages;
            objectArray3[2] = cPageSecs;
            objectArray = objectArray3;
            objectArray3[3] = loader;
        }
        Object[] aoParam = objectArray;
        return (Map)this.instantiateSubclass(sSubclass, SerializationPagedCache.class, loader, aoParam, xmlPaged.getElement("init-params"));
    }

    protected Map instantiateFlashJournalBackingMap(CacheInfo info, XmlElement xmlJournal, BackingMapManagerContext context, ClassLoader loader) {
        throw new UnsupportedOperationException("Elastic Data features are not supported in Coherence CE");
    }

    protected Map instantiateRamJournalBackingMap(CacheInfo info, XmlElement xmlJournal, BackingMapManagerContext context, ClassLoader loader) {
        throw new UnsupportedOperationException("Elastic Data features are not supported in Coherence CE");
    }

    protected BinaryStoreManager instantiateBinaryStoreManager(XmlElement xmlConfig, ClassLoader loader, boolean fPaged) {
        for (XmlElement xmlStore : xmlConfig.getElementList()) {
            String sType = xmlStore.getName();
            String sSubclass = xmlStore.getSafeElement("class-name").getString();
            XmlElement xmlParams = xmlStore.getElement("init-params");
            File fileDir = null;
            int cbMaxSize = 0;
            int cbInitSize = 0;
            if (sType.equals("nio-file-manager") || sType.equals("bdb-store-manager")) {
                String sPath = xmlStore.getSafeElement("directory").getString();
                File file = fileDir = sPath.length() == 0 ? null : new File(sPath);
            }
            if (sType.equals("nio-file-manager")) {
                long cbInit = DefaultConfigurableCacheFactory.parseMemorySize(xmlStore.getSafeElement("initial-size").getString("1"), 20);
                long cbMax = DefaultConfigurableCacheFactory.parseMemorySize(xmlStore.getSafeElement("maximum-size").getString("1024"), 20);
                cbMaxSize = (int)Math.min(Math.max(cbMax, 1L), 2147482624L);
                cbInitSize = (int)Math.min(Math.max(cbInit, 1L), (long)cbMaxSize);
                if ((long)cbInitSize != cbInit) {
                    CacheFactory.log("Invalid initial-size specified for " + sType + "; changed to: " + cbInitSize + " bytes", 2);
                }
                if ((long)cbMaxSize != cbMax) {
                    CacheFactory.log("Invalid maximum-size specified for " + sType + "; changed to: " + cbMaxSize + " bytes", 2);
                }
            }
            if (sType.equals("bdb-store-manager")) {
                String sStoreName = xmlStore.getSafeElement("store-name").getString();
                try {
                    if (sSubclass.length() == 0) {
                        BerkeleyDBBinaryStoreManager bdbMgr = new BerkeleyDBBinaryStoreManager(fileDir, sStoreName);
                        if (xmlParams != null) {
                            SimpleElement xmlInit = new SimpleElement("config");
                            XmlHelper.transformInitParams(xmlInit, xmlParams);
                            bdbMgr.setConfig(xmlInit);
                        }
                        return bdbMgr;
                    }
                    Object[] aoParam = new Object[]{fileDir, sStoreName};
                    return (BinaryStoreManager)this.instantiateSubclass(sSubclass, BerkeleyDBBinaryStoreManager.class, loader, aoParam, xmlParams);
                }
                catch (NoClassDefFoundError e) {
                    String sMsg = "Berkeley DB JE libraries are required to utilize a 'bdb-store-manager', visit www.sleepycat.com for additional information.";
                    throw DefaultConfigurableCacheFactory.ensureRuntimeException(e, sMsg);
                }
            }
            if (sType.equals("nio-file-manager")) {
                if (sSubclass.length() == 0) {
                    return new MappedStoreManager(cbInitSize, cbMaxSize, fileDir);
                }
                Object[] aoParam = new Object[]{cbInitSize, cbMaxSize, fileDir};
                return (BinaryStoreManager)this.instantiateSubclass(sSubclass, MappedStoreManager.class, loader, aoParam, xmlParams);
            }
            if (sType.equals("async-store-manager")) {
                Object[] objectArray;
                int cbMaxAsync = (int)DefaultConfigurableCacheFactory.parseMemorySize(xmlStore.getSafeElement("async-limit").getString("0"));
                BinaryStoreManager mgr = this.instantiateBinaryStoreManager(xmlStore, loader, fPaged);
                if (sSubclass.length() == 0) {
                    return this.instantiateAsyncBinaryStoreManager(mgr, cbMaxAsync);
                }
                if (cbMaxAsync <= 0) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = mgr;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = mgr;
                    objectArray = objectArray3;
                    objectArray3[1] = cbMaxAsync;
                }
                Object[] aoParam = objectArray;
                return (BinaryStoreManager)this.instantiateSubclass(sSubclass, AsyncBinaryStoreManager.class, loader, aoParam, xmlParams);
            }
            if (!sType.equals("custom-store-manager")) continue;
            if (sSubclass.length() == 0) {
                throw new IllegalArgumentException("Missing class-name:\n" + xmlStore);
            }
            return (BinaryStoreManager)this.instantiateSubclass(sSubclass, BinaryStoreManager.class, loader, null, xmlParams);
        }
        throw new IllegalArgumentException("Missing BinaryStoreManager configuration:\n" + xmlConfig);
    }

    protected AsyncBinaryStore instantiateAsyncBinaryStore(BinaryStore store, int cbMaxAsync) {
        return cbMaxAsync <= 0 ? new AsyncBinaryStore(store) : new AsyncBinaryStore(store, cbMaxAsync);
    }

    protected AsyncBinaryStoreManager instantiateAsyncBinaryStoreManager(BinaryStoreManager storeMgr, int cbMaxAsync) {
        return cbMaxAsync <= 0 ? new AsyncBinaryStoreManager(storeMgr) : new AsyncBinaryStoreManager(storeMgr, cbMaxAsync);
    }

    protected SerializationPagedCache instantiateSerializationPagedCache(BinaryStoreManager storeMgr, int cPages, int cPageSecs, ClassLoader loader) {
        return new SerializationPagedCache(storeMgr, cPages, cPageSecs, loader);
    }

    protected SerializationPagedCache instantiateSerializationPagedCache(BinaryStoreManager storeMgr, int cPages, int cPageSecs, boolean fBinaryMap, boolean fPassive) {
        return new SerializationPagedCache(storeMgr, cPages, cPageSecs, fBinaryMap, fPassive);
    }

    protected SerializationCache instantiateSerializationCache(BinaryStore store, int cMax, ClassLoader loader) {
        return new SerializationCache(store, cMax, loader);
    }

    protected SerializationCache instantiateSerializationCache(BinaryStore store, int cMax, boolean fBinaryMap) {
        return new SerializationCache(store, cMax, fBinaryMap);
    }

    protected SerializationMap instantiateSerializationMap(BinaryStore store, ClassLoader loader) {
        return new SerializationMap(store, loader);
    }

    protected SerializationMap instantiateSerializationMap(BinaryStore store, boolean fBinaryMap) {
        return new SerializationMap(store, fBinaryMap);
    }

    protected SimpleSerializationMap instantiateSimpleSerializationMap(BinaryStore store, ClassLoader loader) {
        return new SimpleSerializationMap(store, loader);
    }

    protected SimpleSerializationMap instantiateSimpleSerializationMap(BinaryStore store, boolean fBinaryMap) {
        return new SimpleSerializationMap(store, fBinaryMap);
    }

    protected BundlingNamedCache instantiateBundlingNamedCache(NamedCache cache, XmlElement xmlBundling) {
        BundlingNamedCache cacheBundle = new BundlingNamedCache(cache);
        Iterator iter = xmlBundling.getElements("bundle-config");
        while (iter.hasNext()) {
            XmlElement xmlBundle = (XmlElement)iter.next();
            String sOperation = xmlBundle.getSafeElement("operation-name").getString("all");
            int cBundle = this.convertInt(xmlBundle.getSafeElement("preferred-size"));
            if (sOperation.equals("all")) {
                this.initializeBundler(cacheBundle.ensureGetBundler(cBundle), xmlBundle);
                this.initializeBundler(cacheBundle.ensurePutBundler(cBundle), xmlBundle);
                this.initializeBundler(cacheBundle.ensureRemoveBundler(cBundle), xmlBundle);
                continue;
            }
            if (sOperation.equals("get")) {
                this.initializeBundler(cacheBundle.ensureGetBundler(cBundle), xmlBundle);
                continue;
            }
            if (sOperation.equals("put")) {
                this.initializeBundler(cacheBundle.ensurePutBundler(cBundle), xmlBundle);
                continue;
            }
            if (sOperation.equals("remove")) {
                this.initializeBundler(cacheBundle.ensureRemoveBundler(cBundle), xmlBundle);
                continue;
            }
            throw new IllegalArgumentException("Invalid \"operation-name\" element:\n" + xmlBundle);
        }
        return cacheBundle;
    }

    protected void initializeBundler(AbstractBundler bundler, XmlElement xmlBundle) {
        if (bundler != null) {
            bundler.setThreadThreshold(this.convertInt(xmlBundle.getSafeElement("thread-threshold"), 4));
            bundler.setDelayMillis(this.convertInt(xmlBundle.getSafeElement("delay-millis"), 1));
            bundler.setAllowAutoAdjust(xmlBundle.getSafeElement("auto-adjust").getBoolean(false));
        }
    }

    protected Map instantiateMap(CacheInfo info, XmlElement xmlClass, BackingMapManagerContext context, ClassLoader loader) {
        try {
            return (Map)this.instantiateAny(info, xmlClass, context, loader);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a map:\n" + xmlClass);
        }
    }

    protected Object instantiateCacheStore(CacheInfo info, XmlElement xmlStore, BackingMapManagerContext context, ClassLoader loader) {
        if ((xmlStore = this.resolveScheme(xmlStore, info, true, false)) == null || XmlHelper.isEmpty(xmlStore)) {
            return null;
        }
        String sSchemeType = xmlStore.getName();
        try {
            switch (this.translateSchemeType(sSchemeType)) {
                case 11: {
                    return this.instantiateAny(info, xmlStore, context, loader);
                }
                case 16: {
                    NamedCache cacheRemote = this.configureCache(info, xmlStore, NullImplementation.getClassLoader());
                    if (!this.isSerializerCompatible(cacheRemote.getCacheService(), context.getCacheService())) {
                        CacheService service = context.getCacheService();
                        ExternalizableHelper.reportIncompatibleSerializers(cacheRemote, service.getInfo().getServiceName(), service.getSerializer());
                        cacheRemote.release();
                        cacheRemote = this.configureCache(info, xmlStore, loader);
                    }
                    return cacheRemote;
                }
            }
            throw new UnsupportedOperationException("instantiateCacheStore: " + sSchemeType);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a CacheLoader:\n" + xmlStore);
        }
    }

    protected MapListener instantiateMapListener(CacheInfo info, XmlElement xmlClass, BackingMapManagerContext context, ClassLoader loader) {
        try {
            return (MapListener)this.instantiateAny(info, xmlClass, context, loader);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a listener:\n" + xmlClass);
        }
    }

    public Object instantiateAny(final CacheInfo info, XmlElement xmlClass, final BackingMapManagerContext context, final ClassLoader loader) {
        if (this.translateSchemeType(xmlClass.getName()) != 11) {
            throw new IllegalArgumentException("Invalid class definition: " + xmlClass);
        }
        XmlHelper.ParameterResolver resolver = new XmlHelper.ParameterResolver(){

            @Override
            public Object resolveParameter(String sType, String sValue) {
                if (sValue.equals(DefaultConfigurableCacheFactory.CLASS_LOADER)) {
                    return loader;
                }
                if (sValue.equals(DefaultConfigurableCacheFactory.MGR_CONTEXT)) {
                    return context;
                }
                if (sType.equals(DefaultConfigurableCacheFactory.SCHEME_REF)) {
                    XmlElement xmlScheme = DefaultConfigurableCacheFactory.this.resolveScheme(new CacheInfo(info.getCacheName(), sValue, info.getAttributes()));
                    String sSchemeType = xmlScheme.getName();
                    switch (DefaultConfigurableCacheFactory.this.translateSchemeType(sSchemeType)) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 16: {
                            return DefaultConfigurableCacheFactory.this.configureCache(info, xmlScheme, loader);
                        }
                        case 14: 
                        case 17: {
                            return DefaultConfigurableCacheFactory.this.ensureServiceInternal(xmlScheme);
                        }
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 19: 
                        case 20: {
                            Map mapListeners = context == null ? null : ((Manager)context.getManager()).m_mapBackingMapListeners;
                            return DefaultConfigurableCacheFactory.this.configureBackingMap(info, xmlScheme, context, null, mapListeners);
                        }
                        case 11: {
                            return DefaultConfigurableCacheFactory.this.instantiateAny(info, xmlScheme, context, loader);
                        }
                    }
                    throw new UnsupportedOperationException("instantiateAny: " + sSchemeType);
                }
                if (sType.equals(DefaultConfigurableCacheFactory.CACHE_REF)) {
                    return DefaultConfigurableCacheFactory.this.ensureCache(sValue, loader);
                }
                return XmlHelper.ParameterResolver.UNRESOLVED;
            }
        };
        return XmlHelper.createInstance(xmlClass, loader, resolver);
    }

    public Object instantiateSubclass(String sClass, Class clzSuper, ClassLoader loader, Object[] aoParam, XmlElement xmlParams) {
        if (sClass == null || sClass.length() == 0 || clzSuper == null) {
            throw new IllegalArgumentException("Class name and super class must be specified");
        }
        try {
            Class clz = ExternalizableHelper.loadClass(sClass, loader, clzSuper.getClassLoader());
            if (!clzSuper.isAssignableFrom(clz)) {
                throw new IllegalArgumentException(clzSuper + " is not a super-class of " + clz);
            }
            Object oTarget = aoParam == null ? clz.newInstance() : ClassHelper.newInstance(clz, aoParam);
            if (xmlParams != null && oTarget instanceof XmlConfigurable) {
                SimpleElement xmlConfig = new SimpleElement("config");
                XmlHelper.transformInitParams(xmlConfig, xmlParams);
                ((XmlConfigurable)oTarget).setConfig(xmlConfig);
            }
            return oTarget;
        }
        catch (Exception e) {
            throw DefaultConfigurableCacheFactory.ensureRuntimeException(e, "Fail to instantiate subclass: " + sClass + " of " + clzSuper);
        }
    }

    public void release(Map map, Map mapListeners) {
        ByteBufferManager bufmgr;
        MapListener listener;
        if (map instanceof ObservableMap && mapListeners != null && (listener = (MapListener)mapListeners.get(map)) != null) {
            ((ObservableMap)map).removeMapListener(listener);
            mapListeners.remove(map);
        }
        if (map instanceof LocalCache) {
            CacheLoader loader = ((LocalCache)map).getCacheLoader();
            if (loader instanceof MapCacheStore) {
                this.release(((MapCacheStore)loader).getMap(), mapListeners);
            } else {
                this.release(loader);
            }
        } else if (map instanceof OverflowMap) {
            this.release(((OverflowMap)map).getFrontMap(), mapListeners);
            this.release(((OverflowMap)map).getBackMap(), mapListeners);
        } else if (map instanceof ReadWriteBackingMap) {
            ((ReadWriteBackingMap)map).release();
            this.release(((ReadWriteBackingMap)map).getInternalCache(), mapListeners);
        } else if (map instanceof SerializationMap) {
            this.release(((SerializationMap)map).getBinaryStore());
        } else if (map instanceof SimpleSerializationMap) {
            this.release(((SimpleSerializationMap)map).getBinaryStore());
        } else if (map instanceof BinaryMap && (bufmgr = ((BinaryMap)map).getBufferManager()) instanceof MappedBufferManager) {
            ((MappedBufferManager)bufmgr).close();
        }
        if (map instanceof Disposable) {
            ((Disposable)((Object)map)).dispose();
        }
    }

    protected void release(CacheLoader loader) {
        if (loader instanceof Disposable) {
            ((Disposable)((Object)loader)).dispose();
        } else {
            try {
                ClassHelper.invoke(loader, "close", ClassHelper.VOID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void release(BinaryStore store) {
        if (store instanceof Disposable) {
            ((Disposable)((Object)store)).dispose();
        } else {
            try {
                ClassHelper.invoke(store, "close", ClassHelper.VOID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void releaseCache(NamedCache cache, boolean fDestroy) {
        Runnable runRelease;
        ScopedCacheReferenceStore store = this.m_store;
        String sCacheName = cache.getCacheName();
        ClassLoader loader = cache instanceof ClassLoaderAware ? ((ClassLoaderAware)((Object)cache)).getContextClassLoader() : DefaultConfigurableCacheFactory.getContextClassLoader();
        if (!store.releaseCache(cache, loader, runRelease = () -> {
            if (fDestroy) {
                cache.destroy();
            } else {
                cache.release();
            }
        }) && cache.isActive()) {
            throw new IllegalArgumentException("The cache " + sCacheName + " was created using a different factory; that same factory should be used to release the cache.");
        }
    }

    public int translateSchemeType(String sScheme) {
        return DefaultConfigurableCacheFactory.translateStandardSchemeType(sScheme);
    }

    public static int translateStandardSchemeType(String sScheme) {
        return sScheme.equals("replicated-scheme") ? 1 : (sScheme.equals("optimistic-scheme") ? 2 : (sScheme.equals("distributed-scheme") ? 3 : (sScheme.equals("local-scheme") ? 6 : (sScheme.equals("overflow-scheme") ? 7 : (sScheme.equals("disk-scheme") ? 8 : (sScheme.equals("external-scheme") ? 9 : (sScheme.equals("paged-external-scheme") ? 10 : (sScheme.equals("class-scheme") ? 11 : (sScheme.equals("near-scheme") ? 4 : (sScheme.equals("versioned-near-scheme") ? 5 : (sScheme.equals("read-write-backing-map-scheme") ? 12 : (sScheme.equals("versioned-backing-map-scheme") ? 13 : (sScheme.equals("invocation-scheme") ? 14 : (sScheme.equals("proxy-scheme") ? 15 : (sScheme.equals("remote-cache-scheme") ? 16 : (sScheme.equals("remote-invocation-scheme") ? 17 : (sScheme.equals("transactional-scheme") ? 18 : (sScheme.equals("flashjournal-scheme") ? 19 : (sScheme.equals("ramjournal-scheme") ? 20 : (sScheme.equals("paged-topic-scheme") ? 21 : 0))))))))))))))))))));
    }

    public static boolean isPutAllOptimized(Map map) {
        if (map instanceof SafeHashMap || map instanceof HashMap) {
            return false;
        }
        if (map instanceof ReadWriteBackingMap) {
            ReadWriteBackingMap mapRW = (ReadWriteBackingMap)map;
            return mapRW.isWriteThrough() || DefaultConfigurableCacheFactory.isPutAllOptimized(mapRW.getInternalCache());
        }
        return true;
    }

    public static boolean isCanonicalKeySupported(Map map) {
        return map instanceof ConfigurableCacheMap;
    }

    protected static long getRequestTimeout(XmlElement xmlScheme) {
        String sTimeout;
        switch (DefaultConfigurableCacheFactory.translateStandardSchemeType(xmlScheme.getName())) {
            case 16: 
            case 17: {
                sTimeout = xmlScheme.getSafeElement("initiator-config/outgoing-message-handler/request-timeout").getString();
                break;
            }
            default: {
                sTimeout = xmlScheme.getSafeElement("request-timeout").getString();
            }
        }
        return sTimeout.isEmpty() ? -1L : XmlHelper.parseTime(sTimeout);
    }

    private static boolean isPartitioned(String sPartitioned, int nSchemeType) {
        if (sPartitioned.length() == 0) {
            switch (nSchemeType) {
                case 19: 
                case 20: {
                    return true;
                }
            }
            return false;
        }
        if (sPartitioned.equals("observable")) {
            return true;
        }
        Boolean BPartitioned = (Boolean)XmlHelper.convert(sPartitioned, 1);
        if (BPartitioned == null) {
            throw new IllegalArgumentException("Invalid \"partitioned\" value: \"" + sPartitioned + "\"");
        }
        return BPartitioned;
    }

    protected boolean isSerializerCompatible(Service serviceThis, Service serviceThat) {
        return ExternalizableHelper.isSerializerCompatible(serviceThis.getSerializer(), serviceThat.getSerializer());
    }

    protected void configureInterceptors(XmlElement xmlConfig) {
        String sServiceName;
        XmlElement xmlGlobalIncptrs = xmlConfig.getElement("interceptors");
        if (xmlGlobalIncptrs != null) {
            Iterator iterInterceptor = xmlGlobalIncptrs.getElements("interceptor");
            while (iterInterceptor.hasNext()) {
                XmlElement xmlInterceptor = (XmlElement)iterInterceptor.next();
                this.registerInterceptor(xmlInterceptor, "", "");
            }
        }
        Iterator iter = xmlConfig.getSafeElement("caching-scheme-mapping").getElements("cache-mapping");
        while (iter.hasNext()) {
            XmlElement xmlMapping = (XmlElement)iter.next();
            XmlElement xmlInterceptors = xmlMapping.getElement("interceptors");
            if (xmlInterceptors == null) continue;
            XmlElement xmlScheme = this.findScheme(xmlMapping.getSafeElement("scheme-name").getString());
            sServiceName = xmlScheme.getSafeElement("service-name").getString(null);
            String sCacheName = xmlMapping.getSafeElement("cache-name").getString(null);
            Iterator iterInterceptor = xmlInterceptors.getElements("interceptor");
            while (iterInterceptor.hasNext()) {
                XmlElement xmlInterceptor = (XmlElement)iterInterceptor.next();
                this.registerInterceptor(xmlInterceptor, sCacheName, sServiceName);
            }
        }
        for (XmlElement xmlScheme : xmlConfig.getSafeElement("caching-schemes").getElementList()) {
            String sSchemeType = xmlScheme.getName();
            XmlElement xmlInterceptors = xmlScheme.getElement("interceptors");
            if (xmlInterceptors == null || DefaultConfigurableCacheFactory.translateStandardSchemeType(sSchemeType) != 3) continue;
            sServiceName = xmlScheme.getSafeElement("service-name").getString();
            Iterator iterInterceptor = xmlInterceptors.getElements("interceptor");
            while (iterInterceptor.hasNext()) {
                XmlElement xmlInterceptor = (XmlElement)iterInterceptor.next();
                this.registerInterceptor(xmlInterceptor, "", sServiceName);
            }
        }
    }

    protected void registerInterceptor(XmlElement xmlInterceptor, String sCacheName, String sServiceName) {
        if (xmlInterceptor == null) {
            return;
        }
        XmlElement xmlClass = xmlInterceptor.getElement("instance");
        XmlElement xmlElement = xmlClass = xmlClass == null ? xmlInterceptor.getElement("class-scheme") : xmlClass;
        if (xmlClass == null) {
            throw new IllegalArgumentException(String.format("Interceptor specified in [cacheName: %s, serviceName: %s] must specify class", sCacheName, sServiceName));
        }
        String sClassName = xmlClass.getSafeElement("class-name").getString();
        NamedEventInterceptorBuilder builder = new NamedEventInterceptorBuilder();
        builder.setCustomBuilder((ParameterizedBuilder<EventInterceptor>)new InstanceBuilder<EventInterceptor>(sClassName, XmlHelper.parseInitParams(xmlClass.getSafeElement("init-params"))));
        RegistrationBehavior behavior = RegistrationBehavior.ALWAYS;
        String sIdentifier = xmlInterceptor.getSafeElement("name").getString();
        if (sIdentifier.length() > 0) {
            builder.setName(sIdentifier);
            behavior = RegistrationBehavior.FAIL;
        }
        builder.setRegistrationBehavior(behavior);
        String sOrder = xmlInterceptor.getSafeElement("order").getString();
        if (sOrder.length() > 0) {
            builder.setOrder(Interceptor.Order.valueOf(sOrder));
        }
        ResolvableParameterList resolver = new ResolvableParameterList();
        if (sCacheName != null && !sCacheName.isEmpty()) {
            resolver.add(new Parameter("cache-name", sCacheName));
        }
        if (sServiceName != null && !sServiceName.isEmpty()) {
            resolver.add(new Parameter("service-name", sServiceName));
        }
        NamedEventInterceptor interceptor = builder.realize(resolver, this.getConfigClassLoader(), null);
        this.getInterceptorRegistry().registerEventInterceptor(interceptor);
    }

    protected void register(NamedCache cache, String sContext) {
        MBeanHelper.registerCacheMBean(cache, sContext);
    }

    protected void register(CacheService service, String sCacheName, String sContext, Map map) {
        MBeanHelper.registerCacheMBean(service, sCacheName, sContext, map);
    }

    protected void unregister(CacheService service, String sCacheName) {
        MBeanHelper.unregisterCacheMBean(service, sCacheName, "tier=back");
    }

    protected void unregister(String sCacheName, String sContext) {
        MBeanHelper.unregisterCacheMBean(sCacheName, sContext);
    }

    protected void pushCacheContext(String sContext) {
        this.m_tlo.set(sContext);
    }

    protected String popCacheContext() {
        String s = (String)this.m_tlo.get();
        this.m_tlo.set(null);
        return s;
    }

    protected int convertInt(XmlValue xmlValue) {
        return this.convertInt(xmlValue, 0);
    }

    protected int convertInt(XmlValue xmlValue, int nDefault) {
        try {
            String sValue = xmlValue.getString();
            Integer I = (Integer)XmlHelper.convert(sValue, 2);
            return I == null ? nDefault : I;
        }
        catch (RuntimeException e) {
            this.reportConversionError(xmlValue, "int", String.valueOf(nDefault), e);
            return nDefault;
        }
    }

    protected long convertLong(XmlValue xmlValue) {
        long lDefault = 0L;
        try {
            String sValue = xmlValue.getString();
            Long L = (Long)XmlHelper.convert(sValue, 3);
            return L == null ? lDefault : L;
        }
        catch (RuntimeException e) {
            this.reportConversionError(xmlValue, "long", String.valueOf(lDefault), e);
            return lDefault;
        }
    }

    protected double convertDouble(XmlValue xmlValue) {
        double dDefault = 0.0;
        try {
            String sValue = xmlValue.getString();
            Double D = (Double)XmlHelper.convert(sValue, 4);
            return D == null ? dDefault : D;
        }
        catch (RuntimeException e) {
            this.reportConversionError(xmlValue, "double", String.valueOf(dDefault), e);
            return dDefault;
        }
    }

    protected void reportConversionError(XmlValue xmlValue, String sType, String sDefault, RuntimeException e) {
        CacheFactory.log("Error converting " + xmlValue + " to " + sType + "; proceeding with default value of " + sDefault + "\n" + DefaultConfigurableCacheFactory.getStackTrace(e), 2);
    }

    protected class PartitionedBackingMapManager
    extends AbstractBackingMapManager {
        protected CacheInfo m_info;
        protected XmlElement m_xmlScheme;
        protected BackingMapManagerContext m_context;
        protected ClassLoader m_loader;

        protected PartitionedBackingMapManager(CacheInfo info, XmlElement xmlScheme, BackingMapManagerContext context, ClassLoader loader) {
            this.m_info = info;
            this.m_xmlScheme = xmlScheme;
            this.m_context = context;
            this.m_loader = loader;
        }

        @Override
        public Map instantiateBackingMap(String sName) {
            XmlElement xmlScheme = this.m_xmlScheme;
            xmlScheme.addAttribute("partition-name").setString(sName);
            return DefaultConfigurableCacheFactory.this.configureBackingMap(this.m_info, xmlScheme, this.m_context, this.m_loader, null);
        }

        @Override
        public boolean isBackingMapPersistent(String sName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isBackingMapSlidingExpiry(String sName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public StorageAccessAuthorizer getStorageAccessAuthorizer(String sName) {
            return null;
        }

        @Override
        public void releaseBackingMap(String sName, Map map) {
            DefaultConfigurableCacheFactory.this.release(map, null);
        }

        @Override
        public DefaultConfigurableCacheFactory getCacheFactory() {
            return DefaultConfigurableCacheFactory.this;
        }
    }

    public static class CacheInfo {
        protected String m_sCacheName;
        protected String m_sSchemeName;
        protected Map m_mapAttribute;

        public CacheInfo(String sCacheName, String sSchemeName, Map mapAttribute) {
            this.m_sCacheName = sCacheName;
            this.m_sSchemeName = sSchemeName;
            this.m_mapAttribute = mapAttribute;
        }

        public String getCacheName() {
            return this.m_sCacheName;
        }

        public String getSchemeName() {
            return this.m_sSchemeName;
        }

        public Map getAttributes() {
            return this.m_mapAttribute;
        }

        public void replaceAttributes(XmlElement xml) {
            for (XmlElement xmlChild : xml.getElementList()) {
                if (!xmlChild.isEmpty()) {
                    String sText = xmlChild.getString();
                    int ofStart = sText.indexOf(123);
                    int ofEnd = -1;
                    boolean fReplace = false;
                    StringBuffer sbTextNew = new StringBuffer();
                    while (ofStart >= 0) {
                        String sValue;
                        sbTextNew.append(sText.substring(ofEnd + 1, ofStart));
                        ofEnd = sText.indexOf(125, ofStart);
                        if (ofEnd < 0) {
                            CacheFactory.log("Invalid attribute format: " + sText, 1);
                            fReplace = false;
                            break;
                        }
                        String sAttribute = sText.substring(ofStart, ofEnd + 1);
                        String sAttrName = sText.substring(ofStart + 1, ofEnd).trim();
                        String sDefault = null;
                        String[] asToken = sAttrName.split("\\s+");
                        if (asToken.length == 2) {
                            sAttrName = asToken[0];
                            sDefault = asToken[1];
                        }
                        String string = sValue = sAttribute.equals(DefaultConfigurableCacheFactory.CACHE_NAME) ? this.getCacheName() : (String)this.getAttributes().get(sAttrName);
                        if (sValue == null) {
                            if (sDefault == null) {
                                if (!(sAttribute.equals(DefaultConfigurableCacheFactory.CLASS_LOADER) || sAttribute.equals(DefaultConfigurableCacheFactory.MGR_CONTEXT) || sAttribute.equals(DefaultConfigurableCacheFactory.SCHEME_REF) || sAttribute.equals(DefaultConfigurableCacheFactory.CACHE_REF))) {
                                    CacheFactory.log("Missing parameter definition: " + sAttribute + " for cache \"" + this.getCacheName() + '\"', 2);
                                }
                                fReplace = false;
                                break;
                            }
                            sValue = sDefault;
                        }
                        sbTextNew.append(sValue);
                        fReplace = true;
                        ofStart = sText.indexOf(123, ofEnd);
                    }
                    if (fReplace) {
                        sbTextNew.append(sText.substring(ofEnd + 1));
                        xmlChild.setString(sbTextNew.toString());
                    }
                }
                this.replaceAttributes(xmlChild);
            }
        }

        public CacheInfo getSyntheticInfo(String sSuffix) {
            return new CacheInfo(this.getCacheName() + sSuffix, null, this.getAttributes());
        }
    }

    public class Manager
    extends AbstractBackingMapManager {
        protected Map m_mapBackingMap;
        protected Map m_mapBackingMapListeners;

        @Override
        public void init(BackingMapManagerContext context) {
            super.init(context);
            this.m_mapBackingMap = new HashMap();
            this.m_mapBackingMapListeners = new IdentityHashMap();
        }

        @Override
        public Map instantiateBackingMap(String sName) {
            CacheInfo infoCache = DefaultConfigurableCacheFactory.this.findSchemeMapping(sName);
            XmlElement xmlScheme = DefaultConfigurableCacheFactory.this.resolveScheme(infoCache);
            xmlScheme.addAttribute("tier").setString("back");
            DefaultConfigurableCacheFactory.this.pushCacheContext("tier=back");
            Map map = DefaultConfigurableCacheFactory.this.configureBackingMap(infoCache, xmlScheme, this.getContext(), null, this.m_mapBackingMapListeners);
            this.setBackingMap(sName, map);
            return map;
        }

        @Override
        public boolean isBackingMapPersistent(String sName) {
            CacheInfo infoCache = DefaultConfigurableCacheFactory.this.findSchemeMapping(sName);
            XmlElement xmlScheme = DefaultConfigurableCacheFactory.this.resolveScheme(infoCache);
            return !xmlScheme.getSafeElement("transient").getBoolean(true);
        }

        @Override
        public boolean isBackingMapSlidingExpiry(String sName) {
            CacheInfo infoCache = DefaultConfigurableCacheFactory.this.findSchemeMapping(sName);
            XmlElement xmlScheme = DefaultConfigurableCacheFactory.this.resolveScheme(infoCache);
            return !xmlScheme.getSafeElement("sliding-expiry").getBoolean();
        }

        @Override
        public StorageAccessAuthorizer getStorageAccessAuthorizer(String sName) {
            return null;
        }

        @Override
        public void releaseBackingMap(String sName, Map map) {
            DefaultConfigurableCacheFactory.this.unregister(this.getContext().getCacheService(), sName);
            DefaultConfigurableCacheFactory.this.release(map, this.m_mapBackingMapListeners);
            this.setBackingMap(sName, null);
        }

        public Map getBackingMap(String sName) {
            return this.m_mapBackingMap == null ? null : (Map)this.m_mapBackingMap.get(sName);
        }

        protected void setBackingMap(String sName, Map map) {
            if (map != null && this.getBackingMap(sName) != null) {
                throw new IllegalArgumentException("BackingMap is not resettable: " + sName);
            }
            this.m_mapBackingMap.put(sName, map);
        }

        @Override
        public DefaultConfigurableCacheFactory getCacheFactory() {
            return DefaultConfigurableCacheFactory.this;
        }
    }
}

