/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.config.Config;
import com.tangosol.net.TcpDatagramSocket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentMap;

public class NonBlockingTcpDatagramSocket
extends TcpDatagramSocket {
    public static final boolean SPLIT = Config.getBoolean("coherence.tcpdatagram.splitsocket", false);

    public NonBlockingTcpDatagramSocket() throws SocketException {
        this(new InetSocketAddress(0));
    }

    public NonBlockingTcpDatagramSocket(SocketAddress addr) throws SocketException {
        this(new Impl());
        if (addr != null) {
            this.bind(addr);
        }
    }

    public NonBlockingTcpDatagramSocket(int nPort) throws SocketException {
        this(nPort, null);
    }

    public NonBlockingTcpDatagramSocket(int nPort, InetAddress addr) throws SocketException {
        this(new InetSocketAddress(addr, nPort));
    }

    public NonBlockingTcpDatagramSocket(SocketProvider provider) throws SocketException {
        this(new Impl(provider));
    }

    protected NonBlockingTcpDatagramSocket(Impl impl) {
        super(impl);
    }

    public static class Impl
    extends TcpDatagramSocket.Impl {
        public Impl() throws SocketException {
        }

        public Impl(SocketProvider provider) throws SocketException {
            super(provider);
        }

        @Override
        protected boolean onConnectionHeader(TcpDatagramSocket.Impl.ConnectionStatus status, SocketChannel chan) throws IOException {
            ConcurrentMap map;
            TcpDatagramSocket.Impl.Connection conn;
            boolean fEOS = super.onConnectionHeader(status, chan);
            if (!SPLIT && status.m_state == 4 && (conn = (TcpDatagramSocket.Impl.Connection)(map = this.m_mapConnectionsOut).get(status.m_addr)) == null && map.putIfAbsent(status.m_addr, conn = this.makeConnection(chan)) == null) {
                status.m_connection = conn;
            }
            return fEOS;
        }

        protected TcpDatagramSocket.Impl.Connection makeConnection(SocketChannel chan) throws IOException {
            int nPort = this.f_socket.socket().getLocalPort();
            ByteBuffer buff = ByteBuffer.allocate(16);
            buff.putInt(232718554);
            buff.putInt(this.m_nPacketMagic);
            buff.putInt(this.m_nPacketMagicMask);
            buff.putInt(nPort);
            buff.flip();
            return new NonBlockingConnection(chan, buff);
        }

        @Override
        protected TcpDatagramSocket.Impl.Connection makeConnection(SocketAddress addr) throws IOException {
            NonBlockingConnection conn = (NonBlockingConnection)this.makeConnection(this.m_provider.openSocketChannel());
            this.configureSocket(conn.m_socket);
            conn.m_channel.configureBlocking(false);
            if (conn.m_channel.connect(addr)) {
                TcpDatagramSocket.Impl.ConnectionStatus status = new TcpDatagramSocket.Impl.ConnectionStatus();
                status.m_connection = conn;
                this.scheduleRegistration(conn.m_channel, status);
            }
            return conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void send(DatagramPacket packet) throws IOException {
            SocketChannel chan;
            NonBlockingConnection conn;
            SocketAddress addr = packet.getSocketAddress();
            try {
                conn = (NonBlockingConnection)this.ensureConnection(addr);
                chan = conn.m_channel;
            }
            catch (IOException e) {
                this.logException(packet.getSocketAddress(), e);
                return;
            }
            SocketChannel socketChannel = chan;
            synchronized (socketChannel) {
                try {
                    ByteBuffer[] aBuff;
                    int cbRemain;
                    if (chan.isConnectionPending()) {
                        if (chan.finishConnect()) {
                            TcpDatagramSocket.Impl.ConnectionStatus status = new TcpDatagramSocket.Impl.ConnectionStatus();
                            status.m_connection = conn;
                            this.scheduleRegistration(conn.m_channel, status);
                        } else {
                            return;
                        }
                    }
                    int n = cbRemain = (aBuff = conn.m_pending)[1] == null ? 0 : aBuff[0].remaining() + aBuff[1].remaining();
                    if (cbRemain == 0 || chan.write(aBuff) == (long)cbRemain) {
                        byte[] ab = packet.getData();
                        int cb = packet.getLength();
                        ByteBuffer buffPacket = ByteBuffer.wrap(ab, packet.getOffset(), cb).slice();
                        long cbTotal = cb;
                        switch (this.m_nPacketMagicMask) {
                            case -65536: {
                                if (cb > 65535) {
                                    throw new IOException("packet length exceeds 2^16");
                                }
                                buffPacket.put((byte)(cb >>> 8)).put((byte)cb).position(0);
                                break;
                            }
                            case -16: {
                                buffPacket.put(3, (byte)(conn.m_cTxPacket << 4 | buffPacket.get(3) & 0xF));
                            }
                            case -256: {
                                if (cb > 0xFFFFFF) {
                                    throw new IOException("packet length exceeds 2^24");
                                }
                                buffPacket.put((byte)(cb >> 16)).put((byte)(cb >> 8)).put((byte)cb).position(0);
                                break;
                            }
                            case -1: {
                                buffPacket.putInt(cb).position(0);
                                break;
                            }
                            default: {
                                ByteBuffer buffHead = aBuff[0];
                                buffHead.clear();
                                buffHead.putInt(cb);
                                buffHead.flip();
                                cbTotal += 4L;
                            }
                        }
                        aBuff[1] = buffPacket;
                        long cbWrite = chan.write(aBuff);
                        if (cbWrite > 0L) {
                            ++conn.m_cTxPacket;
                        }
                        if (cbWrite == 0L || cbWrite == cbTotal) {
                            aBuff[1] = null;
                            return;
                        }
                        ByteBuffer buff = ByteBuffer.allocate(buffPacket.remaining());
                        buff.put(buffPacket);
                        buff.flip();
                        aBuff[1] = buff;
                    }
                }
                catch (IOException e) {
                    this.logException(addr, e);
                    this.closeOutbound(addr);
                }
            }
        }

        static class NonBlockingConnection
        extends TcpDatagramSocket.Impl.Connection {
            final SocketChannel m_channel;
            final ByteBuffer[] m_pending = new ByteBuffer[]{(ByteBuffer)ByteBuffer.allocate(4).flip(), null};

            public NonBlockingConnection(SocketChannel chan, ByteBuffer buff) {
                super(chan.socket());
                this.m_channel = chan;
                this.m_pending[1] = buff;
            }
        }
    }
}

