/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.coherence.config.Config;
import com.tangosol.util.Base;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class Ping {
    public static void main(String[] asArg) throws Exception {
        if (asArg.length < 1 || asArg.length > 2) {
            System.err.println("usage: com.tangosol.net.Ping [source ip] <destination ip>");
            return;
        }
        String sSrc = asArg.length == 1 ? null : asArg[0];
        String sDst = asArg.length == 1 ? asArg[0] : asArg[1];
        long cMillisInterval = Base.parseTime(Config.getProperty("coherence.net.ping.interval", "1s"));
        int cMillisTimeout = (int)Base.parseTime(Config.getProperty("coherence.net.ping.timeout", "5s"));
        NetworkInterface nicSrc = null;
        if (sSrc != null) {
            nicSrc = NetworkInterface.getByInetAddress(InetAddress.getByName(sSrc));
            if (nicSrc == null) {
                System.err.println(sSrc + " is not a local address");
                System.exit(1);
            }
            Enumeration<InetAddress> iterIP = nicSrc.getInetAddresses();
            iterIP.nextElement();
            if (iterIP.hasMoreElements()) {
                System.err.println(sSrc + " is associated with network interface " + nicSrc.getDisplayName() + " which has multiple IPs, this may prevent Pings from being routed properly.\nNote: Coherence will detect and automatically avoid this issue.");
            }
        }
        InetAddress addrDst = InetAddress.getByName(sDst);
        while (true) {
            long ldtStart = System.nanoTime();
            if (addrDst.isReachable(nicSrc, 0, cMillisTimeout)) {
                long ldtDelta = System.nanoTime() - ldtStart;
                System.out.println("Response received from " + addrDst + " after " + (double)ldtDelta / 1000000.0 + "ms");
                Blocking.sleep(cMillisInterval);
                continue;
            }
            System.out.println("Request timeout for " + addrDst + " after " + cMillisTimeout + "ms; using java.net.InetAddress.isReachable");
            if ((long)cMillisTimeout >= cMillisInterval) continue;
            Blocking.sleep(cMillisInterval - (long)cMillisTimeout);
        }
    }
}

