/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.AbstractCacheLoader;
import com.tangosol.net.cache.CacheStore;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractCacheStore<K, V>
extends AbstractCacheLoader<K, V>
implements CacheStore<K, V> {
    @Override
    public void store(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeAll(Map<? extends K, ? extends V> mapEntries) {
        boolean fRemove = true;
        Iterator<Map.Entry<K, V>> iter = mapEntries.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, V> entry = iter.next();
            this.store(entry.getKey(), entry.getValue());
            if (!fRemove) continue;
            try {
                iter.remove();
            }
            catch (UnsupportedOperationException e) {
                fRemove = false;
            }
        }
    }

    @Override
    public void erase(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void eraseAll(Collection<? extends K> colKeys) {
        boolean fRemove = true;
        Iterator<K> iter = colKeys.iterator();
        while (iter.hasNext()) {
            this.erase(iter.next());
            if (!fRemove) continue;
            try {
                iter.remove();
            }
            catch (UnsupportedOperationException e) {
                fRemove = false;
            }
        }
    }
}

