/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.BinaryMemoryCalculator;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.util.Base;
import com.tangosol.util.BitHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.LiteSet;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SparseArray;
import java.lang.reflect.Array;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class OldCache
extends SafeHashMap
implements ObservableMap,
ConfigurableCacheMap {
    public static final int DEFAULT_UNITS = 1000;
    public static final int DEFAULT_EXPIRE = 3600000;
    public static final int DEFAULT_FLUSH = 60000;
    public static final double DEFAULT_PRUNE = 0.8;
    public static final int EVICTION_POLICY_HYBRID = 0;
    public static final int EVICTION_POLICY_LRU = 1;
    public static final int EVICTION_POLICY_LFU = 2;
    public static final int EVICTION_POLICY_EXTERNAL = 3;
    public static final int UNIT_CALCULATOR_FIXED = 0;
    public static final int UNIT_CALCULATOR_BINARY = 1;
    public static final int UNIT_CALCULATOR_EXTERNAL = 2;
    public static final EvictionPolicy INSTANCE_HYBRID = new InternalEvictionPolicy(0);
    public static final EvictionPolicy INSTANCE_LRU = new InternalEvictionPolicy(1);
    public static final EvictionPolicy INSTANCE_LFU = new InternalEvictionPolicy(2);
    public static final UnitCalculator INSTANCE_FIXED = InternalUnitCalculator.INSTANCE;
    public static final UnitCalculator INSTANCE_BINARY = BinaryMemoryCalculator.INSTANCE;
    protected volatile long m_cCurUnits;
    protected long m_cMaxUnits;
    protected double m_dflPruneLevel;
    protected long m_cPruneUnits;
    protected int m_nUnitFactor = 1;
    protected int m_cExpiryDelay;
    protected volatile long m_lNextFlush = Long.MAX_VALUE;
    protected SimpleCacheStatistics m_stats = new SimpleCacheStatistics();
    protected MapListenerSupport m_listenerSupport;
    protected int m_nEvictionType = 0;
    protected ConfigurableCacheMap.EvictionPolicy m_policy;
    protected int m_nCalculatorType;
    protected ConfigurableCacheMap.UnitCalculator m_calculator;
    protected LongArray m_arrayExpiry = new SparseArray();
    protected long m_lLastPrune = this.getCurrentTimeMillis();
    protected int m_cAvgTouch;
    protected ListIterator m_iterEvict;
    protected boolean m_fIncrementalEvict = true;
    protected ConfigurableCacheMap.EvictionApprover m_apprvrEvict;
    protected boolean m_fOptimizeGetTime;

    public OldCache() {
        this(1000);
    }

    public OldCache(int cUnits) {
        this(cUnits, 3600000);
    }

    public OldCache(int cUnits, int cExpiryMillis) {
        this(cUnits, cExpiryMillis, 0.8);
    }

    public OldCache(int cUnits, int cExpiryMillis, double dflPruneLevel) {
        this.m_dflPruneLevel = Math.min(Math.max(dflPruneLevel, 0.0), 0.99);
        this.setHighUnits(cUnits);
        this.m_cExpiryDelay = Math.max(cExpiryMillis, 0);
    }

    @Override
    public int size() {
        this.evict();
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        this.evict();
        return this.getEntryInternal(key) != null;
    }

    @Override
    public Object get(Object oKey) {
        SafeHashMap.Entry entry = this.getEntry(oKey);
        return entry == null ? null : entry.getValue();
    }

    public SafeHashMap.Entry getEntry(Object oKey) {
        this.evict();
        Entry entry = (Entry)this.getEntryInternal(oKey);
        if (entry == null) {
            this.m_stats.registerMiss();
        } else {
            this.m_stats.registerHit();
            entry.touch();
        }
        return entry;
    }

    @Override
    public ConfigurableCacheMap.Entry getCacheEntry(Object oKey) {
        return (ConfigurableCacheMap.Entry)((Object)this.getEntry(oKey));
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object oKey, Object oValue, long cMillis) {
        Object oOrig;
        this.evict();
        OldCache oldCache = this;
        synchronized (oldCache) {
            Entry entry = (Entry)this.getEntryInternal(oKey);
            if (entry == null) {
                oOrig = super.put(oKey, oValue);
            } else {
                entry.touch();
                oOrig = entry.setValue(oValue);
            }
            if (cMillis != 0L) {
                if (entry == null) {
                    entry = (Entry)this.getEntryInternal(oKey);
                }
                if (entry != null) {
                    entry.setExpiryMillis(cMillis > 0L ? this.getCurrentTimeMillis() + cMillis : 0L);
                }
            }
            if (this.m_cCurUnits > this.m_cMaxUnits) {
                this.prune();
                if (this.getEntryInternal(oKey) == null) {
                    oOrig = null;
                }
            }
        }
        this.m_stats.registerPut(0L);
        return oOrig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object oKey) {
        this.evict();
        OldCache oldCache = this;
        synchronized (oldCache) {
            Entry entry = (Entry)this.getEntryInternal(oKey);
            if (entry == null) {
                return null;
            }
            entry.discard();
            this.removeEntryInternal(entry);
            return entry.getValue();
        }
    }

    @Override
    public synchronized void clear() {
        while (true) {
            try {
                for (Entry entry : this.entrySet()) {
                    entry.discard();
                }
                if (this.m_cCurUnits != 0L) {
                    Base.err("Invalid LocalCache unit count after clear: " + this.m_cCurUnits);
                    this.m_cCurUnits = 0L;
                }
                if (this.m_arrayExpiry.isEmpty()) break;
                Base.err("LocalCache still contained " + this.m_arrayExpiry.getSize() + " expiry items after clear.");
                this.m_arrayExpiry.clear();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        super.clear();
        this.m_iterEvict = null;
        this.resetHitStatistics();
    }

    @Override
    public synchronized void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, oKey, fLite);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, filter, fLite);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    public Map getAll(Collection colKeys) {
        HashMap map = new HashMap();
        for (Object oKey : colKeys) {
            Entry entry = (Entry)this.getEntry(oKey);
            if (entry == null) continue;
            map.put(oKey, entry.getValue());
        }
        return map;
    }

    @Override
    public void evict(Object oKey) {
        Entry entry = (Entry)this.getEntryInternal(oKey);
        if (entry != null) {
            this.removeEvicted(entry);
        }
    }

    @Override
    public void evictAll(Collection colKeys) {
        for (Object oKey : colKeys) {
            Entry entry = (Entry)this.getEntryInternal(oKey);
            if (entry == null) continue;
            this.removeEvicted(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict() {
        long lCurrent = this.getCurrentTimeMillis();
        if (lCurrent > this.m_lNextFlush) {
            OldCache oldCache = this;
            synchronized (oldCache) {
                if (lCurrent > this.m_lNextFlush && this.m_apprvrEvict != ConfigurableCacheMap.EvictionApprover.DISAPPROVER) {
                    this.m_lNextFlush = Long.MAX_VALUE;
                    try {
                        LongArray arrayExpiry;
                        Set setEvict = null;
                        LongArray longArray = arrayExpiry = this.m_arrayExpiry;
                        synchronized (longArray) {
                            if (!arrayExpiry.isEmpty() && lCurrent > arrayExpiry.getFirstIndex()) {
                                Set setKeys;
                                Iterator iterKeySets = arrayExpiry.iterator();
                                while (iterKeySets.hasNext() && (setKeys = (Set)iterKeySets.next()) != null && lCurrent > iterKeySets.getIndex()) {
                                    iterKeySets.remove();
                                    if (setEvict == null) {
                                        setEvict = setKeys;
                                        continue;
                                    }
                                    setEvict.addAll(setKeys);
                                }
                            }
                        }
                        if (setEvict != null) {
                            this.evictAll(setEvict);
                        }
                    }
                    finally {
                        this.m_lNextFlush = this.getCurrentTimeMillis() + 256L;
                    }
                }
            }
        }
    }

    public CacheStatistics getCacheStatistics() {
        return this.m_stats;
    }

    @Override
    protected SafeHashMap.EntrySet instantiateEntrySet() {
        return new EntrySet();
    }

    @Override
    protected SafeHashMap.KeySet instantiateKeySet() {
        return new KeySet();
    }

    @Override
    protected SafeHashMap.ValuesCollection instantiateValuesCollection() {
        return new ValuesCollection();
    }

    @Override
    public synchronized String toString() {
        while (true) {
            try {
                StringBuilder sb = new StringBuilder("Cache {\n");
                int i = 0;
                for (Map.Entry entry : this.entrySet()) {
                    sb.append('[').append(i++).append("]: ").append(entry).append('\n');
                }
                sb.append('}');
                return sb.toString();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    @Override
    public int getUnits() {
        return OldCache.toExternalUnits(this.m_cCurUnits, this.getUnitFactor());
    }

    @Override
    public int getHighUnits() {
        return OldCache.toExternalUnits(this.m_cMaxUnits, this.getUnitFactor());
    }

    @Override
    public synchronized void setHighUnits(int cMax) {
        long cUnits;
        this.m_cMaxUnits = cUnits = OldCache.toInternalUnits(cMax, this.getUnitFactor());
        long l = this.m_cPruneUnits = cUnits == Long.MAX_VALUE ? cUnits : (long)(this.m_dflPruneLevel * (double)cUnits);
        if (this.m_cCurUnits > cUnits) {
            this.prune();
        }
    }

    @Override
    public int getLowUnits() {
        return OldCache.toExternalUnits(this.m_cPruneUnits, this.getUnitFactor());
    }

    @Override
    public synchronized void setLowUnits(int cMin) {
        long cMax;
        long cUnits = OldCache.toInternalUnits(cMin, this.getUnitFactor());
        if (cUnits >= (cMax = this.m_cMaxUnits)) {
            cUnits = (long)(this.m_dflPruneLevel * (double)cMax);
        } else if (cMax == Long.MAX_VALUE) {
            cUnits = cMax;
        }
        this.m_cPruneUnits = cUnits;
    }

    @Override
    public int getUnitFactor() {
        return this.m_nUnitFactor;
    }

    @Override
    public void setUnitFactor(int nFactor) {
        if (nFactor == this.m_nUnitFactor) {
            return;
        }
        if (nFactor < 1) {
            throw new IllegalArgumentException("unit factor must be >= 1");
        }
        if (this.m_cCurUnits > 0L) {
            throw new IllegalStateException("unit factor cannot be set after the cache has been populated");
        }
        if (this.m_nUnitFactor == 1 && this.m_cMaxUnits != Long.MAX_VALUE) {
            this.m_cMaxUnits *= (long)nFactor;
            this.m_cPruneUnits *= (long)nFactor;
        }
        this.m_nUnitFactor = nFactor;
    }

    protected static long toInternalUnits(int cUnits, int nFactor) {
        return cUnits <= 0 || cUnits == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)cUnits * (long)nFactor;
    }

    protected static int toExternalUnits(long cUnits, int nFactor) {
        if (cUnits == 0L || cUnits == Long.MAX_VALUE) {
            return 0;
        }
        if (nFactor > 1) {
            cUnits = (cUnits + (long)nFactor - 1L) / (long)nFactor;
        }
        return cUnits > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)cUnits;
    }

    public int getEvictionType() {
        return this.m_nEvictionType;
    }

    public synchronized void setEvictionType(int nType) {
        this.configureEviction(nType, null);
    }

    @Override
    public ConfigurableCacheMap.EvictionPolicy getEvictionPolicy() {
        ConfigurableCacheMap.EvictionPolicy policy = this.m_policy;
        if (policy == null) {
            switch (this.getEvictionType()) {
                default: {
                    policy = INSTANCE_HYBRID;
                    break;
                }
                case 1: {
                    policy = INSTANCE_LRU;
                    break;
                }
                case 2: {
                    policy = INSTANCE_LFU;
                }
            }
        }
        return policy;
    }

    @Override
    public synchronized void setEvictionPolicy(ConfigurableCacheMap.EvictionPolicy policy) {
        int nType = policy == null ? 0 : 3;
        this.configureEviction(nType, policy);
    }

    @Override
    public ConfigurableCacheMap.EvictionApprover getEvictionApprover() {
        return this.m_apprvrEvict;
    }

    @Override
    public synchronized void setEvictionApprover(ConfigurableCacheMap.EvictionApprover approver) {
        this.m_apprvrEvict = approver;
    }

    public int getUnitCalculatorType() {
        return this.m_nCalculatorType;
    }

    public void setUnitCalculatorType(int nType) {
        this.configureUnitCalculator(nType, null);
    }

    @Override
    public ConfigurableCacheMap.UnitCalculator getUnitCalculator() {
        ConfigurableCacheMap.UnitCalculator calculator = this.m_calculator;
        if (calculator == null) {
            calculator = this.getUnitCalculatorType() == 1 ? BinaryMemoryCalculator.INSTANCE : InternalUnitCalculator.INSTANCE;
        }
        return calculator;
    }

    @Override
    public void setUnitCalculator(ConfigurableCacheMap.UnitCalculator calculator) {
        int nType = calculator == null ? 0 : 2;
        this.configureUnitCalculator(nType, calculator);
    }

    @Override
    public int getExpiryDelay() {
        return this.m_cExpiryDelay;
    }

    @Override
    public void setExpiryDelay(int cMillis) {
        this.m_cExpiryDelay = Math.max(cMillis, 0);
    }

    @Override
    public long getNextExpiryTime() {
        LongArray arrayExpiry = this.m_arrayExpiry;
        return arrayExpiry.isEmpty() ? 0L : arrayExpiry.getFirstIndex();
    }

    public long getFlushTime() {
        return 0L;
    }

    public void setFlushTime(long lMillis) {
    }

    public boolean isIncrementalEviction() {
        return this.m_fIncrementalEvict;
    }

    public synchronized void setIncrementalEviction(boolean fIncrementalEvict) {
        this.m_fIncrementalEvict = fIncrementalEvict;
        if (!fIncrementalEvict) {
            this.m_iterEvict = null;
        }
    }

    public long getCacheHits() {
        return this.m_stats.getCacheHits();
    }

    public long getCacheMisses() {
        return this.m_stats.getCacheMisses();
    }

    public double getHitProbability() {
        return this.m_stats.getHitProbability();
    }

    public void resetHitStatistics() {
        this.m_stats.resetHitStatistics();
    }

    protected synchronized void configureEviction(int nType, ConfigurableCacheMap.EvictionPolicy policy) {
        switch (nType) {
            case 0: 
            case 1: 
            case 2: {
                policy = null;
                break;
            }
            case 3: {
                if (policy == null) {
                    nType = 0;
                    break;
                }
                if (!(policy instanceof InternalEvictionPolicy)) break;
                nType = ((InternalEvictionPolicy)policy).getEvictionType();
                policy = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown eviction type: " + nType);
            }
        }
        ConfigurableCacheMap.EvictionPolicy policyPrev = this.m_policy;
        if (policyPrev instanceof MapListener) {
            this.removeMapListener((MapListener)((Object)policyPrev));
        }
        this.m_nEvictionType = nType;
        this.m_policy = policy;
        this.m_iterEvict = null;
        if (policy instanceof MapListener) {
            this.addMapListener((MapListener)((Object)policy));
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected synchronized void configureUnitCalculator(int nType, ConfigurableCacheMap.UnitCalculator calculator) {
        switch (nType) {
            case 2: {
                if (calculator != null) ** GOTO lbl6
                nType = 0;
                ** GOTO lbl16
lbl6:
                // 1 sources

                if (calculator != InternalUnitCalculator.INSTANCE) ** GOTO lbl10
                nType = 0;
                calculator = null;
                ** GOTO lbl16
lbl10:
                // 1 sources

                if (calculator == BinaryMemoryCalculator.INSTANCE) {
                    nType = 1;
                    calculator = null;
                } else {
                    if (2 != this.m_nCalculatorType || !Base.equals(calculator, this.m_calculator)) break;
                    return;
                }
            }
lbl16:
            // 4 sources

            case 0: 
            case 1: {
                if (nType != this.m_nCalculatorType) break;
                return;
            }
            default: {
                throw new IllegalArgumentException("unknown unit calculator type: " + nType);
            }
        }
        this.m_nCalculatorType = nType;
        this.m_calculator = calculator;
        for (Entry entry : this.entrySet()) {
            cUnits = entry.calculateUnits(entry.getValue());
            entry.setUnits(cUnits);
        }
    }

    protected SafeHashMap.Entry getEntryInternal(Object oKey) {
        Entry entry = (Entry)super.getEntryInternal(oKey);
        if (entry != null && this.removeIfExpired(entry)) {
            entry = null;
        }
        return entry;
    }

    protected boolean removeExpired(Entry entry, boolean fRemoveInternal) {
        return this.removeEvicted(entry);
    }

    protected synchronized boolean removeEvicted(Entry entry) {
        ConfigurableCacheMap.EvictionApprover appr = this.m_apprvrEvict;
        if (appr == null || appr.isEvictable(entry)) {
            entry.discard();
            this.removeEntryInternal(entry);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeIfExpired(Entry entry) {
        if (entry.isExpired() && this.m_apprvrEvict != ConfigurableCacheMap.EvictionApprover.DISAPPROVER) {
            OldCache oldCache = this;
            synchronized (oldCache) {
                if (entry.isExpired()) {
                    return this.removeEvicted(entry);
                }
            }
        }
        return false;
    }

    protected synchronized void adjustUnits(int cDelta) {
        this.m_cCurUnits += (long)cDelta;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void prune() {
        long cMax = this.m_cMaxUnits;
        if (this.m_cCurUnits <= cMax || this.m_apprvrEvict == ConfigurableCacheMap.EvictionApprover.DISAPPROVER) {
            return;
        }
        this.evict();
        if (this.m_cCurUnits < cMax) {
            return;
        }
        long ldtStart = this.getCurrentTimeMillis();
        int nType = this.getEvictionType();
        if (nType == 3) {
            this.getEvictionPolicy().requestEviction(this.getLowUnits());
        } else {
            boolean fLRU;
            if (this.m_iterEvict != null) {
                this.pruneIncremental();
                if (this.m_cCurUnits < cMax) {
                    this.m_stats.registerIncrementalCachePrune(ldtStart);
                    return;
                }
            }
            long cTarget = this.m_cPruneUnits;
            ArrayList listEvict = null;
            long cRemEvict = this.m_cCurUnits - cTarget;
            boolean bl = fLRU = nType == 1;
            if (this.isIncrementalEviction()) {
                double dflEstPct = Math.max(0.01, Math.min(1.0, 1.0 - (double)cTarget / (double)(cMax + 1L) + 0.005));
                listEvict = new ArrayList((int)(dflEstPct * (double)super.size()) + 10);
            }
            block0 : switch (nType) {
                default: {
                    int i;
                    void var15_19;
                    int cLists = 11;
                    ArrayList[] alist = new ArrayList[cLists];
                    int cGuess = super.size() >>> 4;
                    boolean bl2 = false;
                    while (var15_19 < cLists) {
                        alist[var15_19] = new ArrayList(cGuess);
                        ++var15_19;
                    }
                    CacheStatistics cacheStatistics = this.getCacheStatistics();
                    this.m_cAvgTouch = (int)((cacheStatistics.getTotalPuts() + cacheStatistics.getTotalGets()) / (((long)super.size() + 1L) * (cacheStatistics.getCachePrunes() + 1L)));
                    AtomicReferenceArray aeBucket = this.m_aeBucket;
                    for (i = 0; i < aeBucket.length(); ++i) {
                        for (Object entry = (Entry)aeBucket.get(i); entry != null; entry = ((Entry)entry).getNext()) {
                            alist[((Entry)entry).getPriority()].add(entry);
                        }
                    }
                    for (i = cLists - 1; i >= 0; --i) {
                        for (Object entry : alist[i]) {
                            if ((cRemEvict -= (long)this.queueForEviction((Entry)entry, listEvict)) > 0L) continue;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: 
                case 2: {
                    SparseArray<Object> array = new SparseArray<Object>();
                    AtomicReferenceArray aeBucket = this.m_aeBucket;
                    for (int i = 0; i < aeBucket.length(); ++i) {
                        void var15_21;
                        Entry entry = (Entry)aeBucket.get(i);
                        while (var15_21 != null) {
                            long lOrder = fLRU ? var15_21.getLastTouchMillis() : (long)var15_21.getTouchCount();
                            void oPrev = array.set(lOrder, var15_21);
                            if (oPrev != null) {
                                ArrayList<void> list;
                                if (oPrev instanceof List) {
                                    list = (ArrayList<void>)oPrev;
                                } else {
                                    list = new ArrayList<void>();
                                    list.add(oPrev);
                                }
                                list.add(var15_21);
                                array.set(lOrder, list);
                            }
                            Entry entry2 = var15_21.getNext();
                        }
                    }
                    for (Object e : array) {
                        if (e instanceof Entry) {
                            if ((cRemEvict -= (long)this.queueForEviction((Entry)e, listEvict)) > 0L) continue;
                            break block0;
                        }
                        List list = (List)e;
                        for (Object entry : list) {
                            if ((cRemEvict -= (long)this.queueForEviction((Entry)entry, listEvict)) > 0L) continue;
                            break block0;
                        }
                    }
                }
            }
            if (!fLRU) {
                AtomicReferenceArray aeBucket = this.m_aeBucket;
                for (int i = 0; i < aeBucket.length(); ++i) {
                    for (Entry entry = (Entry)aeBucket.get(i); entry != null; entry = entry.getNext()) {
                        entry.resetTouchCount();
                    }
                }
            }
            if (listEvict != null) {
                this.m_iterEvict = listEvict.listIterator();
            }
            this.pruneIncremental();
        }
        this.m_stats.registerCachePrune(ldtStart);
        this.m_lLastPrune = this.getCurrentTimeMillis();
    }

    private int queueForEviction(Entry entry, List listEvict) {
        int cUnits = entry.getUnits();
        if (listEvict == null) {
            if (!this.removeEvicted(entry)) {
                cUnits = 0;
            }
        } else {
            entry.setEvictable(true);
            listEvict.add(entry.getKey());
        }
        return cUnits;
    }

    private void pruneIncremental() {
        ListIterator iterEvict = this.m_iterEvict;
        if (iterEvict != null) {
            long cMaxUnits = this.m_cMaxUnits;
            int cMinEntries = 60;
            while (iterEvict.hasNext()) {
                Entry entry = (Entry)this.getEntryInternal(iterEvict.next());
                iterEvict.set(null);
                if (entry == null || !entry.isEvictable() || !this.removeEvicted(entry) || --cMinEntries > 0 || this.m_cCurUnits >= cMaxUnits) continue;
                return;
            }
            this.m_iterEvict = null;
        }
    }

    protected void checkFlush() {
        this.evict();
    }

    protected MapEvent instantiateMapEvent(int nId, Object oKey, Object oValueOld, Object oValueNew) {
        return new MapEvent<Object, Object>(this, nId, oKey, oValueOld, oValueNew);
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.m_listenerSupport;
    }

    protected boolean hasListeners() {
        return this.m_listenerSupport != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(MapEvent evt) {
        MapListenerSupport listenerSupport = this.getMapListenerSupport();
        if (listenerSupport != null) {
            OldCache oldCache = this;
            synchronized (oldCache) {
                listenerSupport.fireEvent(evt, false);
            }
        }
    }

    public long getCurrentTimeMillis() {
        return this.m_fOptimizeGetTime ? Base.getLastSafeTimeMillis() : Base.getSafeTimeMillis();
    }

    public void setOptimizeGetTime(boolean fOptimize) {
        this.m_fOptimizeGetTime = fOptimize;
    }

    protected SafeHashMap.Entry instantiateEntry() {
        return new Entry();
    }

    public static class InternalUnitCalculator
    implements UnitCalculator {
        public static final InternalUnitCalculator INSTANCE = new InternalUnitCalculator();

        private InternalUnitCalculator() {
        }

        @Override
        public int calculateUnits(Object oKey, Object oValue) {
            return 1;
        }

        @Override
        public String getName() {
            return "Internal-Fixed";
        }
    }

    public static interface UnitCalculator
    extends ConfigurableCacheMap.UnitCalculator {
    }

    public static class InternalEvictionPolicy
    implements EvictionPolicy {
        private int m_nType;

        InternalEvictionPolicy(int nType) {
            this.m_nType = nType;
        }

        @Override
        public void entryTouched(ConfigurableCacheMap.Entry entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void requestEviction(int cMaximum) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            switch (this.m_nType) {
                case 0: {
                    return "Internal-Hybrid";
                }
                case 1: {
                    return "Internal-LRU";
                }
                case 2: {
                    return "Internal-LFU";
                }
            }
            throw new IllegalStateException();
        }

        public int getEvictionType() {
            return this.m_nType;
        }
    }

    public static interface EvictionPolicy
    extends ConfigurableCacheMap.EvictionPolicy {
    }

    public class Entry
    extends SafeHashMap.Entry
    implements ConfigurableCacheMap.Entry {
        private volatile long m_dtCreated;
        private volatile long m_dtLastUse;
        private volatile long m_dtExpiry;
        private int m_cUses;
        private int m_cUnits;
        private boolean m_fEvictable;

        public Entry() {
            this.m_dtLastUse = this.m_dtCreated = OldCache.this.getCurrentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onAdd() {
            OldCache map;
            this.scheduleExpiry();
            int cNewUnits = this.calculateUnits(this.m_oValue);
            OldCache oldCache = map = OldCache.this;
            synchronized (oldCache) {
                int cOldUnits = this.m_cUnits;
                if (cOldUnits == -1) {
                    return;
                }
                if (cNewUnits != cOldUnits) {
                    map.adjustUnits(cNewUnits - cOldUnits);
                    this.m_cUnits = cNewUnits;
                }
            }
            MapListenerSupport support = map.getMapListenerSupport();
            if (support != null && !support.isEmpty()) {
                map.dispatchEvent(map.instantiateMapEvent(1, this.getKey(), null, this.getValue()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object setValue(Object oValue) {
            Object oPrev;
            OldCache map;
            if (this.m_cUnits == -1) {
                super.setValue(oValue);
                return null;
            }
            int cNewUnits = this.calculateUnits(oValue);
            OldCache oldCache = map = OldCache.this;
            synchronized (oldCache) {
                int cOldUnits = this.m_cUnits;
                if (cOldUnits == -1) {
                    super.setValue(oValue);
                    return null;
                }
                if (cNewUnits != cOldUnits) {
                    map.adjustUnits(cNewUnits - cOldUnits);
                    this.m_cUnits = cNewUnits;
                }
                oPrev = super.setValue(oValue);
                this.setEvictable(false);
            }
            this.scheduleExpiry();
            if (map.hasListeners()) {
                map.dispatchEvent(map.instantiateMapEvent(2, this.getKey(), oPrev, oValue));
            }
            return oPrev;
        }

        protected void copyFrom(SafeHashMap.Entry entry) {
            Entry entryThat = (Entry)entry;
            super.copyFrom(entry);
            this.m_dtCreated = entryThat.m_dtCreated;
            this.m_dtLastUse = entryThat.m_dtLastUse;
            this.m_dtExpiry = entryThat.m_dtExpiry;
            this.m_cUses = entryThat.m_cUses;
            this.m_cUnits = entryThat.m_cUnits;
        }

        public int getPriority() {
            Entry entryNext;
            long dtPrune = OldCache.this.m_lLastPrune;
            long dtTouch = this.m_dtLastUse;
            int nScoreLRU = 0;
            if (dtTouch > dtPrune) {
                long dtCurrent = OldCache.this.getCurrentTimeMillis();
                long cMillisDormant = dtCurrent - dtTouch;
                long cMillisWindow = dtCurrent - dtPrune;
                double dflPct = (double)(cMillisWindow - cMillisDormant) / (1.0 + (double)cMillisWindow);
                nScoreLRU = 1 + BitHelper.indexOfMSB((int)(dflPct * dflPct * 64.0));
            }
            int cUses = this.m_cUses;
            int nScoreLFU = 0;
            if (cUses > 0) {
                int cAdj;
                nScoreLFU = 1;
                int cAvg = OldCache.this.m_cAvgTouch;
                if (cUses > cAvg) {
                    ++nScoreLFU;
                }
                if ((cAdj = (cUses << 1) - cAvg) > 0) {
                    nScoreLFU += 1 + Math.min(4, BitHelper.indexOfMSB((int)((double)(cAdj << 3) / (1.0 + (double)cAvg))));
                }
            }
            if ((entryNext = this.getNext()) != null) {
                if (dtTouch > entryNext.m_dtLastUse) {
                    ++nScoreLRU;
                }
                if (cUses > entryNext.m_cUses) {
                    ++nScoreLFU;
                }
            }
            return Math.max(0, 10 - nScoreLRU - nScoreLFU);
        }

        public long getCreatedMillis() {
            return this.m_dtCreated;
        }

        @Override
        public void touch() {
            ++this.m_cUses;
            this.m_dtLastUse = OldCache.this.getCurrentTimeMillis();
            ConfigurableCacheMap.EvictionPolicy policy = OldCache.this.m_policy;
            if (policy != null) {
                policy.entryTouched(this);
            }
        }

        @Override
        public long getLastTouchMillis() {
            return this.m_dtLastUse;
        }

        @Override
        public int getTouchCount() {
            return this.m_cUses;
        }

        protected void resetTouchCount() {
            int cUses = this.m_cUses;
            if (cUses > 0) {
                this.m_cUses = Math.max(1, cUses >>> 4);
            }
        }

        @Override
        public long getExpiryMillis() {
            return this.m_dtExpiry;
        }

        @Override
        public void setExpiryMillis(long lMillis) {
            if (lMillis != 0L || this.m_dtExpiry != 0L) {
                this.registerExpiry(lMillis);
                this.m_dtExpiry = lMillis;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void registerExpiry(long lMillis) {
            LongArray arrayExpiry;
            LongArray longArray = arrayExpiry = OldCache.this.m_arrayExpiry;
            synchronized (longArray) {
                Set<Object> setKeys;
                boolean fWasEmpty = arrayExpiry.isEmpty();
                long lMillisOld = this.m_dtExpiry;
                if (lMillisOld > 0L && (setKeys = (LiteSet<Object>)arrayExpiry.get(lMillisOld &= 0xFFFFFFFFFFFFFF00L)) != null) {
                    setKeys.remove(this.getKey());
                    if (setKeys.isEmpty()) {
                        arrayExpiry.remove(lMillisOld);
                    }
                }
                if (lMillis > 0L) {
                    setKeys = (Set)arrayExpiry.get(lMillis &= 0xFFFFFFFFFFFFFF00L);
                    if (setKeys == null) {
                        setKeys = new LiteSet<Object>();
                        arrayExpiry.set(lMillis, setKeys);
                    }
                    setKeys.add(this.getKey());
                    if (fWasEmpty && OldCache.this.m_lNextFlush == Long.MAX_VALUE) {
                        OldCache.this.m_lNextFlush = 0L;
                    }
                }
            }
        }

        public boolean isExpired() {
            long dtExpiry = this.m_dtExpiry;
            return dtExpiry != 0L && dtExpiry < OldCache.this.getCurrentTimeMillis();
        }

        protected void scheduleExpiry() {
            long dtExpiry = 0L;
            int cDelay = OldCache.this.m_cExpiryDelay;
            if (cDelay > 0) {
                dtExpiry = OldCache.this.getCurrentTimeMillis() + (long)cDelay;
            }
            this.setExpiryMillis(dtExpiry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void discard() {
            if (!this.isDiscarded()) {
                OldCache map;
                if (this.m_dtExpiry > 0L) {
                    this.registerExpiry(0L);
                }
                OldCache oldCache = map = OldCache.this;
                synchronized (oldCache) {
                    int cUnits = this.m_cUnits;
                    if (cUnits == -1) {
                        return;
                    }
                    if (cUnits > 0) {
                        map.adjustUnits(-cUnits);
                    }
                    this.m_cUnits = -1;
                }
                if (map.hasListeners()) {
                    map.dispatchEvent(map.instantiateMapEvent(3, this.getKey(), this.getValue(), null));
                }
            }
        }

        protected boolean isDiscarded() {
            return this.m_cUnits == -1;
        }

        protected int calculateUnits(Object oValue) {
            OldCache map = OldCache.this;
            Object oKey = this.getKey();
            switch (map.getUnitCalculatorType()) {
                case 1: {
                    return BinaryMemoryCalculator.INSTANCE.calculateUnits(oKey, oValue);
                }
                case 2: {
                    return map.m_calculator.calculateUnits(oKey, oValue);
                }
            }
            return 1;
        }

        @Override
        public int getUnits() {
            return this.m_cUnits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUnits(int cUnits) {
            Entry.azzert(cUnits >= 0);
            OldCache oldCache = OldCache.this;
            synchronized (oldCache) {
                int cOldUnits = this.m_cUnits;
                if (cOldUnits == -1) {
                    return;
                }
                if (cUnits != cOldUnits) {
                    OldCache.this.adjustUnits(cUnits - cOldUnits);
                    this.m_cUnits = cUnits;
                }
            }
        }

        protected boolean isEvictable() {
            return this.m_fEvictable;
        }

        protected void setEvictable(boolean fEvict) {
            this.m_fEvictable = fEvict;
        }

        @Override
        public String toString() {
            long dtExpiry = this.getExpiryMillis();
            return super.toString() + ", priority=" + this.getPriority() + ", created=" + new Time(this.getCreatedMillis()) + ", last-use=" + new Time(this.getLastTouchMillis()) + ", expiry=" + (dtExpiry == 0L ? "none" : new Time(dtExpiry) + (this.isExpired() ? " (expired)" : "")) + ", use-count=" + this.getTouchCount() + ", units=" + this.getUnits();
        }

        Entry getNext() {
            return (Entry)this.m_eNext;
        }

        void setNext(Entry entry) {
            this.m_eNext = entry;
        }
    }

    protected class ValuesCollection
    extends SafeHashMap.ValuesCollection {
        protected ValuesCollection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray(Object[] ao) {
            Object[] aoAll;
            OldCache map;
            int cAll = 0;
            OldCache oldCache = map = OldCache.this;
            synchronized (oldCache) {
                int c = map.size();
                aoAll = new Object[c];
                if (c > 0) {
                    AtomicReferenceArray aeBucket = map.m_aeBucket;
                    for (int i = 0; i < aeBucket.length(); ++i) {
                        for (Entry entry = (Entry)aeBucket.get(i); entry != null; entry = entry.getNext()) {
                            if (OldCache.this.removeIfExpired(entry)) continue;
                            aoAll[cAll++] = entry.getValue();
                        }
                    }
                }
            }
            if (ao == null && cAll == aoAll.length) {
                return aoAll;
            }
            if (ao == null) {
                ao = new Object[cAll];
            } else if (ao.length < cAll) {
                ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cAll);
            } else if (ao.length > cAll) {
                ao[cAll] = null;
            }
            if (cAll > 0) {
                System.arraycopy(aoAll, 0, ao, 0, cAll);
            }
            return ao;
        }
    }

    protected class KeySet
    extends SafeHashMap.KeySet {
        protected KeySet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray(Object[] ao) {
            Object[] aoAll;
            OldCache map;
            int cAll = 0;
            OldCache oldCache = map = OldCache.this;
            synchronized (oldCache) {
                int c = map.size();
                aoAll = new Object[c];
                if (c > 0) {
                    AtomicReferenceArray aeBucket = map.m_aeBucket;
                    for (int i = 0; i < aeBucket.length(); ++i) {
                        for (Entry entry = (Entry)aeBucket.get(i); entry != null; entry = entry.getNext()) {
                            if (OldCache.this.removeIfExpired(entry)) continue;
                            aoAll[cAll++] = entry.getKey();
                        }
                    }
                }
            }
            if (ao == null && cAll == aoAll.length) {
                return aoAll;
            }
            if (ao == null) {
                ao = new Object[cAll];
            } else if (ao.length < cAll) {
                ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cAll);
            } else if (ao.length > cAll) {
                ao[cAll] = null;
            }
            if (cAll > 0) {
                System.arraycopy(aoAll, 0, ao, 0, cAll);
            }
            return ao;
        }

        @Override
        public int size() {
            return OldCache.super.size();
        }
    }

    protected class EntrySet
    extends SafeHashMap.EntrySet {
        protected EntrySet() {
        }

        @Override
        public Iterator iterator() {
            if (OldCache.this.isEmpty()) {
                return NullImplementation.getIterator();
            }
            Iterator iter = this.instantiateIterator();
            Filter<Entry> filter = entry -> !OldCache.this.removeIfExpired((Entry)entry);
            return new FilterEnumerator(iter, filter);
        }

        @Override
        public Object[] toArray(Object[] ao) {
            Entry entry;
            int ofSrc;
            Object[] aoAll = super.toArray(ao);
            int cAll = aoAll.length;
            int ofDest = 0;
            for (ofSrc = 0; ofSrc < cAll && (entry = (Entry)aoAll[ofSrc]) != null; ++ofSrc) {
                if (OldCache.this.removeIfExpired(entry)) continue;
                if (ofSrc > ofDest) {
                    aoAll[ofDest] = aoAll[ofSrc];
                }
                ++ofDest;
            }
            if (ofSrc == ofDest) {
                return aoAll;
            }
            if (ao == aoAll) {
                ao[ofDest] = null;
                return ao;
            }
            ao = ao == null ? new Object[ofDest] : (Object[])Array.newInstance(ao.getClass().getComponentType(), ofDest);
            System.arraycopy(aoAll, 0, ao, 0, ofDest);
            return ao;
        }
    }
}

