/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events.internal;

import com.tangosol.internal.tracing.Scope;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.internal.AbstractEventDispatcher;
import com.tangosol.util.Base;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractEvent<T extends Enum<T>>
implements Event<T> {
    protected final T m_eventType;
    protected Iterator<? extends EventInterceptor<?>> m_iterInterceptor;
    protected final EventDispatcher m_dispatcher;

    public AbstractEvent(T eventType) {
        this(null, eventType);
    }

    public AbstractEvent(EventDispatcher dispatcher, T eventType) {
        this.m_dispatcher = dispatcher;
        this.m_eventType = eventType;
    }

    protected Iterator<? extends EventInterceptor<?>> getIterator() {
        return this.m_iterInterceptor;
    }

    protected void setIterator(Iterator<? extends EventInterceptor<?>> iter) {
        this.m_iterInterceptor = iter;
    }

    @Override
    public T getType() {
        return this.m_eventType;
    }

    @Override
    public EventDispatcher getDispatcher() {
        return this.m_dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextInterceptor() {
        EventDispatcher dispatcher = this.m_dispatcher;
        AbstractEventDispatcher.EventStats stats = null;
        if (dispatcher instanceof AbstractEventDispatcher) {
            stats = ((AbstractEventDispatcher)dispatcher).getStats();
        }
        Iterator<EventInterceptor<?>> iter = this.getIterator();
        while (iter.hasNext()) {
            EventInterceptor<?> interceptor = iter.next();
            Span span = TracingHelper.newSpan("process", this).withMetadata("interceptor", interceptor.getClass().getName()).startSpan();
            try {
                Scope ignored = TracingHelper.getTracer().withSpan(span);
                Throwable throwable = null;
                try {
                    interceptor.onEvent(this);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            catch (Exception e) {
                TracingHelper.augmentSpanWithErrorDetails(span, true, e);
                if (stats != null) {
                    stats.registerEventException(e, this, interceptor);
                }
                if (this.isVetoable()) {
                    String sMsg = "Exception vetoed by \"" + interceptor + "\".";
                    span.log(sMsg);
                    while (iter.hasNext()) {
                        iter.next();
                    }
                    throw Base.ensureRuntimeException(e, sMsg);
                }
                CacheFactory.log("Exception caught while dispatching to \"" + interceptor + "\": " + Base.printStackTrace(e), 1);
            }
            finally {
                span.end();
            }
        }
    }

    protected void dispatch(Collection<? extends EventInterceptor<?>> colIter) {
        this.setIterator(colIter.iterator());
        this.nextInterceptor();
    }

    protected boolean isMutableEvent() {
        return false;
    }

    protected boolean isVetoable() {
        return this.isMutableEvent();
    }

    protected String getDescription() {
        return "Type=" + this.getType();
    }

    public String toString() {
        String sEvt = this.getClass().getName();
        return sEvt.substring(sEvt.lastIndexOf(46) + 1) + '{' + this.getDescription() + '}';
    }
}

